/*
Copyright 2019 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package nodeidentity

import (
	"context"

	corev1 "k8s.io/api/core/v1"
)

type Identifier interface {
	IdentifyNode(ctx context.Context, node *corev1.Node) (*Info, error)
}

type Info struct {
	InstanceID string
	Labels     map[string]string
}

type LegacyIdentifier interface {
	IdentifyNode(ctx context.Context, node *corev1.Node) (*LegacyInfo, error)
}

type LegacyInfo struct {
	InstanceID    string
	InstanceGroup string
	// TODO: Remove
	InstanceLifecycle string
}
