/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	internalversion "k8s.io/kops/pkg/client/clientset_generated/clientset/typed/kops/internalversion"
)

// fakeHosts implements HostInterface
type fakeHosts struct {
	*gentype.FakeClientWithList[*kops.Host, *kops.HostList]
	Fake *FakeKops
}

func newFakeHosts(fake *FakeKops, namespace string) internalversion.HostInterface {
	return &fakeHosts{
		gentype.NewFakeClientWithList[*kops.Host, *kops.HostList](
			fake.Fake,
			namespace,
			kops.SchemeGroupVersion.WithResource("hosts"),
			kops.SchemeGroupVersion.WithKind("Host"),
			func() *kops.Host { return &kops.Host{} },
			func() *kops.HostList { return &kops.HostList{} },
			func(dst, src *kops.HostList) { dst.ListMeta = src.ListMeta },
			func(list *kops.HostList) []*kops.Host { return gentype.ToPointerSlice(list.Items) },
			func(list *kops.HostList, items []*kops.Host) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
