//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by openapi-gen. DO NOT EDIT.

package openapi

import (
	v1 "k8s.io/api/admissionregistration/v1"
	v1alpha1 "k8s.io/api/admissionregistration/v1alpha1"
	v1beta1 "k8s.io/api/admissionregistration/v1beta1"
	v2 "k8s.io/api/apidiscovery/v2"
	v2beta1 "k8s.io/api/apidiscovery/v2beta1"
	apiserverinternalv1alpha1 "k8s.io/api/apiserverinternal/v1alpha1"
	appsv1 "k8s.io/api/apps/v1"
	appsv1beta1 "k8s.io/api/apps/v1beta1"
	v1beta2 "k8s.io/api/apps/v1beta2"
	authenticationv1 "k8s.io/api/authentication/v1"
	authenticationv1alpha1 "k8s.io/api/authentication/v1alpha1"
	authenticationv1beta1 "k8s.io/api/authentication/v1beta1"
	authorizationv1 "k8s.io/api/authorization/v1"
	authorizationv1beta1 "k8s.io/api/authorization/v1beta1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	autoscalingv2 "k8s.io/api/autoscaling/v2"
	autoscalingv2beta1 "k8s.io/api/autoscaling/v2beta1"
	v2beta2 "k8s.io/api/autoscaling/v2beta2"
	batchv1 "k8s.io/api/batch/v1"
	batchv1beta1 "k8s.io/api/batch/v1beta1"
	certificatesv1 "k8s.io/api/certificates/v1"
	certificatesv1alpha1 "k8s.io/api/certificates/v1alpha1"
	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	coordinationv1 "k8s.io/api/coordination/v1"
	v1alpha2 "k8s.io/api/coordination/v1alpha2"
	coordinationv1beta1 "k8s.io/api/coordination/v1beta1"
	corev1 "k8s.io/api/core/v1"
	discoveryv1 "k8s.io/api/discovery/v1"
	discoveryv1beta1 "k8s.io/api/discovery/v1beta1"
	eventsv1 "k8s.io/api/events/v1"
	eventsv1beta1 "k8s.io/api/events/v1beta1"
	extensionsv1beta1 "k8s.io/api/extensions/v1beta1"
	flowcontrolv1 "k8s.io/api/flowcontrol/v1"
	flowcontrolv1beta1 "k8s.io/api/flowcontrol/v1beta1"
	flowcontrolv1beta2 "k8s.io/api/flowcontrol/v1beta2"
	v1beta3 "k8s.io/api/flowcontrol/v1beta3"
	imagepolicyv1alpha1 "k8s.io/api/imagepolicy/v1alpha1"
	networkingv1 "k8s.io/api/networking/v1"
	networkingv1beta1 "k8s.io/api/networking/v1beta1"
	nodev1 "k8s.io/api/node/v1"
	nodev1alpha1 "k8s.io/api/node/v1alpha1"
	nodev1beta1 "k8s.io/api/node/v1beta1"
	policyv1 "k8s.io/api/policy/v1"
	policyv1beta1 "k8s.io/api/policy/v1beta1"
	rbacv1 "k8s.io/api/rbac/v1"
	rbacv1alpha1 "k8s.io/api/rbac/v1alpha1"
	rbacv1beta1 "k8s.io/api/rbac/v1beta1"
	resourcev1 "k8s.io/api/resource/v1"
	v1alpha3 "k8s.io/api/resource/v1alpha3"
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	schedulingv1 "k8s.io/api/scheduling/v1"
	schedulingv1alpha1 "k8s.io/api/scheduling/v1alpha1"
	schedulingv1beta1 "k8s.io/api/scheduling/v1beta1"
	storagev1 "k8s.io/api/storage/v1"
	storagev1alpha1 "k8s.io/api/storage/v1alpha1"
	storagev1beta1 "k8s.io/api/storage/v1beta1"
	storagemigrationv1beta1 "k8s.io/api/storagemigration/v1beta1"
	apiextensionsv1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1"
	apiextensionsv1beta1 "k8s.io/apiextensions-apiserver/pkg/apis/apiextensions/v1beta1"
	resource "k8s.io/apimachinery/pkg/api/resource"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	metav1beta1 "k8s.io/apimachinery/pkg/apis/meta/v1beta1"
	testapigroupv1 "k8s.io/apimachinery/pkg/apis/testapigroup/v1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	intstr "k8s.io/apimachinery/pkg/util/intstr"
	version "k8s.io/apimachinery/pkg/version"
	auditv1 "k8s.io/apiserver/pkg/apis/audit/v1"
	apiv1alpha1 "k8s.io/apiserver/pkg/server/flagz/api/v1alpha1"
	statuszapiv1alpha1 "k8s.io/apiserver/pkg/server/statusz/api/v1alpha1"
	clientauthenticationv1 "k8s.io/client-go/pkg/apis/clientauthentication/v1"
	clientauthenticationv1beta1 "k8s.io/client-go/pkg/apis/clientauthentication/v1beta1"
	configv1alpha1 "k8s.io/cloud-provider/config/v1alpha1"
	nodeconfigv1alpha1 "k8s.io/cloud-provider/controllers/node/config/v1alpha1"
	serviceconfigv1alpha1 "k8s.io/cloud-provider/controllers/service/config/v1alpha1"
	componentbaseconfigv1alpha1 "k8s.io/component-base/config/v1alpha1"
	logsapiv1 "k8s.io/component-base/logs/api/v1"
	apiv1 "k8s.io/component-base/tracing/api/v1"
	controllermanagerconfigv1alpha1 "k8s.io/controller-manager/config/v1alpha1"
	configv1beta1 "k8s.io/controller-manager/config/v1beta1"
	apiregistrationv1 "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1"
	apiregistrationv1beta1 "k8s.io/kube-aggregator/pkg/apis/apiregistration/v1beta1"
	kubecontrollermanagerconfigv1alpha1 "k8s.io/kube-controller-manager/config/v1alpha1"
	common "k8s.io/kube-openapi/pkg/common"
	spec "k8s.io/kube-openapi/pkg/validation/spec"
	kubeproxyconfigv1alpha1 "k8s.io/kube-proxy/config/v1alpha1"
	configv1 "k8s.io/kube-scheduler/config/v1"
	pkgconfigv1alpha1 "k8s.io/kubectl/pkg/config/v1alpha1"
	pkgconfigv1beta1 "k8s.io/kubectl/pkg/config/v1beta1"
	kubeletconfigv1 "k8s.io/kubelet/config/v1"
	kubeletconfigv1alpha1 "k8s.io/kubelet/config/v1alpha1"
	kubeletconfigv1beta1 "k8s.io/kubelet/config/v1beta1"
	abacv1beta1 "k8s.io/kubernetes/pkg/apis/abac/v1beta1"
	custommetricsv1beta1 "k8s.io/metrics/pkg/apis/custom_metrics/v1beta1"
	custommetricsv1beta2 "k8s.io/metrics/pkg/apis/custom_metrics/v1beta2"
	externalmetricsv1beta1 "k8s.io/metrics/pkg/apis/external_metrics/v1beta1"
	metricsv1alpha1 "k8s.io/metrics/pkg/apis/metrics/v1alpha1"
	metricsv1beta1 "k8s.io/metrics/pkg/apis/metrics/v1beta1"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		v1.AuditAnnotation{}.OpenAPIModelName():                                                                         schema_k8sio_api_admissionregistration_v1_AuditAnnotation(ref),
		v1.ExpressionWarning{}.OpenAPIModelName():                                                                       schema_k8sio_api_admissionregistration_v1_ExpressionWarning(ref),
		v1.MatchCondition{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1_MatchCondition(ref),
		v1.MatchResources{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1_MatchResources(ref),
		v1.MutatingWebhook{}.OpenAPIModelName():                                                                         schema_k8sio_api_admissionregistration_v1_MutatingWebhook(ref),
		v1.MutatingWebhookConfiguration{}.OpenAPIModelName():                                                            schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfiguration(ref),
		v1.MutatingWebhookConfigurationList{}.OpenAPIModelName():                                                        schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfigurationList(ref),
		v1.NamedRuleWithOperations{}.OpenAPIModelName():                                                                 schema_k8sio_api_admissionregistration_v1_NamedRuleWithOperations(ref),
		v1.ParamKind{}.OpenAPIModelName():                                                                               schema_k8sio_api_admissionregistration_v1_ParamKind(ref),
		v1.ParamRef{}.OpenAPIModelName():                                                                                schema_k8sio_api_admissionregistration_v1_ParamRef(ref),
		v1.Rule{}.OpenAPIModelName():                                                                                    schema_k8sio_api_admissionregistration_v1_Rule(ref),
		v1.RuleWithOperations{}.OpenAPIModelName():                                                                      schema_k8sio_api_admissionregistration_v1_RuleWithOperations(ref),
		v1.ServiceReference{}.OpenAPIModelName():                                                                        schema_k8sio_api_admissionregistration_v1_ServiceReference(ref),
		v1.TypeChecking{}.OpenAPIModelName():                                                                            schema_k8sio_api_admissionregistration_v1_TypeChecking(ref),
		v1.ValidatingAdmissionPolicy{}.OpenAPIModelName():                                                               schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicy(ref),
		v1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName():                                                        schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBinding(ref),
		v1.ValidatingAdmissionPolicyBindingList{}.OpenAPIModelName():                                                    schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingList(ref),
		v1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName():                                                    schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingSpec(ref),
		v1.ValidatingAdmissionPolicyList{}.OpenAPIModelName():                                                           schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyList(ref),
		v1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName():                                                           schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicySpec(ref),
		v1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyStatus(ref),
		v1.ValidatingWebhook{}.OpenAPIModelName():                                                                       schema_k8sio_api_admissionregistration_v1_ValidatingWebhook(ref),
		v1.ValidatingWebhookConfiguration{}.OpenAPIModelName():                                                          schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfiguration(ref),
		v1.ValidatingWebhookConfigurationList{}.OpenAPIModelName():                                                      schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfigurationList(ref),
		v1.Validation{}.OpenAPIModelName():                                                                              schema_k8sio_api_admissionregistration_v1_Validation(ref),
		v1.Variable{}.OpenAPIModelName():                                                                                schema_k8sio_api_admissionregistration_v1_Variable(ref),
		v1.WebhookClientConfig{}.OpenAPIModelName():                                                                     schema_k8sio_api_admissionregistration_v1_WebhookClientConfig(ref),
		v1alpha1.ApplyConfiguration{}.OpenAPIModelName():                                                                schema_k8sio_api_admissionregistration_v1alpha1_ApplyConfiguration(ref),
		v1alpha1.AuditAnnotation{}.OpenAPIModelName():                                                                   schema_k8sio_api_admissionregistration_v1alpha1_AuditAnnotation(ref),
		v1alpha1.ExpressionWarning{}.OpenAPIModelName():                                                                 schema_k8sio_api_admissionregistration_v1alpha1_ExpressionWarning(ref),
		v1alpha1.JSONPatch{}.OpenAPIModelName():                                                                         schema_k8sio_api_admissionregistration_v1alpha1_JSONPatch(ref),
		v1alpha1.MatchCondition{}.OpenAPIModelName():                                                                    schema_k8sio_api_admissionregistration_v1alpha1_MatchCondition(ref),
		v1alpha1.MatchResources{}.OpenAPIModelName():                                                                    schema_k8sio_api_admissionregistration_v1alpha1_MatchResources(ref),
		v1alpha1.MutatingAdmissionPolicy{}.OpenAPIModelName():                                                           schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicy(ref),
		v1alpha1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName():                                                    schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBinding(ref),
		v1alpha1.MutatingAdmissionPolicyBindingList{}.OpenAPIModelName():                                                schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBindingList(ref),
		v1alpha1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName():                                                schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBindingSpec(ref),
		v1alpha1.MutatingAdmissionPolicyList{}.OpenAPIModelName():                                                       schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyList(ref),
		v1alpha1.MutatingAdmissionPolicySpec{}.OpenAPIModelName():                                                       schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicySpec(ref),
		v1alpha1.Mutation{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1alpha1_Mutation(ref),
		v1alpha1.NamedRuleWithOperations{}.OpenAPIModelName():                                                           schema_k8sio_api_admissionregistration_v1alpha1_NamedRuleWithOperations(ref),
		v1alpha1.ParamKind{}.OpenAPIModelName():                                                                         schema_k8sio_api_admissionregistration_v1alpha1_ParamKind(ref),
		v1alpha1.ParamRef{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1alpha1_ParamRef(ref),
		v1alpha1.TypeChecking{}.OpenAPIModelName():                                                                      schema_k8sio_api_admissionregistration_v1alpha1_TypeChecking(ref),
		v1alpha1.ValidatingAdmissionPolicy{}.OpenAPIModelName():                                                         schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicy(ref),
		v1alpha1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName():                                                  schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBinding(ref),
		v1alpha1.ValidatingAdmissionPolicyBindingList{}.OpenAPIModelName():                                              schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingList(ref),
		v1alpha1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName():                                              schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingSpec(ref),
		v1alpha1.ValidatingAdmissionPolicyList{}.OpenAPIModelName():                                                     schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyList(ref),
		v1alpha1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName():                                                     schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicySpec(ref),
		v1alpha1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName():                                                   schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyStatus(ref),
		v1alpha1.Validation{}.OpenAPIModelName():                                                                        schema_k8sio_api_admissionregistration_v1alpha1_Validation(ref),
		v1alpha1.Variable{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1alpha1_Variable(ref),
		v1beta1.ApplyConfiguration{}.OpenAPIModelName():                                                                 schema_k8sio_api_admissionregistration_v1beta1_ApplyConfiguration(ref),
		v1beta1.AuditAnnotation{}.OpenAPIModelName():                                                                    schema_k8sio_api_admissionregistration_v1beta1_AuditAnnotation(ref),
		v1beta1.ExpressionWarning{}.OpenAPIModelName():                                                                  schema_k8sio_api_admissionregistration_v1beta1_ExpressionWarning(ref),
		v1beta1.JSONPatch{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1beta1_JSONPatch(ref),
		v1beta1.MatchCondition{}.OpenAPIModelName():                                                                     schema_k8sio_api_admissionregistration_v1beta1_MatchCondition(ref),
		v1beta1.MatchResources{}.OpenAPIModelName():                                                                     schema_k8sio_api_admissionregistration_v1beta1_MatchResources(ref),
		v1beta1.MutatingAdmissionPolicy{}.OpenAPIModelName():                                                            schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicy(ref),
		v1beta1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName():                                                     schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBinding(ref),
		v1beta1.MutatingAdmissionPolicyBindingList{}.OpenAPIModelName():                                                 schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBindingList(ref),
		v1beta1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName():                                                 schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBindingSpec(ref),
		v1beta1.MutatingAdmissionPolicyList{}.OpenAPIModelName():                                                        schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyList(ref),
		v1beta1.MutatingAdmissionPolicySpec{}.OpenAPIModelName():                                                        schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicySpec(ref),
		v1beta1.MutatingWebhook{}.OpenAPIModelName():                                                                    schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhook(ref),
		v1beta1.MutatingWebhookConfiguration{}.OpenAPIModelName():                                                       schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfiguration(ref),
		v1beta1.MutatingWebhookConfigurationList{}.OpenAPIModelName():                                                   schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfigurationList(ref),
		v1beta1.Mutation{}.OpenAPIModelName():                                                                           schema_k8sio_api_admissionregistration_v1beta1_Mutation(ref),
		v1beta1.NamedRuleWithOperations{}.OpenAPIModelName():                                                            schema_k8sio_api_admissionregistration_v1beta1_NamedRuleWithOperations(ref),
		v1beta1.ParamKind{}.OpenAPIModelName():                                                                          schema_k8sio_api_admissionregistration_v1beta1_ParamKind(ref),
		v1beta1.ParamRef{}.OpenAPIModelName():                                                                           schema_k8sio_api_admissionregistration_v1beta1_ParamRef(ref),
		v1beta1.ServiceReference{}.OpenAPIModelName():                                                                   schema_k8sio_api_admissionregistration_v1beta1_ServiceReference(ref),
		v1beta1.TypeChecking{}.OpenAPIModelName():                                                                       schema_k8sio_api_admissionregistration_v1beta1_TypeChecking(ref),
		v1beta1.ValidatingAdmissionPolicy{}.OpenAPIModelName():                                                          schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicy(ref),
		v1beta1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName():                                                   schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBinding(ref),
		v1beta1.ValidatingAdmissionPolicyBindingList{}.OpenAPIModelName():                                               schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingList(ref),
		v1beta1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName():                                               schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingSpec(ref),
		v1beta1.ValidatingAdmissionPolicyList{}.OpenAPIModelName():                                                      schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyList(ref),
		v1beta1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName():                                                      schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicySpec(ref),
		v1beta1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName():                                                    schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyStatus(ref),
		v1beta1.ValidatingWebhook{}.OpenAPIModelName():                                                                  schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhook(ref),
		v1beta1.ValidatingWebhookConfiguration{}.OpenAPIModelName():                                                     schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfiguration(ref),
		v1beta1.ValidatingWebhookConfigurationList{}.OpenAPIModelName():                                                 schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfigurationList(ref),
		v1beta1.Validation{}.OpenAPIModelName():                                                                         schema_k8sio_api_admissionregistration_v1beta1_Validation(ref),
		v1beta1.Variable{}.OpenAPIModelName():                                                                           schema_k8sio_api_admissionregistration_v1beta1_Variable(ref),
		v1beta1.WebhookClientConfig{}.OpenAPIModelName():                                                                schema_k8sio_api_admissionregistration_v1beta1_WebhookClientConfig(ref),
		v2.APIGroupDiscovery{}.OpenAPIModelName():                                                                       schema_k8sio_api_apidiscovery_v2_APIGroupDiscovery(ref),
		v2.APIGroupDiscoveryList{}.OpenAPIModelName():                                                                   schema_k8sio_api_apidiscovery_v2_APIGroupDiscoveryList(ref),
		v2.APIResourceDiscovery{}.OpenAPIModelName():                                                                    schema_k8sio_api_apidiscovery_v2_APIResourceDiscovery(ref),
		v2.APISubresourceDiscovery{}.OpenAPIModelName():                                                                 schema_k8sio_api_apidiscovery_v2_APISubresourceDiscovery(ref),
		v2.APIVersionDiscovery{}.OpenAPIModelName():                                                                     schema_k8sio_api_apidiscovery_v2_APIVersionDiscovery(ref),
		v2beta1.APIGroupDiscovery{}.OpenAPIModelName():                                                                  schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscovery(ref),
		v2beta1.APIGroupDiscoveryList{}.OpenAPIModelName():                                                              schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscoveryList(ref),
		v2beta1.APIResourceDiscovery{}.OpenAPIModelName():                                                               schema_k8sio_api_apidiscovery_v2beta1_APIResourceDiscovery(ref),
		v2beta1.APISubresourceDiscovery{}.OpenAPIModelName():                                                            schema_k8sio_api_apidiscovery_v2beta1_APISubresourceDiscovery(ref),
		v2beta1.APIVersionDiscovery{}.OpenAPIModelName():                                                                schema_k8sio_api_apidiscovery_v2beta1_APIVersionDiscovery(ref),
		apiserverinternalv1alpha1.ServerStorageVersion{}.OpenAPIModelName():                                             schema_k8sio_api_apiserverinternal_v1alpha1_ServerStorageVersion(ref),
		apiserverinternalv1alpha1.StorageVersion{}.OpenAPIModelName():                                                   schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersion(ref),
		apiserverinternalv1alpha1.StorageVersionCondition{}.OpenAPIModelName():                                          schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionCondition(ref),
		apiserverinternalv1alpha1.StorageVersionList{}.OpenAPIModelName():                                               schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionList(ref),
		apiserverinternalv1alpha1.StorageVersionSpec{}.OpenAPIModelName():                                               schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionSpec(ref),
		apiserverinternalv1alpha1.StorageVersionStatus{}.OpenAPIModelName():                                             schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionStatus(ref),
		appsv1.ControllerRevision{}.OpenAPIModelName():                                                                  schema_k8sio_api_apps_v1_ControllerRevision(ref),
		appsv1.ControllerRevisionList{}.OpenAPIModelName():                                                              schema_k8sio_api_apps_v1_ControllerRevisionList(ref),
		appsv1.DaemonSet{}.OpenAPIModelName():                                                                           schema_k8sio_api_apps_v1_DaemonSet(ref),
		appsv1.DaemonSetCondition{}.OpenAPIModelName():                                                                  schema_k8sio_api_apps_v1_DaemonSetCondition(ref),
		appsv1.DaemonSetList{}.OpenAPIModelName():                                                                       schema_k8sio_api_apps_v1_DaemonSetList(ref),
		appsv1.DaemonSetSpec{}.OpenAPIModelName():                                                                       schema_k8sio_api_apps_v1_DaemonSetSpec(ref),
		appsv1.DaemonSetStatus{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1_DaemonSetStatus(ref),
		appsv1.DaemonSetUpdateStrategy{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1_DaemonSetUpdateStrategy(ref),
		appsv1.Deployment{}.OpenAPIModelName():                                                                          schema_k8sio_api_apps_v1_Deployment(ref),
		appsv1.DeploymentCondition{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1_DeploymentCondition(ref),
		appsv1.DeploymentList{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1_DeploymentList(ref),
		appsv1.DeploymentSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1_DeploymentSpec(ref),
		appsv1.DeploymentStatus{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1_DeploymentStatus(ref),
		appsv1.DeploymentStrategy{}.OpenAPIModelName():                                                                  schema_k8sio_api_apps_v1_DeploymentStrategy(ref),
		appsv1.ReplicaSet{}.OpenAPIModelName():                                                                          schema_k8sio_api_apps_v1_ReplicaSet(ref),
		appsv1.ReplicaSetCondition{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1_ReplicaSetCondition(ref),
		appsv1.ReplicaSetList{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1_ReplicaSetList(ref),
		appsv1.ReplicaSetSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1_ReplicaSetSpec(ref),
		appsv1.ReplicaSetStatus{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1_ReplicaSetStatus(ref),
		appsv1.RollingUpdateDaemonSet{}.OpenAPIModelName():                                                              schema_k8sio_api_apps_v1_RollingUpdateDaemonSet(ref),
		appsv1.RollingUpdateDeployment{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1_RollingUpdateDeployment(ref),
		appsv1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName():                                                    schema_k8sio_api_apps_v1_RollingUpdateStatefulSetStrategy(ref),
		appsv1.StatefulSet{}.OpenAPIModelName():                                                                         schema_k8sio_api_apps_v1_StatefulSet(ref),
		appsv1.StatefulSetCondition{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1_StatefulSetCondition(ref),
		appsv1.StatefulSetList{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1_StatefulSetList(ref),
		appsv1.StatefulSetOrdinals{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1_StatefulSetOrdinals(ref),
		appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName():                                     schema_k8sio_api_apps_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		appsv1.StatefulSetSpec{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1_StatefulSetSpec(ref),
		appsv1.StatefulSetStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_apps_v1_StatefulSetStatus(ref),
		appsv1.StatefulSetUpdateStrategy{}.OpenAPIModelName():                                                           schema_k8sio_api_apps_v1_StatefulSetUpdateStrategy(ref),
		appsv1beta1.ControllerRevision{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1beta1_ControllerRevision(ref),
		appsv1beta1.ControllerRevisionList{}.OpenAPIModelName():                                                         schema_k8sio_api_apps_v1beta1_ControllerRevisionList(ref),
		appsv1beta1.Deployment{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1beta1_Deployment(ref),
		appsv1beta1.DeploymentCondition{}.OpenAPIModelName():                                                            schema_k8sio_api_apps_v1beta1_DeploymentCondition(ref),
		appsv1beta1.DeploymentList{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta1_DeploymentList(ref),
		appsv1beta1.DeploymentRollback{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1beta1_DeploymentRollback(ref),
		appsv1beta1.DeploymentSpec{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta1_DeploymentSpec(ref),
		appsv1beta1.DeploymentStatus{}.OpenAPIModelName():                                                               schema_k8sio_api_apps_v1beta1_DeploymentStatus(ref),
		appsv1beta1.DeploymentStrategy{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1beta1_DeploymentStrategy(ref),
		appsv1beta1.RollbackConfig{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta1_RollbackConfig(ref),
		appsv1beta1.RollingUpdateDeployment{}.OpenAPIModelName():                                                        schema_k8sio_api_apps_v1beta1_RollingUpdateDeployment(ref),
		appsv1beta1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName():                                               schema_k8sio_api_apps_v1beta1_RollingUpdateStatefulSetStrategy(ref),
		appsv1beta1.Scale{}.OpenAPIModelName():                                                                          schema_k8sio_api_apps_v1beta1_Scale(ref),
		appsv1beta1.ScaleSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1beta1_ScaleSpec(ref),
		appsv1beta1.ScaleStatus{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1beta1_ScaleStatus(ref),
		appsv1beta1.StatefulSet{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1beta1_StatefulSet(ref),
		appsv1beta1.StatefulSetCondition{}.OpenAPIModelName():                                                           schema_k8sio_api_apps_v1beta1_StatefulSetCondition(ref),
		appsv1beta1.StatefulSetList{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1beta1_StatefulSetList(ref),
		appsv1beta1.StatefulSetOrdinals{}.OpenAPIModelName():                                                            schema_k8sio_api_apps_v1beta1_StatefulSetOrdinals(ref),
		appsv1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName():                                schema_k8sio_api_apps_v1beta1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		appsv1beta1.StatefulSetSpec{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1beta1_StatefulSetSpec(ref),
		appsv1beta1.StatefulSetStatus{}.OpenAPIModelName():                                                              schema_k8sio_api_apps_v1beta1_StatefulSetStatus(ref),
		appsv1beta1.StatefulSetUpdateStrategy{}.OpenAPIModelName():                                                      schema_k8sio_api_apps_v1beta1_StatefulSetUpdateStrategy(ref),
		v1beta2.ControllerRevision{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta2_ControllerRevision(ref),
		v1beta2.ControllerRevisionList{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1beta2_ControllerRevisionList(ref),
		v1beta2.DaemonSet{}.OpenAPIModelName():                                                                          schema_k8sio_api_apps_v1beta2_DaemonSet(ref),
		v1beta2.DaemonSetCondition{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta2_DaemonSetCondition(ref),
		v1beta2.DaemonSetList{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1beta2_DaemonSetList(ref),
		v1beta2.DaemonSetSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_apps_v1beta2_DaemonSetSpec(ref),
		v1beta2.DaemonSetStatus{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1beta2_DaemonSetStatus(ref),
		v1beta2.DaemonSetUpdateStrategy{}.OpenAPIModelName():                                                            schema_k8sio_api_apps_v1beta2_DaemonSetUpdateStrategy(ref),
		v1beta2.Deployment{}.OpenAPIModelName():                                                                         schema_k8sio_api_apps_v1beta2_Deployment(ref),
		v1beta2.DeploymentCondition{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1beta2_DeploymentCondition(ref),
		v1beta2.DeploymentList{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1beta2_DeploymentList(ref),
		v1beta2.DeploymentSpec{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1beta2_DeploymentSpec(ref),
		v1beta2.DeploymentStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_apps_v1beta2_DeploymentStatus(ref),
		v1beta2.DeploymentStrategy{}.OpenAPIModelName():                                                                 schema_k8sio_api_apps_v1beta2_DeploymentStrategy(ref),
		v1beta2.ReplicaSet{}.OpenAPIModelName():                                                                         schema_k8sio_api_apps_v1beta2_ReplicaSet(ref),
		v1beta2.ReplicaSetCondition{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1beta2_ReplicaSetCondition(ref),
		v1beta2.ReplicaSetList{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1beta2_ReplicaSetList(ref),
		v1beta2.ReplicaSetSpec{}.OpenAPIModelName():                                                                     schema_k8sio_api_apps_v1beta2_ReplicaSetSpec(ref),
		v1beta2.ReplicaSetStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_apps_v1beta2_ReplicaSetStatus(ref),
		v1beta2.RollingUpdateDaemonSet{}.OpenAPIModelName():                                                             schema_k8sio_api_apps_v1beta2_RollingUpdateDaemonSet(ref),
		v1beta2.RollingUpdateDeployment{}.OpenAPIModelName():                                                            schema_k8sio_api_apps_v1beta2_RollingUpdateDeployment(ref),
		v1beta2.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName():                                                   schema_k8sio_api_apps_v1beta2_RollingUpdateStatefulSetStrategy(ref),
		v1beta2.Scale{}.OpenAPIModelName():                                                                              schema_k8sio_api_apps_v1beta2_Scale(ref),
		v1beta2.ScaleSpec{}.OpenAPIModelName():                                                                          schema_k8sio_api_apps_v1beta2_ScaleSpec(ref),
		v1beta2.ScaleStatus{}.OpenAPIModelName():                                                                        schema_k8sio_api_apps_v1beta2_ScaleStatus(ref),
		v1beta2.StatefulSet{}.OpenAPIModelName():                                                                        schema_k8sio_api_apps_v1beta2_StatefulSet(ref),
		v1beta2.StatefulSetCondition{}.OpenAPIModelName():                                                               schema_k8sio_api_apps_v1beta2_StatefulSetCondition(ref),
		v1beta2.StatefulSetList{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1beta2_StatefulSetList(ref),
		v1beta2.StatefulSetOrdinals{}.OpenAPIModelName():                                                                schema_k8sio_api_apps_v1beta2_StatefulSetOrdinals(ref),
		v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName():                                    schema_k8sio_api_apps_v1beta2_StatefulSetPersistentVolumeClaimRetentionPolicy(ref),
		v1beta2.StatefulSetSpec{}.OpenAPIModelName():                                                                    schema_k8sio_api_apps_v1beta2_StatefulSetSpec(ref),
		v1beta2.StatefulSetStatus{}.OpenAPIModelName():                                                                  schema_k8sio_api_apps_v1beta2_StatefulSetStatus(ref),
		v1beta2.StatefulSetUpdateStrategy{}.OpenAPIModelName():                                                          schema_k8sio_api_apps_v1beta2_StatefulSetUpdateStrategy(ref),
		authenticationv1.BoundObjectReference{}.OpenAPIModelName():                                                      schema_k8sio_api_authentication_v1_BoundObjectReference(ref),
		authenticationv1.SelfSubjectReview{}.OpenAPIModelName():                                                         schema_k8sio_api_authentication_v1_SelfSubjectReview(ref),
		authenticationv1.SelfSubjectReviewStatus{}.OpenAPIModelName():                                                   schema_k8sio_api_authentication_v1_SelfSubjectReviewStatus(ref),
		authenticationv1.TokenRequest{}.OpenAPIModelName():                                                              schema_k8sio_api_authentication_v1_TokenRequest(ref),
		authenticationv1.TokenRequestSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_authentication_v1_TokenRequestSpec(ref),
		authenticationv1.TokenRequestStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_authentication_v1_TokenRequestStatus(ref),
		authenticationv1.TokenReview{}.OpenAPIModelName():                                                               schema_k8sio_api_authentication_v1_TokenReview(ref),
		authenticationv1.TokenReviewSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_authentication_v1_TokenReviewSpec(ref),
		authenticationv1.TokenReviewStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_authentication_v1_TokenReviewStatus(ref),
		authenticationv1.UserInfo{}.OpenAPIModelName():                                                                  schema_k8sio_api_authentication_v1_UserInfo(ref),
		authenticationv1alpha1.SelfSubjectReview{}.OpenAPIModelName():                                                   schema_k8sio_api_authentication_v1alpha1_SelfSubjectReview(ref),
		authenticationv1alpha1.SelfSubjectReviewStatus{}.OpenAPIModelName():                                             schema_k8sio_api_authentication_v1alpha1_SelfSubjectReviewStatus(ref),
		authenticationv1beta1.SelfSubjectReview{}.OpenAPIModelName():                                                    schema_k8sio_api_authentication_v1beta1_SelfSubjectReview(ref),
		authenticationv1beta1.SelfSubjectReviewStatus{}.OpenAPIModelName():                                              schema_k8sio_api_authentication_v1beta1_SelfSubjectReviewStatus(ref),
		authenticationv1beta1.TokenReview{}.OpenAPIModelName():                                                          schema_k8sio_api_authentication_v1beta1_TokenReview(ref),
		authenticationv1beta1.TokenReviewSpec{}.OpenAPIModelName():                                                      schema_k8sio_api_authentication_v1beta1_TokenReviewSpec(ref),
		authenticationv1beta1.TokenReviewStatus{}.OpenAPIModelName():                                                    schema_k8sio_api_authentication_v1beta1_TokenReviewStatus(ref),
		authenticationv1beta1.UserInfo{}.OpenAPIModelName():                                                             schema_k8sio_api_authentication_v1beta1_UserInfo(ref),
		authorizationv1.FieldSelectorAttributes{}.OpenAPIModelName():                                                    schema_k8sio_api_authorization_v1_FieldSelectorAttributes(ref),
		authorizationv1.LabelSelectorAttributes{}.OpenAPIModelName():                                                    schema_k8sio_api_authorization_v1_LabelSelectorAttributes(ref),
		authorizationv1.LocalSubjectAccessReview{}.OpenAPIModelName():                                                   schema_k8sio_api_authorization_v1_LocalSubjectAccessReview(ref),
		authorizationv1.NonResourceAttributes{}.OpenAPIModelName():                                                      schema_k8sio_api_authorization_v1_NonResourceAttributes(ref),
		authorizationv1.NonResourceRule{}.OpenAPIModelName():                                                            schema_k8sio_api_authorization_v1_NonResourceRule(ref),
		authorizationv1.ResourceAttributes{}.OpenAPIModelName():                                                         schema_k8sio_api_authorization_v1_ResourceAttributes(ref),
		authorizationv1.ResourceRule{}.OpenAPIModelName():                                                               schema_k8sio_api_authorization_v1_ResourceRule(ref),
		authorizationv1.SelfSubjectAccessReview{}.OpenAPIModelName():                                                    schema_k8sio_api_authorization_v1_SelfSubjectAccessReview(ref),
		authorizationv1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName():                                                schema_k8sio_api_authorization_v1_SelfSubjectAccessReviewSpec(ref),
		authorizationv1.SelfSubjectRulesReview{}.OpenAPIModelName():                                                     schema_k8sio_api_authorization_v1_SelfSubjectRulesReview(ref),
		authorizationv1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName():                                                 schema_k8sio_api_authorization_v1_SelfSubjectRulesReviewSpec(ref),
		authorizationv1.SubjectAccessReview{}.OpenAPIModelName():                                                        schema_k8sio_api_authorization_v1_SubjectAccessReview(ref),
		authorizationv1.SubjectAccessReviewSpec{}.OpenAPIModelName():                                                    schema_k8sio_api_authorization_v1_SubjectAccessReviewSpec(ref),
		authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName():                                                  schema_k8sio_api_authorization_v1_SubjectAccessReviewStatus(ref),
		authorizationv1.SubjectRulesReviewStatus{}.OpenAPIModelName():                                                   schema_k8sio_api_authorization_v1_SubjectRulesReviewStatus(ref),
		authorizationv1beta1.LocalSubjectAccessReview{}.OpenAPIModelName():                                              schema_k8sio_api_authorization_v1beta1_LocalSubjectAccessReview(ref),
		authorizationv1beta1.NonResourceAttributes{}.OpenAPIModelName():                                                 schema_k8sio_api_authorization_v1beta1_NonResourceAttributes(ref),
		authorizationv1beta1.NonResourceRule{}.OpenAPIModelName():                                                       schema_k8sio_api_authorization_v1beta1_NonResourceRule(ref),
		authorizationv1beta1.ResourceAttributes{}.OpenAPIModelName():                                                    schema_k8sio_api_authorization_v1beta1_ResourceAttributes(ref),
		authorizationv1beta1.ResourceRule{}.OpenAPIModelName():                                                          schema_k8sio_api_authorization_v1beta1_ResourceRule(ref),
		authorizationv1beta1.SelfSubjectAccessReview{}.OpenAPIModelName():                                               schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReview(ref),
		authorizationv1beta1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName():                                           schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReviewSpec(ref),
		authorizationv1beta1.SelfSubjectRulesReview{}.OpenAPIModelName():                                                schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReview(ref),
		authorizationv1beta1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName():                                            schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReviewSpec(ref),
		authorizationv1beta1.SubjectAccessReview{}.OpenAPIModelName():                                                   schema_k8sio_api_authorization_v1beta1_SubjectAccessReview(ref),
		authorizationv1beta1.SubjectAccessReviewSpec{}.OpenAPIModelName():                                               schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewSpec(ref),
		authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName():                                             schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewStatus(ref),
		authorizationv1beta1.SubjectRulesReviewStatus{}.OpenAPIModelName():                                              schema_k8sio_api_authorization_v1beta1_SubjectRulesReviewStatus(ref),
		autoscalingv1.ContainerResourceMetricSource{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v1_ContainerResourceMetricSource(ref),
		autoscalingv1.ContainerResourceMetricStatus{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v1_ContainerResourceMetricStatus(ref),
		autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref),
		autoscalingv1.ExternalMetricSource{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref),
		autoscalingv1.ExternalMetricStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref),
		autoscalingv1.HorizontalPodAutoscaler{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref),
		autoscalingv1.HorizontalPodAutoscalerCondition{}.OpenAPIModelName():                                             schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref),
		autoscalingv1.HorizontalPodAutoscalerList{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref),
		autoscalingv1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref),
		autoscalingv1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref),
		autoscalingv1.MetricSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v1_MetricSpec(ref),
		autoscalingv1.MetricStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_autoscaling_v1_MetricStatus(ref),
		autoscalingv1.ObjectMetricSource{}.OpenAPIModelName():                                                           schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref),
		autoscalingv1.ObjectMetricStatus{}.OpenAPIModelName():                                                           schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref),
		autoscalingv1.PodsMetricSource{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref),
		autoscalingv1.PodsMetricStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref),
		autoscalingv1.ResourceMetricSource{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref),
		autoscalingv1.ResourceMetricStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref),
		autoscalingv1.Scale{}.OpenAPIModelName():                                                                        schema_k8sio_api_autoscaling_v1_Scale(ref),
		autoscalingv1.ScaleSpec{}.OpenAPIModelName():                                                                    schema_k8sio_api_autoscaling_v1_ScaleSpec(ref),
		autoscalingv1.ScaleStatus{}.OpenAPIModelName():                                                                  schema_k8sio_api_autoscaling_v1_ScaleStatus(ref),
		autoscalingv2.ContainerResourceMetricSource{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v2_ContainerResourceMetricSource(ref),
		autoscalingv2.ContainerResourceMetricStatus{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v2_ContainerResourceMetricStatus(ref),
		autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v2_CrossVersionObjectReference(ref),
		autoscalingv2.ExternalMetricSource{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v2_ExternalMetricSource(ref),
		autoscalingv2.ExternalMetricStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v2_ExternalMetricStatus(ref),
		autoscalingv2.HPAScalingPolicy{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v2_HPAScalingPolicy(ref),
		autoscalingv2.HPAScalingRules{}.OpenAPIModelName():                                                              schema_k8sio_api_autoscaling_v2_HPAScalingRules(ref),
		autoscalingv2.HorizontalPodAutoscaler{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscaler(ref),
		autoscalingv2.HorizontalPodAutoscalerBehavior{}.OpenAPIModelName():                                              schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerBehavior(ref),
		autoscalingv2.HorizontalPodAutoscalerCondition{}.OpenAPIModelName():                                             schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerCondition(ref),
		autoscalingv2.HorizontalPodAutoscalerList{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerList(ref),
		autoscalingv2.HorizontalPodAutoscalerSpec{}.OpenAPIModelName():                                                  schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerSpec(ref),
		autoscalingv2.HorizontalPodAutoscalerStatus{}.OpenAPIModelName():                                                schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerStatus(ref),
		autoscalingv2.MetricIdentifier{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v2_MetricIdentifier(ref),
		autoscalingv2.MetricSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v2_MetricSpec(ref),
		autoscalingv2.MetricStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_autoscaling_v2_MetricStatus(ref),
		autoscalingv2.MetricTarget{}.OpenAPIModelName():                                                                 schema_k8sio_api_autoscaling_v2_MetricTarget(ref),
		autoscalingv2.MetricValueStatus{}.OpenAPIModelName():                                                            schema_k8sio_api_autoscaling_v2_MetricValueStatus(ref),
		autoscalingv2.ObjectMetricSource{}.OpenAPIModelName():                                                           schema_k8sio_api_autoscaling_v2_ObjectMetricSource(ref),
		autoscalingv2.ObjectMetricStatus{}.OpenAPIModelName():                                                           schema_k8sio_api_autoscaling_v2_ObjectMetricStatus(ref),
		autoscalingv2.PodsMetricSource{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v2_PodsMetricSource(ref),
		autoscalingv2.PodsMetricStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_autoscaling_v2_PodsMetricStatus(ref),
		autoscalingv2.ResourceMetricSource{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v2_ResourceMetricSource(ref),
		autoscalingv2.ResourceMetricStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_autoscaling_v2_ResourceMetricStatus(ref),
		autoscalingv2beta1.ContainerResourceMetricSource{}.OpenAPIModelName():                                           schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricSource(ref),
		autoscalingv2beta1.ContainerResourceMetricStatus{}.OpenAPIModelName():                                           schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricStatus(ref),
		autoscalingv2beta1.CrossVersionObjectReference{}.OpenAPIModelName():                                             schema_k8sio_api_autoscaling_v2beta1_CrossVersionObjectReference(ref),
		autoscalingv2beta1.ExternalMetricSource{}.OpenAPIModelName():                                                    schema_k8sio_api_autoscaling_v2beta1_ExternalMetricSource(ref),
		autoscalingv2beta1.ExternalMetricStatus{}.OpenAPIModelName():                                                    schema_k8sio_api_autoscaling_v2beta1_ExternalMetricStatus(ref),
		autoscalingv2beta1.HorizontalPodAutoscaler{}.OpenAPIModelName():                                                 schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscaler(ref),
		autoscalingv2beta1.HorizontalPodAutoscalerCondition{}.OpenAPIModelName():                                        schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerCondition(ref),
		autoscalingv2beta1.HorizontalPodAutoscalerList{}.OpenAPIModelName():                                             schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerList(ref),
		autoscalingv2beta1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName():                                             schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerSpec(ref),
		autoscalingv2beta1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName():                                           schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerStatus(ref),
		autoscalingv2beta1.MetricSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_autoscaling_v2beta1_MetricSpec(ref),
		autoscalingv2beta1.MetricStatus{}.OpenAPIModelName():                                                            schema_k8sio_api_autoscaling_v2beta1_MetricStatus(ref),
		autoscalingv2beta1.ObjectMetricSource{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2beta1_ObjectMetricSource(ref),
		autoscalingv2beta1.ObjectMetricStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2beta1_ObjectMetricStatus(ref),
		autoscalingv2beta1.PodsMetricSource{}.OpenAPIModelName():                                                        schema_k8sio_api_autoscaling_v2beta1_PodsMetricSource(ref),
		autoscalingv2beta1.PodsMetricStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_autoscaling_v2beta1_PodsMetricStatus(ref),
		autoscalingv2beta1.ResourceMetricSource{}.OpenAPIModelName():                                                    schema_k8sio_api_autoscaling_v2beta1_ResourceMetricSource(ref),
		autoscalingv2beta1.ResourceMetricStatus{}.OpenAPIModelName():                                                    schema_k8sio_api_autoscaling_v2beta1_ResourceMetricStatus(ref),
		v2beta2.ContainerResourceMetricSource{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricSource(ref),
		v2beta2.ContainerResourceMetricStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2beta2_ContainerResourceMetricStatus(ref),
		v2beta2.CrossVersionObjectReference{}.OpenAPIModelName():                                                        schema_k8sio_api_autoscaling_v2beta2_CrossVersionObjectReference(ref),
		v2beta2.ExternalMetricSource{}.OpenAPIModelName():                                                               schema_k8sio_api_autoscaling_v2beta2_ExternalMetricSource(ref),
		v2beta2.ExternalMetricStatus{}.OpenAPIModelName():                                                               schema_k8sio_api_autoscaling_v2beta2_ExternalMetricStatus(ref),
		v2beta2.HPAScalingPolicy{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v2beta2_HPAScalingPolicy(ref),
		v2beta2.HPAScalingRules{}.OpenAPIModelName():                                                                    schema_k8sio_api_autoscaling_v2beta2_HPAScalingRules(ref),
		v2beta2.HorizontalPodAutoscaler{}.OpenAPIModelName():                                                            schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscaler(ref),
		v2beta2.HorizontalPodAutoscalerBehavior{}.OpenAPIModelName():                                                    schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerBehavior(ref),
		v2beta2.HorizontalPodAutoscalerCondition{}.OpenAPIModelName():                                                   schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerCondition(ref),
		v2beta2.HorizontalPodAutoscalerList{}.OpenAPIModelName():                                                        schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerList(ref),
		v2beta2.HorizontalPodAutoscalerSpec{}.OpenAPIModelName():                                                        schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerSpec(ref),
		v2beta2.HorizontalPodAutoscalerStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_autoscaling_v2beta2_HorizontalPodAutoscalerStatus(ref),
		v2beta2.MetricIdentifier{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v2beta2_MetricIdentifier(ref),
		v2beta2.MetricSpec{}.OpenAPIModelName():                                                                         schema_k8sio_api_autoscaling_v2beta2_MetricSpec(ref),
		v2beta2.MetricStatus{}.OpenAPIModelName():                                                                       schema_k8sio_api_autoscaling_v2beta2_MetricStatus(ref),
		v2beta2.MetricTarget{}.OpenAPIModelName():                                                                       schema_k8sio_api_autoscaling_v2beta2_MetricTarget(ref),
		v2beta2.MetricValueStatus{}.OpenAPIModelName():                                                                  schema_k8sio_api_autoscaling_v2beta2_MetricValueStatus(ref),
		v2beta2.ObjectMetricSource{}.OpenAPIModelName():                                                                 schema_k8sio_api_autoscaling_v2beta2_ObjectMetricSource(ref),
		v2beta2.ObjectMetricStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_autoscaling_v2beta2_ObjectMetricStatus(ref),
		v2beta2.PodsMetricSource{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v2beta2_PodsMetricSource(ref),
		v2beta2.PodsMetricStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_autoscaling_v2beta2_PodsMetricStatus(ref),
		v2beta2.ResourceMetricSource{}.OpenAPIModelName():                                                               schema_k8sio_api_autoscaling_v2beta2_ResourceMetricSource(ref),
		v2beta2.ResourceMetricStatus{}.OpenAPIModelName():                                                               schema_k8sio_api_autoscaling_v2beta2_ResourceMetricStatus(ref),
		batchv1.CronJob{}.OpenAPIModelName():                                                                            schema_k8sio_api_batch_v1_CronJob(ref),
		batchv1.CronJobList{}.OpenAPIModelName():                                                                        schema_k8sio_api_batch_v1_CronJobList(ref),
		batchv1.CronJobSpec{}.OpenAPIModelName():                                                                        schema_k8sio_api_batch_v1_CronJobSpec(ref),
		batchv1.CronJobStatus{}.OpenAPIModelName():                                                                      schema_k8sio_api_batch_v1_CronJobStatus(ref),
		batchv1.Job{}.OpenAPIModelName():                                                                                schema_k8sio_api_batch_v1_Job(ref),
		batchv1.JobCondition{}.OpenAPIModelName():                                                                       schema_k8sio_api_batch_v1_JobCondition(ref),
		batchv1.JobList{}.OpenAPIModelName():                                                                            schema_k8sio_api_batch_v1_JobList(ref),
		batchv1.JobSpec{}.OpenAPIModelName():                                                                            schema_k8sio_api_batch_v1_JobSpec(ref),
		batchv1.JobStatus{}.OpenAPIModelName():                                                                          schema_k8sio_api_batch_v1_JobStatus(ref),
		batchv1.JobTemplateSpec{}.OpenAPIModelName():                                                                    schema_k8sio_api_batch_v1_JobTemplateSpec(ref),
		batchv1.PodFailurePolicy{}.OpenAPIModelName():                                                                   schema_k8sio_api_batch_v1_PodFailurePolicy(ref),
		batchv1.PodFailurePolicyOnExitCodesRequirement{}.OpenAPIModelName():                                             schema_k8sio_api_batch_v1_PodFailurePolicyOnExitCodesRequirement(ref),
		batchv1.PodFailurePolicyOnPodConditionsPattern{}.OpenAPIModelName():                                             schema_k8sio_api_batch_v1_PodFailurePolicyOnPodConditionsPattern(ref),
		batchv1.PodFailurePolicyRule{}.OpenAPIModelName():                                                               schema_k8sio_api_batch_v1_PodFailurePolicyRule(ref),
		batchv1.SuccessPolicy{}.OpenAPIModelName():                                                                      schema_k8sio_api_batch_v1_SuccessPolicy(ref),
		batchv1.SuccessPolicyRule{}.OpenAPIModelName():                                                                  schema_k8sio_api_batch_v1_SuccessPolicyRule(ref),
		batchv1.UncountedTerminatedPods{}.OpenAPIModelName():                                                            schema_k8sio_api_batch_v1_UncountedTerminatedPods(ref),
		batchv1beta1.CronJob{}.OpenAPIModelName():                                                                       schema_k8sio_api_batch_v1beta1_CronJob(ref),
		batchv1beta1.CronJobList{}.OpenAPIModelName():                                                                   schema_k8sio_api_batch_v1beta1_CronJobList(ref),
		batchv1beta1.CronJobSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_batch_v1beta1_CronJobSpec(ref),
		batchv1beta1.CronJobStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_batch_v1beta1_CronJobStatus(ref),
		batchv1beta1.JobTemplateSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_batch_v1beta1_JobTemplateSpec(ref),
		certificatesv1.CertificateSigningRequest{}.OpenAPIModelName():                                                   schema_k8sio_api_certificates_v1_CertificateSigningRequest(ref),
		certificatesv1.CertificateSigningRequestCondition{}.OpenAPIModelName():                                          schema_k8sio_api_certificates_v1_CertificateSigningRequestCondition(ref),
		certificatesv1.CertificateSigningRequestList{}.OpenAPIModelName():                                               schema_k8sio_api_certificates_v1_CertificateSigningRequestList(ref),
		certificatesv1.CertificateSigningRequestSpec{}.OpenAPIModelName():                                               schema_k8sio_api_certificates_v1_CertificateSigningRequestSpec(ref),
		certificatesv1.CertificateSigningRequestStatus{}.OpenAPIModelName():                                             schema_k8sio_api_certificates_v1_CertificateSigningRequestStatus(ref),
		certificatesv1alpha1.ClusterTrustBundle{}.OpenAPIModelName():                                                    schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundle(ref),
		certificatesv1alpha1.ClusterTrustBundleList{}.OpenAPIModelName():                                                schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundleList(ref),
		certificatesv1alpha1.ClusterTrustBundleSpec{}.OpenAPIModelName():                                                schema_k8sio_api_certificates_v1alpha1_ClusterTrustBundleSpec(ref),
		certificatesv1beta1.CertificateSigningRequest{}.OpenAPIModelName():                                              schema_k8sio_api_certificates_v1beta1_CertificateSigningRequest(ref),
		certificatesv1beta1.CertificateSigningRequestCondition{}.OpenAPIModelName():                                     schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestCondition(ref),
		certificatesv1beta1.CertificateSigningRequestList{}.OpenAPIModelName():                                          schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestList(ref),
		certificatesv1beta1.CertificateSigningRequestSpec{}.OpenAPIModelName():                                          schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestSpec(ref),
		certificatesv1beta1.CertificateSigningRequestStatus{}.OpenAPIModelName():                                        schema_k8sio_api_certificates_v1beta1_CertificateSigningRequestStatus(ref),
		certificatesv1beta1.ClusterTrustBundle{}.OpenAPIModelName():                                                     schema_k8sio_api_certificates_v1beta1_ClusterTrustBundle(ref),
		certificatesv1beta1.ClusterTrustBundleList{}.OpenAPIModelName():                                                 schema_k8sio_api_certificates_v1beta1_ClusterTrustBundleList(ref),
		certificatesv1beta1.ClusterTrustBundleSpec{}.OpenAPIModelName():                                                 schema_k8sio_api_certificates_v1beta1_ClusterTrustBundleSpec(ref),
		certificatesv1beta1.PodCertificateRequest{}.OpenAPIModelName():                                                  schema_k8sio_api_certificates_v1beta1_PodCertificateRequest(ref),
		certificatesv1beta1.PodCertificateRequestList{}.OpenAPIModelName():                                              schema_k8sio_api_certificates_v1beta1_PodCertificateRequestList(ref),
		certificatesv1beta1.PodCertificateRequestSpec{}.OpenAPIModelName():                                              schema_k8sio_api_certificates_v1beta1_PodCertificateRequestSpec(ref),
		certificatesv1beta1.PodCertificateRequestStatus{}.OpenAPIModelName():                                            schema_k8sio_api_certificates_v1beta1_PodCertificateRequestStatus(ref),
		coordinationv1.Lease{}.OpenAPIModelName():                                                                       schema_k8sio_api_coordination_v1_Lease(ref),
		coordinationv1.LeaseList{}.OpenAPIModelName():                                                                   schema_k8sio_api_coordination_v1_LeaseList(ref),
		coordinationv1.LeaseSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_coordination_v1_LeaseSpec(ref),
		v1alpha2.LeaseCandidate{}.OpenAPIModelName():                                                                    schema_k8sio_api_coordination_v1alpha2_LeaseCandidate(ref),
		v1alpha2.LeaseCandidateList{}.OpenAPIModelName():                                                                schema_k8sio_api_coordination_v1alpha2_LeaseCandidateList(ref),
		v1alpha2.LeaseCandidateSpec{}.OpenAPIModelName():                                                                schema_k8sio_api_coordination_v1alpha2_LeaseCandidateSpec(ref),
		coordinationv1beta1.Lease{}.OpenAPIModelName():                                                                  schema_k8sio_api_coordination_v1beta1_Lease(ref),
		coordinationv1beta1.LeaseCandidate{}.OpenAPIModelName():                                                         schema_k8sio_api_coordination_v1beta1_LeaseCandidate(ref),
		coordinationv1beta1.LeaseCandidateList{}.OpenAPIModelName():                                                     schema_k8sio_api_coordination_v1beta1_LeaseCandidateList(ref),
		coordinationv1beta1.LeaseCandidateSpec{}.OpenAPIModelName():                                                     schema_k8sio_api_coordination_v1beta1_LeaseCandidateSpec(ref),
		coordinationv1beta1.LeaseList{}.OpenAPIModelName():                                                              schema_k8sio_api_coordination_v1beta1_LeaseList(ref),
		coordinationv1beta1.LeaseSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_coordination_v1beta1_LeaseSpec(ref),
		corev1.AWSElasticBlockStoreVolumeSource{}.OpenAPIModelName():                                                    schema_k8sio_api_core_v1_AWSElasticBlockStoreVolumeSource(ref),
		corev1.Affinity{}.OpenAPIModelName():                                                                            schema_k8sio_api_core_v1_Affinity(ref),
		corev1.AppArmorProfile{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_AppArmorProfile(ref),
		corev1.AttachedVolume{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_AttachedVolume(ref),
		corev1.AvoidPods{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_AvoidPods(ref),
		corev1.AzureDiskVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_AzureDiskVolumeSource(ref),
		corev1.AzureFilePersistentVolumeSource{}.OpenAPIModelName():                                                     schema_k8sio_api_core_v1_AzureFilePersistentVolumeSource(ref),
		corev1.AzureFileVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_AzureFileVolumeSource(ref),
		corev1.Binding{}.OpenAPIModelName():                                                                             schema_k8sio_api_core_v1_Binding(ref),
		corev1.CSIPersistentVolumeSource{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_CSIPersistentVolumeSource(ref),
		corev1.CSIVolumeSource{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_CSIVolumeSource(ref),
		corev1.Capabilities{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_Capabilities(ref),
		corev1.CephFSPersistentVolumeSource{}.OpenAPIModelName():                                                        schema_k8sio_api_core_v1_CephFSPersistentVolumeSource(ref),
		corev1.CephFSVolumeSource{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_CephFSVolumeSource(ref),
		corev1.CinderPersistentVolumeSource{}.OpenAPIModelName():                                                        schema_k8sio_api_core_v1_CinderPersistentVolumeSource(ref),
		corev1.CinderVolumeSource{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_CinderVolumeSource(ref),
		corev1.ClientIPConfig{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ClientIPConfig(ref),
		corev1.ClusterTrustBundleProjection{}.OpenAPIModelName():                                                        schema_k8sio_api_core_v1_ClusterTrustBundleProjection(ref),
		corev1.ComponentCondition{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_ComponentCondition(ref),
		corev1.ComponentStatus{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_ComponentStatus(ref),
		corev1.ComponentStatusList{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ComponentStatusList(ref),
		corev1.ConfigMap{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_ConfigMap(ref),
		corev1.ConfigMapEnvSource{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_ConfigMapEnvSource(ref),
		corev1.ConfigMapKeySelector{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_ConfigMapKeySelector(ref),
		corev1.ConfigMapList{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ConfigMapList(ref),
		corev1.ConfigMapNodeConfigSource{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_ConfigMapNodeConfigSource(ref),
		corev1.ConfigMapProjection{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ConfigMapProjection(ref),
		corev1.ConfigMapVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ConfigMapVolumeSource(ref),
		corev1.Container{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_Container(ref),
		corev1.ContainerExtendedResourceRequest{}.OpenAPIModelName():                                                    schema_k8sio_api_core_v1_ContainerExtendedResourceRequest(ref),
		corev1.ContainerImage{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ContainerImage(ref),
		corev1.ContainerPort{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ContainerPort(ref),
		corev1.ContainerResizePolicy{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ContainerResizePolicy(ref),
		corev1.ContainerRestartRule{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_ContainerRestartRule(ref),
		corev1.ContainerRestartRuleOnExitCodes{}.OpenAPIModelName():                                                     schema_k8sio_api_core_v1_ContainerRestartRuleOnExitCodes(ref),
		corev1.ContainerState{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ContainerState(ref),
		corev1.ContainerStateRunning{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ContainerStateRunning(ref),
		corev1.ContainerStateTerminated{}.OpenAPIModelName():                                                            schema_k8sio_api_core_v1_ContainerStateTerminated(ref),
		corev1.ContainerStateWaiting{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ContainerStateWaiting(ref),
		corev1.ContainerStatus{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_ContainerStatus(ref),
		corev1.ContainerUser{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ContainerUser(ref),
		corev1.DaemonEndpoint{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_DaemonEndpoint(ref),
		corev1.DownwardAPIProjection{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_DownwardAPIProjection(ref),
		corev1.DownwardAPIVolumeFile{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_DownwardAPIVolumeFile(ref),
		corev1.DownwardAPIVolumeSource{}.OpenAPIModelName():                                                             schema_k8sio_api_core_v1_DownwardAPIVolumeSource(ref),
		corev1.EmptyDirVolumeSource{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_EmptyDirVolumeSource(ref),
		corev1.EndpointAddress{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_EndpointAddress(ref),
		corev1.EndpointPort{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_EndpointPort(ref),
		corev1.EndpointSubset{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_EndpointSubset(ref),
		corev1.Endpoints{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_Endpoints(ref),
		corev1.EndpointsList{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_EndpointsList(ref),
		corev1.EnvFromSource{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_EnvFromSource(ref),
		corev1.EnvVar{}.OpenAPIModelName():                                                                              schema_k8sio_api_core_v1_EnvVar(ref),
		corev1.EnvVarSource{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_EnvVarSource(ref),
		corev1.EphemeralContainer{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_EphemeralContainer(ref),
		corev1.EphemeralContainerCommon{}.OpenAPIModelName():                                                            schema_k8sio_api_core_v1_EphemeralContainerCommon(ref),
		corev1.EphemeralVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_EphemeralVolumeSource(ref),
		corev1.Event{}.OpenAPIModelName():                                                                               schema_k8sio_api_core_v1_Event(ref),
		corev1.EventList{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_EventList(ref),
		corev1.EventSeries{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_EventSeries(ref),
		corev1.EventSource{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_EventSource(ref),
		corev1.ExecAction{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_ExecAction(ref),
		corev1.FCVolumeSource{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_FCVolumeSource(ref),
		corev1.FileKeySelector{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_FileKeySelector(ref),
		corev1.FlexPersistentVolumeSource{}.OpenAPIModelName():                                                          schema_k8sio_api_core_v1_FlexPersistentVolumeSource(ref),
		corev1.FlexVolumeSource{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_FlexVolumeSource(ref),
		corev1.FlockerVolumeSource{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_FlockerVolumeSource(ref),
		corev1.GCEPersistentDiskVolumeSource{}.OpenAPIModelName():                                                       schema_k8sio_api_core_v1_GCEPersistentDiskVolumeSource(ref),
		corev1.GRPCAction{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_GRPCAction(ref),
		corev1.GitRepoVolumeSource{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_GitRepoVolumeSource(ref),
		corev1.GlusterfsPersistentVolumeSource{}.OpenAPIModelName():                                                     schema_k8sio_api_core_v1_GlusterfsPersistentVolumeSource(ref),
		corev1.GlusterfsVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_GlusterfsVolumeSource(ref),
		corev1.HTTPGetAction{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_HTTPGetAction(ref),
		corev1.HTTPHeader{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_HTTPHeader(ref),
		corev1.HostAlias{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_HostAlias(ref),
		corev1.HostIP{}.OpenAPIModelName():                                                                              schema_k8sio_api_core_v1_HostIP(ref),
		corev1.HostPathVolumeSource{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_HostPathVolumeSource(ref),
		corev1.ISCSIPersistentVolumeSource{}.OpenAPIModelName():                                                         schema_k8sio_api_core_v1_ISCSIPersistentVolumeSource(ref),
		corev1.ISCSIVolumeSource{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_ISCSIVolumeSource(ref),
		corev1.ImageVolumeSource{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_ImageVolumeSource(ref),
		corev1.KeyToPath{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_KeyToPath(ref),
		corev1.Lifecycle{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_Lifecycle(ref),
		corev1.LifecycleHandler{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_LifecycleHandler(ref),
		corev1.LimitRange{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_LimitRange(ref),
		corev1.LimitRangeItem{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_LimitRangeItem(ref),
		corev1.LimitRangeList{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_LimitRangeList(ref),
		corev1.LimitRangeSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_LimitRangeSpec(ref),
		corev1.LinuxContainerUser{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_LinuxContainerUser(ref),
		corev1.List{}.OpenAPIModelName():                                                                                schema_k8sio_api_core_v1_List(ref),
		corev1.LoadBalancerIngress{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_LoadBalancerIngress(ref),
		corev1.LoadBalancerStatus{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_LoadBalancerStatus(ref),
		corev1.LocalObjectReference{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_LocalObjectReference(ref),
		corev1.LocalVolumeSource{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_LocalVolumeSource(ref),
		corev1.ModifyVolumeStatus{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_ModifyVolumeStatus(ref),
		corev1.NFSVolumeSource{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_NFSVolumeSource(ref),
		corev1.Namespace{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_Namespace(ref),
		corev1.NamespaceCondition{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_NamespaceCondition(ref),
		corev1.NamespaceList{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_NamespaceList(ref),
		corev1.NamespaceSpec{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_NamespaceSpec(ref),
		corev1.NamespaceStatus{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_NamespaceStatus(ref),
		corev1.Node{}.OpenAPIModelName():                                                                                schema_k8sio_api_core_v1_Node(ref),
		corev1.NodeAddress{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_NodeAddress(ref),
		corev1.NodeAffinity{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_NodeAffinity(ref),
		corev1.NodeCondition{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_NodeCondition(ref),
		corev1.NodeConfigSource{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_NodeConfigSource(ref),
		corev1.NodeConfigStatus{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_NodeConfigStatus(ref),
		corev1.NodeDaemonEndpoints{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_NodeDaemonEndpoints(ref),
		corev1.NodeFeatures{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_NodeFeatures(ref),
		corev1.NodeList{}.OpenAPIModelName():                                                                            schema_k8sio_api_core_v1_NodeList(ref),
		corev1.NodeProxyOptions{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_NodeProxyOptions(ref),
		corev1.NodeRuntimeHandler{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_NodeRuntimeHandler(ref),
		corev1.NodeRuntimeHandlerFeatures{}.OpenAPIModelName():                                                          schema_k8sio_api_core_v1_NodeRuntimeHandlerFeatures(ref),
		corev1.NodeSelector{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_NodeSelector(ref),
		corev1.NodeSelectorRequirement{}.OpenAPIModelName():                                                             schema_k8sio_api_core_v1_NodeSelectorRequirement(ref),
		corev1.NodeSelectorTerm{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_NodeSelectorTerm(ref),
		corev1.NodeSpec{}.OpenAPIModelName():                                                                            schema_k8sio_api_core_v1_NodeSpec(ref),
		corev1.NodeStatus{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_NodeStatus(ref),
		corev1.NodeSwapStatus{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_NodeSwapStatus(ref),
		corev1.NodeSystemInfo{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_NodeSystemInfo(ref),
		corev1.ObjectFieldSelector{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ObjectFieldSelector(ref),
		corev1.ObjectReference{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_ObjectReference(ref),
		corev1.PersistentVolume{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_PersistentVolume(ref),
		corev1.PersistentVolumeClaim{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_PersistentVolumeClaim(ref),
		corev1.PersistentVolumeClaimCondition{}.OpenAPIModelName():                                                      schema_k8sio_api_core_v1_PersistentVolumeClaimCondition(ref),
		corev1.PersistentVolumeClaimList{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_PersistentVolumeClaimList(ref),
		corev1.PersistentVolumeClaimSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_PersistentVolumeClaimSpec(ref),
		corev1.PersistentVolumeClaimStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_core_v1_PersistentVolumeClaimStatus(ref),
		corev1.PersistentVolumeClaimTemplate{}.OpenAPIModelName():                                                       schema_k8sio_api_core_v1_PersistentVolumeClaimTemplate(ref),
		corev1.PersistentVolumeClaimVolumeSource{}.OpenAPIModelName():                                                   schema_k8sio_api_core_v1_PersistentVolumeClaimVolumeSource(ref),
		corev1.PersistentVolumeList{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_PersistentVolumeList(ref),
		corev1.PersistentVolumeSource{}.OpenAPIModelName():                                                              schema_k8sio_api_core_v1_PersistentVolumeSource(ref),
		corev1.PersistentVolumeSpec{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_PersistentVolumeSpec(ref),
		corev1.PersistentVolumeStatus{}.OpenAPIModelName():                                                              schema_k8sio_api_core_v1_PersistentVolumeStatus(ref),
		corev1.PhotonPersistentDiskVolumeSource{}.OpenAPIModelName():                                                    schema_k8sio_api_core_v1_PhotonPersistentDiskVolumeSource(ref),
		corev1.Pod{}.OpenAPIModelName():                                                                                 schema_k8sio_api_core_v1_Pod(ref),
		corev1.PodAffinity{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_PodAffinity(ref),
		corev1.PodAffinityTerm{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodAffinityTerm(ref),
		corev1.PodAntiAffinity{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodAntiAffinity(ref),
		corev1.PodAttachOptions{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_PodAttachOptions(ref),
		corev1.PodCertificateProjection{}.OpenAPIModelName():                                                            schema_k8sio_api_core_v1_PodCertificateProjection(ref),
		corev1.PodCondition{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_PodCondition(ref),
		corev1.PodDNSConfig{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_PodDNSConfig(ref),
		corev1.PodDNSConfigOption{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_PodDNSConfigOption(ref),
		corev1.PodExecOptions{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_PodExecOptions(ref),
		corev1.PodExtendedResourceClaimStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_core_v1_PodExtendedResourceClaimStatus(ref),
		corev1.PodIP{}.OpenAPIModelName():                                                                               schema_k8sio_api_core_v1_PodIP(ref),
		corev1.PodList{}.OpenAPIModelName():                                                                             schema_k8sio_api_core_v1_PodList(ref),
		corev1.PodLogOptions{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_PodLogOptions(ref),
		corev1.PodOS{}.OpenAPIModelName():                                                                               schema_k8sio_api_core_v1_PodOS(ref),
		corev1.PodPortForwardOptions{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_PodPortForwardOptions(ref),
		corev1.PodProxyOptions{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodProxyOptions(ref),
		corev1.PodReadinessGate{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_PodReadinessGate(ref),
		corev1.PodResourceClaim{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_PodResourceClaim(ref),
		corev1.PodResourceClaimStatus{}.OpenAPIModelName():                                                              schema_k8sio_api_core_v1_PodResourceClaimStatus(ref),
		corev1.PodSchedulingGate{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_PodSchedulingGate(ref),
		corev1.PodSecurityContext{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_PodSecurityContext(ref),
		corev1.PodSignature{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_PodSignature(ref),
		corev1.PodSpec{}.OpenAPIModelName():                                                                             schema_k8sio_api_core_v1_PodSpec(ref),
		corev1.PodStatus{}.OpenAPIModelName():                                                                           schema_k8sio_api_core_v1_PodStatus(ref),
		corev1.PodStatusResult{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodStatusResult(ref),
		corev1.PodTemplate{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_PodTemplate(ref),
		corev1.PodTemplateList{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodTemplateList(ref),
		corev1.PodTemplateSpec{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_PodTemplateSpec(ref),
		corev1.PortStatus{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_PortStatus(ref),
		corev1.PortworxVolumeSource{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_PortworxVolumeSource(ref),
		corev1.PreferAvoidPodsEntry{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_PreferAvoidPodsEntry(ref),
		corev1.PreferredSchedulingTerm{}.OpenAPIModelName():                                                             schema_k8sio_api_core_v1_PreferredSchedulingTerm(ref),
		corev1.Probe{}.OpenAPIModelName():                                                                               schema_k8sio_api_core_v1_Probe(ref),
		corev1.ProbeHandler{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_ProbeHandler(ref),
		corev1.ProjectedVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ProjectedVolumeSource(ref),
		corev1.QuobyteVolumeSource{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_QuobyteVolumeSource(ref),
		corev1.RBDPersistentVolumeSource{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_RBDPersistentVolumeSource(ref),
		corev1.RBDVolumeSource{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_RBDVolumeSource(ref),
		corev1.RangeAllocation{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_RangeAllocation(ref),
		corev1.ReplicationController{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ReplicationController(ref),
		corev1.ReplicationControllerCondition{}.OpenAPIModelName():                                                      schema_k8sio_api_core_v1_ReplicationControllerCondition(ref),
		corev1.ReplicationControllerList{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_ReplicationControllerList(ref),
		corev1.ReplicationControllerSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_ReplicationControllerSpec(ref),
		corev1.ReplicationControllerStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_core_v1_ReplicationControllerStatus(ref),
		corev1.ResourceClaim{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ResourceClaim(ref),
		corev1.ResourceFieldSelector{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_ResourceFieldSelector(ref),
		corev1.ResourceHealth{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ResourceHealth(ref),
		corev1.ResourceQuota{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ResourceQuota(ref),
		corev1.ResourceQuotaList{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_ResourceQuotaList(ref),
		corev1.ResourceQuotaSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_ResourceQuotaSpec(ref),
		corev1.ResourceQuotaStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ResourceQuotaStatus(ref),
		corev1.ResourceRequirements{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_ResourceRequirements(ref),
		corev1.ResourceStatus{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ResourceStatus(ref),
		corev1.SELinuxOptions{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_SELinuxOptions(ref),
		corev1.ScaleIOPersistentVolumeSource{}.OpenAPIModelName():                                                       schema_k8sio_api_core_v1_ScaleIOPersistentVolumeSource(ref),
		corev1.ScaleIOVolumeSource{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ScaleIOVolumeSource(ref),
		corev1.ScopeSelector{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ScopeSelector(ref),
		corev1.ScopedResourceSelectorRequirement{}.OpenAPIModelName():                                                   schema_k8sio_api_core_v1_ScopedResourceSelectorRequirement(ref),
		corev1.SeccompProfile{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_SeccompProfile(ref),
		corev1.Secret{}.OpenAPIModelName():                                                                              schema_k8sio_api_core_v1_Secret(ref),
		corev1.SecretEnvSource{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_SecretEnvSource(ref),
		corev1.SecretKeySelector{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_SecretKeySelector(ref),
		corev1.SecretList{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_SecretList(ref),
		corev1.SecretProjection{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_SecretProjection(ref),
		corev1.SecretReference{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_SecretReference(ref),
		corev1.SecretVolumeSource{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_SecretVolumeSource(ref),
		corev1.SecurityContext{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_SecurityContext(ref),
		corev1.SerializedReference{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_SerializedReference(ref),
		corev1.Service{}.OpenAPIModelName():                                                                             schema_k8sio_api_core_v1_Service(ref),
		corev1.ServiceAccount{}.OpenAPIModelName():                                                                      schema_k8sio_api_core_v1_ServiceAccount(ref),
		corev1.ServiceAccountList{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_ServiceAccountList(ref),
		corev1.ServiceAccountTokenProjection{}.OpenAPIModelName():                                                       schema_k8sio_api_core_v1_ServiceAccountTokenProjection(ref),
		corev1.ServiceList{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_ServiceList(ref),
		corev1.ServicePort{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_ServicePort(ref),
		corev1.ServiceProxyOptions{}.OpenAPIModelName():                                                                 schema_k8sio_api_core_v1_ServiceProxyOptions(ref),
		corev1.ServiceSpec{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_ServiceSpec(ref),
		corev1.ServiceStatus{}.OpenAPIModelName():                                                                       schema_k8sio_api_core_v1_ServiceStatus(ref),
		corev1.SessionAffinityConfig{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_SessionAffinityConfig(ref),
		corev1.SleepAction{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_SleepAction(ref),
		corev1.StorageOSPersistentVolumeSource{}.OpenAPIModelName():                                                     schema_k8sio_api_core_v1_StorageOSPersistentVolumeSource(ref),
		corev1.StorageOSVolumeSource{}.OpenAPIModelName():                                                               schema_k8sio_api_core_v1_StorageOSVolumeSource(ref),
		corev1.Sysctl{}.OpenAPIModelName():                                                                              schema_k8sio_api_core_v1_Sysctl(ref),
		corev1.TCPSocketAction{}.OpenAPIModelName():                                                                     schema_k8sio_api_core_v1_TCPSocketAction(ref),
		corev1.Taint{}.OpenAPIModelName():                                                                               schema_k8sio_api_core_v1_Taint(ref),
		corev1.Toleration{}.OpenAPIModelName():                                                                          schema_k8sio_api_core_v1_Toleration(ref),
		corev1.TopologySelectorLabelRequirement{}.OpenAPIModelName():                                                    schema_k8sio_api_core_v1_TopologySelectorLabelRequirement(ref),
		corev1.TopologySelectorTerm{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_TopologySelectorTerm(ref),
		corev1.TopologySpreadConstraint{}.OpenAPIModelName():                                                            schema_k8sio_api_core_v1_TopologySpreadConstraint(ref),
		corev1.TypedLocalObjectReference{}.OpenAPIModelName():                                                           schema_k8sio_api_core_v1_TypedLocalObjectReference(ref),
		corev1.TypedObjectReference{}.OpenAPIModelName():                                                                schema_k8sio_api_core_v1_TypedObjectReference(ref),
		corev1.Volume{}.OpenAPIModelName():                                                                              schema_k8sio_api_core_v1_Volume(ref),
		corev1.VolumeDevice{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_VolumeDevice(ref),
		corev1.VolumeMount{}.OpenAPIModelName():                                                                         schema_k8sio_api_core_v1_VolumeMount(ref),
		corev1.VolumeMountStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_VolumeMountStatus(ref),
		corev1.VolumeNodeAffinity{}.OpenAPIModelName():                                                                  schema_k8sio_api_core_v1_VolumeNodeAffinity(ref),
		corev1.VolumeProjection{}.OpenAPIModelName():                                                                    schema_k8sio_api_core_v1_VolumeProjection(ref),
		corev1.VolumeResourceRequirements{}.OpenAPIModelName():                                                          schema_k8sio_api_core_v1_VolumeResourceRequirements(ref),
		corev1.VolumeSource{}.OpenAPIModelName():                                                                        schema_k8sio_api_core_v1_VolumeSource(ref),
		corev1.VsphereVirtualDiskVolumeSource{}.OpenAPIModelName():                                                      schema_k8sio_api_core_v1_VsphereVirtualDiskVolumeSource(ref),
		corev1.WeightedPodAffinityTerm{}.OpenAPIModelName():                                                             schema_k8sio_api_core_v1_WeightedPodAffinityTerm(ref),
		corev1.WindowsSecurityContextOptions{}.OpenAPIModelName():                                                       schema_k8sio_api_core_v1_WindowsSecurityContextOptions(ref),
		corev1.WorkloadReference{}.OpenAPIModelName():                                                                   schema_k8sio_api_core_v1_WorkloadReference(ref),
		discoveryv1.Endpoint{}.OpenAPIModelName():                                                                       schema_k8sio_api_discovery_v1_Endpoint(ref),
		discoveryv1.EndpointConditions{}.OpenAPIModelName():                                                             schema_k8sio_api_discovery_v1_EndpointConditions(ref),
		discoveryv1.EndpointHints{}.OpenAPIModelName():                                                                  schema_k8sio_api_discovery_v1_EndpointHints(ref),
		discoveryv1.EndpointPort{}.OpenAPIModelName():                                                                   schema_k8sio_api_discovery_v1_EndpointPort(ref),
		discoveryv1.EndpointSlice{}.OpenAPIModelName():                                                                  schema_k8sio_api_discovery_v1_EndpointSlice(ref),
		discoveryv1.EndpointSliceList{}.OpenAPIModelName():                                                              schema_k8sio_api_discovery_v1_EndpointSliceList(ref),
		discoveryv1.ForNode{}.OpenAPIModelName():                                                                        schema_k8sio_api_discovery_v1_ForNode(ref),
		discoveryv1.ForZone{}.OpenAPIModelName():                                                                        schema_k8sio_api_discovery_v1_ForZone(ref),
		discoveryv1beta1.Endpoint{}.OpenAPIModelName():                                                                  schema_k8sio_api_discovery_v1beta1_Endpoint(ref),
		discoveryv1beta1.EndpointConditions{}.OpenAPIModelName():                                                        schema_k8sio_api_discovery_v1beta1_EndpointConditions(ref),
		discoveryv1beta1.EndpointHints{}.OpenAPIModelName():                                                             schema_k8sio_api_discovery_v1beta1_EndpointHints(ref),
		discoveryv1beta1.EndpointPort{}.OpenAPIModelName():                                                              schema_k8sio_api_discovery_v1beta1_EndpointPort(ref),
		discoveryv1beta1.EndpointSlice{}.OpenAPIModelName():                                                             schema_k8sio_api_discovery_v1beta1_EndpointSlice(ref),
		discoveryv1beta1.EndpointSliceList{}.OpenAPIModelName():                                                         schema_k8sio_api_discovery_v1beta1_EndpointSliceList(ref),
		discoveryv1beta1.ForNode{}.OpenAPIModelName():                                                                   schema_k8sio_api_discovery_v1beta1_ForNode(ref),
		discoveryv1beta1.ForZone{}.OpenAPIModelName():                                                                   schema_k8sio_api_discovery_v1beta1_ForZone(ref),
		eventsv1.Event{}.OpenAPIModelName():                                                                             schema_k8sio_api_events_v1_Event(ref),
		eventsv1.EventList{}.OpenAPIModelName():                                                                         schema_k8sio_api_events_v1_EventList(ref),
		eventsv1.EventSeries{}.OpenAPIModelName():                                                                       schema_k8sio_api_events_v1_EventSeries(ref),
		eventsv1beta1.Event{}.OpenAPIModelName():                                                                        schema_k8sio_api_events_v1beta1_Event(ref),
		eventsv1beta1.EventList{}.OpenAPIModelName():                                                                    schema_k8sio_api_events_v1beta1_EventList(ref),
		eventsv1beta1.EventSeries{}.OpenAPIModelName():                                                                  schema_k8sio_api_events_v1beta1_EventSeries(ref),
		extensionsv1beta1.DaemonSet{}.OpenAPIModelName():                                                                schema_k8sio_api_extensions_v1beta1_DaemonSet(ref),
		extensionsv1beta1.DaemonSetCondition{}.OpenAPIModelName():                                                       schema_k8sio_api_extensions_v1beta1_DaemonSetCondition(ref),
		extensionsv1beta1.DaemonSetList{}.OpenAPIModelName():                                                            schema_k8sio_api_extensions_v1beta1_DaemonSetList(ref),
		extensionsv1beta1.DaemonSetSpec{}.OpenAPIModelName():                                                            schema_k8sio_api_extensions_v1beta1_DaemonSetSpec(ref),
		extensionsv1beta1.DaemonSetStatus{}.OpenAPIModelName():                                                          schema_k8sio_api_extensions_v1beta1_DaemonSetStatus(ref),
		extensionsv1beta1.DaemonSetUpdateStrategy{}.OpenAPIModelName():                                                  schema_k8sio_api_extensions_v1beta1_DaemonSetUpdateStrategy(ref),
		extensionsv1beta1.Deployment{}.OpenAPIModelName():                                                               schema_k8sio_api_extensions_v1beta1_Deployment(ref),
		extensionsv1beta1.DeploymentCondition{}.OpenAPIModelName():                                                      schema_k8sio_api_extensions_v1beta1_DeploymentCondition(ref),
		extensionsv1beta1.DeploymentList{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_DeploymentList(ref),
		extensionsv1beta1.DeploymentRollback{}.OpenAPIModelName():                                                       schema_k8sio_api_extensions_v1beta1_DeploymentRollback(ref),
		extensionsv1beta1.DeploymentSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_DeploymentSpec(ref),
		extensionsv1beta1.DeploymentStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_extensions_v1beta1_DeploymentStatus(ref),
		extensionsv1beta1.DeploymentStrategy{}.OpenAPIModelName():                                                       schema_k8sio_api_extensions_v1beta1_DeploymentStrategy(ref),
		extensionsv1beta1.HTTPIngressPath{}.OpenAPIModelName():                                                          schema_k8sio_api_extensions_v1beta1_HTTPIngressPath(ref),
		extensionsv1beta1.HTTPIngressRuleValue{}.OpenAPIModelName():                                                     schema_k8sio_api_extensions_v1beta1_HTTPIngressRuleValue(ref),
		extensionsv1beta1.IPBlock{}.OpenAPIModelName():                                                                  schema_k8sio_api_extensions_v1beta1_IPBlock(ref),
		extensionsv1beta1.Ingress{}.OpenAPIModelName():                                                                  schema_k8sio_api_extensions_v1beta1_Ingress(ref),
		extensionsv1beta1.IngressBackend{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_IngressBackend(ref),
		extensionsv1beta1.IngressList{}.OpenAPIModelName():                                                              schema_k8sio_api_extensions_v1beta1_IngressList(ref),
		extensionsv1beta1.IngressLoadBalancerIngress{}.OpenAPIModelName():                                               schema_k8sio_api_extensions_v1beta1_IngressLoadBalancerIngress(ref),
		extensionsv1beta1.IngressLoadBalancerStatus{}.OpenAPIModelName():                                                schema_k8sio_api_extensions_v1beta1_IngressLoadBalancerStatus(ref),
		extensionsv1beta1.IngressPortStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_extensions_v1beta1_IngressPortStatus(ref),
		extensionsv1beta1.IngressRule{}.OpenAPIModelName():                                                              schema_k8sio_api_extensions_v1beta1_IngressRule(ref),
		extensionsv1beta1.IngressRuleValue{}.OpenAPIModelName():                                                         schema_k8sio_api_extensions_v1beta1_IngressRuleValue(ref),
		extensionsv1beta1.IngressSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_extensions_v1beta1_IngressSpec(ref),
		extensionsv1beta1.IngressStatus{}.OpenAPIModelName():                                                            schema_k8sio_api_extensions_v1beta1_IngressStatus(ref),
		extensionsv1beta1.IngressTLS{}.OpenAPIModelName():                                                               schema_k8sio_api_extensions_v1beta1_IngressTLS(ref),
		extensionsv1beta1.NetworkPolicy{}.OpenAPIModelName():                                                            schema_k8sio_api_extensions_v1beta1_NetworkPolicy(ref),
		extensionsv1beta1.NetworkPolicyEgressRule{}.OpenAPIModelName():                                                  schema_k8sio_api_extensions_v1beta1_NetworkPolicyEgressRule(ref),
		extensionsv1beta1.NetworkPolicyIngressRule{}.OpenAPIModelName():                                                 schema_k8sio_api_extensions_v1beta1_NetworkPolicyIngressRule(ref),
		extensionsv1beta1.NetworkPolicyList{}.OpenAPIModelName():                                                        schema_k8sio_api_extensions_v1beta1_NetworkPolicyList(ref),
		extensionsv1beta1.NetworkPolicyPeer{}.OpenAPIModelName():                                                        schema_k8sio_api_extensions_v1beta1_NetworkPolicyPeer(ref),
		extensionsv1beta1.NetworkPolicyPort{}.OpenAPIModelName():                                                        schema_k8sio_api_extensions_v1beta1_NetworkPolicyPort(ref),
		extensionsv1beta1.NetworkPolicySpec{}.OpenAPIModelName():                                                        schema_k8sio_api_extensions_v1beta1_NetworkPolicySpec(ref),
		extensionsv1beta1.ReplicaSet{}.OpenAPIModelName():                                                               schema_k8sio_api_extensions_v1beta1_ReplicaSet(ref),
		extensionsv1beta1.ReplicaSetCondition{}.OpenAPIModelName():                                                      schema_k8sio_api_extensions_v1beta1_ReplicaSetCondition(ref),
		extensionsv1beta1.ReplicaSetList{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_ReplicaSetList(ref),
		extensionsv1beta1.ReplicaSetSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_ReplicaSetSpec(ref),
		extensionsv1beta1.ReplicaSetStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_extensions_v1beta1_ReplicaSetStatus(ref),
		extensionsv1beta1.RollbackConfig{}.OpenAPIModelName():                                                           schema_k8sio_api_extensions_v1beta1_RollbackConfig(ref),
		extensionsv1beta1.RollingUpdateDaemonSet{}.OpenAPIModelName():                                                   schema_k8sio_api_extensions_v1beta1_RollingUpdateDaemonSet(ref),
		extensionsv1beta1.RollingUpdateDeployment{}.OpenAPIModelName():                                                  schema_k8sio_api_extensions_v1beta1_RollingUpdateDeployment(ref),
		extensionsv1beta1.Scale{}.OpenAPIModelName():                                                                    schema_k8sio_api_extensions_v1beta1_Scale(ref),
		extensionsv1beta1.ScaleSpec{}.OpenAPIModelName():                                                                schema_k8sio_api_extensions_v1beta1_ScaleSpec(ref),
		extensionsv1beta1.ScaleStatus{}.OpenAPIModelName():                                                              schema_k8sio_api_extensions_v1beta1_ScaleStatus(ref),
		flowcontrolv1.ExemptPriorityLevelConfiguration{}.OpenAPIModelName():                                             schema_k8sio_api_flowcontrol_v1_ExemptPriorityLevelConfiguration(ref),
		flowcontrolv1.FlowDistinguisherMethod{}.OpenAPIModelName():                                                      schema_k8sio_api_flowcontrol_v1_FlowDistinguisherMethod(ref),
		flowcontrolv1.FlowSchema{}.OpenAPIModelName():                                                                   schema_k8sio_api_flowcontrol_v1_FlowSchema(ref),
		flowcontrolv1.FlowSchemaCondition{}.OpenAPIModelName():                                                          schema_k8sio_api_flowcontrol_v1_FlowSchemaCondition(ref),
		flowcontrolv1.FlowSchemaList{}.OpenAPIModelName():                                                               schema_k8sio_api_flowcontrol_v1_FlowSchemaList(ref),
		flowcontrolv1.FlowSchemaSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_flowcontrol_v1_FlowSchemaSpec(ref),
		flowcontrolv1.FlowSchemaStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_flowcontrol_v1_FlowSchemaStatus(ref),
		flowcontrolv1.GroupSubject{}.OpenAPIModelName():                                                                 schema_k8sio_api_flowcontrol_v1_GroupSubject(ref),
		flowcontrolv1.LimitResponse{}.OpenAPIModelName():                                                                schema_k8sio_api_flowcontrol_v1_LimitResponse(ref),
		flowcontrolv1.LimitedPriorityLevelConfiguration{}.OpenAPIModelName():                                            schema_k8sio_api_flowcontrol_v1_LimitedPriorityLevelConfiguration(ref),
		flowcontrolv1.NonResourcePolicyRule{}.OpenAPIModelName():                                                        schema_k8sio_api_flowcontrol_v1_NonResourcePolicyRule(ref),
		flowcontrolv1.PolicyRulesWithSubjects{}.OpenAPIModelName():                                                      schema_k8sio_api_flowcontrol_v1_PolicyRulesWithSubjects(ref),
		flowcontrolv1.PriorityLevelConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1_PriorityLevelConfiguration(ref),
		flowcontrolv1.PriorityLevelConfigurationCondition{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationCondition(ref),
		flowcontrolv1.PriorityLevelConfigurationList{}.OpenAPIModelName():                                               schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationList(ref),
		flowcontrolv1.PriorityLevelConfigurationReference{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationReference(ref),
		flowcontrolv1.PriorityLevelConfigurationSpec{}.OpenAPIModelName():                                               schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationSpec(ref),
		flowcontrolv1.PriorityLevelConfigurationStatus{}.OpenAPIModelName():                                             schema_k8sio_api_flowcontrol_v1_PriorityLevelConfigurationStatus(ref),
		flowcontrolv1.QueuingConfiguration{}.OpenAPIModelName():                                                         schema_k8sio_api_flowcontrol_v1_QueuingConfiguration(ref),
		flowcontrolv1.ResourcePolicyRule{}.OpenAPIModelName():                                                           schema_k8sio_api_flowcontrol_v1_ResourcePolicyRule(ref),
		flowcontrolv1.ServiceAccountSubject{}.OpenAPIModelName():                                                        schema_k8sio_api_flowcontrol_v1_ServiceAccountSubject(ref),
		flowcontrolv1.Subject{}.OpenAPIModelName():                                                                      schema_k8sio_api_flowcontrol_v1_Subject(ref),
		flowcontrolv1.UserSubject{}.OpenAPIModelName():                                                                  schema_k8sio_api_flowcontrol_v1_UserSubject(ref),
		flowcontrolv1beta1.ExemptPriorityLevelConfiguration{}.OpenAPIModelName():                                        schema_k8sio_api_flowcontrol_v1beta1_ExemptPriorityLevelConfiguration(ref),
		flowcontrolv1beta1.FlowDistinguisherMethod{}.OpenAPIModelName():                                                 schema_k8sio_api_flowcontrol_v1beta1_FlowDistinguisherMethod(ref),
		flowcontrolv1beta1.FlowSchema{}.OpenAPIModelName():                                                              schema_k8sio_api_flowcontrol_v1beta1_FlowSchema(ref),
		flowcontrolv1beta1.FlowSchemaCondition{}.OpenAPIModelName():                                                     schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaCondition(ref),
		flowcontrolv1beta1.FlowSchemaList{}.OpenAPIModelName():                                                          schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaList(ref),
		flowcontrolv1beta1.FlowSchemaSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaSpec(ref),
		flowcontrolv1beta1.FlowSchemaStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_flowcontrol_v1beta1_FlowSchemaStatus(ref),
		flowcontrolv1beta1.GroupSubject{}.OpenAPIModelName():                                                            schema_k8sio_api_flowcontrol_v1beta1_GroupSubject(ref),
		flowcontrolv1beta1.LimitResponse{}.OpenAPIModelName():                                                           schema_k8sio_api_flowcontrol_v1beta1_LimitResponse(ref),
		flowcontrolv1beta1.LimitedPriorityLevelConfiguration{}.OpenAPIModelName():                                       schema_k8sio_api_flowcontrol_v1beta1_LimitedPriorityLevelConfiguration(ref),
		flowcontrolv1beta1.NonResourcePolicyRule{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta1_NonResourcePolicyRule(ref),
		flowcontrolv1beta1.PolicyRulesWithSubjects{}.OpenAPIModelName():                                                 schema_k8sio_api_flowcontrol_v1beta1_PolicyRulesWithSubjects(ref),
		flowcontrolv1beta1.PriorityLevelConfiguration{}.OpenAPIModelName():                                              schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfiguration(ref),
		flowcontrolv1beta1.PriorityLevelConfigurationCondition{}.OpenAPIModelName():                                     schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationCondition(ref),
		flowcontrolv1beta1.PriorityLevelConfigurationList{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationList(ref),
		flowcontrolv1beta1.PriorityLevelConfigurationReference{}.OpenAPIModelName():                                     schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationReference(ref),
		flowcontrolv1beta1.PriorityLevelConfigurationSpec{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationSpec(ref),
		flowcontrolv1beta1.PriorityLevelConfigurationStatus{}.OpenAPIModelName():                                        schema_k8sio_api_flowcontrol_v1beta1_PriorityLevelConfigurationStatus(ref),
		flowcontrolv1beta1.QueuingConfiguration{}.OpenAPIModelName():                                                    schema_k8sio_api_flowcontrol_v1beta1_QueuingConfiguration(ref),
		flowcontrolv1beta1.ResourcePolicyRule{}.OpenAPIModelName():                                                      schema_k8sio_api_flowcontrol_v1beta1_ResourcePolicyRule(ref),
		flowcontrolv1beta1.ServiceAccountSubject{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta1_ServiceAccountSubject(ref),
		flowcontrolv1beta1.Subject{}.OpenAPIModelName():                                                                 schema_k8sio_api_flowcontrol_v1beta1_Subject(ref),
		flowcontrolv1beta1.UserSubject{}.OpenAPIModelName():                                                             schema_k8sio_api_flowcontrol_v1beta1_UserSubject(ref),
		flowcontrolv1beta2.ExemptPriorityLevelConfiguration{}.OpenAPIModelName():                                        schema_k8sio_api_flowcontrol_v1beta2_ExemptPriorityLevelConfiguration(ref),
		flowcontrolv1beta2.FlowDistinguisherMethod{}.OpenAPIModelName():                                                 schema_k8sio_api_flowcontrol_v1beta2_FlowDistinguisherMethod(ref),
		flowcontrolv1beta2.FlowSchema{}.OpenAPIModelName():                                                              schema_k8sio_api_flowcontrol_v1beta2_FlowSchema(ref),
		flowcontrolv1beta2.FlowSchemaCondition{}.OpenAPIModelName():                                                     schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaCondition(ref),
		flowcontrolv1beta2.FlowSchemaList{}.OpenAPIModelName():                                                          schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaList(ref),
		flowcontrolv1beta2.FlowSchemaSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaSpec(ref),
		flowcontrolv1beta2.FlowSchemaStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_flowcontrol_v1beta2_FlowSchemaStatus(ref),
		flowcontrolv1beta2.GroupSubject{}.OpenAPIModelName():                                                            schema_k8sio_api_flowcontrol_v1beta2_GroupSubject(ref),
		flowcontrolv1beta2.LimitResponse{}.OpenAPIModelName():                                                           schema_k8sio_api_flowcontrol_v1beta2_LimitResponse(ref),
		flowcontrolv1beta2.LimitedPriorityLevelConfiguration{}.OpenAPIModelName():                                       schema_k8sio_api_flowcontrol_v1beta2_LimitedPriorityLevelConfiguration(ref),
		flowcontrolv1beta2.NonResourcePolicyRule{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta2_NonResourcePolicyRule(ref),
		flowcontrolv1beta2.PolicyRulesWithSubjects{}.OpenAPIModelName():                                                 schema_k8sio_api_flowcontrol_v1beta2_PolicyRulesWithSubjects(ref),
		flowcontrolv1beta2.PriorityLevelConfiguration{}.OpenAPIModelName():                                              schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfiguration(ref),
		flowcontrolv1beta2.PriorityLevelConfigurationCondition{}.OpenAPIModelName():                                     schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationCondition(ref),
		flowcontrolv1beta2.PriorityLevelConfigurationList{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationList(ref),
		flowcontrolv1beta2.PriorityLevelConfigurationReference{}.OpenAPIModelName():                                     schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationReference(ref),
		flowcontrolv1beta2.PriorityLevelConfigurationSpec{}.OpenAPIModelName():                                          schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationSpec(ref),
		flowcontrolv1beta2.PriorityLevelConfigurationStatus{}.OpenAPIModelName():                                        schema_k8sio_api_flowcontrol_v1beta2_PriorityLevelConfigurationStatus(ref),
		flowcontrolv1beta2.QueuingConfiguration{}.OpenAPIModelName():                                                    schema_k8sio_api_flowcontrol_v1beta2_QueuingConfiguration(ref),
		flowcontrolv1beta2.ResourcePolicyRule{}.OpenAPIModelName():                                                      schema_k8sio_api_flowcontrol_v1beta2_ResourcePolicyRule(ref),
		flowcontrolv1beta2.ServiceAccountSubject{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta2_ServiceAccountSubject(ref),
		flowcontrolv1beta2.Subject{}.OpenAPIModelName():                                                                 schema_k8sio_api_flowcontrol_v1beta2_Subject(ref),
		flowcontrolv1beta2.UserSubject{}.OpenAPIModelName():                                                             schema_k8sio_api_flowcontrol_v1beta2_UserSubject(ref),
		v1beta3.ExemptPriorityLevelConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta3_ExemptPriorityLevelConfiguration(ref),
		v1beta3.FlowDistinguisherMethod{}.OpenAPIModelName():                                                            schema_k8sio_api_flowcontrol_v1beta3_FlowDistinguisherMethod(ref),
		v1beta3.FlowSchema{}.OpenAPIModelName():                                                                         schema_k8sio_api_flowcontrol_v1beta3_FlowSchema(ref),
		v1beta3.FlowSchemaCondition{}.OpenAPIModelName():                                                                schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaCondition(ref),
		v1beta3.FlowSchemaList{}.OpenAPIModelName():                                                                     schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaList(ref),
		v1beta3.FlowSchemaSpec{}.OpenAPIModelName():                                                                     schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaSpec(ref),
		v1beta3.FlowSchemaStatus{}.OpenAPIModelName():                                                                   schema_k8sio_api_flowcontrol_v1beta3_FlowSchemaStatus(ref),
		v1beta3.GroupSubject{}.OpenAPIModelName():                                                                       schema_k8sio_api_flowcontrol_v1beta3_GroupSubject(ref),
		v1beta3.LimitResponse{}.OpenAPIModelName():                                                                      schema_k8sio_api_flowcontrol_v1beta3_LimitResponse(ref),
		v1beta3.LimitedPriorityLevelConfiguration{}.OpenAPIModelName():                                                  schema_k8sio_api_flowcontrol_v1beta3_LimitedPriorityLevelConfiguration(ref),
		v1beta3.NonResourcePolicyRule{}.OpenAPIModelName():                                                              schema_k8sio_api_flowcontrol_v1beta3_NonResourcePolicyRule(ref),
		v1beta3.PolicyRulesWithSubjects{}.OpenAPIModelName():                                                            schema_k8sio_api_flowcontrol_v1beta3_PolicyRulesWithSubjects(ref),
		v1beta3.PriorityLevelConfiguration{}.OpenAPIModelName():                                                         schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfiguration(ref),
		v1beta3.PriorityLevelConfigurationCondition{}.OpenAPIModelName():                                                schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationCondition(ref),
		v1beta3.PriorityLevelConfigurationList{}.OpenAPIModelName():                                                     schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationList(ref),
		v1beta3.PriorityLevelConfigurationReference{}.OpenAPIModelName():                                                schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationReference(ref),
		v1beta3.PriorityLevelConfigurationSpec{}.OpenAPIModelName():                                                     schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationSpec(ref),
		v1beta3.PriorityLevelConfigurationStatus{}.OpenAPIModelName():                                                   schema_k8sio_api_flowcontrol_v1beta3_PriorityLevelConfigurationStatus(ref),
		v1beta3.QueuingConfiguration{}.OpenAPIModelName():                                                               schema_k8sio_api_flowcontrol_v1beta3_QueuingConfiguration(ref),
		v1beta3.ResourcePolicyRule{}.OpenAPIModelName():                                                                 schema_k8sio_api_flowcontrol_v1beta3_ResourcePolicyRule(ref),
		v1beta3.ServiceAccountSubject{}.OpenAPIModelName():                                                              schema_k8sio_api_flowcontrol_v1beta3_ServiceAccountSubject(ref),
		v1beta3.Subject{}.OpenAPIModelName():                                                                            schema_k8sio_api_flowcontrol_v1beta3_Subject(ref),
		v1beta3.UserSubject{}.OpenAPIModelName():                                                                        schema_k8sio_api_flowcontrol_v1beta3_UserSubject(ref),
		imagepolicyv1alpha1.ImageReview{}.OpenAPIModelName():                                                            schema_k8sio_api_imagepolicy_v1alpha1_ImageReview(ref),
		imagepolicyv1alpha1.ImageReviewContainerSpec{}.OpenAPIModelName():                                               schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewContainerSpec(ref),
		imagepolicyv1alpha1.ImageReviewSpec{}.OpenAPIModelName():                                                        schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewSpec(ref),
		imagepolicyv1alpha1.ImageReviewStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_imagepolicy_v1alpha1_ImageReviewStatus(ref),
		networkingv1.HTTPIngressPath{}.OpenAPIModelName():                                                               schema_k8sio_api_networking_v1_HTTPIngressPath(ref),
		networkingv1.HTTPIngressRuleValue{}.OpenAPIModelName():                                                          schema_k8sio_api_networking_v1_HTTPIngressRuleValue(ref),
		networkingv1.IPAddress{}.OpenAPIModelName():                                                                     schema_k8sio_api_networking_v1_IPAddress(ref),
		networkingv1.IPAddressList{}.OpenAPIModelName():                                                                 schema_k8sio_api_networking_v1_IPAddressList(ref),
		networkingv1.IPAddressSpec{}.OpenAPIModelName():                                                                 schema_k8sio_api_networking_v1_IPAddressSpec(ref),
		networkingv1.IPBlock{}.OpenAPIModelName():                                                                       schema_k8sio_api_networking_v1_IPBlock(ref),
		networkingv1.Ingress{}.OpenAPIModelName():                                                                       schema_k8sio_api_networking_v1_Ingress(ref),
		networkingv1.IngressBackend{}.OpenAPIModelName():                                                                schema_k8sio_api_networking_v1_IngressBackend(ref),
		networkingv1.IngressClass{}.OpenAPIModelName():                                                                  schema_k8sio_api_networking_v1_IngressClass(ref),
		networkingv1.IngressClassList{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1_IngressClassList(ref),
		networkingv1.IngressClassParametersReference{}.OpenAPIModelName():                                               schema_k8sio_api_networking_v1_IngressClassParametersReference(ref),
		networkingv1.IngressClassSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1_IngressClassSpec(ref),
		networkingv1.IngressList{}.OpenAPIModelName():                                                                   schema_k8sio_api_networking_v1_IngressList(ref),
		networkingv1.IngressLoadBalancerIngress{}.OpenAPIModelName():                                                    schema_k8sio_api_networking_v1_IngressLoadBalancerIngress(ref),
		networkingv1.IngressLoadBalancerStatus{}.OpenAPIModelName():                                                     schema_k8sio_api_networking_v1_IngressLoadBalancerStatus(ref),
		networkingv1.IngressPortStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_IngressPortStatus(ref),
		networkingv1.IngressRule{}.OpenAPIModelName():                                                                   schema_k8sio_api_networking_v1_IngressRule(ref),
		networkingv1.IngressRuleValue{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1_IngressRuleValue(ref),
		networkingv1.IngressServiceBackend{}.OpenAPIModelName():                                                         schema_k8sio_api_networking_v1_IngressServiceBackend(ref),
		networkingv1.IngressSpec{}.OpenAPIModelName():                                                                   schema_k8sio_api_networking_v1_IngressSpec(ref),
		networkingv1.IngressStatus{}.OpenAPIModelName():                                                                 schema_k8sio_api_networking_v1_IngressStatus(ref),
		networkingv1.IngressTLS{}.OpenAPIModelName():                                                                    schema_k8sio_api_networking_v1_IngressTLS(ref),
		networkingv1.NetworkPolicy{}.OpenAPIModelName():                                                                 schema_k8sio_api_networking_v1_NetworkPolicy(ref),
		networkingv1.NetworkPolicyEgressRule{}.OpenAPIModelName():                                                       schema_k8sio_api_networking_v1_NetworkPolicyEgressRule(ref),
		networkingv1.NetworkPolicyIngressRule{}.OpenAPIModelName():                                                      schema_k8sio_api_networking_v1_NetworkPolicyIngressRule(ref),
		networkingv1.NetworkPolicyList{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_NetworkPolicyList(ref),
		networkingv1.NetworkPolicyPeer{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_NetworkPolicyPeer(ref),
		networkingv1.NetworkPolicyPort{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_NetworkPolicyPort(ref),
		networkingv1.NetworkPolicySpec{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_NetworkPolicySpec(ref),
		networkingv1.ParentReference{}.OpenAPIModelName():                                                               schema_k8sio_api_networking_v1_ParentReference(ref),
		networkingv1.ServiceBackendPort{}.OpenAPIModelName():                                                            schema_k8sio_api_networking_v1_ServiceBackendPort(ref),
		networkingv1.ServiceCIDR{}.OpenAPIModelName():                                                                   schema_k8sio_api_networking_v1_ServiceCIDR(ref),
		networkingv1.ServiceCIDRList{}.OpenAPIModelName():                                                               schema_k8sio_api_networking_v1_ServiceCIDRList(ref),
		networkingv1.ServiceCIDRSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_networking_v1_ServiceCIDRSpec(ref),
		networkingv1.ServiceCIDRStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1_ServiceCIDRStatus(ref),
		networkingv1beta1.HTTPIngressPath{}.OpenAPIModelName():                                                          schema_k8sio_api_networking_v1beta1_HTTPIngressPath(ref),
		networkingv1beta1.HTTPIngressRuleValue{}.OpenAPIModelName():                                                     schema_k8sio_api_networking_v1beta1_HTTPIngressRuleValue(ref),
		networkingv1beta1.IPAddress{}.OpenAPIModelName():                                                                schema_k8sio_api_networking_v1beta1_IPAddress(ref),
		networkingv1beta1.IPAddressList{}.OpenAPIModelName():                                                            schema_k8sio_api_networking_v1beta1_IPAddressList(ref),
		networkingv1beta1.IPAddressSpec{}.OpenAPIModelName():                                                            schema_k8sio_api_networking_v1beta1_IPAddressSpec(ref),
		networkingv1beta1.Ingress{}.OpenAPIModelName():                                                                  schema_k8sio_api_networking_v1beta1_Ingress(ref),
		networkingv1beta1.IngressBackend{}.OpenAPIModelName():                                                           schema_k8sio_api_networking_v1beta1_IngressBackend(ref),
		networkingv1beta1.IngressClass{}.OpenAPIModelName():                                                             schema_k8sio_api_networking_v1beta1_IngressClass(ref),
		networkingv1beta1.IngressClassList{}.OpenAPIModelName():                                                         schema_k8sio_api_networking_v1beta1_IngressClassList(ref),
		networkingv1beta1.IngressClassParametersReference{}.OpenAPIModelName():                                          schema_k8sio_api_networking_v1beta1_IngressClassParametersReference(ref),
		networkingv1beta1.IngressClassSpec{}.OpenAPIModelName():                                                         schema_k8sio_api_networking_v1beta1_IngressClassSpec(ref),
		networkingv1beta1.IngressList{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1beta1_IngressList(ref),
		networkingv1beta1.IngressLoadBalancerIngress{}.OpenAPIModelName():                                               schema_k8sio_api_networking_v1beta1_IngressLoadBalancerIngress(ref),
		networkingv1beta1.IngressLoadBalancerStatus{}.OpenAPIModelName():                                                schema_k8sio_api_networking_v1beta1_IngressLoadBalancerStatus(ref),
		networkingv1beta1.IngressPortStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_networking_v1beta1_IngressPortStatus(ref),
		networkingv1beta1.IngressRule{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1beta1_IngressRule(ref),
		networkingv1beta1.IngressRuleValue{}.OpenAPIModelName():                                                         schema_k8sio_api_networking_v1beta1_IngressRuleValue(ref),
		networkingv1beta1.IngressSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1beta1_IngressSpec(ref),
		networkingv1beta1.IngressStatus{}.OpenAPIModelName():                                                            schema_k8sio_api_networking_v1beta1_IngressStatus(ref),
		networkingv1beta1.IngressTLS{}.OpenAPIModelName():                                                               schema_k8sio_api_networking_v1beta1_IngressTLS(ref),
		networkingv1beta1.ParentReference{}.OpenAPIModelName():                                                          schema_k8sio_api_networking_v1beta1_ParentReference(ref),
		networkingv1beta1.ServiceCIDR{}.OpenAPIModelName():                                                              schema_k8sio_api_networking_v1beta1_ServiceCIDR(ref),
		networkingv1beta1.ServiceCIDRList{}.OpenAPIModelName():                                                          schema_k8sio_api_networking_v1beta1_ServiceCIDRList(ref),
		networkingv1beta1.ServiceCIDRSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_networking_v1beta1_ServiceCIDRSpec(ref),
		networkingv1beta1.ServiceCIDRStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_networking_v1beta1_ServiceCIDRStatus(ref),
		nodev1.Overhead{}.OpenAPIModelName():                                                                            schema_k8sio_api_node_v1_Overhead(ref),
		nodev1.RuntimeClass{}.OpenAPIModelName():                                                                        schema_k8sio_api_node_v1_RuntimeClass(ref),
		nodev1.RuntimeClassList{}.OpenAPIModelName():                                                                    schema_k8sio_api_node_v1_RuntimeClassList(ref),
		nodev1.Scheduling{}.OpenAPIModelName():                                                                          schema_k8sio_api_node_v1_Scheduling(ref),
		nodev1alpha1.Overhead{}.OpenAPIModelName():                                                                      schema_k8sio_api_node_v1alpha1_Overhead(ref),
		nodev1alpha1.RuntimeClass{}.OpenAPIModelName():                                                                  schema_k8sio_api_node_v1alpha1_RuntimeClass(ref),
		nodev1alpha1.RuntimeClassList{}.OpenAPIModelName():                                                              schema_k8sio_api_node_v1alpha1_RuntimeClassList(ref),
		nodev1alpha1.RuntimeClassSpec{}.OpenAPIModelName():                                                              schema_k8sio_api_node_v1alpha1_RuntimeClassSpec(ref),
		nodev1alpha1.Scheduling{}.OpenAPIModelName():                                                                    schema_k8sio_api_node_v1alpha1_Scheduling(ref),
		nodev1beta1.Overhead{}.OpenAPIModelName():                                                                       schema_k8sio_api_node_v1beta1_Overhead(ref),
		nodev1beta1.RuntimeClass{}.OpenAPIModelName():                                                                   schema_k8sio_api_node_v1beta1_RuntimeClass(ref),
		nodev1beta1.RuntimeClassList{}.OpenAPIModelName():                                                               schema_k8sio_api_node_v1beta1_RuntimeClassList(ref),
		nodev1beta1.Scheduling{}.OpenAPIModelName():                                                                     schema_k8sio_api_node_v1beta1_Scheduling(ref),
		policyv1.Eviction{}.OpenAPIModelName():                                                                          schema_k8sio_api_policy_v1_Eviction(ref),
		policyv1.PodDisruptionBudget{}.OpenAPIModelName():                                                               schema_k8sio_api_policy_v1_PodDisruptionBudget(ref),
		policyv1.PodDisruptionBudgetList{}.OpenAPIModelName():                                                           schema_k8sio_api_policy_v1_PodDisruptionBudgetList(ref),
		policyv1.PodDisruptionBudgetSpec{}.OpenAPIModelName():                                                           schema_k8sio_api_policy_v1_PodDisruptionBudgetSpec(ref),
		policyv1.PodDisruptionBudgetStatus{}.OpenAPIModelName():                                                         schema_k8sio_api_policy_v1_PodDisruptionBudgetStatus(ref),
		policyv1beta1.Eviction{}.OpenAPIModelName():                                                                     schema_k8sio_api_policy_v1beta1_Eviction(ref),
		policyv1beta1.PodDisruptionBudget{}.OpenAPIModelName():                                                          schema_k8sio_api_policy_v1beta1_PodDisruptionBudget(ref),
		policyv1beta1.PodDisruptionBudgetList{}.OpenAPIModelName():                                                      schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetList(ref),
		policyv1beta1.PodDisruptionBudgetSpec{}.OpenAPIModelName():                                                      schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetSpec(ref),
		policyv1beta1.PodDisruptionBudgetStatus{}.OpenAPIModelName():                                                    schema_k8sio_api_policy_v1beta1_PodDisruptionBudgetStatus(ref),
		rbacv1.AggregationRule{}.OpenAPIModelName():                                                                     schema_k8sio_api_rbac_v1_AggregationRule(ref),
		rbacv1.ClusterRole{}.OpenAPIModelName():                                                                         schema_k8sio_api_rbac_v1_ClusterRole(ref),
		rbacv1.ClusterRoleBinding{}.OpenAPIModelName():                                                                  schema_k8sio_api_rbac_v1_ClusterRoleBinding(ref),
		rbacv1.ClusterRoleBindingList{}.OpenAPIModelName():                                                              schema_k8sio_api_rbac_v1_ClusterRoleBindingList(ref),
		rbacv1.ClusterRoleList{}.OpenAPIModelName():                                                                     schema_k8sio_api_rbac_v1_ClusterRoleList(ref),
		rbacv1.PolicyRule{}.OpenAPIModelName():                                                                          schema_k8sio_api_rbac_v1_PolicyRule(ref),
		rbacv1.Role{}.OpenAPIModelName():                                                                                schema_k8sio_api_rbac_v1_Role(ref),
		rbacv1.RoleBinding{}.OpenAPIModelName():                                                                         schema_k8sio_api_rbac_v1_RoleBinding(ref),
		rbacv1.RoleBindingList{}.OpenAPIModelName():                                                                     schema_k8sio_api_rbac_v1_RoleBindingList(ref),
		rbacv1.RoleList{}.OpenAPIModelName():                                                                            schema_k8sio_api_rbac_v1_RoleList(ref),
		rbacv1.RoleRef{}.OpenAPIModelName():                                                                             schema_k8sio_api_rbac_v1_RoleRef(ref),
		rbacv1.Subject{}.OpenAPIModelName():                                                                             schema_k8sio_api_rbac_v1_Subject(ref),
		rbacv1alpha1.AggregationRule{}.OpenAPIModelName():                                                               schema_k8sio_api_rbac_v1alpha1_AggregationRule(ref),
		rbacv1alpha1.ClusterRole{}.OpenAPIModelName():                                                                   schema_k8sio_api_rbac_v1alpha1_ClusterRole(ref),
		rbacv1alpha1.ClusterRoleBinding{}.OpenAPIModelName():                                                            schema_k8sio_api_rbac_v1alpha1_ClusterRoleBinding(ref),
		rbacv1alpha1.ClusterRoleBindingList{}.OpenAPIModelName():                                                        schema_k8sio_api_rbac_v1alpha1_ClusterRoleBindingList(ref),
		rbacv1alpha1.ClusterRoleList{}.OpenAPIModelName():                                                               schema_k8sio_api_rbac_v1alpha1_ClusterRoleList(ref),
		rbacv1alpha1.PolicyRule{}.OpenAPIModelName():                                                                    schema_k8sio_api_rbac_v1alpha1_PolicyRule(ref),
		rbacv1alpha1.Role{}.OpenAPIModelName():                                                                          schema_k8sio_api_rbac_v1alpha1_Role(ref),
		rbacv1alpha1.RoleBinding{}.OpenAPIModelName():                                                                   schema_k8sio_api_rbac_v1alpha1_RoleBinding(ref),
		rbacv1alpha1.RoleBindingList{}.OpenAPIModelName():                                                               schema_k8sio_api_rbac_v1alpha1_RoleBindingList(ref),
		rbacv1alpha1.RoleList{}.OpenAPIModelName():                                                                      schema_k8sio_api_rbac_v1alpha1_RoleList(ref),
		rbacv1alpha1.RoleRef{}.OpenAPIModelName():                                                                       schema_k8sio_api_rbac_v1alpha1_RoleRef(ref),
		rbacv1alpha1.Subject{}.OpenAPIModelName():                                                                       schema_k8sio_api_rbac_v1alpha1_Subject(ref),
		rbacv1beta1.AggregationRule{}.OpenAPIModelName():                                                                schema_k8sio_api_rbac_v1beta1_AggregationRule(ref),
		rbacv1beta1.ClusterRole{}.OpenAPIModelName():                                                                    schema_k8sio_api_rbac_v1beta1_ClusterRole(ref),
		rbacv1beta1.ClusterRoleBinding{}.OpenAPIModelName():                                                             schema_k8sio_api_rbac_v1beta1_ClusterRoleBinding(ref),
		rbacv1beta1.ClusterRoleBindingList{}.OpenAPIModelName():                                                         schema_k8sio_api_rbac_v1beta1_ClusterRoleBindingList(ref),
		rbacv1beta1.ClusterRoleList{}.OpenAPIModelName():                                                                schema_k8sio_api_rbac_v1beta1_ClusterRoleList(ref),
		rbacv1beta1.PolicyRule{}.OpenAPIModelName():                                                                     schema_k8sio_api_rbac_v1beta1_PolicyRule(ref),
		rbacv1beta1.Role{}.OpenAPIModelName():                                                                           schema_k8sio_api_rbac_v1beta1_Role(ref),
		rbacv1beta1.RoleBinding{}.OpenAPIModelName():                                                                    schema_k8sio_api_rbac_v1beta1_RoleBinding(ref),
		rbacv1beta1.RoleBindingList{}.OpenAPIModelName():                                                                schema_k8sio_api_rbac_v1beta1_RoleBindingList(ref),
		rbacv1beta1.RoleList{}.OpenAPIModelName():                                                                       schema_k8sio_api_rbac_v1beta1_RoleList(ref),
		rbacv1beta1.RoleRef{}.OpenAPIModelName():                                                                        schema_k8sio_api_rbac_v1beta1_RoleRef(ref),
		rbacv1beta1.Subject{}.OpenAPIModelName():                                                                        schema_k8sio_api_rbac_v1beta1_Subject(ref),
		resourcev1.AllocatedDeviceStatus{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1_AllocatedDeviceStatus(ref),
		resourcev1.AllocationResult{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1_AllocationResult(ref),
		resourcev1.CELDeviceSelector{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_CELDeviceSelector(ref),
		resourcev1.CapacityRequestPolicy{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1_CapacityRequestPolicy(ref),
		resourcev1.CapacityRequestPolicyRange{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1_CapacityRequestPolicyRange(ref),
		resourcev1.CapacityRequirements{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1_CapacityRequirements(ref),
		resourcev1.Counter{}.OpenAPIModelName():                                                                         schema_k8sio_api_resource_v1_Counter(ref),
		resourcev1.CounterSet{}.OpenAPIModelName():                                                                      schema_k8sio_api_resource_v1_CounterSet(ref),
		resourcev1.Device{}.OpenAPIModelName():                                                                          schema_k8sio_api_resource_v1_Device(ref),
		resourcev1.DeviceAllocationConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1_DeviceAllocationConfiguration(ref),
		resourcev1.DeviceAllocationResult{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1_DeviceAllocationResult(ref),
		resourcev1.DeviceAttribute{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1_DeviceAttribute(ref),
		resourcev1.DeviceCapacity{}.OpenAPIModelName():                                                                  schema_k8sio_api_resource_v1_DeviceCapacity(ref),
		resourcev1.DeviceClaim{}.OpenAPIModelName():                                                                     schema_k8sio_api_resource_v1_DeviceClaim(ref),
		resourcev1.DeviceClaimConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1_DeviceClaimConfiguration(ref),
		resourcev1.DeviceClass{}.OpenAPIModelName():                                                                     schema_k8sio_api_resource_v1_DeviceClass(ref),
		resourcev1.DeviceClassConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1_DeviceClassConfiguration(ref),
		resourcev1.DeviceClassList{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1_DeviceClassList(ref),
		resourcev1.DeviceClassSpec{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1_DeviceClassSpec(ref),
		resourcev1.DeviceConfiguration{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1_DeviceConfiguration(ref),
		resourcev1.DeviceConstraint{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1_DeviceConstraint(ref),
		resourcev1.DeviceCounterConsumption{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1_DeviceCounterConsumption(ref),
		resourcev1.DeviceRequest{}.OpenAPIModelName():                                                                   schema_k8sio_api_resource_v1_DeviceRequest(ref),
		resourcev1.DeviceRequestAllocationResult{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1_DeviceRequestAllocationResult(ref),
		resourcev1.DeviceSelector{}.OpenAPIModelName():                                                                  schema_k8sio_api_resource_v1_DeviceSelector(ref),
		resourcev1.DeviceSubRequest{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1_DeviceSubRequest(ref),
		resourcev1.DeviceTaint{}.OpenAPIModelName():                                                                     schema_k8sio_api_resource_v1_DeviceTaint(ref),
		resourcev1.DeviceToleration{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1_DeviceToleration(ref),
		resourcev1.ExactDeviceRequest{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1_ExactDeviceRequest(ref),
		resourcev1.NetworkDeviceData{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_NetworkDeviceData(ref),
		resourcev1.OpaqueDeviceConfiguration{}.OpenAPIModelName():                                                       schema_k8sio_api_resource_v1_OpaqueDeviceConfiguration(ref),
		resourcev1.ResourceClaim{}.OpenAPIModelName():                                                                   schema_k8sio_api_resource_v1_ResourceClaim(ref),
		resourcev1.ResourceClaimConsumerReference{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1_ResourceClaimConsumerReference(ref),
		resourcev1.ResourceClaimList{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_ResourceClaimList(ref),
		resourcev1.ResourceClaimSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_ResourceClaimSpec(ref),
		resourcev1.ResourceClaimStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1_ResourceClaimStatus(ref),
		resourcev1.ResourceClaimTemplate{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1_ResourceClaimTemplate(ref),
		resourcev1.ResourceClaimTemplateList{}.OpenAPIModelName():                                                       schema_k8sio_api_resource_v1_ResourceClaimTemplateList(ref),
		resourcev1.ResourceClaimTemplateSpec{}.OpenAPIModelName():                                                       schema_k8sio_api_resource_v1_ResourceClaimTemplateSpec(ref),
		resourcev1.ResourcePool{}.OpenAPIModelName():                                                                    schema_k8sio_api_resource_v1_ResourcePool(ref),
		resourcev1.ResourceSlice{}.OpenAPIModelName():                                                                   schema_k8sio_api_resource_v1_ResourceSlice(ref),
		resourcev1.ResourceSliceList{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_ResourceSliceList(ref),
		resourcev1.ResourceSliceSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1_ResourceSliceSpec(ref),
		v1alpha3.CELDeviceSelector{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1alpha3_CELDeviceSelector(ref),
		v1alpha3.DeviceSelector{}.OpenAPIModelName():                                                                    schema_k8sio_api_resource_v1alpha3_DeviceSelector(ref),
		v1alpha3.DeviceTaint{}.OpenAPIModelName():                                                                       schema_k8sio_api_resource_v1alpha3_DeviceTaint(ref),
		v1alpha3.DeviceTaintRule{}.OpenAPIModelName():                                                                   schema_k8sio_api_resource_v1alpha3_DeviceTaintRule(ref),
		v1alpha3.DeviceTaintRuleList{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1alpha3_DeviceTaintRuleList(ref),
		v1alpha3.DeviceTaintRuleSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1alpha3_DeviceTaintRuleSpec(ref),
		v1alpha3.DeviceTaintRuleStatus{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1alpha3_DeviceTaintRuleStatus(ref),
		v1alpha3.DeviceTaintSelector{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1alpha3_DeviceTaintSelector(ref),
		resourcev1beta1.AllocatedDeviceStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta1_AllocatedDeviceStatus(ref),
		resourcev1beta1.AllocationResult{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta1_AllocationResult(ref),
		resourcev1beta1.BasicDevice{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta1_BasicDevice(ref),
		resourcev1beta1.CELDeviceSelector{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_CELDeviceSelector(ref),
		resourcev1beta1.CapacityRequestPolicy{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta1_CapacityRequestPolicy(ref),
		resourcev1beta1.CapacityRequestPolicyRange{}.OpenAPIModelName():                                                 schema_k8sio_api_resource_v1beta1_CapacityRequestPolicyRange(ref),
		resourcev1beta1.CapacityRequirements{}.OpenAPIModelName():                                                       schema_k8sio_api_resource_v1beta1_CapacityRequirements(ref),
		resourcev1beta1.Counter{}.OpenAPIModelName():                                                                    schema_k8sio_api_resource_v1beta1_Counter(ref),
		resourcev1beta1.CounterSet{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1beta1_CounterSet(ref),
		resourcev1beta1.Device{}.OpenAPIModelName():                                                                     schema_k8sio_api_resource_v1beta1_Device(ref),
		resourcev1beta1.DeviceAllocationConfiguration{}.OpenAPIModelName():                                              schema_k8sio_api_resource_v1beta1_DeviceAllocationConfiguration(ref),
		resourcev1beta1.DeviceAllocationResult{}.OpenAPIModelName():                                                     schema_k8sio_api_resource_v1beta1_DeviceAllocationResult(ref),
		resourcev1beta1.DeviceAttribute{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta1_DeviceAttribute(ref),
		resourcev1beta1.DeviceCapacity{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1beta1_DeviceCapacity(ref),
		resourcev1beta1.DeviceClaim{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta1_DeviceClaim(ref),
		resourcev1beta1.DeviceClaimConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta1_DeviceClaimConfiguration(ref),
		resourcev1beta1.DeviceClass{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta1_DeviceClass(ref),
		resourcev1beta1.DeviceClassConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta1_DeviceClassConfiguration(ref),
		resourcev1beta1.DeviceClassList{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta1_DeviceClassList(ref),
		resourcev1beta1.DeviceClassSpec{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta1_DeviceClassSpec(ref),
		resourcev1beta1.DeviceConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1beta1_DeviceConfiguration(ref),
		resourcev1beta1.DeviceConstraint{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta1_DeviceConstraint(ref),
		resourcev1beta1.DeviceCounterConsumption{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta1_DeviceCounterConsumption(ref),
		resourcev1beta1.DeviceRequest{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta1_DeviceRequest(ref),
		resourcev1beta1.DeviceRequestAllocationResult{}.OpenAPIModelName():                                              schema_k8sio_api_resource_v1beta1_DeviceRequestAllocationResult(ref),
		resourcev1beta1.DeviceSelector{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1beta1_DeviceSelector(ref),
		resourcev1beta1.DeviceSubRequest{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta1_DeviceSubRequest(ref),
		resourcev1beta1.DeviceTaint{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta1_DeviceTaint(ref),
		resourcev1beta1.DeviceToleration{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta1_DeviceToleration(ref),
		resourcev1beta1.NetworkDeviceData{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_NetworkDeviceData(ref),
		resourcev1beta1.OpaqueDeviceConfiguration{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta1_OpaqueDeviceConfiguration(ref),
		resourcev1beta1.ResourceClaim{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta1_ResourceClaim(ref),
		resourcev1beta1.ResourceClaimConsumerReference{}.OpenAPIModelName():                                             schema_k8sio_api_resource_v1beta1_ResourceClaimConsumerReference(ref),
		resourcev1beta1.ResourceClaimList{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_ResourceClaimList(ref),
		resourcev1beta1.ResourceClaimSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_ResourceClaimSpec(ref),
		resourcev1beta1.ResourceClaimStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1beta1_ResourceClaimStatus(ref),
		resourcev1beta1.ResourceClaimTemplate{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta1_ResourceClaimTemplate(ref),
		resourcev1beta1.ResourceClaimTemplateList{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta1_ResourceClaimTemplateList(ref),
		resourcev1beta1.ResourceClaimTemplateSpec{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta1_ResourceClaimTemplateSpec(ref),
		resourcev1beta1.ResourcePool{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1beta1_ResourcePool(ref),
		resourcev1beta1.ResourceSlice{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta1_ResourceSlice(ref),
		resourcev1beta1.ResourceSliceList{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_ResourceSliceList(ref),
		resourcev1beta1.ResourceSliceSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta1_ResourceSliceSpec(ref),
		resourcev1beta2.AllocatedDeviceStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta2_AllocatedDeviceStatus(ref),
		resourcev1beta2.AllocationResult{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta2_AllocationResult(ref),
		resourcev1beta2.CELDeviceSelector{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_CELDeviceSelector(ref),
		resourcev1beta2.CapacityRequestPolicy{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta2_CapacityRequestPolicy(ref),
		resourcev1beta2.CapacityRequestPolicyRange{}.OpenAPIModelName():                                                 schema_k8sio_api_resource_v1beta2_CapacityRequestPolicyRange(ref),
		resourcev1beta2.CapacityRequirements{}.OpenAPIModelName():                                                       schema_k8sio_api_resource_v1beta2_CapacityRequirements(ref),
		resourcev1beta2.Counter{}.OpenAPIModelName():                                                                    schema_k8sio_api_resource_v1beta2_Counter(ref),
		resourcev1beta2.CounterSet{}.OpenAPIModelName():                                                                 schema_k8sio_api_resource_v1beta2_CounterSet(ref),
		resourcev1beta2.Device{}.OpenAPIModelName():                                                                     schema_k8sio_api_resource_v1beta2_Device(ref),
		resourcev1beta2.DeviceAllocationConfiguration{}.OpenAPIModelName():                                              schema_k8sio_api_resource_v1beta2_DeviceAllocationConfiguration(ref),
		resourcev1beta2.DeviceAllocationResult{}.OpenAPIModelName():                                                     schema_k8sio_api_resource_v1beta2_DeviceAllocationResult(ref),
		resourcev1beta2.DeviceAttribute{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta2_DeviceAttribute(ref),
		resourcev1beta2.DeviceCapacity{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1beta2_DeviceCapacity(ref),
		resourcev1beta2.DeviceClaim{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta2_DeviceClaim(ref),
		resourcev1beta2.DeviceClaimConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta2_DeviceClaimConfiguration(ref),
		resourcev1beta2.DeviceClass{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta2_DeviceClass(ref),
		resourcev1beta2.DeviceClassConfiguration{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta2_DeviceClassConfiguration(ref),
		resourcev1beta2.DeviceClassList{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta2_DeviceClassList(ref),
		resourcev1beta2.DeviceClassSpec{}.OpenAPIModelName():                                                            schema_k8sio_api_resource_v1beta2_DeviceClassSpec(ref),
		resourcev1beta2.DeviceConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1beta2_DeviceConfiguration(ref),
		resourcev1beta2.DeviceConstraint{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta2_DeviceConstraint(ref),
		resourcev1beta2.DeviceCounterConsumption{}.OpenAPIModelName():                                                   schema_k8sio_api_resource_v1beta2_DeviceCounterConsumption(ref),
		resourcev1beta2.DeviceRequest{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta2_DeviceRequest(ref),
		resourcev1beta2.DeviceRequestAllocationResult{}.OpenAPIModelName():                                              schema_k8sio_api_resource_v1beta2_DeviceRequestAllocationResult(ref),
		resourcev1beta2.DeviceSelector{}.OpenAPIModelName():                                                             schema_k8sio_api_resource_v1beta2_DeviceSelector(ref),
		resourcev1beta2.DeviceSubRequest{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta2_DeviceSubRequest(ref),
		resourcev1beta2.DeviceTaint{}.OpenAPIModelName():                                                                schema_k8sio_api_resource_v1beta2_DeviceTaint(ref),
		resourcev1beta2.DeviceToleration{}.OpenAPIModelName():                                                           schema_k8sio_api_resource_v1beta2_DeviceToleration(ref),
		resourcev1beta2.ExactDeviceRequest{}.OpenAPIModelName():                                                         schema_k8sio_api_resource_v1beta2_ExactDeviceRequest(ref),
		resourcev1beta2.NetworkDeviceData{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_NetworkDeviceData(ref),
		resourcev1beta2.OpaqueDeviceConfiguration{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta2_OpaqueDeviceConfiguration(ref),
		resourcev1beta2.ResourceClaim{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta2_ResourceClaim(ref),
		resourcev1beta2.ResourceClaimConsumerReference{}.OpenAPIModelName():                                             schema_k8sio_api_resource_v1beta2_ResourceClaimConsumerReference(ref),
		resourcev1beta2.ResourceClaimList{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_ResourceClaimList(ref),
		resourcev1beta2.ResourceClaimSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_ResourceClaimSpec(ref),
		resourcev1beta2.ResourceClaimStatus{}.OpenAPIModelName():                                                        schema_k8sio_api_resource_v1beta2_ResourceClaimStatus(ref),
		resourcev1beta2.ResourceClaimTemplate{}.OpenAPIModelName():                                                      schema_k8sio_api_resource_v1beta2_ResourceClaimTemplate(ref),
		resourcev1beta2.ResourceClaimTemplateList{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta2_ResourceClaimTemplateList(ref),
		resourcev1beta2.ResourceClaimTemplateSpec{}.OpenAPIModelName():                                                  schema_k8sio_api_resource_v1beta2_ResourceClaimTemplateSpec(ref),
		resourcev1beta2.ResourcePool{}.OpenAPIModelName():                                                               schema_k8sio_api_resource_v1beta2_ResourcePool(ref),
		resourcev1beta2.ResourceSlice{}.OpenAPIModelName():                                                              schema_k8sio_api_resource_v1beta2_ResourceSlice(ref),
		resourcev1beta2.ResourceSliceList{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_ResourceSliceList(ref),
		resourcev1beta2.ResourceSliceSpec{}.OpenAPIModelName():                                                          schema_k8sio_api_resource_v1beta2_ResourceSliceSpec(ref),
		schedulingv1.PriorityClass{}.OpenAPIModelName():                                                                 schema_k8sio_api_scheduling_v1_PriorityClass(ref),
		schedulingv1.PriorityClassList{}.OpenAPIModelName():                                                             schema_k8sio_api_scheduling_v1_PriorityClassList(ref),
		schedulingv1alpha1.BasicSchedulingPolicy{}.OpenAPIModelName():                                                   schema_k8sio_api_scheduling_v1alpha1_BasicSchedulingPolicy(ref),
		schedulingv1alpha1.GangSchedulingPolicy{}.OpenAPIModelName():                                                    schema_k8sio_api_scheduling_v1alpha1_GangSchedulingPolicy(ref),
		schedulingv1alpha1.PodGroup{}.OpenAPIModelName():                                                                schema_k8sio_api_scheduling_v1alpha1_PodGroup(ref),
		schedulingv1alpha1.PodGroupPolicy{}.OpenAPIModelName():                                                          schema_k8sio_api_scheduling_v1alpha1_PodGroupPolicy(ref),
		schedulingv1alpha1.PriorityClass{}.OpenAPIModelName():                                                           schema_k8sio_api_scheduling_v1alpha1_PriorityClass(ref),
		schedulingv1alpha1.PriorityClassList{}.OpenAPIModelName():                                                       schema_k8sio_api_scheduling_v1alpha1_PriorityClassList(ref),
		schedulingv1alpha1.TypedLocalObjectReference{}.OpenAPIModelName():                                               schema_k8sio_api_scheduling_v1alpha1_TypedLocalObjectReference(ref),
		schedulingv1alpha1.Workload{}.OpenAPIModelName():                                                                schema_k8sio_api_scheduling_v1alpha1_Workload(ref),
		schedulingv1alpha1.WorkloadList{}.OpenAPIModelName():                                                            schema_k8sio_api_scheduling_v1alpha1_WorkloadList(ref),
		schedulingv1alpha1.WorkloadSpec{}.OpenAPIModelName():                                                            schema_k8sio_api_scheduling_v1alpha1_WorkloadSpec(ref),
		schedulingv1beta1.PriorityClass{}.OpenAPIModelName():                                                            schema_k8sio_api_scheduling_v1beta1_PriorityClass(ref),
		schedulingv1beta1.PriorityClassList{}.OpenAPIModelName():                                                        schema_k8sio_api_scheduling_v1beta1_PriorityClassList(ref),
		storagev1.CSIDriver{}.OpenAPIModelName():                                                                        schema_k8sio_api_storage_v1_CSIDriver(ref),
		storagev1.CSIDriverList{}.OpenAPIModelName():                                                                    schema_k8sio_api_storage_v1_CSIDriverList(ref),
		storagev1.CSIDriverSpec{}.OpenAPIModelName():                                                                    schema_k8sio_api_storage_v1_CSIDriverSpec(ref),
		storagev1.CSINode{}.OpenAPIModelName():                                                                          schema_k8sio_api_storage_v1_CSINode(ref),
		storagev1.CSINodeDriver{}.OpenAPIModelName():                                                                    schema_k8sio_api_storage_v1_CSINodeDriver(ref),
		storagev1.CSINodeList{}.OpenAPIModelName():                                                                      schema_k8sio_api_storage_v1_CSINodeList(ref),
		storagev1.CSINodeSpec{}.OpenAPIModelName():                                                                      schema_k8sio_api_storage_v1_CSINodeSpec(ref),
		storagev1.CSIStorageCapacity{}.OpenAPIModelName():                                                               schema_k8sio_api_storage_v1_CSIStorageCapacity(ref),
		storagev1.CSIStorageCapacityList{}.OpenAPIModelName():                                                           schema_k8sio_api_storage_v1_CSIStorageCapacityList(ref),
		storagev1.StorageClass{}.OpenAPIModelName():                                                                     schema_k8sio_api_storage_v1_StorageClass(ref),
		storagev1.StorageClassList{}.OpenAPIModelName():                                                                 schema_k8sio_api_storage_v1_StorageClassList(ref),
		storagev1.TokenRequest{}.OpenAPIModelName():                                                                     schema_k8sio_api_storage_v1_TokenRequest(ref),
		storagev1.VolumeAttachment{}.OpenAPIModelName():                                                                 schema_k8sio_api_storage_v1_VolumeAttachment(ref),
		storagev1.VolumeAttachmentList{}.OpenAPIModelName():                                                             schema_k8sio_api_storage_v1_VolumeAttachmentList(ref),
		storagev1.VolumeAttachmentSource{}.OpenAPIModelName():                                                           schema_k8sio_api_storage_v1_VolumeAttachmentSource(ref),
		storagev1.VolumeAttachmentSpec{}.OpenAPIModelName():                                                             schema_k8sio_api_storage_v1_VolumeAttachmentSpec(ref),
		storagev1.VolumeAttachmentStatus{}.OpenAPIModelName():                                                           schema_k8sio_api_storage_v1_VolumeAttachmentStatus(ref),
		storagev1.VolumeAttributesClass{}.OpenAPIModelName():                                                            schema_k8sio_api_storage_v1_VolumeAttributesClass(ref),
		storagev1.VolumeAttributesClassList{}.OpenAPIModelName():                                                        schema_k8sio_api_storage_v1_VolumeAttributesClassList(ref),
		storagev1.VolumeError{}.OpenAPIModelName():                                                                      schema_k8sio_api_storage_v1_VolumeError(ref),
		storagev1.VolumeNodeResources{}.OpenAPIModelName():                                                              schema_k8sio_api_storage_v1_VolumeNodeResources(ref),
		storagev1alpha1.CSIStorageCapacity{}.OpenAPIModelName():                                                         schema_k8sio_api_storage_v1alpha1_CSIStorageCapacity(ref),
		storagev1alpha1.CSIStorageCapacityList{}.OpenAPIModelName():                                                     schema_k8sio_api_storage_v1alpha1_CSIStorageCapacityList(ref),
		storagev1alpha1.VolumeAttachment{}.OpenAPIModelName():                                                           schema_k8sio_api_storage_v1alpha1_VolumeAttachment(ref),
		storagev1alpha1.VolumeAttachmentList{}.OpenAPIModelName():                                                       schema_k8sio_api_storage_v1alpha1_VolumeAttachmentList(ref),
		storagev1alpha1.VolumeAttachmentSource{}.OpenAPIModelName():                                                     schema_k8sio_api_storage_v1alpha1_VolumeAttachmentSource(ref),
		storagev1alpha1.VolumeAttachmentSpec{}.OpenAPIModelName():                                                       schema_k8sio_api_storage_v1alpha1_VolumeAttachmentSpec(ref),
		storagev1alpha1.VolumeAttachmentStatus{}.OpenAPIModelName():                                                     schema_k8sio_api_storage_v1alpha1_VolumeAttachmentStatus(ref),
		storagev1alpha1.VolumeAttributesClass{}.OpenAPIModelName():                                                      schema_k8sio_api_storage_v1alpha1_VolumeAttributesClass(ref),
		storagev1alpha1.VolumeAttributesClassList{}.OpenAPIModelName():                                                  schema_k8sio_api_storage_v1alpha1_VolumeAttributesClassList(ref),
		storagev1alpha1.VolumeError{}.OpenAPIModelName():                                                                schema_k8sio_api_storage_v1alpha1_VolumeError(ref),
		storagev1beta1.CSIDriver{}.OpenAPIModelName():                                                                   schema_k8sio_api_storage_v1beta1_CSIDriver(ref),
		storagev1beta1.CSIDriverList{}.OpenAPIModelName():                                                               schema_k8sio_api_storage_v1beta1_CSIDriverList(ref),
		storagev1beta1.CSIDriverSpec{}.OpenAPIModelName():                                                               schema_k8sio_api_storage_v1beta1_CSIDriverSpec(ref),
		storagev1beta1.CSINode{}.OpenAPIModelName():                                                                     schema_k8sio_api_storage_v1beta1_CSINode(ref),
		storagev1beta1.CSINodeDriver{}.OpenAPIModelName():                                                               schema_k8sio_api_storage_v1beta1_CSINodeDriver(ref),
		storagev1beta1.CSINodeList{}.OpenAPIModelName():                                                                 schema_k8sio_api_storage_v1beta1_CSINodeList(ref),
		storagev1beta1.CSINodeSpec{}.OpenAPIModelName():                                                                 schema_k8sio_api_storage_v1beta1_CSINodeSpec(ref),
		storagev1beta1.CSIStorageCapacity{}.OpenAPIModelName():                                                          schema_k8sio_api_storage_v1beta1_CSIStorageCapacity(ref),
		storagev1beta1.CSIStorageCapacityList{}.OpenAPIModelName():                                                      schema_k8sio_api_storage_v1beta1_CSIStorageCapacityList(ref),
		storagev1beta1.StorageClass{}.OpenAPIModelName():                                                                schema_k8sio_api_storage_v1beta1_StorageClass(ref),
		storagev1beta1.StorageClassList{}.OpenAPIModelName():                                                            schema_k8sio_api_storage_v1beta1_StorageClassList(ref),
		storagev1beta1.TokenRequest{}.OpenAPIModelName():                                                                schema_k8sio_api_storage_v1beta1_TokenRequest(ref),
		storagev1beta1.VolumeAttachment{}.OpenAPIModelName():                                                            schema_k8sio_api_storage_v1beta1_VolumeAttachment(ref),
		storagev1beta1.VolumeAttachmentList{}.OpenAPIModelName():                                                        schema_k8sio_api_storage_v1beta1_VolumeAttachmentList(ref),
		storagev1beta1.VolumeAttachmentSource{}.OpenAPIModelName():                                                      schema_k8sio_api_storage_v1beta1_VolumeAttachmentSource(ref),
		storagev1beta1.VolumeAttachmentSpec{}.OpenAPIModelName():                                                        schema_k8sio_api_storage_v1beta1_VolumeAttachmentSpec(ref),
		storagev1beta1.VolumeAttachmentStatus{}.OpenAPIModelName():                                                      schema_k8sio_api_storage_v1beta1_VolumeAttachmentStatus(ref),
		storagev1beta1.VolumeAttributesClass{}.OpenAPIModelName():                                                       schema_k8sio_api_storage_v1beta1_VolumeAttributesClass(ref),
		storagev1beta1.VolumeAttributesClassList{}.OpenAPIModelName():                                                   schema_k8sio_api_storage_v1beta1_VolumeAttributesClassList(ref),
		storagev1beta1.VolumeError{}.OpenAPIModelName():                                                                 schema_k8sio_api_storage_v1beta1_VolumeError(ref),
		storagev1beta1.VolumeNodeResources{}.OpenAPIModelName():                                                         schema_k8sio_api_storage_v1beta1_VolumeNodeResources(ref),
		storagemigrationv1beta1.StorageVersionMigration{}.OpenAPIModelName():                                            schema_k8sio_api_storagemigration_v1beta1_StorageVersionMigration(ref),
		storagemigrationv1beta1.StorageVersionMigrationList{}.OpenAPIModelName():                                        schema_k8sio_api_storagemigration_v1beta1_StorageVersionMigrationList(ref),
		storagemigrationv1beta1.StorageVersionMigrationSpec{}.OpenAPIModelName():                                        schema_k8sio_api_storagemigration_v1beta1_StorageVersionMigrationSpec(ref),
		storagemigrationv1beta1.StorageVersionMigrationStatus{}.OpenAPIModelName():                                      schema_k8sio_api_storagemigration_v1beta1_StorageVersionMigrationStatus(ref),
		apiextensionsv1.ConversionRequest{}.OpenAPIModelName():                                                          schema_pkg_apis_apiextensions_v1_ConversionRequest(ref),
		apiextensionsv1.ConversionResponse{}.OpenAPIModelName():                                                         schema_pkg_apis_apiextensions_v1_ConversionResponse(ref),
		apiextensionsv1.ConversionReview{}.OpenAPIModelName():                                                           schema_pkg_apis_apiextensions_v1_ConversionReview(ref),
		apiextensionsv1.CustomResourceColumnDefinition{}.OpenAPIModelName():                                             schema_pkg_apis_apiextensions_v1_CustomResourceColumnDefinition(ref),
		apiextensionsv1.CustomResourceConversion{}.OpenAPIModelName():                                                   schema_pkg_apis_apiextensions_v1_CustomResourceConversion(ref),
		apiextensionsv1.CustomResourceDefinition{}.OpenAPIModelName():                                                   schema_pkg_apis_apiextensions_v1_CustomResourceDefinition(ref),
		apiextensionsv1.CustomResourceDefinitionCondition{}.OpenAPIModelName():                                          schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionCondition(ref),
		apiextensionsv1.CustomResourceDefinitionList{}.OpenAPIModelName():                                               schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionList(ref),
		apiextensionsv1.CustomResourceDefinitionNames{}.OpenAPIModelName():                                              schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionNames(ref),
		apiextensionsv1.CustomResourceDefinitionSpec{}.OpenAPIModelName():                                               schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionSpec(ref),
		apiextensionsv1.CustomResourceDefinitionStatus{}.OpenAPIModelName():                                             schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionStatus(ref),
		apiextensionsv1.CustomResourceDefinitionVersion{}.OpenAPIModelName():                                            schema_pkg_apis_apiextensions_v1_CustomResourceDefinitionVersion(ref),
		apiextensionsv1.CustomResourceSubresourceScale{}.OpenAPIModelName():                                             schema_pkg_apis_apiextensions_v1_CustomResourceSubresourceScale(ref),
		apiextensionsv1.CustomResourceSubresourceStatus{}.OpenAPIModelName():                                            schema_pkg_apis_apiextensions_v1_CustomResourceSubresourceStatus(ref),
		apiextensionsv1.CustomResourceSubresources{}.OpenAPIModelName():                                                 schema_pkg_apis_apiextensions_v1_CustomResourceSubresources(ref),
		apiextensionsv1.CustomResourceValidation{}.OpenAPIModelName():                                                   schema_pkg_apis_apiextensions_v1_CustomResourceValidation(ref),
		apiextensionsv1.ExternalDocumentation{}.OpenAPIModelName():                                                      schema_pkg_apis_apiextensions_v1_ExternalDocumentation(ref),
		apiextensionsv1.JSON{}.OpenAPIModelName():                                                                       schema_pkg_apis_apiextensions_v1_JSON(ref),
		apiextensionsv1.JSONSchemaProps{}.OpenAPIModelName():                                                            schema_pkg_apis_apiextensions_v1_JSONSchemaProps(ref),
		apiextensionsv1.JSONSchemaPropsOrArray{}.OpenAPIModelName():                                                     schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrArray(ref),
		apiextensionsv1.JSONSchemaPropsOrBool{}.OpenAPIModelName():                                                      schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrBool(ref),
		apiextensionsv1.JSONSchemaPropsOrStringArray{}.OpenAPIModelName():                                               schema_pkg_apis_apiextensions_v1_JSONSchemaPropsOrStringArray(ref),
		apiextensionsv1.SelectableField{}.OpenAPIModelName():                                                            schema_pkg_apis_apiextensions_v1_SelectableField(ref),
		apiextensionsv1.ServiceReference{}.OpenAPIModelName():                                                           schema_pkg_apis_apiextensions_v1_ServiceReference(ref),
		apiextensionsv1.ValidationRule{}.OpenAPIModelName():                                                             schema_pkg_apis_apiextensions_v1_ValidationRule(ref),
		apiextensionsv1.WebhookClientConfig{}.OpenAPIModelName():                                                        schema_pkg_apis_apiextensions_v1_WebhookClientConfig(ref),
		apiextensionsv1.WebhookConversion{}.OpenAPIModelName():                                                          schema_pkg_apis_apiextensions_v1_WebhookConversion(ref),
		apiextensionsv1beta1.ConversionRequest{}.OpenAPIModelName():                                                     schema_pkg_apis_apiextensions_v1beta1_ConversionRequest(ref),
		apiextensionsv1beta1.ConversionResponse{}.OpenAPIModelName():                                                    schema_pkg_apis_apiextensions_v1beta1_ConversionResponse(ref),
		apiextensionsv1beta1.ConversionReview{}.OpenAPIModelName():                                                      schema_pkg_apis_apiextensions_v1beta1_ConversionReview(ref),
		apiextensionsv1beta1.CustomResourceColumnDefinition{}.OpenAPIModelName():                                        schema_pkg_apis_apiextensions_v1beta1_CustomResourceColumnDefinition(ref),
		apiextensionsv1beta1.CustomResourceConversion{}.OpenAPIModelName():                                              schema_pkg_apis_apiextensions_v1beta1_CustomResourceConversion(ref),
		apiextensionsv1beta1.CustomResourceDefinition{}.OpenAPIModelName():                                              schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinition(ref),
		apiextensionsv1beta1.CustomResourceDefinitionCondition{}.OpenAPIModelName():                                     schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionCondition(ref),
		apiextensionsv1beta1.CustomResourceDefinitionList{}.OpenAPIModelName():                                          schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionList(ref),
		apiextensionsv1beta1.CustomResourceDefinitionNames{}.OpenAPIModelName():                                         schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionNames(ref),
		apiextensionsv1beta1.CustomResourceDefinitionSpec{}.OpenAPIModelName():                                          schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionSpec(ref),
		apiextensionsv1beta1.CustomResourceDefinitionStatus{}.OpenAPIModelName():                                        schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionStatus(ref),
		apiextensionsv1beta1.CustomResourceDefinitionVersion{}.OpenAPIModelName():                                       schema_pkg_apis_apiextensions_v1beta1_CustomResourceDefinitionVersion(ref),
		apiextensionsv1beta1.CustomResourceSubresourceScale{}.OpenAPIModelName():                                        schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresourceScale(ref),
		apiextensionsv1beta1.CustomResourceSubresourceStatus{}.OpenAPIModelName():                                       schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresourceStatus(ref),
		apiextensionsv1beta1.CustomResourceSubresources{}.OpenAPIModelName():                                            schema_pkg_apis_apiextensions_v1beta1_CustomResourceSubresources(ref),
		apiextensionsv1beta1.CustomResourceValidation{}.OpenAPIModelName():                                              schema_pkg_apis_apiextensions_v1beta1_CustomResourceValidation(ref),
		apiextensionsv1beta1.ExternalDocumentation{}.OpenAPIModelName():                                                 schema_pkg_apis_apiextensions_v1beta1_ExternalDocumentation(ref),
		apiextensionsv1beta1.JSON{}.OpenAPIModelName():                                                                  schema_pkg_apis_apiextensions_v1beta1_JSON(ref),
		apiextensionsv1beta1.JSONSchemaProps{}.OpenAPIModelName():                                                       schema_pkg_apis_apiextensions_v1beta1_JSONSchemaProps(ref),
		apiextensionsv1beta1.JSONSchemaPropsOrArray{}.OpenAPIModelName():                                                schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrArray(ref),
		apiextensionsv1beta1.JSONSchemaPropsOrBool{}.OpenAPIModelName():                                                 schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrBool(ref),
		apiextensionsv1beta1.JSONSchemaPropsOrStringArray{}.OpenAPIModelName():                                          schema_pkg_apis_apiextensions_v1beta1_JSONSchemaPropsOrStringArray(ref),
		apiextensionsv1beta1.SelectableField{}.OpenAPIModelName():                                                       schema_pkg_apis_apiextensions_v1beta1_SelectableField(ref),
		apiextensionsv1beta1.ServiceReference{}.OpenAPIModelName():                                                      schema_pkg_apis_apiextensions_v1beta1_ServiceReference(ref),
		apiextensionsv1beta1.ValidationRule{}.OpenAPIModelName():                                                        schema_pkg_apis_apiextensions_v1beta1_ValidationRule(ref),
		apiextensionsv1beta1.WebhookClientConfig{}.OpenAPIModelName():                                                   schema_pkg_apis_apiextensions_v1beta1_WebhookClientConfig(ref),
		resource.Quantity{}.OpenAPIModelName():                                                                          schema_apimachinery_pkg_api_resource_Quantity(ref),
		metav1.APIGroup{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_APIGroup(ref),
		metav1.APIGroupList{}.OpenAPIModelName():                                                                        schema_pkg_apis_meta_v1_APIGroupList(ref),
		metav1.APIResource{}.OpenAPIModelName():                                                                         schema_pkg_apis_meta_v1_APIResource(ref),
		metav1.APIResourceList{}.OpenAPIModelName():                                                                     schema_pkg_apis_meta_v1_APIResourceList(ref),
		metav1.APIVersions{}.OpenAPIModelName():                                                                         schema_pkg_apis_meta_v1_APIVersions(ref),
		metav1.ApplyOptions{}.OpenAPIModelName():                                                                        schema_pkg_apis_meta_v1_ApplyOptions(ref),
		metav1.Condition{}.OpenAPIModelName():                                                                           schema_pkg_apis_meta_v1_Condition(ref),
		metav1.CreateOptions{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_CreateOptions(ref),
		metav1.DeleteOptions{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_DeleteOptions(ref),
		metav1.Duration{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_Duration(ref),
		metav1.FieldSelectorRequirement{}.OpenAPIModelName():                                                            schema_pkg_apis_meta_v1_FieldSelectorRequirement(ref),
		metav1.FieldsV1{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_FieldsV1(ref),
		metav1.GetOptions{}.OpenAPIModelName():                                                                          schema_pkg_apis_meta_v1_GetOptions(ref),
		metav1.GroupKind{}.OpenAPIModelName():                                                                           schema_pkg_apis_meta_v1_GroupKind(ref),
		metav1.GroupResource{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_GroupResource(ref),
		metav1.GroupVersion{}.OpenAPIModelName():                                                                        schema_pkg_apis_meta_v1_GroupVersion(ref),
		metav1.GroupVersionForDiscovery{}.OpenAPIModelName():                                                            schema_pkg_apis_meta_v1_GroupVersionForDiscovery(ref),
		metav1.GroupVersionKind{}.OpenAPIModelName():                                                                    schema_pkg_apis_meta_v1_GroupVersionKind(ref),
		metav1.GroupVersionResource{}.OpenAPIModelName():                                                                schema_pkg_apis_meta_v1_GroupVersionResource(ref),
		metav1.InternalEvent{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_InternalEvent(ref),
		metav1.LabelSelector{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_LabelSelector(ref),
		metav1.LabelSelectorRequirement{}.OpenAPIModelName():                                                            schema_pkg_apis_meta_v1_LabelSelectorRequirement(ref),
		metav1.List{}.OpenAPIModelName():                                                                                schema_pkg_apis_meta_v1_List(ref),
		metav1.ListMeta{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_ListMeta(ref),
		metav1.ListOptions{}.OpenAPIModelName():                                                                         schema_pkg_apis_meta_v1_ListOptions(ref),
		metav1.ManagedFieldsEntry{}.OpenAPIModelName():                                                                  schema_pkg_apis_meta_v1_ManagedFieldsEntry(ref),
		metav1.MicroTime{}.OpenAPIModelName():                                                                           schema_pkg_apis_meta_v1_MicroTime(ref),
		metav1.ObjectMeta{}.OpenAPIModelName():                                                                          schema_pkg_apis_meta_v1_ObjectMeta(ref),
		metav1.OwnerReference{}.OpenAPIModelName():                                                                      schema_pkg_apis_meta_v1_OwnerReference(ref),
		metav1.PartialObjectMetadata{}.OpenAPIModelName():                                                               schema_pkg_apis_meta_v1_PartialObjectMetadata(ref),
		metav1.PartialObjectMetadataList{}.OpenAPIModelName():                                                           schema_pkg_apis_meta_v1_PartialObjectMetadataList(ref),
		metav1.Patch{}.OpenAPIModelName():                                                                               schema_pkg_apis_meta_v1_Patch(ref),
		metav1.PatchOptions{}.OpenAPIModelName():                                                                        schema_pkg_apis_meta_v1_PatchOptions(ref),
		metav1.Preconditions{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_Preconditions(ref),
		metav1.RootPaths{}.OpenAPIModelName():                                                                           schema_pkg_apis_meta_v1_RootPaths(ref),
		metav1.ServerAddressByClientCIDR{}.OpenAPIModelName():                                                           schema_pkg_apis_meta_v1_ServerAddressByClientCIDR(ref),
		metav1.Status{}.OpenAPIModelName():                                                                              schema_pkg_apis_meta_v1_Status(ref),
		metav1.StatusCause{}.OpenAPIModelName():                                                                         schema_pkg_apis_meta_v1_StatusCause(ref),
		metav1.StatusDetails{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_StatusDetails(ref),
		metav1.Table{}.OpenAPIModelName():                                                                               schema_pkg_apis_meta_v1_Table(ref),
		metav1.TableColumnDefinition{}.OpenAPIModelName():                                                               schema_pkg_apis_meta_v1_TableColumnDefinition(ref),
		metav1.TableOptions{}.OpenAPIModelName():                                                                        schema_pkg_apis_meta_v1_TableOptions(ref),
		metav1.TableRow{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_TableRow(ref),
		metav1.TableRowCondition{}.OpenAPIModelName():                                                                   schema_pkg_apis_meta_v1_TableRowCondition(ref),
		metav1.Time{}.OpenAPIModelName():                                                                                schema_pkg_apis_meta_v1_Time(ref),
		metav1.Timestamp{}.OpenAPIModelName():                                                                           schema_pkg_apis_meta_v1_Timestamp(ref),
		metav1.TypeMeta{}.OpenAPIModelName():                                                                            schema_pkg_apis_meta_v1_TypeMeta(ref),
		metav1.UpdateOptions{}.OpenAPIModelName():                                                                       schema_pkg_apis_meta_v1_UpdateOptions(ref),
		metav1.WatchEvent{}.OpenAPIModelName():                                                                          schema_pkg_apis_meta_v1_WatchEvent(ref),
		metav1beta1.PartialObjectMetadataList{}.OpenAPIModelName():                                                      schema_pkg_apis_meta_v1beta1_PartialObjectMetadataList(ref),
		testapigroupv1.Carp{}.OpenAPIModelName():                                                                        schema_pkg_apis_testapigroup_v1_Carp(ref),
		testapigroupv1.CarpCondition{}.OpenAPIModelName():                                                               schema_pkg_apis_testapigroup_v1_CarpCondition(ref),
		testapigroupv1.CarpInfo{}.OpenAPIModelName():                                                                    schema_pkg_apis_testapigroup_v1_CarpInfo(ref),
		testapigroupv1.CarpList{}.OpenAPIModelName():                                                                    schema_pkg_apis_testapigroup_v1_CarpList(ref),
		testapigroupv1.CarpSpec{}.OpenAPIModelName():                                                                    schema_pkg_apis_testapigroup_v1_CarpSpec(ref),
		testapigroupv1.CarpStatus{}.OpenAPIModelName():                                                                  schema_pkg_apis_testapigroup_v1_CarpStatus(ref),
		runtime.RawExtension{}.OpenAPIModelName():                                                                       schema_k8sio_apimachinery_pkg_runtime_RawExtension(ref),
		runtime.TypeMeta{}.OpenAPIModelName():                                                                           schema_k8sio_apimachinery_pkg_runtime_TypeMeta(ref),
		runtime.Unknown{}.OpenAPIModelName():                                                                            schema_k8sio_apimachinery_pkg_runtime_Unknown(ref),
		intstr.IntOrString{}.OpenAPIModelName():                                                                         schema_apimachinery_pkg_util_intstr_IntOrString(ref),
		version.Info{}.OpenAPIModelName():                                                                               schema_k8sio_apimachinery_pkg_version_Info(ref),
		auditv1.AuthenticationMetadata{}.OpenAPIModelName():                                                             schema_pkg_apis_audit_v1_AuthenticationMetadata(ref),
		auditv1.Event{}.OpenAPIModelName():                                                                              schema_pkg_apis_audit_v1_Event(ref),
		auditv1.EventList{}.OpenAPIModelName():                                                                          schema_pkg_apis_audit_v1_EventList(ref),
		auditv1.GroupResources{}.OpenAPIModelName():                                                                     schema_pkg_apis_audit_v1_GroupResources(ref),
		auditv1.ObjectReference{}.OpenAPIModelName():                                                                    schema_pkg_apis_audit_v1_ObjectReference(ref),
		auditv1.Policy{}.OpenAPIModelName():                                                                             schema_pkg_apis_audit_v1_Policy(ref),
		auditv1.PolicyList{}.OpenAPIModelName():                                                                         schema_pkg_apis_audit_v1_PolicyList(ref),
		auditv1.PolicyRule{}.OpenAPIModelName():                                                                         schema_pkg_apis_audit_v1_PolicyRule(ref),
		apiv1alpha1.Flagz{}.OpenAPIModelName():                                                                          schema_server_flagz_api_v1alpha1_Flagz(ref),
		statuszapiv1alpha1.Statusz{}.OpenAPIModelName():                                                                 schema_server_statusz_api_v1alpha1_Statusz(ref),
		clientauthenticationv1.Cluster{}.OpenAPIModelName():                                                             schema_pkg_apis_clientauthentication_v1_Cluster(ref),
		clientauthenticationv1.ExecCredential{}.OpenAPIModelName():                                                      schema_pkg_apis_clientauthentication_v1_ExecCredential(ref),
		clientauthenticationv1.ExecCredentialSpec{}.OpenAPIModelName():                                                  schema_pkg_apis_clientauthentication_v1_ExecCredentialSpec(ref),
		clientauthenticationv1.ExecCredentialStatus{}.OpenAPIModelName():                                                schema_pkg_apis_clientauthentication_v1_ExecCredentialStatus(ref),
		clientauthenticationv1beta1.Cluster{}.OpenAPIModelName():                                                        schema_pkg_apis_clientauthentication_v1beta1_Cluster(ref),
		clientauthenticationv1beta1.ExecCredential{}.OpenAPIModelName():                                                 schema_pkg_apis_clientauthentication_v1beta1_ExecCredential(ref),
		clientauthenticationv1beta1.ExecCredentialSpec{}.OpenAPIModelName():                                             schema_pkg_apis_clientauthentication_v1beta1_ExecCredentialSpec(ref),
		clientauthenticationv1beta1.ExecCredentialStatus{}.OpenAPIModelName():                                           schema_pkg_apis_clientauthentication_v1beta1_ExecCredentialStatus(ref),
		configv1alpha1.CloudControllerManagerConfiguration{}.OpenAPIModelName():                                         schema_k8sio_cloud_provider_config_v1alpha1_CloudControllerManagerConfiguration(ref),
		configv1alpha1.CloudProviderConfiguration{}.OpenAPIModelName():                                                  schema_k8sio_cloud_provider_config_v1alpha1_CloudProviderConfiguration(ref),
		configv1alpha1.KubeCloudSharedConfiguration{}.OpenAPIModelName():                                                schema_k8sio_cloud_provider_config_v1alpha1_KubeCloudSharedConfiguration(ref),
		configv1alpha1.WebhookConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_cloud_provider_config_v1alpha1_WebhookConfiguration(ref),
		nodeconfigv1alpha1.NodeControllerConfiguration{}.OpenAPIModelName():                                             schema_controllers_node_config_v1alpha1_NodeControllerConfiguration(ref),
		serviceconfigv1alpha1.ServiceControllerConfiguration{}.OpenAPIModelName():                                       schema_controllers_service_config_v1alpha1_ServiceControllerConfiguration(ref),
		componentbaseconfigv1alpha1.ClientConnectionConfiguration{}.OpenAPIModelName():                                  schema_k8sio_component_base_config_v1alpha1_ClientConnectionConfiguration(ref),
		componentbaseconfigv1alpha1.DebuggingConfiguration{}.OpenAPIModelName():                                         schema_k8sio_component_base_config_v1alpha1_DebuggingConfiguration(ref),
		componentbaseconfigv1alpha1.LeaderElectionConfiguration{}.OpenAPIModelName():                                    schema_k8sio_component_base_config_v1alpha1_LeaderElectionConfiguration(ref),
		apiv1.TracingConfiguration{}.OpenAPIModelName():                                                                 schema_component_base_tracing_api_v1_TracingConfiguration(ref),
		controllermanagerconfigv1alpha1.ControllerLeaderConfiguration{}.OpenAPIModelName():                              schema_k8sio_controller_manager_config_v1alpha1_ControllerLeaderConfiguration(ref),
		controllermanagerconfigv1alpha1.GenericControllerManagerConfiguration{}.OpenAPIModelName():                      schema_k8sio_controller_manager_config_v1alpha1_GenericControllerManagerConfiguration(ref),
		controllermanagerconfigv1alpha1.LeaderMigrationConfiguration{}.OpenAPIModelName():                               schema_k8sio_controller_manager_config_v1alpha1_LeaderMigrationConfiguration(ref),
		configv1beta1.ControllerLeaderConfiguration{}.OpenAPIModelName():                                                schema_k8sio_controller_manager_config_v1beta1_ControllerLeaderConfiguration(ref),
		configv1beta1.LeaderMigrationConfiguration{}.OpenAPIModelName():                                                 schema_k8sio_controller_manager_config_v1beta1_LeaderMigrationConfiguration(ref),
		apiregistrationv1.APIService{}.OpenAPIModelName():                                                               schema_pkg_apis_apiregistration_v1_APIService(ref),
		apiregistrationv1.APIServiceCondition{}.OpenAPIModelName():                                                      schema_pkg_apis_apiregistration_v1_APIServiceCondition(ref),
		apiregistrationv1.APIServiceList{}.OpenAPIModelName():                                                           schema_pkg_apis_apiregistration_v1_APIServiceList(ref),
		apiregistrationv1.APIServiceSpec{}.OpenAPIModelName():                                                           schema_pkg_apis_apiregistration_v1_APIServiceSpec(ref),
		apiregistrationv1.APIServiceStatus{}.OpenAPIModelName():                                                         schema_pkg_apis_apiregistration_v1_APIServiceStatus(ref),
		apiregistrationv1.ServiceReference{}.OpenAPIModelName():                                                         schema_pkg_apis_apiregistration_v1_ServiceReference(ref),
		apiregistrationv1beta1.APIService{}.OpenAPIModelName():                                                          schema_pkg_apis_apiregistration_v1beta1_APIService(ref),
		apiregistrationv1beta1.APIServiceCondition{}.OpenAPIModelName():                                                 schema_pkg_apis_apiregistration_v1beta1_APIServiceCondition(ref),
		apiregistrationv1beta1.APIServiceList{}.OpenAPIModelName():                                                      schema_pkg_apis_apiregistration_v1beta1_APIServiceList(ref),
		apiregistrationv1beta1.APIServiceSpec{}.OpenAPIModelName():                                                      schema_pkg_apis_apiregistration_v1beta1_APIServiceSpec(ref),
		apiregistrationv1beta1.APIServiceStatus{}.OpenAPIModelName():                                                    schema_pkg_apis_apiregistration_v1beta1_APIServiceStatus(ref),
		apiregistrationv1beta1.ServiceReference{}.OpenAPIModelName():                                                    schema_pkg_apis_apiregistration_v1beta1_ServiceReference(ref),
		kubecontrollermanagerconfigv1alpha1.AttachDetachControllerConfiguration{}.OpenAPIModelName():                    schema_k8sio_kube_controller_manager_config_v1alpha1_AttachDetachControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.CSRSigningConfiguration{}.OpenAPIModelName():                                schema_k8sio_kube_controller_manager_config_v1alpha1_CSRSigningConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.CSRSigningControllerConfiguration{}.OpenAPIModelName():                      schema_k8sio_kube_controller_manager_config_v1alpha1_CSRSigningControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.CronJobControllerConfiguration{}.OpenAPIModelName():                         schema_k8sio_kube_controller_manager_config_v1alpha1_CronJobControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.DaemonSetControllerConfiguration{}.OpenAPIModelName():                       schema_k8sio_kube_controller_manager_config_v1alpha1_DaemonSetControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.DeploymentControllerConfiguration{}.OpenAPIModelName():                      schema_k8sio_kube_controller_manager_config_v1alpha1_DeploymentControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.DeprecatedControllerConfiguration{}.OpenAPIModelName():                      schema_k8sio_kube_controller_manager_config_v1alpha1_DeprecatedControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.DeviceTaintEvictionControllerConfiguration{}.OpenAPIModelName():             schema_k8sio_kube_controller_manager_config_v1alpha1_DeviceTaintEvictionControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.EndpointControllerConfiguration{}.OpenAPIModelName():                        schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.EndpointSliceControllerConfiguration{}.OpenAPIModelName():                   schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointSliceControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.EndpointSliceMirroringControllerConfiguration{}.OpenAPIModelName():          schema_k8sio_kube_controller_manager_config_v1alpha1_EndpointSliceMirroringControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.EphemeralVolumeControllerConfiguration{}.OpenAPIModelName():                 schema_k8sio_kube_controller_manager_config_v1alpha1_EphemeralVolumeControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.GarbageCollectorControllerConfiguration{}.OpenAPIModelName():                schema_k8sio_kube_controller_manager_config_v1alpha1_GarbageCollectorControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.GroupResource{}.OpenAPIModelName():                                          schema_k8sio_kube_controller_manager_config_v1alpha1_GroupResource(ref),
		kubecontrollermanagerconfigv1alpha1.HPAControllerConfiguration{}.OpenAPIModelName():                             schema_k8sio_kube_controller_manager_config_v1alpha1_HPAControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.JobControllerConfiguration{}.OpenAPIModelName():                             schema_k8sio_kube_controller_manager_config_v1alpha1_JobControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.KubeControllerManagerConfiguration{}.OpenAPIModelName():                     schema_k8sio_kube_controller_manager_config_v1alpha1_KubeControllerManagerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.LegacySATokenCleanerConfiguration{}.OpenAPIModelName():                      schema_k8sio_kube_controller_manager_config_v1alpha1_LegacySATokenCleanerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.NamespaceControllerConfiguration{}.OpenAPIModelName():                       schema_k8sio_kube_controller_manager_config_v1alpha1_NamespaceControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.NodeIPAMControllerConfiguration{}.OpenAPIModelName():                        schema_k8sio_kube_controller_manager_config_v1alpha1_NodeIPAMControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.NodeLifecycleControllerConfiguration{}.OpenAPIModelName():                   schema_k8sio_kube_controller_manager_config_v1alpha1_NodeLifecycleControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.PersistentVolumeBinderControllerConfiguration{}.OpenAPIModelName():          schema_k8sio_kube_controller_manager_config_v1alpha1_PersistentVolumeBinderControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.PersistentVolumeRecyclerConfiguration{}.OpenAPIModelName():                  schema_k8sio_kube_controller_manager_config_v1alpha1_PersistentVolumeRecyclerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.PodGCControllerConfiguration{}.OpenAPIModelName():                           schema_k8sio_kube_controller_manager_config_v1alpha1_PodGCControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.ReplicaSetControllerConfiguration{}.OpenAPIModelName():                      schema_k8sio_kube_controller_manager_config_v1alpha1_ReplicaSetControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.ReplicationControllerConfiguration{}.OpenAPIModelName():                     schema_k8sio_kube_controller_manager_config_v1alpha1_ReplicationControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.ResourceQuotaControllerConfiguration{}.OpenAPIModelName():                   schema_k8sio_kube_controller_manager_config_v1alpha1_ResourceQuotaControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.SAControllerConfiguration{}.OpenAPIModelName():                              schema_k8sio_kube_controller_manager_config_v1alpha1_SAControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.StatefulSetControllerConfiguration{}.OpenAPIModelName():                     schema_k8sio_kube_controller_manager_config_v1alpha1_StatefulSetControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.TTLAfterFinishedControllerConfiguration{}.OpenAPIModelName():                schema_k8sio_kube_controller_manager_config_v1alpha1_TTLAfterFinishedControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.ValidatingAdmissionPolicyStatusControllerConfiguration{}.OpenAPIModelName(): schema_k8sio_kube_controller_manager_config_v1alpha1_ValidatingAdmissionPolicyStatusControllerConfiguration(ref),
		kubecontrollermanagerconfigv1alpha1.VolumeConfiguration{}.OpenAPIModelName():                                    schema_k8sio_kube_controller_manager_config_v1alpha1_VolumeConfiguration(ref),
		kubeproxyconfigv1alpha1.DetectLocalConfiguration{}.OpenAPIModelName():                                           schema_k8sio_kube_proxy_config_v1alpha1_DetectLocalConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyConfiguration{}.OpenAPIModelName():                                             schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyConntrackConfiguration{}.OpenAPIModelName():                                    schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyConntrackConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyIPTablesConfiguration{}.OpenAPIModelName():                                     schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyIPTablesConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyIPVSConfiguration{}.OpenAPIModelName():                                         schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyIPVSConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyNFTablesConfiguration{}.OpenAPIModelName():                                     schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyNFTablesConfiguration(ref),
		kubeproxyconfigv1alpha1.KubeProxyWinkernelConfiguration{}.OpenAPIModelName():                                    schema_k8sio_kube_proxy_config_v1alpha1_KubeProxyWinkernelConfiguration(ref),
		configv1.DefaultPreemptionArgs{}.OpenAPIModelName():                                                             schema_k8sio_kube_scheduler_config_v1_DefaultPreemptionArgs(ref),
		configv1.DynamicResourcesArgs{}.OpenAPIModelName():                                                              schema_k8sio_kube_scheduler_config_v1_DynamicResourcesArgs(ref),
		configv1.Extender{}.OpenAPIModelName():                                                                          schema_k8sio_kube_scheduler_config_v1_Extender(ref),
		configv1.ExtenderManagedResource{}.OpenAPIModelName():                                                           schema_k8sio_kube_scheduler_config_v1_ExtenderManagedResource(ref),
		configv1.ExtenderTLSConfig{}.OpenAPIModelName():                                                                 schema_k8sio_kube_scheduler_config_v1_ExtenderTLSConfig(ref),
		configv1.InterPodAffinityArgs{}.OpenAPIModelName():                                                              schema_k8sio_kube_scheduler_config_v1_InterPodAffinityArgs(ref),
		configv1.KubeSchedulerConfiguration{}.OpenAPIModelName():                                                        schema_k8sio_kube_scheduler_config_v1_KubeSchedulerConfiguration(ref),
		configv1.KubeSchedulerProfile{}.OpenAPIModelName():                                                              schema_k8sio_kube_scheduler_config_v1_KubeSchedulerProfile(ref),
		configv1.NodeAffinityArgs{}.OpenAPIModelName():                                                                  schema_k8sio_kube_scheduler_config_v1_NodeAffinityArgs(ref),
		configv1.NodeResourcesBalancedAllocationArgs{}.OpenAPIModelName():                                               schema_k8sio_kube_scheduler_config_v1_NodeResourcesBalancedAllocationArgs(ref),
		configv1.NodeResourcesFitArgs{}.OpenAPIModelName():                                                              schema_k8sio_kube_scheduler_config_v1_NodeResourcesFitArgs(ref),
		configv1.Plugin{}.OpenAPIModelName():                                                                            schema_k8sio_kube_scheduler_config_v1_Plugin(ref),
		configv1.PluginConfig{}.OpenAPIModelName():                                                                      schema_k8sio_kube_scheduler_config_v1_PluginConfig(ref),
		configv1.PluginSet{}.OpenAPIModelName():                                                                         schema_k8sio_kube_scheduler_config_v1_PluginSet(ref),
		configv1.Plugins{}.OpenAPIModelName():                                                                           schema_k8sio_kube_scheduler_config_v1_Plugins(ref),
		configv1.PodTopologySpreadArgs{}.OpenAPIModelName():                                                             schema_k8sio_kube_scheduler_config_v1_PodTopologySpreadArgs(ref),
		configv1.RequestedToCapacityRatioParam{}.OpenAPIModelName():                                                     schema_k8sio_kube_scheduler_config_v1_RequestedToCapacityRatioParam(ref),
		configv1.ResourceSpec{}.OpenAPIModelName():                                                                      schema_k8sio_kube_scheduler_config_v1_ResourceSpec(ref),
		configv1.ScoringStrategy{}.OpenAPIModelName():                                                                   schema_k8sio_kube_scheduler_config_v1_ScoringStrategy(ref),
		configv1.UtilizationShapePoint{}.OpenAPIModelName():                                                             schema_k8sio_kube_scheduler_config_v1_UtilizationShapePoint(ref),
		configv1.VolumeBindingArgs{}.OpenAPIModelName():                                                                 schema_k8sio_kube_scheduler_config_v1_VolumeBindingArgs(ref),
		pkgconfigv1alpha1.AliasOverride{}.OpenAPIModelName():                                                            schema_kubectl_pkg_config_v1alpha1_AliasOverride(ref),
		pkgconfigv1alpha1.CommandDefaults{}.OpenAPIModelName():                                                          schema_kubectl_pkg_config_v1alpha1_CommandDefaults(ref),
		pkgconfigv1alpha1.CommandOptionDefault{}.OpenAPIModelName():                                                     schema_kubectl_pkg_config_v1alpha1_CommandOptionDefault(ref),
		pkgconfigv1alpha1.Preference{}.OpenAPIModelName():                                                               schema_kubectl_pkg_config_v1alpha1_Preference(ref),
		pkgconfigv1beta1.AliasOverride{}.OpenAPIModelName():                                                             schema_kubectl_pkg_config_v1beta1_AliasOverride(ref),
		pkgconfigv1beta1.AllowlistEntry{}.OpenAPIModelName():                                                            schema_kubectl_pkg_config_v1beta1_AllowlistEntry(ref),
		pkgconfigv1beta1.CommandDefaults{}.OpenAPIModelName():                                                           schema_kubectl_pkg_config_v1beta1_CommandDefaults(ref),
		pkgconfigv1beta1.CommandOptionDefault{}.OpenAPIModelName():                                                      schema_kubectl_pkg_config_v1beta1_CommandOptionDefault(ref),
		pkgconfigv1beta1.Preference{}.OpenAPIModelName():                                                                schema_kubectl_pkg_config_v1beta1_Preference(ref),
		kubeletconfigv1.CredentialProvider{}.OpenAPIModelName():                                                         schema_k8sio_kubelet_config_v1_CredentialProvider(ref),
		kubeletconfigv1.CredentialProviderConfig{}.OpenAPIModelName():                                                   schema_k8sio_kubelet_config_v1_CredentialProviderConfig(ref),
		kubeletconfigv1.ExecEnvVar{}.OpenAPIModelName():                                                                 schema_k8sio_kubelet_config_v1_ExecEnvVar(ref),
		kubeletconfigv1.ServiceAccountTokenAttributes{}.OpenAPIModelName():                                              schema_k8sio_kubelet_config_v1_ServiceAccountTokenAttributes(ref),
		kubeletconfigv1alpha1.CredentialProvider{}.OpenAPIModelName():                                                   schema_k8sio_kubelet_config_v1alpha1_CredentialProvider(ref),
		kubeletconfigv1alpha1.CredentialProviderConfig{}.OpenAPIModelName():                                             schema_k8sio_kubelet_config_v1alpha1_CredentialProviderConfig(ref),
		kubeletconfigv1alpha1.ExecEnvVar{}.OpenAPIModelName():                                                           schema_k8sio_kubelet_config_v1alpha1_ExecEnvVar(ref),
		kubeletconfigv1alpha1.ImagePullCredentials{}.OpenAPIModelName():                                                 schema_k8sio_kubelet_config_v1alpha1_ImagePullCredentials(ref),
		kubeletconfigv1alpha1.ImagePullIntent{}.OpenAPIModelName():                                                      schema_k8sio_kubelet_config_v1alpha1_ImagePullIntent(ref),
		kubeletconfigv1alpha1.ImagePullSecret{}.OpenAPIModelName():                                                      schema_k8sio_kubelet_config_v1alpha1_ImagePullSecret(ref),
		kubeletconfigv1alpha1.ImagePullServiceAccount{}.OpenAPIModelName():                                              schema_k8sio_kubelet_config_v1alpha1_ImagePullServiceAccount(ref),
		kubeletconfigv1alpha1.ImagePulledRecord{}.OpenAPIModelName():                                                    schema_k8sio_kubelet_config_v1alpha1_ImagePulledRecord(ref),
		kubeletconfigv1beta1.CrashLoopBackOffConfig{}.OpenAPIModelName():                                                schema_k8sio_kubelet_config_v1beta1_CrashLoopBackOffConfig(ref),
		kubeletconfigv1beta1.CredentialProvider{}.OpenAPIModelName():                                                    schema_k8sio_kubelet_config_v1beta1_CredentialProvider(ref),
		kubeletconfigv1beta1.CredentialProviderConfig{}.OpenAPIModelName():                                              schema_k8sio_kubelet_config_v1beta1_CredentialProviderConfig(ref),
		kubeletconfigv1beta1.ExecEnvVar{}.OpenAPIModelName():                                                            schema_k8sio_kubelet_config_v1beta1_ExecEnvVar(ref),
		kubeletconfigv1beta1.ImagePullCredentials{}.OpenAPIModelName():                                                  schema_k8sio_kubelet_config_v1beta1_ImagePullCredentials(ref),
		kubeletconfigv1beta1.ImagePullIntent{}.OpenAPIModelName():                                                       schema_k8sio_kubelet_config_v1beta1_ImagePullIntent(ref),
		kubeletconfigv1beta1.ImagePullSecret{}.OpenAPIModelName():                                                       schema_k8sio_kubelet_config_v1beta1_ImagePullSecret(ref),
		kubeletconfigv1beta1.ImagePullServiceAccount{}.OpenAPIModelName():                                               schema_k8sio_kubelet_config_v1beta1_ImagePullServiceAccount(ref),
		kubeletconfigv1beta1.ImagePulledRecord{}.OpenAPIModelName():                                                     schema_k8sio_kubelet_config_v1beta1_ImagePulledRecord(ref),
		kubeletconfigv1beta1.KubeletAnonymousAuthentication{}.OpenAPIModelName():                                        schema_k8sio_kubelet_config_v1beta1_KubeletAnonymousAuthentication(ref),
		kubeletconfigv1beta1.KubeletAuthentication{}.OpenAPIModelName():                                                 schema_k8sio_kubelet_config_v1beta1_KubeletAuthentication(ref),
		kubeletconfigv1beta1.KubeletAuthorization{}.OpenAPIModelName():                                                  schema_k8sio_kubelet_config_v1beta1_KubeletAuthorization(ref),
		kubeletconfigv1beta1.KubeletConfiguration{}.OpenAPIModelName():                                                  schema_k8sio_kubelet_config_v1beta1_KubeletConfiguration(ref),
		kubeletconfigv1beta1.KubeletWebhookAuthentication{}.OpenAPIModelName():                                          schema_k8sio_kubelet_config_v1beta1_KubeletWebhookAuthentication(ref),
		kubeletconfigv1beta1.KubeletWebhookAuthorization{}.OpenAPIModelName():                                           schema_k8sio_kubelet_config_v1beta1_KubeletWebhookAuthorization(ref),
		kubeletconfigv1beta1.KubeletX509Authentication{}.OpenAPIModelName():                                             schema_k8sio_kubelet_config_v1beta1_KubeletX509Authentication(ref),
		kubeletconfigv1beta1.MemoryReservation{}.OpenAPIModelName():                                                     schema_k8sio_kubelet_config_v1beta1_MemoryReservation(ref),
		kubeletconfigv1beta1.MemorySwapConfiguration{}.OpenAPIModelName():                                               schema_k8sio_kubelet_config_v1beta1_MemorySwapConfiguration(ref),
		kubeletconfigv1beta1.SerializedNodeConfigSource{}.OpenAPIModelName():                                            schema_k8sio_kubelet_config_v1beta1_SerializedNodeConfigSource(ref),
		kubeletconfigv1beta1.ShutdownGracePeriodByPodPriority{}.OpenAPIModelName():                                      schema_k8sio_kubelet_config_v1beta1_ShutdownGracePeriodByPodPriority(ref),
		kubeletconfigv1beta1.UserNamespaces{}.OpenAPIModelName():                                                        schema_k8sio_kubelet_config_v1beta1_UserNamespaces(ref),
		abacv1beta1.Policy{}.OpenAPIModelName():                                                                         schema_pkg_apis_abac_v1beta1_Policy(ref),
		abacv1beta1.PolicySpec{}.OpenAPIModelName():                                                                     schema_pkg_apis_abac_v1beta1_PolicySpec(ref),
		custommetricsv1beta1.MetricListOptions{}.OpenAPIModelName():                                                     schema_pkg_apis_custom_metrics_v1beta1_MetricListOptions(ref),
		custommetricsv1beta1.MetricValue{}.OpenAPIModelName():                                                           schema_pkg_apis_custom_metrics_v1beta1_MetricValue(ref),
		custommetricsv1beta1.MetricValueList{}.OpenAPIModelName():                                                       schema_pkg_apis_custom_metrics_v1beta1_MetricValueList(ref),
		custommetricsv1beta2.MetricIdentifier{}.OpenAPIModelName():                                                      schema_pkg_apis_custom_metrics_v1beta2_MetricIdentifier(ref),
		custommetricsv1beta2.MetricListOptions{}.OpenAPIModelName():                                                     schema_pkg_apis_custom_metrics_v1beta2_MetricListOptions(ref),
		custommetricsv1beta2.MetricValue{}.OpenAPIModelName():                                                           schema_pkg_apis_custom_metrics_v1beta2_MetricValue(ref),
		custommetricsv1beta2.MetricValueList{}.OpenAPIModelName():                                                       schema_pkg_apis_custom_metrics_v1beta2_MetricValueList(ref),
		externalmetricsv1beta1.ExternalMetricValue{}.OpenAPIModelName():                                                 schema_pkg_apis_external_metrics_v1beta1_ExternalMetricValue(ref),
		externalmetricsv1beta1.ExternalMetricValueList{}.OpenAPIModelName():                                             schema_pkg_apis_external_metrics_v1beta1_ExternalMetricValueList(ref),
		metricsv1alpha1.ContainerMetrics{}.OpenAPIModelName():                                                           schema_pkg_apis_metrics_v1alpha1_ContainerMetrics(ref),
		metricsv1alpha1.NodeMetrics{}.OpenAPIModelName():                                                                schema_pkg_apis_metrics_v1alpha1_NodeMetrics(ref),
		metricsv1alpha1.NodeMetricsList{}.OpenAPIModelName():                                                            schema_pkg_apis_metrics_v1alpha1_NodeMetricsList(ref),
		metricsv1alpha1.PodMetrics{}.OpenAPIModelName():                                                                 schema_pkg_apis_metrics_v1alpha1_PodMetrics(ref),
		metricsv1alpha1.PodMetricsList{}.OpenAPIModelName():                                                             schema_pkg_apis_metrics_v1alpha1_PodMetricsList(ref),
		metricsv1beta1.ContainerMetrics{}.OpenAPIModelName():                                                            schema_pkg_apis_metrics_v1beta1_ContainerMetrics(ref),
		metricsv1beta1.NodeMetrics{}.OpenAPIModelName():                                                                 schema_pkg_apis_metrics_v1beta1_NodeMetrics(ref),
		metricsv1beta1.NodeMetricsList{}.OpenAPIModelName():                                                             schema_pkg_apis_metrics_v1beta1_NodeMetricsList(ref),
		metricsv1beta1.PodMetrics{}.OpenAPIModelName():                                                                  schema_pkg_apis_metrics_v1beta1_PodMetrics(ref),
		metricsv1beta1.PodMetricsList{}.OpenAPIModelName():                                                              schema_pkg_apis_metrics_v1beta1_PodMetricsList(ref),
	}
}

func schema_k8sio_api_admissionregistration_v1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchCondition represents a condition which must by fulfilled for a request to be sent to a webhook.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			v1.NamedRuleWithOperations{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref(v1.WebhookClientConfig{}.OpenAPIModelName()),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.RuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.\n\nPossible enum values:\n - `\"None\"` means that calling the webhook will have no side effects.\n - `\"NoneOnDryRun\"` means that calling the webhook will possibly have side effects, but if the request being reviewed has the dry-run attribute, the side effects will be suppressed.\n - `\"Some\"` means that calling the webhook will possibly have side effects. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.\n - `\"Unknown\"` means that no information is known about the side effects of calling the webhook. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"None", "NoneOnDryRun", "Some", "Unknown"},
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: the webhook will not be called more than once in a single admission evaluation.\n\nIfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.\n\nDefaults to \"Never\".\n\nPossible enum values:\n - `\"IfNeeded\"` indicates that the mutation may be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial mutation call.\n - `\"Never\"` indicates that the mutation must not be called more than once in a single admission evaluation.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"IfNeeded", "Never"},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig", "sideEffects", "admissionReviewVersions"},
			},
		},
		Dependencies: []string{
			v1.MatchCondition{}.OpenAPIModelName(), v1.RuleWithOperations{}.OpenAPIModelName(), v1.WebhookClientConfig{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.MutatingWebhook{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.MutatingWebhook{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_MutatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of MutatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.MutatingWebhookConfiguration{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1.MutatingWebhookConfiguration{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".\n\n\nPossible enum values:\n - `\"*\"` means that all scopes are included.\n - `\"Cluster\"` means that scope is limited to cluster-scoped objects. Namespace objects are cluster-scoped.\n - `\"Namespaced\"` means that scope is limited to namespaced objects.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"*", "Cluster", "Namespaced"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource being referenced.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.\n\nA single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny`\n\nRequired",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_Rule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Rule is a tuple of APIGroups, APIVersion, and Resources.It is recommended to make sure that all the tuple expansions are valid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".\n\n\nPossible enum values:\n - `\"*\"` means that all scopes are included.\n - `\"Cluster\"` means that scope is limited to cluster-scoped objects. Namespace objects are cluster-scoped.\n - `\"Namespaced\"` means that scope is limited to namespaced objects.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"*", "Cluster", "Namespaced"},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_RuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RuleWithOperations is a tuple of Operations and Resources. It is recommended to make sure that all the tuple expansions are valid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".\n\n\nPossible enum values:\n - `\"*\"` means that all scopes are included.\n - `\"Cluster\"` means that scope is limited to cluster-scoped objects. Namespace objects are cluster-scoped.\n - `\"Namespaced\"` means that scope is limited to namespaced objects.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"*", "Cluster", "Namespaced"},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_ServiceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "`namespace` is the namespace of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "`path` is an optional URL path which will be sent in any request to this service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"namespace", "name"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.ExpressionWarning{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.ExpressionWarning{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName(), v1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref(v1.ParamRef{}.OpenAPIModelName()),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref(v1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\\\"message\\\": \\\"Invalid value\\\", {\\\"policy\\\": \\\"policy.example.com\\\", {\\\"binding\\\": \\\"policybinding.example.com\\\", {\\\"expressionIndex\\\": \\\"1\\\", {\\\"validationActions\\\": [\\\"Audit\\\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.MatchResources{}.OpenAPIModelName(), v1.ParamRef{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.ValidatingAdmissionPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1.ValidatingAdmissionPolicy{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref(v1.ParamKind{}.OpenAPIModelName()),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref(v1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.Validation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.AuditAnnotation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.Variable{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.AuditAnnotation{}.OpenAPIModelName(), v1.MatchCondition{}.OpenAPIModelName(), v1.MatchResources{}.OpenAPIModelName(), v1.ParamKind{}.OpenAPIModelName(), v1.Validation{}.OpenAPIModelName(), v1.Variable{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref(v1.TypeChecking{}.OpenAPIModelName()),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.Condition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.TypeChecking{}.OpenAPIModelName(), metav1.Condition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref(v1.WebhookClientConfig{}.OpenAPIModelName()),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.RuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the webhook causes the admission to fail.\n - `\"Ignore\"` means that an error calling the webhook is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the webhook if they modify a resource listed in rules via another API group or version.\n - `\"Exact\"` means requests should only be sent to the webhook if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: None, NoneOnDryRun (webhooks created via v1beta1 may also specify Some or Unknown). Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some.\n\nPossible enum values:\n - `\"None\"` means that calling the webhook will have no side effects.\n - `\"NoneOnDryRun\"` means that calling the webhook will possibly have side effects, but if the request being reviewed has the dry-run attribute, the side effects will be suppressed.\n - `\"Some\"` means that calling the webhook will possibly have side effects. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.\n - `\"Unknown\"` means that no information is known about the side effects of calling the webhook. If a request with the dry-run attribute would trigger a call to this webhook, the request will instead fail.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"None", "NoneOnDryRun", "Some", "Unknown"},
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 10 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig", "sideEffects", "admissionReviewVersions"},
			},
		},
		Dependencies: []string{
			v1.MatchCondition{}.OpenAPIModelName(), v1.RuleWithOperations{}.OpenAPIModelName(), v1.WebhookClientConfig{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.ValidatingWebhook{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.ValidatingWebhook{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_ValidatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.ValidatingWebhookConfiguration{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1.ValidatingWebhookConfiguration{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1_WebhookClientConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WebhookClientConfig contains the information to make a TLS connection with the webhook",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "`url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.\n\nThe `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.\n\nPlease note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.\n\nThe scheme must be \"https\"; the URL must begin with \"https://\".\n\nA path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.\n\nAttempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "`service` is a reference to the service for this webhook. Either `service` or `url` must be specified.\n\nIf the webhook is running within the cluster, then you should use `service`.",
							Ref:         ref(v1.ServiceReference{}.OpenAPIModelName()),
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1.ServiceReference{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ApplyConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ApplyConfiguration defines the desired configuration values of an object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec\n\nApply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:\n\n\tObject{\n\t  spec: Object.spec{\n\t    serviceAccountName: \"example\"\n\t  }\n\t}\n\nApply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.\n\nCEL expressions have access to the object types needed to create apply configurations:\n\n- 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')\n\nCEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_JSONPatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JSONPatch defines a JSON Patch.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec\n\nexpression must return an array of JSONPatch values.\n\nFor example, this CEL expression returns a JSON patch to conditionally modify a value:\n\n\t  [\n\t    JSONPatch{op: \"test\", path: \"/spec/example\", value: \"Red\"},\n\t    JSONPatch{op: \"replace\", path: \"/spec/example\", value: \"Green\"}\n\t  ]\n\nTo define an object for the patch value, use Object types. For example:\n\n\t  [\n\t    JSONPatch{\n\t      op: \"add\",\n\t      path: \"/spec/selector\",\n\t      value: Object.spec.selector{matchLabels: {\"environment\": \"test\"}}\n\t    }\n\t  ]\n\nTo use strings containing '/' and '~' as JSONPatch path keys, use \"jsonpatch.escapeKey\". For example:\n\n\t  [\n\t    JSONPatch{\n\t      op: \"add\",\n\t      path: \"/metadata/labels/\" + jsonpatch.escapeKey(\"example.com/environment\"),\n\t      value: \"test\"\n\t    },\n\t  ]\n\nCEL expressions have access to the types needed to create JSON patches and objects:\n\n- 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.\n  See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,\n  integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a\n  [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL\n  function may be used to escape path keys containing '/' and '~'.\n- 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')\n\nCEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nCEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:\n\n- 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the policy based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the policy's expression (CEL), and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the admission policy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the policy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, the admission policy does not consider requests to apps/v1beta1 or extensions/v1beta1 API groups.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, the admission policy **does** consider requests made to apps/v1beta1 or extensions/v1beta1 API groups. The API server translates the request to a matched resource API if necessary.\n\nDefaults to \"Equivalent\"\n\nPossible enum values:\n - `\"Equivalent\"` means requests should be sent to the admission webhook or admission policy if they modify a resource listed in rules via an equivalent API group or version. For example, `autoscaling/v1` and `autoscaling/v2` HorizontalPodAutoscalers are equivalent: the same set of resources appear via both APIs.\n - `\"Exact\"` means requests should only be sent to the admission webhook or admission policy if they exactly match a given rule.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Equivalent", "Exact"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			v1alpha1.NamedRuleWithOperations{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicy describes the definition of an admission mutation policy that mutates the object coming into admission chain.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the MutatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1alpha1.MutatingAdmissionPolicySpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.MutatingAdmissionPolicySpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBinding binds the MutatingAdmissionPolicy with parametrized resources. MutatingAdmissionPolicyBinding and the optional parameter resource together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding. Each evaluation is constrained by a [runtime cost budget](https://kubernetes.io/docs/reference/using-api/cel/#runtime-cost-budget).\n\nAdding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the MutatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1alpha1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBindingList is a list of MutatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1alpha1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref(v1alpha1.ParamRef{}.OpenAPIModelName()),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.",
							Ref:         ref(v1alpha1.MatchResources{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.MatchResources{}.OpenAPIModelName(), v1alpha1.ParamRef{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyList is a list of MutatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.MutatingAdmissionPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1alpha1.MutatingAdmissionPolicy{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_MutatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref(v1alpha1.ParamKind{}.OpenAPIModelName()),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.",
							Ref:         ref(v1alpha1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.Variable{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"mutations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.Mutation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nAllowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the admission webhook or admission policy causes resource admission to fail.\n - `\"Ignore\"` means that an error calling the admission webhook or admission policy is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: These mutations will not be called more than once per binding in a single admission evaluation.\n\nIfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.\n\nPossible enum values:\n - `\"IfNeeded\"` indicates that the mutation may be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial mutation call.\n - `\"Never\"` indicates that the mutation must not be called more than once in a single admission evaluation.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"IfNeeded", "Never"},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.MatchCondition{}.OpenAPIModelName(), v1alpha1.MatchResources{}.OpenAPIModelName(), v1alpha1.Mutation{}.OpenAPIModelName(), v1alpha1.ParamKind{}.OpenAPIModelName(), v1alpha1.Variable{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_Mutation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Mutation specifies the CEL expression which is used to apply the Mutation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"patchType": {
						SchemaProps: spec.SchemaProps{
							Description: "patchType indicates the patch strategy used. Allowed values are \"ApplyConfiguration\" and \"JSONPatch\". Required.\n\n\nPossible enum values:\n - `\"ApplyConfiguration\"` ApplyConfiguration indicates that the mutation is using apply configuration to mutate the object.\n - `\"JSONPatch\"` JSONPatch indicates that the object is mutated through JSON Patch.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ApplyConfiguration", "JSONPatch"},
						},
					},
					"applyConfiguration": {
						SchemaProps: spec.SchemaProps{
							Description: "applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.",
							Ref:         ref(v1alpha1.ApplyConfiguration{}.OpenAPIModelName()),
						},
					},
					"jsonPatch": {
						SchemaProps: spec.SchemaProps{
							Description: "jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.",
							Ref:         ref(v1alpha1.JSONPatch{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"patchType"},
			},
		},
		Dependencies: []string{
			v1alpha1.ApplyConfiguration{}.OpenAPIModelName(), v1alpha1.JSONPatch{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".\n\n\nPossible enum values:\n - `\"*\"` means that all scopes are included.\n - `\"Cluster\"` means that scope is limited to cluster-scoped objects. Namespace objects are cluster-scoped.\n - `\"Namespaced\"` means that scope is limited to namespaced objects.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"*", "Cluster", "Namespaced"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the resource being referenced.\n\n`name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny` Default to `Deny`\n\nPossible enum values:\n - `\"Allow\"` Ignore means that an error finding params for a binding is ignored\n - `\"Deny\"` Fail means that an error finding params for a binding is ignored",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Allow", "Deny"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.ExpressionWarning{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.ExpressionWarning{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1alpha1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1alpha1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName(), v1alpha1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1alpha1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1alpha1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref(v1alpha1.ParamRef{}.OpenAPIModelName()),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref(v1alpha1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\\\"message\\\": \\\"Invalid value\\\", {\\\"policy\\\": \\\"policy.example.com\\\", {\\\"binding\\\": \\\"policybinding.example.com\\\", {\\\"expressionIndex\\\": \\\"1\\\", {\\\"validationActions\\\": [\\\"Audit\\\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.MatchResources{}.OpenAPIModelName(), v1alpha1.ParamRef{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.ValidatingAdmissionPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1alpha1.ValidatingAdmissionPolicy{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref(v1alpha1.ParamKind{}.OpenAPIModelName()),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref(v1alpha1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.Validation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.\n\nPossible enum values:\n - `\"Fail\"` means that an error calling the admission webhook or admission policy causes resource admission to fail.\n - `\"Ignore\"` means that an error calling the admission webhook or admission policy is ignored.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Fail", "Ignore"},
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.AuditAnnotation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1alpha1.Variable{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.AuditAnnotation{}.OpenAPIModelName(), v1alpha1.MatchCondition{}.OpenAPIModelName(), v1alpha1.MatchResources{}.OpenAPIModelName(), v1alpha1.ParamKind{}.OpenAPIModelName(), v1alpha1.Validation{}.OpenAPIModelName(), v1alpha1.Variable{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of a ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref(v1alpha1.TypeChecking{}.OpenAPIModelName()),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.Condition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1alpha1.TypeChecking{}.OpenAPIModelName(), metav1.Condition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1alpha1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ApplyConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ApplyConfiguration defines the desired configuration values of an object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "expression will be evaluated by CEL to create an apply configuration. ref: https://github.com/google/cel-spec\n\nApply configurations are declared in CEL using object initialization. For example, this CEL expression returns an apply configuration to set a single field:\n\n\tObject{\n\t  spec: Object.spec{\n\t    serviceAccountName: \"example\"\n\t  }\n\t}\n\nApply configurations may not modify atomic structs, maps or arrays due to the risk of accidental deletion of values not included in the apply configuration.\n\nCEL expressions have access to the object types needed to create apply configurations:\n\n- 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')\n\nCEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_AuditAnnotation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "AuditAnnotation describes how to produce an audit annotation for an API request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"key": {
						SchemaProps: spec.SchemaProps{
							Description: "key specifies the audit annotation key. The audit annotation keys of a ValidatingAdmissionPolicy must be unique. The key must be a qualified name ([A-Za-z0-9][-A-Za-z0-9_.]*) no more than 63 bytes in length.\n\nThe key is combined with the resource name of the ValidatingAdmissionPolicy to construct an audit annotation key: \"{ValidatingAdmissionPolicy name}/{key}\".\n\nIf an admission webhook uses the same resource name as this ValidatingAdmissionPolicy and the same audit annotation key, the annotation key will be identical. In this case, the first annotation written with the key will be included in the audit event and all subsequent annotations with the same key will be discarded.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"valueExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "valueExpression represents the expression which is evaluated by CEL to produce an audit annotation value. The expression must evaluate to either a string or null value. If the expression evaluates to a string, the audit annotation is included with the string value. If the expression evaluates to null or empty string the audit annotation will be omitted. The valueExpression may be no longer than 5kb in length. If the result of the valueExpression is more than 10kb in length, it will be truncated to 10kb.\n\nIf multiple ValidatingAdmissionPolicyBinding resources match an API request, then the valueExpression will be evaluated for each binding. All unique values produced by the valueExpressions will be joined together in a comma-separated list.\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"key", "valueExpression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ExpressionWarning(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExpressionWarning is a warning information that targets a specific expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"fieldRef": {
						SchemaProps: spec.SchemaProps{
							Description: "The path to the field that refers the expression. For example, the reference to the expression of the first item of validations is \"spec.validations[0].expression\"",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"warning": {
						SchemaProps: spec.SchemaProps{
							Description: "The content of type checking information in a human-readable form. Each line of the warning contains the type that the expression is checked against, followed by the type check error from the compiler.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"fieldRef", "warning"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_JSONPatch(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "JSONPatch defines a JSON Patch.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "expression will be evaluated by CEL to create a [JSON patch](https://jsonpatch.com/). ref: https://github.com/google/cel-spec\n\nexpression must return an array of JSONPatch values.\n\nFor example, this CEL expression returns a JSON patch to conditionally modify a value:\n\n\t  [\n\t    JSONPatch{op: \"test\", path: \"/spec/example\", value: \"Red\"},\n\t    JSONPatch{op: \"replace\", path: \"/spec/example\", value: \"Green\"}\n\t  ]\n\nTo define an object for the patch value, use Object types. For example:\n\n\t  [\n\t    JSONPatch{\n\t      op: \"add\",\n\t      path: \"/spec/selector\",\n\t      value: Object.spec.selector{matchLabels: {\"environment\": \"test\"}}\n\t    }\n\t  ]\n\nTo use strings containing '/' and '~' as JSONPatch path keys, use \"jsonpatch.escapeKey\". For example:\n\n\t  [\n\t    JSONPatch{\n\t      op: \"add\",\n\t      path: \"/metadata/labels/\" + jsonpatch.escapeKey(\"example.com/environment\"),\n\t      value: \"test\"\n\t    },\n\t  ]\n\nCEL expressions have access to the types needed to create JSON patches and objects:\n\n- 'JSONPatch' - CEL type of JSON Patch operations. JSONPatch has the fields 'op', 'from', 'path' and 'value'.\n  See [JSON patch](https://jsonpatch.com/) for more details. The 'value' field may be set to any of: string,\n  integer, array, map or object.  If set, the 'path' and 'from' fields must be set to a\n  [JSON pointer](https://datatracker.ietf.org/doc/html/rfc6901/) string, where the 'jsonpatch.escapeKey()' CEL\n  function may be used to escape path keys containing '/' and '~'.\n- 'Object' - CEL type of the resource object. - 'Object.<fieldName>' - CEL type of object field (such as 'Object.spec') - 'Object.<fieldName1>.<fieldName2>...<fieldNameN>` - CEL type of nested field (such as 'Object.spec.containers')\n\nCEL expressions have access to the contents of the API request, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nCEL expressions have access to [Kubernetes CEL function libraries](https://kubernetes.io/docs/reference/using-api/cel/#cel-options-language-features-and-libraries) as well as:\n\n- 'jsonpatch.escapeKey' - Performs JSONPatch key escaping. '~' and  '/' are escaped as '~0' and `~1' respectively).\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MatchCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchCondition represents a condition which must be fulfilled for a request to be sent to a webhook.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is an identifier for this match condition, used for strategic merging of MatchConditions, as well as providing an identifier for logging purposes. A good name should be descriptive of the associated expression. Name must be a qualified name consisting of alphanumeric characters, '-', '_' or '.', and must start and end with an alphanumeric character (e.g. 'MyName',  or 'my.name',  or '123-abc', regex used for validation is '([A-Za-z0-9][-A-Za-z0-9_.]*)?[A-Za-z0-9]') with an optional DNS subdomain prefix and '/' (e.g. 'example.com/MyName')\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. Must evaluate to bool. CEL expressions have access to the contents of the AdmissionRequest and Authorizer, organized into CEL variables:\n\n'object' - The object from the incoming request. The value is null for DELETE requests. 'oldObject' - The existing object. The value is null for CREATE requests. 'request' - Attributes of the admission request(/pkg/apis/admission/types.go#AdmissionRequest). 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\nDocumentation on CEL: https://kubernetes.io/docs/reference/using-api/cel/\n\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MatchResources(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MatchResources decides whether to run the admission control policy on an object based on whether it meets the match criteria. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the admission control policy on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the policy.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the policy on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the validation based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the cel validation, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy matches. The policy cares about an operation if it matches _any_ Rule.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"excludeResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ExcludeResourceRules describes what operations on what resources/subresources the ValidatingAdmissionPolicy should not care about. The exclude rules take precedence over include rules (if a resource matches both, it is excluded)",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.NamedRuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"MatchResources\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the ValidatingAdmissionPolicy.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the ValidatingAdmissionPolicy.\n\nDefaults to \"Equivalent\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			v1beta1.NamedRuleWithOperations{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicy describes the definition of an admission mutation policy that mutates the object coming into admission chain.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the MutatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.MutatingAdmissionPolicySpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingAdmissionPolicySpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBinding binds the MutatingAdmissionPolicy with parametrized resources. MutatingAdmissionPolicyBinding and the optional parameter resource together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding. Each evaluation is constrained by a [runtime cost budget](https://kubernetes.io/docs/reference/using-api/cel/#runtime-cost-budget).\n\nAdding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the MutatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingAdmissionPolicyBindingSpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBindingList is a list of MutatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingAdmissionPolicyBinding{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyBindingSpec is the specification of the MutatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "policyName references a MutatingAdmissionPolicy name which the MutatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in spec.ParamKind of the bound MutatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the MutatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref(v1beta1.ParamRef{}.OpenAPIModelName()),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "matchResources limits what resources match this binding and may be mutated by it. Note that if matchResources matches a resource, the resource must also match a policy's matchConstraints and matchConditions before the resource may be mutated. When matchResources is unset, it does not constrain resource matching, and only the policy's matchConstraints and matchConditions must match for the resource to be mutated. Additionally, matchResources.resourceRules are optional and do not constraint matching when unset. Note that this is differs from MutatingAdmissionPolicy matchConstraints, where resourceRules are required. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT.",
							Ref:         ref(v1beta1.MatchResources{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MatchResources{}.OpenAPIModelName(), v1beta1.ParamRef{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicyList is a list of MutatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MutatingAdmissionPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingAdmissionPolicy{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingAdmissionPolicySpec is the specification of the desired behavior of the admission policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "paramKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If paramKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in MutatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref(v1beta1.ParamKind{}.OpenAPIModelName()),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "matchConstraints specifies what resources this policy is designed to validate. The MutatingAdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API MutatingAdmissionPolicy cannot match MutatingAdmissionPolicy and MutatingAdmissionPolicyBinding. The CREATE, UPDATE and CONNECT operations are allowed.  The DELETE operation may not be matched. '*' matches CREATE, UPDATE and CONNECT. Required.",
							Ref:         ref(v1beta1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except matchConditions because matchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.Variable{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"mutations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "mutations contain operations to perform on matching objects. mutations may not be empty; a minimum of one mutation is required. mutations are evaluated in order, and are reinvoked according to the reinvocationPolicy. The mutations of a policy are invoked for each binding of this policy and reinvocation of mutations occurs on a per binding basis.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.Mutation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if paramKind refers to a non-existent Kind. A binding is invalid if paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nAllowed values are Ignore or Fail. Defaults to Fail.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "matchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the matchConstraints. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether mutations may be called multiple times per MutatingAdmissionPolicyBinding as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: These mutations will not be called more than once per binding in a single admission evaluation.\n\nIfNeeded: These mutations may be invoked more than once per binding for a single admission request and there is no guarantee of order with respect to other admission plugins, admission webhooks, bindings of this policy and admission policies.  Mutations are only reinvoked when mutations change the object after this mutation is invoked. Required.\n\nPossible enum values:\n - `\"IfNeeded\"` indicates that the mutation may be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial mutation call.\n - `\"Never\"` indicates that the mutation must not be called more than once in a single admission evaluation.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"IfNeeded", "Never"},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MatchCondition{}.OpenAPIModelName(), v1beta1.MatchResources{}.OpenAPIModelName(), v1beta1.Mutation{}.OpenAPIModelName(), v1beta1.ParamKind{}.OpenAPIModelName(), v1beta1.Variable{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.WebhookClientConfig{}.OpenAPIModelName()),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.RuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Exact\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"sideEffects": {
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"reinvocationPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "reinvocationPolicy indicates whether this webhook should be called multiple times as part of a single admission evaluation. Allowed values are \"Never\" and \"IfNeeded\".\n\nNever: the webhook will not be called more than once in a single admission evaluation.\n\nIfNeeded: the webhook will be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial webhook call. Webhooks that specify this option *must* be idempotent, able to process objects they previously admitted. Note: * the number of additional invocations is not guaranteed to be exactly one. * if additional invocations result in further modifications to the object, webhooks are not guaranteed to be invoked again. * webhooks that use this option may be reordered to minimize the number of additional invocations. * to validate an object after all mutations are guaranteed complete, use a validating admission webhook instead.\n\nDefaults to \"Never\".\n\nPossible enum values:\n - `\"IfNeeded\"` indicates that the mutation may be called at least one additional time as part of the admission evaluation if the object being admitted is modified by other admission plugins after the initial mutation call.\n - `\"Never\"` indicates that the mutation must not be called more than once in a single admission evaluation.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"IfNeeded", "Never"},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig"},
			},
		},
		Dependencies: []string{
			v1.RuleWithOperations{}.OpenAPIModelName(), v1beta1.MatchCondition{}.OpenAPIModelName(), v1beta1.WebhookClientConfig{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 MutatingWebhookConfiguration instead.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MutatingWebhook{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingWebhook{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_MutatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MutatingWebhookConfigurationList is a list of MutatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of MutatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MutatingWebhookConfiguration{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.MutatingWebhookConfiguration{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_Mutation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Mutation specifies the CEL expression which is used to apply the Mutation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"patchType": {
						SchemaProps: spec.SchemaProps{
							Description: "patchType indicates the patch strategy used. Allowed values are \"ApplyConfiguration\" and \"JSONPatch\". Required.\n\n\nPossible enum values:\n - `\"ApplyConfiguration\"` ApplyConfiguration indicates that the mutation is using apply configuration to mutate the object.\n - `\"JSONPatch\"` JSONPatch indicates that the object is mutated through JSON Patch.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ApplyConfiguration", "JSONPatch"},
						},
					},
					"applyConfiguration": {
						SchemaProps: spec.SchemaProps{
							Description: "applyConfiguration defines the desired configuration values of an object. The configuration is applied to the admission object using [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff). A CEL expression is used to create apply configuration.",
							Ref:         ref(v1beta1.ApplyConfiguration{}.OpenAPIModelName()),
						},
					},
					"jsonPatch": {
						SchemaProps: spec.SchemaProps{
							Description: "jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object. A CEL expression is used to create the JSON patch.",
							Ref:         ref(v1beta1.JSONPatch{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"patchType"},
			},
		},
		Dependencies: []string{
			v1beta1.ApplyConfiguration{}.OpenAPIModelName(), v1beta1.JSONPatch{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_NamedRuleWithOperations(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NamedRuleWithOperations is a tuple of Operations and Resources with ResourceNames.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"operations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Operations is the operations the admission hook cares about - CREATE, UPDATE, DELETE, CONNECT or * for all of those operations and any future admission operations that are added. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"*", "CONNECT", "CREATE", "DELETE", "UPDATE"},
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the API groups the resources belong to. '*' is all groups. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIVersions is the API versions the resources belong to. '*' is all versions. If '*' is present, the length of the slice must be one. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.\n\nFor example: 'pods' means pods. 'pods/log' means the log subresource of pods. '*' means all resources, but not subresources. 'pods/*' means all subresources of pods. '*/scale' means all scale subresources. '*/*' means all resources and their subresources.\n\nIf wildcard is present, the validation rule will ensure resources do not overlap with each other.\n\nDepending on the enclosing object, subresources might not be allowed. Required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope specifies the scope of this rule. Valid values are \"Cluster\", \"Namespaced\", and \"*\" \"Cluster\" means that only cluster-scoped resources will match this rule. Namespace API objects are cluster-scoped. \"Namespaced\" means that only namespaced resources will match this rule. \"*\" means that there are no scope restrictions. Subresources match the scope of their parent resource. Default is \"*\".\n\n\nPossible enum values:\n - `\"*\"` means that all scopes are included.\n - `\"Cluster\"` means that scope is limited to cluster-scoped objects. Namespace objects are cluster-scoped.\n - `\"Namespaced\"` means that scope is limited to namespaced objects.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"*", "Cluster", "Namespaced"},
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ParamKind(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamKind is a tuple of Group Kind and Version.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion is the API group version the resources belong to. In format of \"group/version\". Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is the API kind the resources belong to. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ParamRef(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ParamRef describes how to locate the params to be used as input to expressions of rules applied by a policy binding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource being referenced.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.\n\nA single parameter used for all admission requests can be configured by setting the `name` field, leaving `selector` blank, and setting namespace if `paramKind` is namespace-scoped.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "namespace is the namespace of the referenced resource. Allows limiting the search for params to a specific namespace. Applies to both `name` and `selector` fields.\n\nA per-namespace parameter may be used by specifying a namespace-scoped `paramKind` in the policy and leaving this field empty.\n\n- If `paramKind` is cluster-scoped, this field MUST be unset. Setting this field results in a configuration error.\n\n- If `paramKind` is namespace-scoped, the namespace of the object being evaluated for admission will be used when this field is left unset. Take care that if this is left empty the binding must not match any cluster-scoped resources, which will result in an error.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector can be used to match multiple param objects based on their labels. Supply selector: {} to match all resources of the ParamKind.\n\nIf multiple params are found, they are all evaluated with the policy expressions and the results are ANDed together.\n\nOne of `name` or `selector` must be set, but `name` and `selector` are mutually exclusive properties. If one is set, the other must be unset.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"parameterNotFoundAction": {
						SchemaProps: spec.SchemaProps{
							Description: "`parameterNotFoundAction` controls the behavior of the binding when the resource exists, and name or selector is valid, but there are no parameters matched by the binding. If the value is set to `Allow`, then no matched parameters will be treated as successful validation by the binding. If set to `Deny`, then no matched parameters will be subject to the `failurePolicy` of the policy.\n\nAllowed values are `Allow` or `Deny`\n\nRequired",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
		Dependencies: []string{
			metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ServiceReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ServiceReference holds a reference to Service.legacy.k8s.io",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "`namespace` is the namespace of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "`name` is the name of the service. Required",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "`path` is an optional URL path which will be sent in any request to this service.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"port": {
						SchemaProps: spec.SchemaProps{
							Description: "If specified, the port on the service that hosting webhook. Default to 443 for backward compatibility. `port` should be a valid port number (1-65535, inclusive).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"namespace", "name"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_TypeChecking(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeChecking contains results of type checking the expressions in the ValidatingAdmissionPolicy",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expressionWarnings": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The type checking warnings for each expression.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.ExpressionWarning{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.ExpressionWarning{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicy describes the definition of an admission validation policy that accepts or rejects an object without changing it.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicy.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The status of the ValidatingAdmissionPolicy, including warnings that are useful to determine if the policy behaves in the expected way. Populated by the system. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingAdmissionPolicySpec{}.OpenAPIModelName(), v1beta1.ValidatingAdmissionPolicyStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBinding(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBinding binds the ValidatingAdmissionPolicy with paramerized resources. ValidatingAdmissionPolicyBinding and parameter CRDs together define how cluster administrators configure policies for clusters.\n\nFor a given admission request, each binding will cause its policy to be evaluated N times, where N is 1 for policies/bindings that don't use params, otherwise N is the number of parameters selected by the binding.\n\nThe CEL expressions of a policy must have a computed CEL cost below the maximum CEL budget. Each evaluation of the policy is given an independent CEL cost budget. Adding/removing policies, bindings, or params can not affect whether a given (policy, binding, param) combination is within its own CEL budget.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the ValidatingAdmissionPolicyBinding.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingAdmissionPolicyBindingSpec{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingList is a list of ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of PolicyBinding.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingAdmissionPolicyBinding{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyBindingSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyBindingSpec is the specification of the ValidatingAdmissionPolicyBinding.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"policyName": {
						SchemaProps: spec.SchemaProps{
							Description: "PolicyName references a ValidatingAdmissionPolicy name which the ValidatingAdmissionPolicyBinding binds to. If the referenced resource does not exist, this binding is considered invalid and will be ignored Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"paramRef": {
						SchemaProps: spec.SchemaProps{
							Description: "paramRef specifies the parameter resource used to configure the admission control policy. It should point to a resource of the type specified in ParamKind of the bound ValidatingAdmissionPolicy. If the policy specifies a ParamKind and the resource referred to by ParamRef does not exist, this binding is considered mis-configured and the FailurePolicy of the ValidatingAdmissionPolicy applied. If the policy does not specify a ParamKind then this field is ignored, and the rules are evaluated without a param.",
							Ref:         ref(v1beta1.ParamRef{}.OpenAPIModelName()),
						},
					},
					"matchResources": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchResources declares what resources match this binding and will be validated by it. Note that this is intersected with the policy's matchConstraints, so only requests that are matched by the policy can be selected by this. If this is unset, all resources matched by the policy are validated by this binding When resourceRules is unset, it does not constrain resource matching. If a resource is matched by the other fields of this object, it will be validated. Note that this is differs from ValidatingAdmissionPolicy matchConstraints, where resourceRules are required.",
							Ref:         ref(v1beta1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validationActions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "validationActions declares how Validations of the referenced ValidatingAdmissionPolicy are enforced. If a validation evaluates to false it is always enforced according to these actions.\n\nFailures defined by the ValidatingAdmissionPolicy's FailurePolicy are enforced according to these actions only if the FailurePolicy is set to Fail, otherwise the failures are ignored. This includes compilation errors, runtime errors and misconfigurations of the policy.\n\nvalidationActions is declared as a set of action values. Order does not matter. validationActions may not contain duplicates of the same action.\n\nThe supported actions values are:\n\n\"Deny\" specifies that a validation failure results in a denied request.\n\n\"Warn\" specifies that a validation failure is reported to the request client in HTTP Warning headers, with a warning code of 299. Warnings can be sent both for allowed or denied admission responses.\n\n\"Audit\" specifies that a validation failure is included in the published audit event for the request. The audit event will contain a `validation.policy.admission.k8s.io/validation_failure` audit annotation with a value containing the details of the validation failures, formatted as a JSON list of objects, each with the following fields: - message: The validation failure message string - policy: The resource name of the ValidatingAdmissionPolicy - binding: The resource name of the ValidatingAdmissionPolicyBinding - expressionIndex: The index of the failed validations in the ValidatingAdmissionPolicy - validationActions: The enforcement actions enacted for the validation failure Example audit annotation: `\"validation.policy.admission.k8s.io/validation_failure\": \"[{\\\"message\\\": \\\"Invalid value\\\", {\\\"policy\\\": \\\"policy.example.com\\\", {\\\"binding\\\": \\\"policybinding.example.com\\\", {\\\"expressionIndex\\\": \\\"1\\\", {\\\"validationActions\\\": [\\\"Audit\\\"]}]\"`\n\nClients should expect to handle additional values by ignoring any values not recognized.\n\n\"Deny\" and \"Warn\" may not be used together since this combination needlessly duplicates the validation failure both in the API response body and the HTTP warning headers.\n\nRequired.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
										Enum:    []interface{}{"Audit", "Deny", "Warn"},
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.MatchResources{}.OpenAPIModelName(), v1beta1.ParamRef{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyList is a list of ValidatingAdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingAdmissionPolicy.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.ValidatingAdmissionPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingAdmissionPolicy{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicySpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"paramKind": {
						SchemaProps: spec.SchemaProps{
							Description: "ParamKind specifies the kind of resources used to parameterize this policy. If absent, there are no parameters for this policy and the param CEL variable will not be provided to validation expressions. If ParamKind refers to a non-existent kind, this policy definition is mis-configured and the FailurePolicy is applied. If paramKind is specified but paramRef is unset in ValidatingAdmissionPolicyBinding, the params variable will be null.",
							Ref:         ref(v1beta1.ParamKind{}.OpenAPIModelName()),
						},
					},
					"matchConstraints": {
						SchemaProps: spec.SchemaProps{
							Description: "MatchConstraints specifies what resources this policy is designed to validate. The AdmissionPolicy cares about a request if it matches _all_ Constraints. However, in order to prevent clusters from being put into an unstable state that cannot be recovered from via the API ValidatingAdmissionPolicy cannot match ValidatingAdmissionPolicy and ValidatingAdmissionPolicyBinding. Required.",
							Ref:         ref(v1beta1.MatchResources{}.OpenAPIModelName()),
						},
					},
					"validations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.Validation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.\n\nA policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.\n\nfailurePolicy does not define how validations that evaluate to false are handled.\n\nWhen failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.\n\nAllowed values are Ignore or Fail. Defaults to Fail.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"auditAnnotations": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.AuditAnnotation{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nIf a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the policy is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the policy is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"variables": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.\n\nThe expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.Variable{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.AuditAnnotation{}.OpenAPIModelName(), v1beta1.MatchCondition{}.OpenAPIModelName(), v1beta1.MatchResources{}.OpenAPIModelName(), v1beta1.ParamKind{}.OpenAPIModelName(), v1beta1.Validation{}.OpenAPIModelName(), v1beta1.Variable{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingAdmissionPolicyStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingAdmissionPolicyStatus represents the status of an admission validation policy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"typeChecking": {
						SchemaProps: spec.SchemaProps{
							Description: "The results of type checking for each expression. Presence of this field indicates the completion of the type checking.",
							Ref:         ref(v1beta1.TypeChecking{}.OpenAPIModelName()),
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The conditions represent the latest available observations of a policy's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.Condition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.TypeChecking{}.OpenAPIModelName(), metav1.Condition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhook(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhook describes an admission webhook and the resources and operations it applies to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "The name of the admission webhook. Name should be fully qualified, e.g., imagepolicy.kubernetes.io, where \"imagepolicy\" is the name of the webhook, and kubernetes.io is the name of the organization. Required.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"clientConfig": {
						SchemaProps: spec.SchemaProps{
							Description: "ClientConfig defines how to communicate with the hook. Required",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta1.WebhookClientConfig{}.OpenAPIModelName()),
						},
					},
					"rules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Rules describes what operations on what resources/subresources the webhook cares about. The webhook cares about an operation if it matches _any_ Rule. However, in order to prevent ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks from putting the cluster in a state which cannot be recovered from without completely disabling the plugin, ValidatingAdmissionWebhooks and MutatingAdmissionWebhooks are never called on admission requests for ValidatingWebhookConfiguration and MutatingWebhookConfiguration objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1.RuleWithOperations{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"failurePolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "FailurePolicy defines how unrecognized errors from the admission endpoint are handled - allowed values are Ignore or Fail. Defaults to Ignore.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"matchPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "matchPolicy defines how the \"rules\" list is used to match incoming requests. Allowed values are \"Exact\" or \"Equivalent\".\n\n- Exact: match a request only if it exactly matches a specified rule. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, but \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would not be sent to the webhook.\n\n- Equivalent: match a request if modifies a resource listed in rules, even via another API group or version. For example, if deployments can be modified via apps/v1, apps/v1beta1, and extensions/v1beta1, and \"rules\" only included `apiGroups:[\"apps\"], apiVersions:[\"v1\"], resources: [\"deployments\"]`, a request to apps/v1beta1 or extensions/v1beta1 would be converted to apps/v1 and sent to the webhook.\n\nDefaults to \"Exact\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"namespaceSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "NamespaceSelector decides whether to run the webhook on an object based on whether the namespace for that object matches the selector. If the object itself is a namespace, the matching is performed on object.metadata.labels. If the object is another cluster scoped resource, it never skips the webhook.\n\nFor example, to run the webhook on any objects whose namespace is not associated with \"runlevel\" of \"0\" or \"1\";  you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"runlevel\",\n      \"operator\": \"NotIn\",\n      \"values\": [\n        \"0\",\n        \"1\"\n      ]\n    }\n  ]\n}\n\nIf instead you want to only run the webhook on any objects whose namespace is associated with the \"environment\" of \"prod\" or \"staging\"; you will set the selector as follows: \"namespaceSelector\": {\n  \"matchExpressions\": [\n    {\n      \"key\": \"environment\",\n      \"operator\": \"In\",\n      \"values\": [\n        \"prod\",\n        \"staging\"\n      ]\n    }\n  ]\n}\n\nSee https://kubernetes.io/docs/concepts/overview/working-with-objects/labels for more examples of label selectors.\n\nDefault to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"objectSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "ObjectSelector decides whether to run the webhook based on if the object has matching labels. objectSelector is evaluated against both the oldObject and newObject that would be sent to the webhook, and is considered to match if either object matches the selector. A null object (oldObject in the case of create, or newObject in the case of delete) or an object that cannot have labels (like a DeploymentRollback or a PodProxyOptions object) is not considered to match. Use the object selector only if the webhook is opt-in, because end users may skip the admission webhook by setting the labels. Default to the empty LabelSelector, which matches everything.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"sideEffects": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "SideEffects states whether this webhook has side effects. Acceptable values are: Unknown, None, Some, NoneOnDryRun Webhooks with side effects MUST implement a reconciliation system, since a request may be rejected by a future step in the admission chain and the side effects therefore need to be undone. Requests with the dryRun attribute will be auto-rejected if they match a webhook with sideEffects == Unknown or Some. Defaults to Unknown.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"timeoutSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "TimeoutSeconds specifies the timeout for this webhook. After the timeout passes, the webhook call will be ignored or the API call will fail based on the failure policy. The timeout value must be between 1 and 30 seconds. Default to 30 seconds.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"admissionReviewVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "AdmissionReviewVersions is an ordered list of preferred `AdmissionReview` versions the Webhook expects. API server will try to use first version in the list which it supports. If none of the versions specified in this list supported by API server, validation will fail for this object. If a persisted webhook configuration specifies allowed versions and does not include any versions known to the API Server, calls to the webhook will fail and be subject to the failure policy. Default to `['v1beta1']`.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"matchConditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "MatchConditions is a list of conditions that must be met for a request to be sent to this webhook. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.\n\nThe exact matching logic is (in order):\n  1. If ANY matchCondition evaluates to FALSE, the webhook is skipped.\n  2. If ALL matchConditions evaluate to TRUE, the webhook is called.\n  3. If any matchCondition evaluates to an error (but none are FALSE):\n     - If failurePolicy=Fail, reject the request\n     - If failurePolicy=Ignore, the error is ignored and the webhook is skipped",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.MatchCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "clientConfig"},
			},
		},
		Dependencies: []string{
			v1.RuleWithOperations{}.OpenAPIModelName(), v1beta1.MatchCondition{}.OpenAPIModelName(), v1beta1.WebhookClientConfig{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfiguration(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it. Deprecated in v1.16, planned for removal in v1.19. Use admissionregistration.k8s.io/v1 ValidatingWebhookConfiguration instead.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"webhooks": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"name",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "name",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Webhooks is a list of webhooks and the affected resources and operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.ValidatingWebhook{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingWebhook{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_ValidatingWebhookConfigurationList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ValidatingWebhookConfigurationList is a list of ValidatingWebhookConfiguration.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ValidatingWebhookConfiguration.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta1.ValidatingWebhookConfiguration{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta1.ValidatingWebhookConfiguration{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_Validation(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Validation specifies the CEL expression which is used to apply the validation.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression represents the expression which will be evaluated by CEL. ref: https://github.com/google/cel-spec CEL expressions have access to the contents of the API request/response, organized into CEL variables as well as some other useful variables:\n\n- 'object' - The object from the incoming request. The value is null for DELETE requests. - 'oldObject' - The existing object. The value is null for CREATE requests. - 'request' - Attributes of the API request([ref](/pkg/apis/admission/types.go#AdmissionRequest)). - 'params' - Parameter resource referred to by the policy binding being evaluated. Only populated if the policy has a ParamKind. - 'namespaceObject' - The namespace object that the incoming object belongs to. The value is null for cluster-scoped resources. - 'variables' - Map of composited variables, from its name to its lazily evaluated value.\n  For example, a variable named 'foo' can be accessed as 'variables.foo'.\n- 'authorizer' - A CEL Authorizer. May be used to perform authorization checks for the principal (user or service account) of the request.\n  See https://pkg.go.dev/k8s.io/apiserver/pkg/cel/library#Authz\n- 'authorizer.requestResource' - A CEL ResourceCheck constructed from the 'authorizer' and configured with the\n  request resource.\n\nThe `apiVersion`, `kind`, `metadata.name` and `metadata.generateName` are always accessible from the root of the object. No other metadata properties are accessible.\n\nOnly property names of the form `[a-zA-Z_.-/][a-zA-Z0-9_.-/]*` are accessible. Accessible property names are escaped according to the following rules when accessed in the expression: - '__' escapes to '__underscores__' - '.' escapes to '__dot__' - '-' escapes to '__dash__' - '/' escapes to '__slash__' - Property names that exactly match a CEL RESERVED keyword escape to '__{keyword}__'. The keywords are:\n\t  \"true\", \"false\", \"null\", \"in\", \"as\", \"break\", \"const\", \"continue\", \"else\", \"for\", \"function\", \"if\",\n\t  \"import\", \"let\", \"loop\", \"package\", \"namespace\", \"return\".\nExamples:\n  - Expression accessing a property named \"namespace\": {\"Expression\": \"object.__namespace__ > 0\"}\n  - Expression accessing a property named \"x-prop\": {\"Expression\": \"object.x__dash__prop > 0\"}\n  - Expression accessing a property named \"redact__d\": {\"Expression\": \"object.redact__underscores__d > 0\"}\n\nEquality on arrays with list type of 'set' or 'map' ignores element order, i.e. [1, 2] == [2, 1]. Concatenation on arrays with x-kubernetes-list-type use the semantics of the list type:\n  - 'set': `X + Y` performs a union where the array positions of all elements in `X` are preserved and\n    non-intersecting elements in `Y` are appended, retaining their partial order.\n  - 'map': `X + Y` performs a merge where the array positions of all keys in `X` are preserved but the values\n    are overwritten by values in `Y` when the key sets of `X` and `Y` intersect. Elements in `Y` with\n    non-intersecting keys are appended, retaining their partial order.\nRequired.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "Message represents the message displayed when validation fails. The message is required if the Expression contains line breaks. The message must not contain line breaks. If unset, the message is \"failed rule: {Rule}\". e.g. \"must be a URL with the host matching spec.host\" If the Expression contains line breaks. Message is required. The message must not contain line breaks. If unset, the message is \"failed Expression: {Expression}\".",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason represents a machine-readable description of why this validation failed. If this is the first validation in the list to fail, this reason, as well as the corresponding HTTP response code, are used in the HTTP response to the client. The currently supported reasons are: \"Unauthorized\", \"Forbidden\", \"Invalid\", \"RequestEntityTooLarge\". If not set, StatusReasonInvalid is used in the response to the client.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"messageExpression": {
						SchemaProps: spec.SchemaProps{
							Description: "messageExpression declares a CEL expression that evaluates to the validation failure message that is returned when this rule fails. Since messageExpression is used as a failure message, it must evaluate to a string. If both message and messageExpression are present on a validation, then messageExpression will be used if validation fails. If messageExpression results in a runtime error, the runtime error is logged, and the validation failure message is produced as if the messageExpression field were unset. If messageExpression evaluates to an empty string, a string with only spaces, or a string that contains line breaks, then the validation failure message will also be produced as if the messageExpression field were unset, and the fact that messageExpression produced an empty string/string with only spaces/string with line breaks will be logged. messageExpression has access to all the same variables as the `expression` except for 'authorizer' and 'authorizer.requestResource'. Example: \"object.x must be less than max (\"+string(params.max)+\")\"",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"expression"},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_Variable(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Variable is the definition of a variable that is used for composition. A variable is defined as a named expression.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the variable. The name must be a valid CEL identifier and unique among all variables. The variable can be accessed in other expressions through `variables` For example, if name is \"foo\", the variable will be available as `variables.foo`",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expression": {
						SchemaProps: spec.SchemaProps{
							Description: "Expression is the expression that will be evaluated as the value of the variable. The CEL expression has access to the same identifiers as the CEL expressions in Validation.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "expression"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_admissionregistration_v1beta1_WebhookClientConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "WebhookClientConfig contains the information to make a TLS connection with the webhook",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"url": {
						SchemaProps: spec.SchemaProps{
							Description: "`url` gives the location of the webhook, in standard URL form (`scheme://host:port/path`). Exactly one of `url` or `service` must be specified.\n\nThe `host` should not refer to a service running in the cluster; use the `service` field instead. The host might be resolved via external DNS in some apiservers (e.g., `kube-apiserver` cannot resolve in-cluster DNS as that would be a layering violation). `host` may also be an IP address.\n\nPlease note that using `localhost` or `127.0.0.1` as a `host` is risky unless you take great care to run this webhook on all hosts which run an apiserver which might need to make calls to this webhook. Such installs are likely to be non-portable, i.e., not easy to turn up in a new cluster.\n\nThe scheme must be \"https\"; the URL must begin with \"https://\".\n\nA path is optional, and if present may be any string permissible in a URL. You may use the path to pass an arbitrary string to the webhook, for example, a cluster identifier.\n\nAttempting to use a user or basic auth e.g. \"user:password@\" is not allowed. Fragments (\"#...\") and query parameters (\"?...\") are not allowed, either.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"service": {
						SchemaProps: spec.SchemaProps{
							Description: "`service` is a reference to the service for this webhook. Either `service` or `url` must be specified.\n\nIf the webhook is running within the cluster, then you should use `service`.",
							Ref:         ref(v1beta1.ServiceReference{}.OpenAPIModelName()),
						},
					},
					"caBundle": {
						SchemaProps: spec.SchemaProps{
							Description: "`caBundle` is a PEM encoded CA bundle which will be used to validate the webhook's server certificate. If unspecified, system trust roots on the apiserver are used.",
							Type:        []string{"string"},
							Format:      "byte",
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta1.ServiceReference{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIGroupDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscovery holds information about which resources are being served for all version of the API Group. It contains a list of APIVersionDiscovery that holds a list of APIResourceDiscovery types served for a version. Versions are in descending order of preference, with the first version being the preferred entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. The only field completed will be name. For instance, resourceVersion will be empty. name is the name of the API group whose discovery information is presented here. name is allowed to be \"\" to represent the legacy, ungroupified resources. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"version",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group. They are sorted in descending order of preference, with the preferred version being the first entry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2.APIVersionDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v2.APIVersionDiscovery{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIGroupDiscoveryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscoveryList is a resource containing a list of APIGroupDiscovery. This is one of the types able to be returned from the /api and /apis endpoint and contains an aggregated list of API resources (built-ins, Custom Resource Definitions, resources from aggregated servers) that a cluster supports.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceVersion will not be set, because this does not have a replayable ordering among multiple apiservers. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of groups for discovery. The groups are listed in priority order.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2.APIGroupDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v2.APIGroupDiscovery{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIResourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceDiscovery provides information about an API resource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource is the plural name of the resource.  This is used in the URL path and is the unique identifier for this resource across all versions in the API group. Resources with non-empty groups are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource> Resources with empty groups are located at /api/v1/<APIResourceDiscovery.Resource>",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. APIs may return other objects types at their discretion, such as error conditions, requests for alternate representations, or other operation specific behavior. This value will be null or empty if an APIService reports subresources but supports no operations on the parent resource",
							Ref:         ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope indicates the scope of a resource, either Cluster or Namespaced",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singularResource": {
						SchemaProps: spec.SchemaProps{
							Description: "singularResource is the singular name of the resource.  This allows clients to handle plural and singular opaquely. For many clients the singular form of the resource will be more understandable to users reading messages and should be used when integrating the name of the resource into a sentence. The command line tool kubectl, for example, allows use of the singular resource name in place of plurals. The singular form of a resource should always be an optional element - when in doubt use the canonical resource name.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"shortNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "shortNames is a list of suggested short names of the resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"categories": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all'). Clients may use this to simplify acting on multiple resource types at once.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"subresources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"subresource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "subresources is a list of subresources provided by this resource. Subresources are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource>/name-of-instance/<APIResourceDiscovery.subresources[i].subresource>",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2.APISubresourceDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"resource", "scope", "singularResource", "verbs"},
			},
		},
		Dependencies: []string{
			v2.APISubresourceDiscovery{}.OpenAPIModelName(), metav1.GroupVersionKind{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2_APISubresourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APISubresourceDiscovery provides information about an API subresource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "subresource is the name of the subresource.  This is used in the URL path and is the unique identifier for this resource across all versions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. Some subresources do not return normal resources, these will have null or empty return types.",
							Ref:         ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
						},
					},
					"acceptedTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"group",
									"version",
									"kind",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "acceptedTypes describes the kinds that this endpoint accepts. Subresources may accept the standard content types or define custom negotiation schemes. The list may not be exhaustive for all operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy). Subresources may define custom verbs outside the standard Kubernetes verb set. Clients should expect the behavior of standard verbs to align with Kubernetes interaction conventions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"subresource", "verbs"},
			},
		},
		Dependencies: []string{
			metav1.GroupVersionKind{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2_APIVersionDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersionDiscovery holds a list of APIResourceDiscovery types that are served for a particular version within an API Group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version is the name of the version within a group version.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"resource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "resources is a list of APIResourceDiscovery objects for the corresponding group version.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2.APIResourceDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"freshness": {
						SchemaProps: spec.SchemaProps{
							Description: "freshness marks whether a group version's discovery document is up to date. \"Current\" indicates the discovery document was recently refreshed. \"Stale\" indicates the discovery document could not be retrieved and the returned discovery document may be significantly out of date. Clients that require the latest version of the discovery information be retrieved before performing an operation should not use the aggregated document",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			v2.APIResourceDiscovery{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscovery holds information about which resources are being served for all version of the API Group. It contains a list of APIVersionDiscovery that holds a list of APIResourceDiscovery types served for a version. Versions are in descending order of preference, with the first version being the preferred entry.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. The only field completed will be name. For instance, resourceVersion will be empty. name is the name of the API group whose discovery information is presented here. name is allowed to be \"\" to represent the legacy, ungroupified resources. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"versions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"version",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "versions are the versions supported in this group. They are sorted in descending order of preference, with the preferred version being the first entry.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2beta1.APIVersionDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			v2beta1.APIVersionDiscovery{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIGroupDiscoveryList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIGroupDiscoveryList is a resource containing a list of APIGroupDiscovery. This is one of the types able to be returned from the /api and /apis endpoint and contains an aggregated list of API resources (built-ins, Custom Resource Definitions, resources from aggregated servers) that a cluster supports.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceVersion will not be set, because this does not have a replayable ordering among multiple apiservers. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of groups for discovery. The groups are listed in priority order.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2beta1.APIGroupDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v2beta1.APIGroupDiscovery{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIResourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIResourceDiscovery provides information about an API resource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource is the plural name of the resource.  This is used in the URL path and is the unique identifier for this resource across all versions in the API group. Resources with non-empty groups are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource> Resources with empty groups are located at /api/v1/<APIResourceDiscovery.Resource>",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. APIs may return other objects types at their discretion, such as error conditions, requests for alternate representations, or other operation specific behavior. This value will be null or empty if an APIService reports subresources but supports no operations on the parent resource",
							Ref:         ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
						},
					},
					"scope": {
						SchemaProps: spec.SchemaProps{
							Description: "scope indicates the scope of a resource, either Cluster or Namespaced",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"singularResource": {
						SchemaProps: spec.SchemaProps{
							Description: "singularResource is the singular name of the resource.  This allows clients to handle plural and singular opaquely. For many clients the singular form of the resource will be more understandable to users reading messages and should be used when integrating the name of the resource into a sentence. The command line tool kubectl, for example, allows use of the singular resource name in place of plurals. The singular form of a resource should always be an optional element - when in doubt use the canonical resource name.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy).",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"shortNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "shortNames is a list of suggested short names of the resource.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"categories": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "categories is a list of the grouped resources this resource belongs to (e.g. 'all'). Clients may use this to simplify acting on multiple resource types at once.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"subresources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"subresource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "subresources is a list of subresources provided by this resource. Subresources are located at /apis/<APIGroupDiscovery.objectMeta.name>/<APIVersionDiscovery.version>/<APIResourceDiscovery.Resource>/name-of-instance/<APIResourceDiscovery.subresources[i].subresource>",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2beta1.APISubresourceDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"resource", "scope", "singularResource", "verbs"},
			},
		},
		Dependencies: []string{
			v2beta1.APISubresourceDiscovery{}.OpenAPIModelName(), metav1.GroupVersionKind{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APISubresourceDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APISubresourceDiscovery provides information about an API subresource for discovery.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "subresource is the name of the subresource.  This is used in the URL path and is the unique identifier for this resource across all versions.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"responseKind": {
						SchemaProps: spec.SchemaProps{
							Description: "responseKind describes the group, version, and kind of the serialization schema for the object type this endpoint typically returns. Some subresources do not return normal resources, these will have null or empty return types.",
							Ref:         ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
						},
					},
					"acceptedTypes": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"group",
									"version",
									"kind",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "acceptedTypes describes the kinds that this endpoint accepts. Subresources may accept the standard content types or define custom negotiation schemes. The list may not be exhaustive for all operations.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.GroupVersionKind{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "verbs is a list of supported API operation types (this includes but is not limited to get, list, watch, create, update, patch, delete, deletecollection, and proxy). Subresources may define custom verbs outside the standard Kubernetes verb set. Clients should expect the behavior of standard verbs to align with Kubernetes interaction conventions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"subresource", "verbs"},
			},
		},
		Dependencies: []string{
			metav1.GroupVersionKind{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apidiscovery_v2beta1_APIVersionDiscovery(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIVersionDiscovery holds a list of APIResourceDiscovery types that are served for a particular version within an API Group.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "version is the name of the version within a group version.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"resource",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "resources is a list of APIResourceDiscovery objects for the corresponding group version.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v2beta1.APIResourceDiscovery{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"freshness": {
						SchemaProps: spec.SchemaProps{
							Description: "freshness marks whether a group version's discovery document is up to date. \"Current\" indicates the discovery document was recently refreshed. \"Stale\" indicates the discovery document could not be retrieved and the returned discovery document may be significantly out of date. Clients that require the latest version of the discovery information be retrieved before performing an operation should not use the aggregated document",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"version"},
			},
		},
		Dependencies: []string{
			v2beta1.APIResourceDiscovery{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_ServerStorageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "An API server instance reports the version it can decode and the version it encodes objects to when persisting objects in the backend.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"apiServerID": {
						SchemaProps: spec.SchemaProps{
							Description: "The ID of the reporting API server.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"encodingVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "The API server encodes the object to this version when persisting it in the backend (e.g., etcd).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"decodableVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The API server can decode objects encoded in these versions. The encodingVersion must be included in the decodableVersions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"servedVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "set",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The API server can serve these versions. DecodableVersions must include all ServedVersions.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersion(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Storage version of a specific resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "The name is <group>.<resource>.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec is an empty spec. It is here to comply with Kubernetes API style.",
							Default:     map[string]interface{}{},
							Ref:         ref(apiserverinternalv1alpha1.StorageVersionSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "API server instances report the version they can decode and the version they encode objects to when persisting objects in the backend.",
							Default:     map[string]interface{}{},
							Ref:         ref(apiserverinternalv1alpha1.StorageVersionStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec", "status"},
			},
		},
		Dependencies: []string{
			apiserverinternalv1alpha1.StorageVersionSpec{}.OpenAPIModelName(), apiserverinternalv1alpha1.StorageVersionStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Describes the state of the storageVersion at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of the condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "If set, this represents the .metadata.generation that the condition was set based upon.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status", "reason", "message"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A list of StorageVersions.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items holds a list of StorageVersion",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(apiserverinternalv1alpha1.StorageVersion{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			apiserverinternalv1alpha1.StorageVersion{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StorageVersionSpec is an empty spec.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_k8sio_api_apiserverinternal_v1alpha1_StorageVersionStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "API server instances report the versions they can decode and the version they encode objects to when persisting objects in the backend.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"storageVersions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"apiServerID",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The reported versions per API server instance.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(apiserverinternalv1alpha1.ServerStorageVersion{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"commonEncodingVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "If all API server instances agree on the same encoding storage version, then this field is set to that version. Otherwise this field is left empty. API servers should finish updating its storageVersionStatus entry before serving write operations, so that this field will be in sync with the reality.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type": "map",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The latest available observations of the storageVersion's state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(apiserverinternalv1alpha1.StorageVersionCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			apiserverinternalv1alpha1.ServerStorageVersion{}.OpenAPIModelName(), apiserverinternalv1alpha1.StorageVersionCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the serialized representation of the state.",
							Ref:         ref(runtime.RawExtension{}.OpenAPIModelName()),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			metav1.ObjectMeta{}.OpenAPIModelName(), runtime.RawExtension{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.ControllerRevision{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1.ControllerRevision{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSet represents the configuration of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DaemonSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DaemonSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.DaemonSetSpec{}.OpenAPIModelName(), appsv1.DaemonSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetCondition describes the state of a DaemonSet at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of DaemonSet condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.DaemonSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1.DaemonSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is \"Always\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "An update strategy to replace existing DaemonSet pods with new pods.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DaemonSetUpdateStrategy{}.OpenAPIModelName()),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			appsv1.DaemonSetUpdateStrategy{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "numberReady is the number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The most recent generation observed by the daemon set controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"updatedNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that are running updated daemon pod",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a DaemonSet's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.DaemonSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{
			appsv1.DaemonSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DaemonSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of daemon set update. Can be \"RollingUpdate\" or \"OnDelete\". Default is RollingUpdate.\n\nPossible enum values:\n - `\"OnDelete\"` Replace the old daemons only when it's killed\n - `\"RollingUpdate\"` Replace the old daemons by new ones using rolling update i.e replace them on each node one after the other.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OnDelete", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if type = \"RollingUpdate\".",
							Ref:         ref(appsv1.RollingUpdateDaemonSet{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.RollingUpdateDaemonSet{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DeploymentSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DeploymentStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.DeploymentSpec{}.OpenAPIModelName(), appsv1.DeploymentStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.Deployment{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1.Deployment{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.DeploymentStrategy{}.OpenAPIModelName()),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			appsv1.DeploymentStrategy{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this Deployment with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminatingReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.\n\nThis is a beta field and requires enabling DeploymentReplicaSetTerminatingReplicas feature (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.DeploymentCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.DeploymentCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.\n\nPossible enum values:\n - `\"Recreate\"` Kill all existing pods before creating new ones.\n - `\"RollingUpdate\"` Replace the old ReplicaSets by new one using rolling update i.e gradually scale down the old ReplicaSets and scale up the new one.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"Recreate", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref(appsv1.RollingUpdateDeployment{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.RollingUpdateDeployment{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSet ensures that a specified number of pod replicas are running at any given time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.ReplicaSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.ReplicaSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.ReplicaSetSpec{}.OpenAPIModelName(), appsv1.ReplicaSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ReplicaSets. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.ReplicaSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1.ReplicaSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_ReplicaSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminatingReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.\n\nThis is a beta field and requires enabling DeploymentReplicaSetTerminatingReplicas feature (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.ReplicaSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			appsv1.ReplicaSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateDaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of daemon set rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediately created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is beta-level and is enabled by default. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable. This setting might not be effective for the OrderedReady podManagementPolicy. That policy ensures pods are created and become ready one at a time.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.StatefulSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.StatefulSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.StatefulSetSpec{}.OpenAPIModelName(), appsv1.StatefulSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of stateful sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.StatefulSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1.StatefulSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\". The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(corev1.PersistentVolumeClaim{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.\n\nPossible enum values:\n - `\"OrderedReady\"` will create pods in strictly increasing order on scale up and strictly decreasing order on scale down, progressing only when the previous pod is ready or terminated. At most one pod will be changed at any time.\n - `\"Parallel\"` will create and delete pods as soon as the stateful set replica count is changed, and will not wait for pods to be ready or complete termination.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OrderedReady", "Parallel"},
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1.StatefulSetUpdateStrategy{}.OpenAPIModelName()),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.",
							Ref:         ref(appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName()),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref(appsv1.StatefulSetOrdinals{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			appsv1.StatefulSetOrdinals{}.OpenAPIModelName(), appsv1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName(), appsv1.StatefulSetUpdateStrategy{}.OpenAPIModelName(), corev1.PersistentVolumeClaim{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created for this StatefulSet with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1.StatefulSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this statefulset.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			appsv1.StatefulSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.\n\nPossible enum values:\n - `\"OnDelete\"` triggers the legacy behavior. Version tracking and ordered rolling restarts are disabled. Pods are recreated from the StatefulSetSpec when they are manually deleted. When a scale operation is performed with this strategy,specification version indicated by the StatefulSet's currentRevision.\n - `\"RollingUpdate\"` indicates that update will be applied to all Pods in the StatefulSet with respect to the StatefulSet ordering constraints. When a scale operation is performed with this strategy, new Pods will be created from the specification version indicated by the StatefulSet's updateRevision.",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"OnDelete", "RollingUpdate"},
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref(appsv1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "data is the serialized representation of the state.",
							Ref:         ref(runtime.RawExtension{}.OpenAPIModelName()),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			metav1.ObjectMeta{}.OpenAPIModelName(), runtime.RawExtension{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1beta1.ControllerRevision{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1beta1.ControllerRevision{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.DeploymentSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.DeploymentStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.DeploymentSpec{}.OpenAPIModelName(), appsv1beta1.DeploymentStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1beta1.Deployment{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1beta1.Deployment{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentRollback(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED. DeploymentRollback stores the information required to rollback a deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Required: This must match the Name of a deployment.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updatedAnnotations": {
						SchemaProps: spec.SchemaProps{
							Description: "The annotations to be updated to a deployment",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "The config of this deployment rollback.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.RollbackConfig{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name", "rollbackTo"},
			},
		},
		Dependencies: []string{
			appsv1beta1.RollbackConfig{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.DeploymentStrategy{}.OpenAPIModelName()),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "minReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 2.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "paused indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"rollbackTo": {
						SchemaProps: spec.SchemaProps{
							Description: "DEPRECATED. rollbackTo is the config this deployment is rolling back to. Will be cleared after rollback is done.",
							Ref:         ref(appsv1beta1.RollbackConfig{}.OpenAPIModelName()),
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "progressDeadlineSeconds is the maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			appsv1beta1.DeploymentStrategy{}.OpenAPIModelName(), appsv1beta1.RollbackConfig{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this Deployment with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminatingReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.\n\nThis is a beta field and requires enabling DeploymentReplicaSetTerminatingReplicas feature (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1beta1.DeploymentCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.DeploymentCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref(appsv1beta1.RollingUpdateDeployment{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.RollingUpdateDeployment{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_RollbackConfig(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "The revision to rollback to. If set to 0, rollback to the last revision.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "maxUnavailable is the maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is beta-level and is enabled by default. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable. This setting might not be effective for the OrderedReady podManagementPolicy. That policy ensures pods are created and become ready one at a time.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.ScaleSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status defines current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.ScaleStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.ScaleSpec{}.OpenAPIModelName(), appsv1beta1.ScaleStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replias is the actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"targetSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "targetSelector is the label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.StatefulSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.StatefulSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.StatefulSetSpec{}.OpenAPIModelName(), appsv1beta1.StatefulSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1beta1.StatefulSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			appsv1beta1.StatefulSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "whenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "whenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. If empty, defaulted to labels on the pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(corev1.PersistentVolumeClaim{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref(appsv1beta1.StatefulSetUpdateStrategy{}.OpenAPIModelName()),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "minReadySeconds is the minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.",
							Ref:         ref(appsv1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName()),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref(appsv1beta1.StatefulSetOrdinals{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"template"},
			},
		},
		Dependencies: []string{
			appsv1beta1.StatefulSetOrdinals{}.OpenAPIModelName(), appsv1beta1.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName(), appsv1beta1.StatefulSetUpdateStrategy{}.OpenAPIModelName(), corev1.PersistentVolumeClaim{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions represent the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(appsv1beta1.StatefulSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "availableReplicas is the total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			appsv1beta1.StatefulSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta1_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref(appsv1beta1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			appsv1beta1.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ControllerRevision(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1/ControllerRevision. See the release notes for more information. ControllerRevision implements an immutable snapshot of state data. Clients are responsible for serializing and deserializing the objects that contain their internal state. Once a ControllerRevision has been successfully created, it can not be updated. The API Server will fail validation of all requests that attempt to mutate the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However, it may be subject to name and representation changes in future releases, and clients should not depend on its stability. It is primarily for internal use by controllers.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"data": {
						SchemaProps: spec.SchemaProps{
							Description: "Data is the serialized representation of the state.",
							Ref:         ref(runtime.RawExtension{}.OpenAPIModelName()),
						},
					},
					"revision": {
						SchemaProps: spec.SchemaProps{
							Description: "Revision indicates the revision of the state represented by Data.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
				},
				Required: []string{"revision"},
			},
		},
		Dependencies: []string{
			metav1.ObjectMeta{}.OpenAPIModelName(), runtime.RawExtension{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ControllerRevisionList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ControllerRevisionList is a resource containing a list of ControllerRevision objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of ControllerRevisions",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.ControllerRevision{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta2.ControllerRevision{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of DaemonSet is deprecated by apps/v1/DaemonSet. See the release notes for more information. DaemonSet represents the configuration of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "The desired behavior of this daemon set. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DaemonSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "The current status of this daemon set. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DaemonSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.DaemonSetSpec{}.OpenAPIModelName(), v1beta2.DaemonSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetCondition describes the state of a DaemonSet at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of DaemonSet condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetList is a collection of daemon sets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "A list of daemon sets.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.DaemonSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta2.DaemonSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetSpec is the specification of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "A label query over pods that are managed by the daemon set. Must match in order to be controlled. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). The only allowed template.spec.restartPolicy value is \"Always\". More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "An update strategy to replace existing DaemonSet pods with new pods.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DaemonSetUpdateStrategy{}.OpenAPIModelName()),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			v1beta2.DaemonSetUpdateStrategy{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetStatus represents the current status of a daemon set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"currentNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberMisscheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberReady": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of nodes that should be running the daemon pod and have one or more of the daemon pod running with a Ready Condition by passing the readinessProbe.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The most recent generation observed by the daemon set controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"updatedNumberScheduled": {
						SchemaProps: spec.SchemaProps{
							Description: "The total number of nodes that are running updated daemon pod",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberAvailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"numberUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a DaemonSet's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.DaemonSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"currentNumberScheduled", "numberMisscheduled", "desiredNumberScheduled", "numberReady"},
			},
		},
		Dependencies: []string{
			v1beta2.DaemonSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DaemonSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DaemonSetUpdateStrategy is a struct used to control the update strategy for a DaemonSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of daemon set update. Can be \"RollingUpdate\" or \"OnDelete\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if type = \"RollingUpdate\".",
							Ref:         ref(v1beta2.RollingUpdateDaemonSet{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.RollingUpdateDaemonSet{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_Deployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of Deployment is deprecated by apps/v1/Deployment. See the release notes for more information. Deployment enables declarative updates for Pods and ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Specification of the desired behavior of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DeploymentSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Most recently observed status of the Deployment.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DeploymentStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.DeploymentSpec{}.OpenAPIModelName(), v1beta2.DeploymentStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentCondition describes the state of a deployment at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastUpdateTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time this condition was updated.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentList is a list of Deployments.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "Items is the list of Deployments.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.Deployment{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta2.Deployment{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentSpec is the specification of the desired behavior of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Number of desired pods. This is a pointer to distinguish between explicit zero and not specified. Defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Label selector for pods. Existing ReplicaSets whose pods are selected by this will be the ones affected by this deployment. It must match the pod template's labels.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template describes the pods that will be created. The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"strategy": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-patch-strategy": "retainKeys",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The deployment strategy to use to replace existing pods with new ones.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.DeploymentStrategy{}.OpenAPIModelName()),
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of old ReplicaSets to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"paused": {
						SchemaProps: spec.SchemaProps{
							Description: "Indicates that the deployment is paused.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"progressDeadlineSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum time in seconds for a deployment to make progress before it is considered to be failed. The deployment controller will continue to process failed deployments and a condition with a ProgressDeadlineExceeded reason will be surfaced in the deployment status. Note that progress will not be estimated during the time a deployment is paused. Defaults to 600s.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			v1beta2.DeploymentStrategy{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStatus is the most recently observed status of the Deployment.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "The generation observed by the deployment controller.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment (their labels match the selector).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this deployment that have the desired template spec.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of non-terminating pods targeted by this Deployment with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available non-terminating pods (ready for at least minReadySeconds) targeted by this deployment.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"unavailableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of unavailable pods targeted by this deployment. This is the total number of pods that are still required for the deployment to have 100% available capacity. They may either be pods that are running but not yet available or pods that still have not been created.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminatingReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of terminating pods targeted by this deployment. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.\n\nThis is a beta field and requires enabling DeploymentReplicaSetTerminatingReplicas feature (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a deployment's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.DeploymentCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "Count of hash collisions for the Deployment. The Deployment controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.DeploymentCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_DeploymentStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DeploymentStrategy describes how to replace existing pods with new ones.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of deployment. Can be \"Recreate\" or \"RollingUpdate\". Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "Rolling update config params. Present only if DeploymentStrategyType = RollingUpdate.",
							Ref:         ref(v1beta2.RollingUpdateDeployment{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.RollingUpdateDeployment{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of ReplicaSet is deprecated by apps/v1/ReplicaSet. See the release notes for more information. ReplicaSet ensures that a specified number of pod replicas are running at any given time.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "If the Labels of a ReplicaSet are empty, they are defaulted to be the same as the Pod(s) that the ReplicaSet manages. Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the specification of the desired behavior of the ReplicaSet. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.ReplicaSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the most recently observed status of the ReplicaSet. This data may be out of date by some window of time. Populated by the system. Read-only. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.ReplicaSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.ReplicaSetSpec{}.OpenAPIModelName(), v1beta2.ReplicaSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetCondition describes the state of a replica set at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of replica set condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "The last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetList is a collection of ReplicaSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "List of ReplicaSets. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.ReplicaSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta2.ReplicaSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetSpec is the specification of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the number of desired pods. This is a pointer to distinguish between explicit zero and unspecified. Defaults to 1. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "Selector is a label query over pods that should match the replica count. Label keys and values that must match in order to be controlled by this replica set. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "Template is the object that describes the pod that will be created if insufficient replicas are detected. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset/#pod-template",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"selector"},
			},
		},
		Dependencies: []string{
			corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ReplicaSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ReplicaSetStatus represents the current status of a ReplicaSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Replicas is the most recently observed number of non-terminating pods. More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicaset",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"fullyLabeledReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of non-terminating pods that have labels matching the labels of the pod template of the replicaset.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of non-terminating pods targeted by this ReplicaSet with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of available non-terminating pods (ready for at least minReadySeconds) for this replica set.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"terminatingReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "The number of terminating pods for this replica set. Terminating pods have a non-null .metadata.deletionTimestamp and have not yet reached the Failed or Succeeded .status.phase.\n\nThis is a beta field and requires enabling DeploymentReplicaSetTerminatingReplicas feature (enabled by default).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "ObservedGeneration reflects the generation of the most recently observed ReplicaSet.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a replica set's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.ReplicaSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			v1beta2.ReplicaSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateDaemonSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of daemon set rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of DaemonSet pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of total number of DaemonSet pods at the start of the update (ex: 10%). Absolute number is calculated from percentage by rounding up. This cannot be 0 if MaxSurge is 0 Default value is 1. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their pods stopped for an update at any given time. The update starts by stopping at most 30% of those DaemonSet pods and then brings up new DaemonSet pods in their place. Once the new pods are available, it then proceeds onto other DaemonSet pods, thus ensuring that at least 70% of original number of DaemonSet pods are available at all times during the update.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of nodes with an existing available DaemonSet pod that can have an updated DaemonSet pod during during an update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up to a minimum of 1. Default value is 0. Example: when this is set to 30%, at most 30% of the total number of nodes that should be running the daemon pod (i.e. status.desiredNumberScheduled) can have their a new pod created before the old pod is marked as deleted. The update starts by launching new pods on 30% of nodes. Once an updated pod is available (Ready for at least minReadySeconds) the old DaemonSet pod on that node is marked deleted. If the old pod becomes unavailable for any reason (Ready transitions to false, is evicted, or is drained) an updated pod is immediately created on that node without considering surge limits. Allowing surge implies the possibility that the resources consumed by the daemonset on any given node can double if the readiness check fails, and so resource intensive daemonsets should take into account that they may cause evictions during disruption.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateDeployment(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Spec to control the desired behavior of rolling update.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding down. This can not be 0 if MaxSurge is 0. Defaults to 25%. Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods immediately when the rolling update starts. Once new pods are ready, old ReplicaSet can be scaled down further, followed by scaling up the new ReplicaSet, ensuring that the total number of pods available at all times during the update is at least 70% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
					"maxSurge": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be scheduled above the desired number of pods. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). This can not be 0 if MaxUnavailable is 0. Absolute number is calculated from percentage by rounding up. Defaults to 25%. Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when the rolling update starts, such that the total number of old and new pods do not exceed 130% of desired pods. Once old pods have been killed, new ReplicaSet can be scaled up further, ensuring that total number of pods running at any time during the update is at most 130% of desired pods.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_RollingUpdateStatefulSetStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"partition": {
						SchemaProps: spec.SchemaProps{
							Description: "Partition indicates the ordinal at which the StatefulSet should be partitioned for updates. During a rolling update, all pods from ordinal Replicas-1 to Partition are updated. All pods from ordinal Partition-1 to 0 remain untouched. This is helpful in being able to do a canary based deployment. The default value is 0.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxUnavailable": {
						SchemaProps: spec.SchemaProps{
							Description: "The maximum number of pods that can be unavailable during the update. Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%). Absolute number is calculated from percentage by rounding up. This can not be 0. Defaults to 1. This field is beta-level and is enabled by default. The field applies to all pods in the range 0 to Replicas-1. That means if there is any unavailable pod in the range 0 to Replicas-1, it will be counted towards MaxUnavailable. This setting might not be effective for the OrderedReady podManagementPolicy. That policy ensures pods are created and become ready one at a time.",
							Ref:         ref(intstr.IntOrString{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			intstr.IntOrString{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.ScaleSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.ScaleStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.ScaleSpec{}.OpenAPIModelName(), v1beta2.ScaleStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desired number of instances for the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-map-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"targetSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "label selector for pods that should match the replicas count. This is a serializated version of both map-based and more expressive set-based selectors. This is done to avoid introspection in the clients. The string will be in the same format as the query-param syntax. If the target type only supports map-based selectors, both this field and map-based selector field are populated. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSet(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DEPRECATED - This group version of StatefulSet is deprecated by apps/v1/StatefulSet. See the release notes for more information. StatefulSet represents a set of pods with consistent identities. Identities are defined as:\n  - Network: A single stable DNS and hostname.\n  - Storage: As many VolumeClaims as requested.\n\nThe StatefulSet guarantees that a given network identity will always map to the same storage identity.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec defines the desired identities of pods in this set.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.StatefulSetSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is the current status of Pods in this StatefulSet. This data may be out of date by some window of time.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.StatefulSetStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.StatefulSetSpec{}.OpenAPIModelName(), v1beta2.StatefulSetStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetCondition describes the state of a statefulset at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type of statefulset condition.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status of the condition, one of True, False, Unknown.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "Last time the condition transitioned from one status to another.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "The reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "A human readable message indicating details about the transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetList is a collection of StatefulSets.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Default: map[string]interface{}{},
							Ref:     ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.StatefulSet{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			v1beta2.StatefulSet{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetOrdinals(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetOrdinals describes the policy used for replica ordinal assignment in this StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"start": {
						SchemaProps: spec.SchemaProps{
							Description: "start is the number representing the first replica's index. It may be used to number replicas from an alternate index (eg: 1-indexed) over the default 0-indexed names, or to orchestrate progressive movement of replicas from one StatefulSet to another. If set, replica indices will be in the range:\n  [.spec.ordinals.start, .spec.ordinals.start + .spec.replicas).\nIf unset, defaults to 0. Replica indices will be in the range:\n  [0, .spec.replicas).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetPersistentVolumeClaimRetentionPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetPersistentVolumeClaimRetentionPolicy describes the policy used for PVCs created from the StatefulSet VolumeClaimTemplates.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"whenDeleted": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenDeleted specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is deleted. The default policy of `Retain` causes PVCs to not be affected by StatefulSet deletion. The `Delete` policy causes those PVCs to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"whenScaled": {
						SchemaProps: spec.SchemaProps{
							Description: "WhenScaled specifies what happens to PVCs created from StatefulSet VolumeClaimTemplates when the StatefulSet is scaled down. The default policy of `Retain` causes PVCs to not be affected by a scaledown. The `Delete` policy causes the associated PVCs for any excess pods above the replica count to be deleted.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "A StatefulSetSpec is the specification of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of replicas of the given Template. These are replicas in the sense that they are instantiations of the same Template, but individual replicas also have a consistent identity. If unspecified, defaults to 1.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is a label query over pods that should match the replica count. It must match the pod template's labels. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"template": {
						SchemaProps: spec.SchemaProps{
							Description: "template is the object that describes the pod that will be created if insufficient replicas are detected. Each pod stamped out by the StatefulSet will fulfill this Template, but have a unique identity from the rest of the StatefulSet. Each pod will be named with the format <statefulsetname>-<podindex>. For example, a pod in a StatefulSet named \"web\" with index number \"3\" would be named \"web-3\". The only allowed template.spec.restartPolicy value is \"Always\".",
							Default:     map[string]interface{}{},
							Ref:         ref(corev1.PodTemplateSpec{}.OpenAPIModelName()),
						},
					},
					"volumeClaimTemplates": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "volumeClaimTemplates is a list of claims that pods are allowed to reference. The StatefulSet controller is responsible for mapping network identities to claims in a way that maintains the identity of a pod. Every claim in this list must have at least one matching (by name) volumeMount in one container in the template. A claim in this list takes precedence over any volumes in the template, with the same name.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(corev1.PersistentVolumeClaim{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"serviceName": {
						SchemaProps: spec.SchemaProps{
							Description: "serviceName is the name of the service that governs this StatefulSet. This service must exist before the StatefulSet, and is responsible for the network identity of the set. Pods get DNS/hostnames that follow the pattern: pod-specific-string.serviceName.default.svc.cluster.local where \"pod-specific-string\" is managed by the StatefulSet controller.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"podManagementPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "podManagementPolicy controls how pods are created during initial scale up, when replacing pods on nodes, or when scaling down. The default policy is `OrderedReady`, where pods are created in increasing order (pod-0, then pod-1, etc) and the controller will wait until each pod is ready before continuing. When scaling down, the pods are removed in the opposite order. The alternative policy is `Parallel` which will create pods in parallel to match the desired scale without waiting, and on scale down will delete all pods at once.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateStrategy": {
						SchemaProps: spec.SchemaProps{
							Description: "updateStrategy indicates the StatefulSetUpdateStrategy that will be employed to update Pods in the StatefulSet when a revision is made to Template.",
							Default:     map[string]interface{}{},
							Ref:         ref(v1beta2.StatefulSetUpdateStrategy{}.OpenAPIModelName()),
						},
					},
					"revisionHistoryLimit": {
						SchemaProps: spec.SchemaProps{
							Description: "revisionHistoryLimit is the maximum number of revisions that will be maintained in the StatefulSet's revision history. The revision history consists of all revisions not represented by a currently applied StatefulSetSpec version. The default value is 10.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"minReadySeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "Minimum number of seconds for which a newly created pod should be ready without any of its container crashing for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready)",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"persistentVolumeClaimRetentionPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "persistentVolumeClaimRetentionPolicy describes the lifecycle of persistent volume claims created from volumeClaimTemplates. By default, all persistent volume claims are created as needed and retained until manually deleted. This policy allows the lifecycle to be altered, for example by deleting persistent volume claims when their stateful set is deleted, or when their pod is scaled down.",
							Ref:         ref(v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName()),
						},
					},
					"ordinals": {
						SchemaProps: spec.SchemaProps{
							Description: "ordinals controls the numbering of replica indices in a StatefulSet. The default ordinals behavior assigns a \"0\" index to the first replica and increments the index by one for each additional replica requested.",
							Ref:         ref(v1beta2.StatefulSetOrdinals{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"selector", "template"},
			},
		},
		Dependencies: []string{
			v1beta2.StatefulSetOrdinals{}.OpenAPIModelName(), v1beta2.StatefulSetPersistentVolumeClaimRetentionPolicy{}.OpenAPIModelName(), v1beta2.StatefulSetUpdateStrategy{}.OpenAPIModelName(), corev1.PersistentVolumeClaim{}.OpenAPIModelName(), corev1.PodTemplateSpec{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetStatus represents the current state of a StatefulSet.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the number of Pods created by the StatefulSet controller.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"readyReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"updatedReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"updateRevision": {
						SchemaProps: spec.SchemaProps{
							Description: "updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"collisionCount": {
						SchemaProps: spec.SchemaProps{
							Description: "collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Represents the latest available observations of a statefulset's current state.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(v1beta2.StatefulSetCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"availableReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
		Dependencies: []string{
			v1beta2.StatefulSetCondition{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_apps_v1beta2_StatefulSetUpdateStrategy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "StatefulSetUpdateStrategy indicates the strategy that the StatefulSet controller will use to perform updates. It includes any additional parameters necessary to perform the update for the indicated strategy.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type indicates the type of the StatefulSetUpdateStrategy. Default is RollingUpdate.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"rollingUpdate": {
						SchemaProps: spec.SchemaProps{
							Description: "RollingUpdate is used to communicate parameters when Type is RollingUpdateStatefulSetStrategyType.",
							Ref:         ref(v1beta2.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			v1beta2.RollingUpdateStatefulSetStrategy{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_BoundObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BoundObjectReference is a reference to an object that a token is bound to.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent. Valid kinds are 'Pod' and 'Secret'.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID of the referent.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.SelfSubjectReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1.SelfSubjectReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.UserInfo{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1.UserInfo{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequest(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequest requests a token for a given service account.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.TokenRequestSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the token can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.TokenRequestStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authenticationv1.TokenRequestSpec{}.OpenAPIModelName(), authenticationv1.TokenRequestStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequestSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequestSpec contains client provided parameters of a token request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are the intendend audiences of the token. A recipient of a token must identify themself with an identifier in the list of audiences of the token, and otherwise should reject the token. A token issued for multiple audiences may be used to authenticate against any of the audiences listed but implies a high degree of trust between the target audiences.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"expirationSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationSeconds is the requested duration of validity of the request. The token issuer may return a token with a different validity duration so a client needs to check the 'expiration' field in a response.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"boundObjectRef": {
						SchemaProps: spec.SchemaProps{
							Description: "BoundObjectRef is a reference to an object that the token will be bound to. The token will only be valid for as long as the bound object exists. NOTE: The API server's TokenReview endpoint will validate the BoundObjectRef, but other audiences may not. Keep ExpirationSeconds small if you want prompt revocation.",
							Ref:         ref(authenticationv1.BoundObjectReference{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"audiences"},
			},
		},
		Dependencies: []string{
			authenticationv1.BoundObjectReference{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_TokenRequestStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenRequestStatus is the result of a token request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"expirationTimestamp": {
						SchemaProps: spec.SchemaProps{
							Description: "ExpirationTimestamp is the time of expiration of the returned token.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"token", "expirationTimestamp"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_TokenReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.TokenReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.TokenReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authenticationv1.TokenReviewSpec{}.OpenAPIModelName(), authenticationv1.TokenReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_TokenReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1_TokenReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.UserInfo{}.OpenAPIModelName()),
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1.UserInfo{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1_UserInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1alpha1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1alpha1.SelfSubjectReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1alpha1.SelfSubjectReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1alpha1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.UserInfo{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1.UserInfo{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1beta1_SelfSubjectReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReview contains the user information that the kube-apiserver has about the user making this request. When using impersonation, users will receive the user info of the user being impersonated.  If impersonation or request header authentication is used, any extra keys will have their case ignored and returned as lowercase.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server with the user attributes.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1beta1.SelfSubjectReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1beta1.SelfSubjectReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1beta1_SelfSubjectReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a user.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"userInfo": {
						SchemaProps: spec.SchemaProps{
							Description: "User attributes of the user making this request.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1.UserInfo{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1.UserInfo{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReview attempts to authenticate a token to a known user. Note: TokenReview requests may be cached by the webhook token authenticator plugin in the kube-apiserver.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1beta1.TokenReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the token can be authenticated.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1beta1.TokenReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authenticationv1beta1.TokenReviewSpec{}.OpenAPIModelName(), authenticationv1beta1.TokenReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewSpec is a description of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"token": {
						SchemaProps: spec.SchemaProps{
							Description: "Token is the opaque bearer token.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences is a list of the identifiers that the resource server presented with the token identifies as. Audience-aware token authenticators will verify that the token was intended for at least one of the audiences in this list. If no audiences are provided, the audience will default to the audience of the Kubernetes apiserver.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authentication_v1beta1_TokenReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TokenReviewStatus is the result of the token authentication request.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"authenticated": {
						SchemaProps: spec.SchemaProps{
							Description: "Authenticated indicates that the token was associated with a known user.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the UserInfo associated with the provided token.",
							Default:     map[string]interface{}{},
							Ref:         ref(authenticationv1beta1.UserInfo{}.OpenAPIModelName()),
						},
					},
					"audiences": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Audiences are audience identifiers chosen by the authenticator that are compatible with both the TokenReview and token. An identifier is any identifier in the intersection of the TokenReviewSpec audiences and the token's audiences. A client of the TokenReview API that sets the spec.audiences field should validate that a compatible audience identifier is returned in the status.audiences field to ensure that the TokenReview server is audience aware. If a TokenReview returns an empty status.audience field where status.authenticated is \"true\", the token is valid against the audience of the Kubernetes API server.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"error": {
						SchemaProps: spec.SchemaProps{
							Description: "Error indicates that the token couldn't be checked",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			authenticationv1beta1.UserInfo{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authentication_v1beta1_UserInfo(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "UserInfo holds the information about the user needed to implement the user.Info interface.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"username": {
						SchemaProps: spec.SchemaProps{
							Description: "The name that uniquely identifies this user among all active users.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "A unique value that identifies this user across time. If this user is deleted and another user by the same name is added, they will have different UIDs.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "The names of groups this user is a part of.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Any additional information provided by the authenticator.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_FieldSelectorAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FieldSelectorAttributes indicates a field limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"rawSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requirements": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "requirements is the parsed interpretation of a field selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.FieldSelectorRequirement{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			metav1.FieldSelectorRequirement{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_LabelSelectorAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LabelSelectorAttributes indicates a label limited access. Webhook authors are encouraged to * ensure rawSelector and requirements are not both set * consider the requirements field if set * not try to parse or consider the rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting different systems to agree on how exactly to parse a query is not something we want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack for more details. For the *SubjectAccessReview endpoints of the kube-apiserver: * If rawSelector is empty and requirements are empty, the request is not limited. * If rawSelector is present and requirements are empty, the rawSelector will be parsed and limited if the parsing succeeds. * If rawSelector is empty and requirements are present, the requirements should be honored * If rawSelector is present and requirements are present, the request is invalid.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"rawSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "rawSelector is the serialization of a field selector that would be included in a query parameter. Webhook implementations are encouraged to ignore rawSelector. The kube-apiserver's *SubjectAccessReview will parse the rawSelector as long as the requirements are not present.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"requirements": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "requirements is the parsed interpretation of a label selector. All requirements must be met for a resource instance to match the selector. Webhook implementations should handle requirements, but how to handle them is up to the webhook. Since requirements can only limit the request, it is safe to authorize as unlimited request if the requirements are not understood.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(metav1.LabelSelectorRequirement{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			metav1.LabelSelectorRequirement{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_LocalSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1.SubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_NonResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_NonResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceRule holds information that describes a rule for the non-resource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"nonResourceURLs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_ResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.",
							Ref:         ref(authorizationv1.FieldSelectorAttributes{}.OpenAPIModelName()),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.",
							Ref:         ref(authorizationv1.LabelSelectorAttributes{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1.FieldSelectorAttributes{}.OpenAPIModelName(), authorizationv1.LabelSelectorAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_ResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  \"*\" means all in the specified apiGroups.\n \"*/foo\" represents the subresource 'foo' for all resources in the specified apiGroups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  user and groups must be empty",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref(authorizationv1.ResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref(authorizationv1.NonResourceAttributes{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1.NonResourceAttributes{}.OpenAPIModelName(), authorizationv1.ResourceAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectRulesReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates the set of actions a user can perform.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectRulesReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName(), authorizationv1.SubjectRulesReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_SelfSubjectRulesReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace to evaluate rules for. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1.SubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref(authorizationv1.ResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref(authorizationv1.NonResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Groups\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"groups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID information about the requesting user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1.NonResourceAttributes{}.OpenAPIModelName(), authorizationv1.ResourceAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1_SubjectAccessReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required. True if the action would be allowed, false otherwise.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"denied": {
						SchemaProps: spec.SchemaProps{
							Description: "Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1_SubjectRulesReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(authorizationv1.ResourceRule{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"nonResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(authorizationv1.NonResourceRule{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"incomplete": {
						SchemaProps: spec.SchemaProps{
							Description: "Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"resourceRules", "nonResourceRules", "incomplete"},
			},
		},
		Dependencies: []string{
			authorizationv1.NonResourceRule{}.OpenAPIModelName(), authorizationv1.ResourceRule{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_LocalSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "LocalSubjectAccessReview checks whether or not a user or group can perform an action in a given namespace. Having a namespace scoped resource makes it much easier to grant namespace scoped policy that includes permissions checking.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  spec.namespace must be equal to the namespace you made the request against.  If empty, it is defaulted.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.SubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_NonResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceAttributes includes the authorization attributes available for non-resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Description: "Path is the URL path of the request",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is the standard HTTP verb",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_NonResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "NonResourceRule holds information that describes a rule for the non-resource",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes non-resource API verbs, like: get, post, put, delete, patch, head, options.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"nonResourceURLs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_ResourceAttributes(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceAttributes includes the authorization attributes available for resource requests to the Authorizer interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace is the namespace of the action being requested.  Currently, there is no distinction between no namespace and all namespaces \"\" (empty) is defaulted for LocalSubjectAccessReviews \"\" (empty) is empty for cluster-scoped resources \"\" (empty) means \"all\" for namespace scoped resources from a SubjectAccessReview or SelfSubjectAccessReview",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"verb": {
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a kubernetes resource API verb, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						SchemaProps: spec.SchemaProps{
							Description: "Group is the API Group of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"version": {
						SchemaProps: spec.SchemaProps{
							Description: "Version is the API Version of the Resource.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "Resource is one of the existing resource types.  \"*\" means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"subresource": {
						SchemaProps: spec.SchemaProps{
							Description: "Subresource is one of the existing resource types.  \"\" means none.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name is the name of the resource being requested for a \"get\" or deleted for a \"delete\". \"\" (empty) means all.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"fieldSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "fieldSelector describes the limitation on access based on field.  It can only limit access, not broaden it.",
							Ref:         ref(authorizationv1.FieldSelectorAttributes{}.OpenAPIModelName()),
						},
					},
					"labelSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "labelSelector describes the limitation on access based on labels.  It can only limit access, not broaden it.",
							Ref:         ref(authorizationv1.LabelSelectorAttributes{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1.FieldSelectorAttributes{}.OpenAPIModelName(), authorizationv1.LabelSelectorAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_ResourceRule(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceRule is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"verbs": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Verb is a list of kubernetes resource API verbs, like: get, list, watch, create, update, delete, proxy.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"apiGroups": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resources": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Resources is a list of resources this rule applies to.  \"*\" means all in the specified apiGroups.\n \"*/foo\" represents the subresource 'foo' for all resources in the specified apiGroups.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"resourceNames": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.  \"*\" means all.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
				},
				Required: []string{"verbs"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReview checks whether or the current user can perform an action.  Not filling in a spec.namespace means \"in all namespaces\".  Self is a special case, because users should always be able to check whether they can perform an action",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.  user and groups must be empty",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.SelfSubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref(authorizationv1beta1.ResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref(authorizationv1beta1.NonResourceAttributes{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.NonResourceAttributes{}.OpenAPIModelName(), authorizationv1beta1.ResourceAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReview enumerates the set of actions the current user can perform within a namespace. The returned list of actions may be incomplete depending on the server's authorization mode, and any errors experienced during the evaluation. SelfSubjectRulesReview should be used by UIs to show/hide actions, or to quickly let an end user reason about their permissions. It should NOT Be used by external systems to drive authorization decisions as this raises confused deputy, cache lifetime/revocation, and correctness concerns. SubjectAccessReview, and LocalAccessReview are the correct way to defer authorization decisions to the API server.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates the set of actions a user can perform.",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectRulesReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.SelfSubjectRulesReviewSpec{}.OpenAPIModelName(), authorizationv1beta1.SubjectRulesReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_SelfSubjectRulesReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SelfSubjectRulesReviewSpec defines the specification for SelfSubjectRulesReview.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"namespace": {
						SchemaProps: spec.SchemaProps{
							Description: "Namespace to evaluate rules for. Required.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReview(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReview checks whether or not a user or group can perform an action.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "Spec holds information about the request being evaluated",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectAccessReviewSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "Status is filled in by the server and indicates whether the request is allowed or not",
							Default:     map[string]interface{}{},
							Ref:         ref(authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"spec"},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.SubjectAccessReviewSpec{}.OpenAPIModelName(), authorizationv1beta1.SubjectAccessReviewStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "ResourceAuthorizationAttributes describes information for a resource access request",
							Ref:         ref(authorizationv1beta1.ResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"nonResourceAttributes": {
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceAttributes describes information for a non-resource access request",
							Ref:         ref(authorizationv1beta1.NonResourceAttributes{}.OpenAPIModelName()),
						},
					},
					"user": {
						SchemaProps: spec.SchemaProps{
							Description: "User is the user you're testing for. If you specify \"User\" but not \"Group\", then is it interpreted as \"What if User were not a member of any groups",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"group": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "Groups is the groups you're testing for.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: "",
										Type:    []string{"string"},
										Format:  "",
									},
								},
							},
						},
					},
					"extra": {
						SchemaProps: spec.SchemaProps{
							Description: "Extra corresponds to the user.Info.GetExtra() method from the authenticator.  Since that is input to the authorizer it needs a reflection here.",
							Type:        []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type: []string{"array"},
										Items: &spec.SchemaOrArray{
											Schema: &spec.Schema{
												SchemaProps: spec.SchemaProps{
													Default: "",
													Type:    []string{"string"},
													Format:  "",
												},
											},
										},
									},
								},
							},
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Description: "UID information about the requesting user.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.NonResourceAttributes{}.OpenAPIModelName(), authorizationv1beta1.ResourceAttributes{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectAccessReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectAccessReviewStatus",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"allowed": {
						SchemaProps: spec.SchemaProps{
							Description: "Allowed is required. True if the action would be allowed, false otherwise.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"denied": {
						SchemaProps: spec.SchemaProps{
							Description: "Denied is optional. True if the action would be denied, otherwise false. If both allowed is false and denied is false, then the authorizer has no opinion on whether to authorize the action. Denied may not be true if Allowed is true.",
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "Reason is optional.  It indicates why a request was allowed or denied.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError is an indication that some error occurred during the authorization check. It is entirely possible to get an error and be able to continue determine authorization status in spite of it. For instance, RBAC can be missing a role, but enough roles are still present and bound to reason about the request.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"allowed"},
			},
		},
	}
}

func schema_k8sio_api_authorization_v1beta1_SubjectRulesReviewStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SubjectRulesReviewStatus contains the result of a rules check. This check can be incomplete depending on the set of authorizers the server is configured with and any errors experienced during evaluation. Because authorization rules are additive, if a rule appears in a list it's safe to assume the subject has that permission, even if that list is incomplete.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"resourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "ResourceRules is the list of actions the subject is allowed to perform on resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(authorizationv1beta1.ResourceRule{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"nonResourceRules": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "NonResourceRules is the list of actions the subject is allowed to perform on non-resources. The list ordering isn't significant, may contain duplicates, and possibly be incomplete.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(authorizationv1beta1.NonResourceRule{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"incomplete": {
						SchemaProps: spec.SchemaProps{
							Description: "Incomplete is true when the rules returned by this call are incomplete. This is most commonly encountered when an authorizer, such as an external authorizer, doesn't support rules evaluation.",
							Default:     false,
							Type:        []string{"boolean"},
							Format:      "",
						},
					},
					"evaluationError": {
						SchemaProps: spec.SchemaProps{
							Description: "EvaluationError can appear in combination with Rules. It indicates an error occurred during rule evaluation, such as an authorizer that doesn't support rule evaluation, and that ResourceRules and/or NonResourceRules may be incomplete.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"resourceRules", "nonResourceRules", "incomplete"},
			},
		},
		Dependencies: []string{
			authorizationv1beta1.NonResourceRule{}.OpenAPIModelName(), authorizationv1beta1.ResourceRule{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in the requests and limits, describing a single container in each of the pods of the current scale target(e.g. CPU or memory). The values will be averaged together before being compared to the target. Such metrics are built into Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source. Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "container"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling taget",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "currentAverageValue", "container"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "apiVersion is the API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
			VendorExtensible: spec.VendorExtensible{
				Extensions: spec.Extensions{
					"x-kubernetes-map-type": "atomic",
				},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of a metric used for autoscaling in metric system.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of metric averaged over autoscaled pods.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "configuration of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behaviour of autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName(), autoscalingv1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv1.HorizontalPodAutoscaler{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			autoscalingv1.HorizontalPodAutoscaler{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "specification of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "reference to scaled resource; horizontal pod autoscaler will learn the current resource consumption and will set the desired number of pods by using its Scale subresource.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of pods that can be set by the autoscaler; cannot be smaller than MinReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "targetCPUUtilizationPercentage is the target average CPU utilization (represented as a percentage of requested CPU) over all the pods; if not specified the default autoscaling policy will be used.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "current status of a horizontal pod autoscaler",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods; used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is the current number of replicas of pods managed by this autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the  desired number of replicas of pods managed by this autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentCPUUtilizationPercentage": {
						SchemaProps: spec.SchemaProps{
							Description: "currentCPUUtilizationPercentage is the current average CPU utilization over all pods, represented as a percentage of requested CPU, e.g. 70 means that an average pod is using now 70% of its requested CPU.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"currentReplicas", "desiredReplicas"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.\n\nPossible enum values:\n - `\"ContainerResource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).\n - `\"External\"` is a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).\n - `\"Object\"` is a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).\n - `\"Pods\"` is a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.\n - `\"Resource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ContainerResource", "External", "Object", "Pods", "Resource"},
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref(autoscalingv1.ObjectMetricSource{}.OpenAPIModelName()),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref(autoscalingv1.PodsMetricSource{}.OpenAPIModelName()),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv1.ResourceMetricSource{}.OpenAPIModelName()),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv1.ContainerResourceMetricSource{}.OpenAPIModelName()),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref(autoscalingv1.ExternalMetricSource{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			autoscalingv1.ContainerResourceMetricSource{}.OpenAPIModelName(), autoscalingv1.ExternalMetricSource{}.OpenAPIModelName(), autoscalingv1.ObjectMetricSource{}.OpenAPIModelName(), autoscalingv1.PodsMetricSource{}.OpenAPIModelName(), autoscalingv1.ResourceMetricSource{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object.\n\nPossible enum values:\n - `\"ContainerResource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).\n - `\"External\"` is a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).\n - `\"Object\"` is a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).\n - `\"Pods\"` is a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.\n - `\"Resource\"` is a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics (the \"pods\" source).",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
							Enum:        []interface{}{"ContainerResource", "External", "Object", "Pods", "Resource"},
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref(autoscalingv1.ObjectMetricStatus{}.OpenAPIModelName()),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref(autoscalingv1.PodsMetricStatus{}.OpenAPIModelName()),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv1.ResourceMetricStatus{}.OpenAPIModelName()),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv1.ContainerResourceMetricStatus{}.OpenAPIModelName()),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref(autoscalingv1.ExternalMetricStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			autoscalingv1.ContainerResourceMetricStatus{}.OpenAPIModelName(), autoscalingv1.ExternalMetricStatus{}.OpenAPIModelName(), autoscalingv1.ObjectMetricStatus{}.OpenAPIModelName(), autoscalingv1.PodsMetricStatus{}.OpenAPIModelName(), autoscalingv1.ResourceMetricStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity).",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric. When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"target", "metricName", "targetValue"},
			},
		},
		Dependencies: []string{
			autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName(), resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target is the described Kubernetes object.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity).",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the ObjectMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"target", "metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			autoscalingv1.CrossVersionObjectReference{}.OpenAPIModelName(), resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping When unset, just the metricName will be used to gather metrics.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName", "targetAverageValue"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set in the PodsMetricSource, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name", "currentAverageValue"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_Scale(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Scale represents a scaling request for a resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.ScaleSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv1.ScaleStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv1.ScaleSpec{}.OpenAPIModelName(), autoscalingv1.ScaleStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleSpec describes the attributes of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the desired number of instances for the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v1_ScaleStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ScaleStatus represents the current status of a scale subresource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"replicas": {
						SchemaProps: spec.SchemaProps{
							Description: "replicas is the actual number of observed instances of the scaled object.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the label query over pods that should match the replicas count. This is same as the label selector but in the string format to avoid introspection by clients. The string will be in the same format as the query-param syntax. More info about label selectors: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"replicas"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricTarget{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "target", "container"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricTarget{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricValueStatus{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "current", "container"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricValueStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "kind is the kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "apiVersion is the API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricTarget{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricTarget{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricValueStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricValueStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HPAScalingPolicy(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingPolicy is a single policy which must hold true for a specified past interval.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is used to specify the scaling policy.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value contains the amount of change which is permitted by the policy. It must be greater than zero",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"periodSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type", "value", "periodSeconds"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2_HPAScalingRules(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HPAScalingRules configures the scaling behavior for one direction via scaling Policy Rules and a configurable metric tolerance.\n\nScaling Policy Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.\n\nThe tolerance is applied to the metric values and prevents scaling too eagerly for small metric variations. (Note that setting a tolerance requires the beta HPAConfigurableTolerance feature gate to be enabled.)",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"stabilizationWindowSeconds": {
						SchemaProps: spec.SchemaProps{
							Description: "stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"selectPolicy": {
						SchemaProps: spec.SchemaProps{
							Description: "selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"policies": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "policies is a list of potential scaling polices which can be used during scaling. If not set, use the default values: - For scale up: allow doubling the number of pods, or an absolute change of 4 pods in a 15s window. - For scale down: allow all pods to be removed in a 15s window.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2.HPAScalingPolicy{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"tolerance": {
						SchemaProps: spec.SchemaProps{
							Description: "tolerance is the tolerance on the ratio between the current and desired metric value under which no updates are made to the desired number of replicas (e.g. 0.01 for 1%). Must be greater than or equal to zero. If not set, the default cluster-wide tolerance is applied (by default 10%).\n\nFor example, if autoscaling is configured with a memory consumption target of 100Mi, and scale-down and scale-up tolerances of 5% and 1% respectively, scaling will be triggered when the actual consumption falls below 95Mi or exceeds 101Mi.\n\nThis is an beta field and requires the HPAConfigurableTolerance feature gate to be enabled.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv2.HPAScalingPolicy{}.OpenAPIModelName(), resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.HorizontalPodAutoscalerSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.HorizontalPodAutoscalerStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv2.HorizontalPodAutoscalerSpec{}.OpenAPIModelName(), autoscalingv2.HorizontalPodAutoscalerStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerBehavior(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleUp": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleUp is scaling policy for scaling Up. If not set, the default value is the higher of:\n  * increase no more than 4 pods per 60 seconds\n  * double the number of pods per 60 seconds\nNo stabilization is used.",
							Ref:         ref(autoscalingv2.HPAScalingRules{}.OpenAPIModelName()),
						},
					},
					"scaleDown": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleDown is scaling policy for scaling Down. If not set, the default value is to allow to scale down to minReplicas pods, with a 300 second stabilization window (i.e., the highest recommendation for the last 300sec is used).",
							Ref:         ref(autoscalingv2.HPAScalingRules{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv2.HPAScalingRules{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerList is a list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2.HorizontalPodAutoscaler{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			autoscalingv2.HorizontalPodAutoscaler{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond. If not set, the default metric will be set to 80% average CPU utilization.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2.MetricSpec{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"behavior": {
						SchemaProps: spec.SchemaProps{
							Description: "behavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). If not set, the default HPAScalingRules for scale up and scale down are used.",
							Ref:         ref(autoscalingv2.HorizontalPodAutoscalerBehavior{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName(), autoscalingv2.HorizontalPodAutoscalerBehavior{}.OpenAPIModelName(), autoscalingv2.MetricSpec{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerStatus describes the current status of a horizontal pod autoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"observedGeneration": {
						SchemaProps: spec.SchemaProps{
							Description: "observedGeneration is the most recent generation observed by this autoscaler.",
							Type:        []string{"integer"},
							Format:      "int64",
						},
					},
					"lastScaleTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastScaleTime is the last time the HorizontalPodAutoscaler scaled the number of pods, used by the autoscaler to control how often the number of pods is changed.",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"currentReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "currentReplicas is current number of replicas of pods managed by this autoscaler, as last seen by the autoscaler.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"desiredReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "desiredReplicas is the desired number of replicas of pods managed by this autoscaler, as last calculated by the autoscaler.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentMetrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "currentMetrics is the last read state of the metrics used by this autoscaler.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2.MetricStatus{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
					"conditions": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-map-keys": []interface{}{
									"type",
								},
								"x-kubernetes-list-type":       "map",
								"x-kubernetes-patch-merge-key": "type",
								"x-kubernetes-patch-strategy":  "merge",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "conditions is the set of conditions required for this autoscaler to scale its target, and indicates whether or not those conditions are met.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2.HorizontalPodAutoscalerCondition{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"desiredReplicas"},
			},
		},
		Dependencies: []string{
			autoscalingv2.HorizontalPodAutoscalerCondition{}.OpenAPIModelName(), autoscalingv2.MetricStatus{}.OpenAPIModelName(), metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricIdentifier(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricIdentifier defines the name and optionally selector for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the given metric",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"selector": {
						SchemaProps: spec.SchemaProps{
							Description: "selector is the string-encoded form of a standard kubernetes label selector for the given metric When set, it is passed as an additional parameter to the metrics server for more specific metrics scoping. When unset, just the metricName will be used to gather metrics.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricSpec specifies how to scale based on a single metric (only `type` and one other matching field should be set at once).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It should be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each mapping to a matching field in the object.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref(autoscalingv2.ObjectMetricSource{}.OpenAPIModelName()),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref(autoscalingv2.PodsMetricSource{}.OpenAPIModelName()),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv2.ResourceMetricSource{}.OpenAPIModelName()),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "containerResource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod of the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv2.ContainerResourceMetricSource{}.OpenAPIModelName()),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref(autoscalingv2.ExternalMetricSource{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			autoscalingv2.ContainerResourceMetricSource{}.OpenAPIModelName(), autoscalingv2.ExternalMetricSource{}.OpenAPIModelName(), autoscalingv2.ObjectMetricSource{}.OpenAPIModelName(), autoscalingv2.PodsMetricSource{}.OpenAPIModelName(), autoscalingv2.ResourceMetricSource{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricStatus describes the last-read state of a single metric.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type is the type of metric source.  It will be one of \"ContainerResource\", \"External\", \"Object\", \"Pods\" or \"Resource\", each corresponds to a matching field in the object.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"object": {
						SchemaProps: spec.SchemaProps{
							Description: "object refers to a metric describing a single kubernetes object (for example, hits-per-second on an Ingress object).",
							Ref:         ref(autoscalingv2.ObjectMetricStatus{}.OpenAPIModelName()),
						},
					},
					"pods": {
						SchemaProps: spec.SchemaProps{
							Description: "pods refers to a metric describing each pod in the current scale target (for example, transactions-processed-per-second).  The values will be averaged together before being compared to the target value.",
							Ref:         ref(autoscalingv2.PodsMetricStatus{}.OpenAPIModelName()),
						},
					},
					"resource": {
						SchemaProps: spec.SchemaProps{
							Description: "resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv2.ResourceMetricStatus{}.OpenAPIModelName()),
						},
					},
					"containerResource": {
						SchemaProps: spec.SchemaProps{
							Description: "container resource refers to a resource metric (such as those specified in requests and limits) known to Kubernetes describing a single container in each pod in the current scale target (e.g. CPU or memory). Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
							Ref:         ref(autoscalingv2.ContainerResourceMetricStatus{}.OpenAPIModelName()),
						},
					},
					"external": {
						SchemaProps: spec.SchemaProps{
							Description: "external refers to a global metric that is not associated with any Kubernetes object. It allows autoscaling based on information coming from components running outside of cluster (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster).",
							Ref:         ref(autoscalingv2.ExternalMetricStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			autoscalingv2.ContainerResourceMetricStatus{}.OpenAPIModelName(), autoscalingv2.ExternalMetricStatus{}.OpenAPIModelName(), autoscalingv2.ObjectMetricStatus{}.OpenAPIModelName(), autoscalingv2.PodsMetricStatus{}.OpenAPIModelName(), autoscalingv2.ResourceMetricStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricTarget(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricTarget defines the target value, average value, or average utilization of a specific metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type represents whether the metric type is Utilization, Value, or AverageValue",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the target value of the metric (as a quantity).",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the target value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
				Required: []string{"type"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_MetricValueStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "MetricValueStatus holds the current value for a metric",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"value": {
						SchemaProps: spec.SchemaProps{
							Description: "value is the current value of the metric (as a quantity).",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"averageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "averageValue is the current value of the average of the metric across all relevant pods (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"averageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
				},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ObjectMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricSource indicates how to scale on a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "describedObject specifies the descriptions of a object,such as kind,name apiVersion",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricTarget{}.OpenAPIModelName()),
						},
					},
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"describedObject", "target", "metric"},
			},
		},
		Dependencies: []string{
			autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName(), autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricTarget{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ObjectMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMetricStatus indicates the current value of a metric describing a kubernetes object (for example, hits-per-second on an Ingress object).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricValueStatus{}.OpenAPIModelName()),
						},
					},
					"describedObject": {
						SchemaProps: spec.SchemaProps{
							Description: "DescribedObject specifies the descriptions of a object,such as kind,name apiVersion",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metric", "current", "describedObject"},
			},
		},
		Dependencies: []string{
			autoscalingv2.CrossVersionObjectReference{}.OpenAPIModelName(), autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricValueStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_PodsMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricTarget{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metric", "target"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricTarget{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_PodsMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PodsMetricStatus indicates the current value of a metric describing each pod in the current scale target (for example, transactions-processed-per-second).",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metric": {
						SchemaProps: spec.SchemaProps{
							Description: "metric identifies the target metric by name and selector",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricIdentifier{}.OpenAPIModelName()),
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricValueStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metric", "current"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricIdentifier{}.OpenAPIModelName(), autoscalingv2.MetricValueStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"target": {
						SchemaProps: spec.SchemaProps{
							Description: "target specifies the target value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricTarget{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name", "target"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricTarget{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2_ResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"current": {
						SchemaProps: spec.SchemaProps{
							Description: "current contains the current value for the given metric",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2.MetricValueStatus{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"name", "current"},
			},
		},
		Dependencies: []string{
			autoscalingv2.MetricValueStatus{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.  Only one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"targetAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "container"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ContainerResourceMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the \"pods\" source.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "name is the name of the resource in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"currentAverageUtilization": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageUtilization is the current value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods.  It will only be present if `targetAverageValue` was set in the corresponding metric specification.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of the average of the resource metric across all relevant pods, as a raw value (instead of as a percentage of the request), similar to the \"pods\" metric source type. It will always be set, regardless of the corresponding metric specification.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"container": {
						SchemaProps: spec.SchemaProps{
							Description: "container is the name of the container in the pods of the scaling target",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"name", "currentAverageValue", "container"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_CrossVersionObjectReference(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "CrossVersionObjectReference contains enough information to let you identify the referred resource.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind of the referent; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"name": {
						SchemaProps: spec.SchemaProps{
							Description: "Name of the referent; More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "API version of the referent",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"kind", "name"},
			},
		},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ExternalMetricSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricSource indicates how to scale on a metric not associated with any Kubernetes object (for example length of queue in cloud messaging service, or QPS from loadbalancer running outside of cluster). Exactly one \"target\" type should be set.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of the metric in question.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"targetValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetValue is the target value of the metric (as a quantity). Mutually exclusive with TargetAverageValue.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"targetAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "targetAverageValue is the target per-pod value of global metric (as a quantity). Mutually exclusive with TargetValue.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_ExternalMetricStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ExternalMetricStatus indicates the current value of a global metric not associated with any Kubernetes object.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metricName": {
						SchemaProps: spec.SchemaProps{
							Description: "metricName is the name of a metric used for autoscaling in metric system.",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metricSelector": {
						SchemaProps: spec.SchemaProps{
							Description: "metricSelector is used to identify a specific time series within a given metric.",
							Ref:         ref(metav1.LabelSelector{}.OpenAPIModelName()),
						},
					},
					"currentValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentValue is the current value of the metric (as a quantity)",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
					"currentAverageValue": {
						SchemaProps: spec.SchemaProps{
							Description: "currentAverageValue is the current value of metric averaged over autoscaled pods.",
							Ref:         ref(resource.Quantity{}.OpenAPIModelName()),
						},
					},
				},
				Required: []string{"metricName", "currentValue"},
			},
		},
		Dependencies: []string{
			resource.Quantity{}.OpenAPIModelName(), metav1.LabelSelector{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscaler(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is the configuration for a horizontal pod autoscaler, which automatically manages the replica count of any resource implementing the scale subresource based on the metrics specified.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard object metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ObjectMeta{}.OpenAPIModelName()),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Description: "spec is the specification for the behaviour of the autoscaler. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2beta1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName()),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the current information about the autoscaler.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2beta1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName()),
						},
					},
				},
			},
		},
		Dependencies: []string{
			autoscalingv2beta1.HorizontalPodAutoscalerSpec{}.OpenAPIModelName(), autoscalingv2beta1.HorizontalPodAutoscalerStatus{}.OpenAPIModelName(), metav1.ObjectMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerCondition(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerCondition describes the state of a HorizontalPodAutoscaler at a certain point.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "type describes the current condition",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Description: "status is the status of the condition (True, False, Unknown)",
							Default:     "",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"lastTransitionTime": {
						SchemaProps: spec.SchemaProps{
							Description: "lastTransitionTime is the last time the condition transitioned from one status to another",
							Ref:         ref(metav1.Time{}.OpenAPIModelName()),
						},
					},
					"reason": {
						SchemaProps: spec.SchemaProps{
							Description: "reason is the reason for the condition's last transition.",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"message": {
						SchemaProps: spec.SchemaProps{
							Description: "message is a human-readable explanation containing details about the transition",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "status"},
			},
		},
		Dependencies: []string{
			metav1.Time{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerList(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscaler is a list of horizontal pod autoscaler objects.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"kind": {
						SchemaProps: spec.SchemaProps{
							Description: "Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"apiVersion": {
						SchemaProps: spec.SchemaProps{
							Description: "APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "metadata is the standard list metadata.",
							Default:     map[string]interface{}{},
							Ref:         ref(metav1.ListMeta{}.OpenAPIModelName()),
						},
					},
					"items": {
						SchemaProps: spec.SchemaProps{
							Description: "items is the list of horizontal pod autoscaler objects.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2beta1.HorizontalPodAutoscaler{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"items"},
			},
		},
		Dependencies: []string{
			autoscalingv2beta1.HorizontalPodAutoscaler{}.OpenAPIModelName(), metav1.ListMeta{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "HorizontalPodAutoscalerSpec describes the desired functionality of the HorizontalPodAutoscaler.",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"scaleTargetRef": {
						SchemaProps: spec.SchemaProps{
							Description: "scaleTargetRef points to the target resource to scale, and is used to the pods for which metrics should be collected, as well as to actually change the replica count.",
							Default:     map[string]interface{}{},
							Ref:         ref(autoscalingv2beta1.CrossVersionObjectReference{}.OpenAPIModelName()),
						},
					},
					"minReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "minReplicas is the lower limit for the number of replicas to which the autoscaler can scale down.  It defaults to 1 pod.  minReplicas is allowed to be 0 if the alpha feature gate HPAScaleToZero is enabled and at least one Object or External metric is configured.  Scaling is active as long as at least one metric value is available.",
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"maxReplicas": {
						SchemaProps: spec.SchemaProps{
							Description: "maxReplicas is the upper limit for the number of replicas to which the autoscaler can scale up. It cannot be less that minReplicas.",
							Default:     0,
							Type:        []string{"integer"},
							Format:      "int32",
						},
					},
					"metrics": {
						VendorExtensible: spec.VendorExtensible{
							Extensions: spec.Extensions{
								"x-kubernetes-list-type": "atomic",
							},
						},
						SchemaProps: spec.SchemaProps{
							Description: "metrics contains the specifications for which to use to calculate the desired replica count (the maximum replica count across all metrics will be used).  The desired replica count is calculated multiplying the ratio between the target value and the current value by the current number of pods.  Ergo, metrics used must decrease as the pod count is increased, and vice-versa.  See the individual metric source types for more information about how each type of metric must respond.",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Default: map[string]interface{}{},
										Ref:     ref(autoscalingv2beta1.MetricSpec{}.OpenAPIModelName()),
									},
								},
							},
						},
					},
				},
				Required: []string{"scaleTargetRef", "maxReplicas"},
			},
		},
		Dependencies: []string{
			autoscalingv2beta1.CrossVersionObjectReference{}.OpenAPIModelName(), autoscalingv2beta1.MetricSpec{}.OpenAPIModelName()},
	}
}

func schema_k8sio_api_autoscaling_v2beta1_HorizontalPodAutoscalerStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Horizontal