/* eslint-disable */
import * as types from './graphql';
import { TypedDocumentNode as DocumentNode } from '@graphql-typed-document-node/core';

/**
 * Map of all GraphQL operations in the project.
 *
 * This map has several performance disadvantages:
 * 1. It is not tree-shakeable, so it will include all operations in the project.
 * 2. It is not minifiable, so the string of a GraphQL query will be multiple times inside the bundle.
 * 3. It does not support dead code elimination, so it will add unused operations.
 *
 * Therefore it is highly recommended to use the babel or swc plugin for production.
 * Learn more about it here: https://the-guild.dev/graphql/codegen/plugins/presets/preset-client#reducing-bundle-size
 */
type Documents = {
    "\n  fragment ConsoleLoggingResourcesGenericObjectFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesGenericObjectFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesCronJobFragment on BatchV1CronJob {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      jobTemplate {\n        spec {\n          selector {\n            matchLabels\n          }\n        }\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesCronJobFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesDaemonSetFragment on AppsV1DaemonSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesDaemonSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesDeploymentFragment on AppsV1Deployment {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesDeploymentFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesJobFragment on BatchV1Job {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesJobFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesPodFragment on CoreV1Pod {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      containers {\n        name\n      }\n      nodeName\n    }\n    status {\n      containerStatuses {\n        name\n        started\n        state {\n          running {\n            startedAt\n          }\n          terminated {\n            exitCode\n          }\n        }\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesPodFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesReplicaSetFragment on AppsV1ReplicaSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesReplicaSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesStatefulSetFragment on AppsV1StatefulSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesStatefulSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesJobsFindFragment on BatchV1Job {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesJobsFindFragmentFragmentDoc,
    "\n  fragment ConsoleNodesListItemFragment on CoreV1Node {\n    id\n    metadata {\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      labels\n      annotations\n    }\n  }\n": typeof types.ConsoleNodesListItemFragmentFragmentDoc,
    "\n  fragment HealthCheckResponseFragment on HealthCheckResponse {\n    status\n    message\n    timestamp\n  }\n": typeof types.HealthCheckResponseFragmentFragmentDoc,
    "\n  fragment HelmReleaseFragment on HelmRelease {\n    name\n    version\n    namespace\n    chart {\n      metadata {\n        name\n        version\n        appVersion\n      }\n    }\n  }\n": typeof types.HelmReleaseFragmentFragmentDoc,
    "\n  fragment HomeCronJobsListItemFragment on BatchV1CronJob {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeCronJobsListItemFragmentFragmentDoc,
    "\n  fragment HomeDaemonSetsListItemFragment on AppsV1DaemonSet {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeDaemonSetsListItemFragmentFragmentDoc,
    "\n  fragment HomeDeploymentsListItemFragment on AppsV1Deployment {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeDeploymentsListItemFragmentFragmentDoc,
    "\n  fragment HomeJobsListItemFragment on BatchV1Job {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeJobsListItemFragmentFragmentDoc,
    "\n  fragment HomeGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n": typeof types.HomeGenericListFragmentFragmentDoc,
    "\n  fragment HomeGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n": typeof types.HomeGenericListItemFragmentFragmentDoc,
    "\n  fragment HomeNamespacesListItemFragment on CoreV1Namespace {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeNamespacesListItemFragmentFragmentDoc,
    "\n  fragment HomePodsListItemFragment on CoreV1Pod {\n    ...HomeGenericListItemFragment\n    status {\n      containerStatuses {\n        containerID\n        started\n      }\n    }\n  }\n": typeof types.HomePodsListItemFragmentFragmentDoc,
    "\n  fragment HomeReplicaSetsListItemFragment on AppsV1ReplicaSet {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeReplicaSetsListItemFragmentFragmentDoc,
    "\n  fragment HomeStatefulSetsListItemFragment on AppsV1StatefulSet {\n    ...HomeGenericListItemFragment\n  }\n": typeof types.HomeStatefulSetsListItemFragmentFragmentDoc,
    "\n  fragment ClusterAPIServicesListItemFragment on CoreV1Service {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n    spec {\n      ports {\n        name\n        port\n        appProtocol\n      }\n    }\n  }\n": typeof types.ClusterApiServicesListItemFragmentFragmentDoc,
    "\n  fragment KubeConfigFragment on KubeConfig {\n    currentContext\n    contexts {\n      name\n      cluster\n      namespace\n    }\n  }\n": typeof types.KubeConfigFragmentFragmentDoc,
    "\n  fragment LogRecordsFragment on LogRecord {\n    timestamp\n    message\n    source {\n      ...LogSourceFragment\n    }\n  }\n": typeof types.LogRecordsFragmentFragmentDoc,
    "\n  fragment LogSourceFragment on LogSource {\n    metadata {\n      region\n      zone\n      os\n      arch\n      node\n    }\n    namespace\n    podName\n    containerName\n    containerID\n  }\n": typeof types.LogSourceFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericCounterFragment on List {\n    metadata {\n      remainingItemCount\n      resourceVersion\n    }\n    items {\n      ...SourcePickerGenericCounterItemFragment\n    }\n  }\n": typeof types.SourcePickerGenericCounterFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericCounterItemFragment on Object {\n    id\n    metadata {\n      resourceVersion\n    }\n  }\n": typeof types.SourcePickerGenericCounterItemFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n": typeof types.SourcePickerGenericListFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n  }\n": typeof types.SourcePickerGenericListItemFragmentFragmentDoc,
    "\n  query ConsoleLoggingResourcesCronJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1CronJobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesCronJobFragment\n    }\n  }\n": typeof types.ConsoleLoggingResourcesCronJobGetDocument,
    "\n  subscription ConsoleLoggingResourcesCronJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesCronJobFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesCronJobWatchDocument,
    "\n  query ConsoleLoggingResourcesDaemonSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DaemonSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDaemonSetFragment\n    }    \n  }\n": typeof types.ConsoleLoggingResourcesDaemonSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesDaemonSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDaemonSetFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesDaemonSetWatchDocument,
    "\n  query ConsoleLoggingResourcesDeploymentGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DeploymentsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDeploymentFragment\n    }    \n  }\n": typeof types.ConsoleLoggingResourcesDeploymentGetDocument,
    "\n  subscription ConsoleLoggingResourcesDeploymentWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDeploymentFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesDeploymentWatchDocument,
    "\n  query ConsoleLoggingResourcesJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1JobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesJobFragment\n    }\n  }\n": typeof types.ConsoleLoggingResourcesJobGetDocument,
    "\n  subscription ConsoleLoggingResourcesJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesJobWatchDocument,
    "\n  query ConsoleLoggingResourcesPodGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    coreV1PodsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesPodFragment\n    }\n  }\n": typeof types.ConsoleLoggingResourcesPodGetDocument,
    "\n  subscription ConsoleLoggingResourcesPodWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesPodWatchDocument,
    "\n  query ConsolePodsListFetch($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": typeof types.ConsolePodsListFetchDocument,
    "\n  subscription ConsolePodsListWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": typeof types.ConsolePodsListWatchDocument,
    "\n  query ConsoleLoggingResourcesReplicaSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1ReplicaSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesReplicaSetFragment\n    }\n  }\n": typeof types.ConsoleLoggingResourcesReplicaSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesReplicaSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesReplicaSetFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesReplicaSetWatchDocument,
    "\n  query ConsoleLoggingResourcesStatefulSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1StatefulSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesStatefulSetFragment\n    }    \n  }\n": typeof types.ConsoleLoggingResourcesStatefulSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesStatefulSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesStatefulSetFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesStatefulSetWatchDocument,
    "\n  query ConsoleLoggingResourcesJobsFind($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesJobsFindFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesJobsFindDocument,
    "\n  subscription ConsoleStreamsJobsWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n": typeof types.ConsoleStreamsJobsWatchDocument,
    "\n  query ConsoleLoggingResourcesPodsFind($kubeContext: String!, $namespace: String!, $labelSelector: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesPodsFindDocument,
    "\n  subscription ConsoleLoggingResourcesPodsWatch($kubeContext: String!, $namespace: String!, $labelSelector: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": typeof types.ConsoleLoggingResourcesPodsWatchDocument,
    "\n  query ConsoleNodesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NodesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n": typeof types.ConsoleNodesListFetchDocument,
    "\n  subscription ConsoleNodesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NodesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n": typeof types.ConsoleNodesListWatchDocument,
    "\n  query HomeCronJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeCronJobsListFetchDocument,
    "\n  subscription HomeCronJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeCronJobsListWatchDocument,
    "\n  query HomeDaemonSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeDaemonSetsListFetchDocument,
    "\n  subscription HomeDaemonSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeDaemonSetsListWatchDocument,
    "\n  query HomeDeploymentsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeDeploymentsListFetchDocument,
    "\n  subscription HomeDeploymentsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeDeploymentsListWatchDocument,
    "\n  query HomeJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeJobsListFetchDocument,
    "\n  subscription HomeJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeJobsListWatchDocument,
    "\n  query HomeNamespacesListFetch($kubeContext: String, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n": typeof types.HomeNamespacesListFetchDocument,
    "\n  subscription HomeNamespacesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n": typeof types.HomeNamespacesListWatchDocument,
    "\n  query HomePodsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n": typeof types.HomePodsListFetchDocument,
    "\n  subscription HomePodsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n": typeof types.HomePodsListWatchDocument,
    "\n  query HomeReplicaSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeReplicaSetsListFetchDocument,
    "\n  subscription HomeReplicaSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeReplicaSetsListWatchDocument,
    "\n  query HomeStatefulSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeStatefulSetsListFetchDocument,
    "\n  subscription HomeStatefulSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": typeof types.HomeStatefulSetsListWatchDocument,
    "\n  subscription ClusterAPIReadyWait($kubeContext: String!, $namespace: String!, $serviceName: String!) {\n    clusterAPIReadyWait(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName)\n  }\n": typeof types.ClusterApiReadyWaitDocument,
    "\n  query ClusterAPIServicesListFetch($kubeContext: String, $continue: String = \"\") {\n    clusterAPIServicesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }\n  }\n": typeof types.ClusterApiServicesListFetchDocument,
    "\n  subscription ClusterAPIServicesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    clusterAPIServicesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }    \n  }\n": typeof types.ClusterApiServicesListWatchDocument,
    "\n  mutation HelmInstallLatest($kubeContext: String) {\n    helmInstallLatest(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n": typeof types.HelmInstallLatestDocument,
    "\n  query HelmListReleases($kubeContext: String) {\n    helmListReleases(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n": typeof types.HelmListReleasesDocument,
    "\n  query KubeConfigGet {\n    kubeConfigGet {\n      ...KubeConfigFragment\n    }\n  }\n": typeof types.KubeConfigGetDocument,
    "\n  subscription KubeConfigWatch {\n    kubeConfigWatch {\n      type\n      object {\n        ...KubeConfigFragment\n      }\n    }\n  }\n": typeof types.KubeConfigWatchDocument,
    "\n  subscription KubernetesAPIReadyWait($kubeContext: String) {\n    kubernetesAPIReadyWait(kubeContext: $kubeContext)\n  }\n": typeof types.KubernetesApiReadyWaitDocument,
    "\n  query LogRecordsFetch($kubeContext: String, $sources: [String!]!, $mode: LogRecordsQueryMode, $since: String, $until: String, $after: String, $before: String, $grep: String, $sourceFilter: LogSourceFilter, $limit: Int) {\n    logRecordsFetch(kubeContext: $kubeContext, sources: $sources, mode: $mode, since: $since, until: $until, after: $after, before: $before, grep: $grep, sourceFilter: $sourceFilter, limit: $limit) {\n      records {\n        ...LogRecordsFragment\n      }\n      nextCursor\n    }\n  }\n": typeof types.LogRecordsFetchDocument,
    "\n  subscription LogRecordsFollow($kubeContext: String, $sources: [String!]!, $since: String, $after: String, $grep: String, $sourceFilter: LogSourceFilter) {\n    logRecordsFollow(kubeContext: $kubeContext, sources: $sources, since: $since, after: $after, grep: $grep, sourceFilter: $sourceFilter) {\n      ...LogRecordsFragment\n    }\n  }\n": typeof types.LogRecordsFollowDocument,
    "\n  subscription LogSourcesWatch($kubeContext: String, $sources: [String!]!) {\n    logSourcesWatch(kubeContext: $kubeContext, sources: $sources) {\n      type\n      object {\n        ...LogSourceFragment\n      }\n    }\n  }\n": typeof types.LogSourcesWatchDocument,
    "\n  query ServerStatusKubernetesAPIHealthzGet($kubeContext: String!) {\n    kubernetesAPIHealthzGet(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": typeof types.ServerStatusKubernetesApiHealthzGetDocument,
    "\n  subscription ServerStatusKubernetesAPIHealthzWatch($kubeContext: String!) {\n    kubernetesAPIHealthzWatch(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": typeof types.ServerStatusKubernetesApiHealthzWatchDocument,
    "\n  query ServerStatusClusterAPIHealthzGet($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzGet(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": typeof types.ServerStatusClusterApiHealthzGetDocument,
    "\n  subscription ServerStatusClusterAPIHealthzWatch($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzWatch(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": typeof types.ServerStatusClusterApiHealthzWatchDocument,
    "\n  query SourcePickerCronJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerCronJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerCronJobsCountFetchDocument,
    "\n  subscription SourcePickerCronJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerCronJobsCountWatchDocument,
    "\n  query SourcePickerDaemonSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDaemonSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDaemonSetsCountFetchDocument,
    "\n  subscription SourcePickerDaemonSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDaemonSetsCountWatchDocument,
    "\n  query SourcePickerDeploymentsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDeploymentsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDeploymentsCountFetchDocument,
    "\n  subscription SourcePickerDeploymentsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDeploymentsCountWatchDocument,
    "\n  query SourcePickerJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerJobsCountFetchDocument,
    "\n  subscription SourcePickerJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerJobsCountWatchDocument,
    "\n  query SourcePickerPodsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerPodsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerPodsCountFetchDocument,
    "\n  subscription SourcePickerPodsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerPodsCountWatchDocument,
    "\n  query SourcePickerReplicaSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerReplicaSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerReplicaSetsCountFetchDocument,
    "\n  subscription SourcePickerReplicaSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerReplicaSetsCountWatchDocument,
    "\n  query SourcePickerStatefulSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerStatefulSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerStatefulSetsCountFetchDocument,
    "\n  subscription SourcePickerStatefulSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerStatefulSetsCountWatchDocument,
    "\n  query SourcePickerCronJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerCronJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerCronJobsListFetchDocument,
    "\n  subscription SourcePickerCronJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerCronJobsListWatchDocument,
    "\n  query SourcePickerDaemonSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDaemonSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDaemonSetsListFetchDocument,
    "\n  subscription SourcePickerDaemonSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDaemonSetsListWatchDocument,
    "\n  query SourcePickerDeploymentsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDeploymentsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDeploymentsListFetchDocument,
    "\n  subscription SourcePickerDeploymentsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerDeploymentsListWatchDocument,
    "\n  query SourcePickerJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerJobsListFetchDocument,
    "\n  subscription SourcePickerJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerJobsListWatchDocument,
    "\n  query SourcePickerNamespacesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerNamespacesListFetchDocument,
    "\n  subscription SourcePickerNamespacesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerNamespacesListWatchDocument,
    "\n  query SourcePickerPodsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerPodsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerPodsListFetchDocument,
    "\n  subscription SourcePickerPodsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerPodsListWatchDocument,
    "\n  query SourcePickerReplicaSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerReplicaSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerReplicaSetsListFetchDocument,
    "\n  subscription SourcePickerReplicaSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerReplicaSetsListWatchDocument,
    "\n  query SourcePickerStatefulSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerStatefulSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerStatefulSetsListFetchDocument,
    "\n  subscription SourcePickerStatefulSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": typeof types.SourcePickerStatefulSetsListWatchDocument,
};
const documents: Documents = {
    "\n  fragment ConsoleLoggingResourcesGenericObjectFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesGenericObjectFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesCronJobFragment on BatchV1CronJob {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      jobTemplate {\n        spec {\n          selector {\n            matchLabels\n          }\n        }\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesCronJobFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesDaemonSetFragment on AppsV1DaemonSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesDaemonSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesDeploymentFragment on AppsV1Deployment {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesDeploymentFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesJobFragment on BatchV1Job {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesJobFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesPodFragment on CoreV1Pod {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      containers {\n        name\n      }\n      nodeName\n    }\n    status {\n      containerStatuses {\n        name\n        started\n        state {\n          running {\n            startedAt\n          }\n          terminated {\n            exitCode\n          }\n        }\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesPodFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesReplicaSetFragment on AppsV1ReplicaSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesReplicaSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesStatefulSetFragment on AppsV1StatefulSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesStatefulSetFragmentFragmentDoc,
    "\n  fragment ConsoleLoggingResourcesJobsFindFragment on BatchV1Job {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesJobsFindFragmentFragmentDoc,
    "\n  fragment ConsoleNodesListItemFragment on CoreV1Node {\n    id\n    metadata {\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      labels\n      annotations\n    }\n  }\n": types.ConsoleNodesListItemFragmentFragmentDoc,
    "\n  fragment HealthCheckResponseFragment on HealthCheckResponse {\n    status\n    message\n    timestamp\n  }\n": types.HealthCheckResponseFragmentFragmentDoc,
    "\n  fragment HelmReleaseFragment on HelmRelease {\n    name\n    version\n    namespace\n    chart {\n      metadata {\n        name\n        version\n        appVersion\n      }\n    }\n  }\n": types.HelmReleaseFragmentFragmentDoc,
    "\n  fragment HomeCronJobsListItemFragment on BatchV1CronJob {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeCronJobsListItemFragmentFragmentDoc,
    "\n  fragment HomeDaemonSetsListItemFragment on AppsV1DaemonSet {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeDaemonSetsListItemFragmentFragmentDoc,
    "\n  fragment HomeDeploymentsListItemFragment on AppsV1Deployment {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeDeploymentsListItemFragmentFragmentDoc,
    "\n  fragment HomeJobsListItemFragment on BatchV1Job {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeJobsListItemFragmentFragmentDoc,
    "\n  fragment HomeGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n": types.HomeGenericListFragmentFragmentDoc,
    "\n  fragment HomeGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n": types.HomeGenericListItemFragmentFragmentDoc,
    "\n  fragment HomeNamespacesListItemFragment on CoreV1Namespace {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeNamespacesListItemFragmentFragmentDoc,
    "\n  fragment HomePodsListItemFragment on CoreV1Pod {\n    ...HomeGenericListItemFragment\n    status {\n      containerStatuses {\n        containerID\n        started\n      }\n    }\n  }\n": types.HomePodsListItemFragmentFragmentDoc,
    "\n  fragment HomeReplicaSetsListItemFragment on AppsV1ReplicaSet {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeReplicaSetsListItemFragmentFragmentDoc,
    "\n  fragment HomeStatefulSetsListItemFragment on AppsV1StatefulSet {\n    ...HomeGenericListItemFragment\n  }\n": types.HomeStatefulSetsListItemFragmentFragmentDoc,
    "\n  fragment ClusterAPIServicesListItemFragment on CoreV1Service {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n    spec {\n      ports {\n        name\n        port\n        appProtocol\n      }\n    }\n  }\n": types.ClusterApiServicesListItemFragmentFragmentDoc,
    "\n  fragment KubeConfigFragment on KubeConfig {\n    currentContext\n    contexts {\n      name\n      cluster\n      namespace\n    }\n  }\n": types.KubeConfigFragmentFragmentDoc,
    "\n  fragment LogRecordsFragment on LogRecord {\n    timestamp\n    message\n    source {\n      ...LogSourceFragment\n    }\n  }\n": types.LogRecordsFragmentFragmentDoc,
    "\n  fragment LogSourceFragment on LogSource {\n    metadata {\n      region\n      zone\n      os\n      arch\n      node\n    }\n    namespace\n    podName\n    containerName\n    containerID\n  }\n": types.LogSourceFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericCounterFragment on List {\n    metadata {\n      remainingItemCount\n      resourceVersion\n    }\n    items {\n      ...SourcePickerGenericCounterItemFragment\n    }\n  }\n": types.SourcePickerGenericCounterFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericCounterItemFragment on Object {\n    id\n    metadata {\n      resourceVersion\n    }\n  }\n": types.SourcePickerGenericCounterItemFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n": types.SourcePickerGenericListFragmentFragmentDoc,
    "\n  fragment SourcePickerGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n  }\n": types.SourcePickerGenericListItemFragmentFragmentDoc,
    "\n  query ConsoleLoggingResourcesCronJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1CronJobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesCronJobFragment\n    }\n  }\n": types.ConsoleLoggingResourcesCronJobGetDocument,
    "\n  subscription ConsoleLoggingResourcesCronJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesCronJobFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesCronJobWatchDocument,
    "\n  query ConsoleLoggingResourcesDaemonSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DaemonSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDaemonSetFragment\n    }    \n  }\n": types.ConsoleLoggingResourcesDaemonSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesDaemonSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDaemonSetFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesDaemonSetWatchDocument,
    "\n  query ConsoleLoggingResourcesDeploymentGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DeploymentsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDeploymentFragment\n    }    \n  }\n": types.ConsoleLoggingResourcesDeploymentGetDocument,
    "\n  subscription ConsoleLoggingResourcesDeploymentWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDeploymentFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesDeploymentWatchDocument,
    "\n  query ConsoleLoggingResourcesJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1JobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesJobFragment\n    }\n  }\n": types.ConsoleLoggingResourcesJobGetDocument,
    "\n  subscription ConsoleLoggingResourcesJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesJobWatchDocument,
    "\n  query ConsoleLoggingResourcesPodGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    coreV1PodsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesPodFragment\n    }\n  }\n": types.ConsoleLoggingResourcesPodGetDocument,
    "\n  subscription ConsoleLoggingResourcesPodWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesPodWatchDocument,
    "\n  query ConsolePodsListFetch($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": types.ConsolePodsListFetchDocument,
    "\n  subscription ConsolePodsListWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": types.ConsolePodsListWatchDocument,
    "\n  query ConsoleLoggingResourcesReplicaSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1ReplicaSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesReplicaSetFragment\n    }\n  }\n": types.ConsoleLoggingResourcesReplicaSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesReplicaSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesReplicaSetFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesReplicaSetWatchDocument,
    "\n  query ConsoleLoggingResourcesStatefulSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1StatefulSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesStatefulSetFragment\n    }    \n  }\n": types.ConsoleLoggingResourcesStatefulSetGetDocument,
    "\n  subscription ConsoleLoggingResourcesStatefulSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesStatefulSetFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesStatefulSetWatchDocument,
    "\n  query ConsoleLoggingResourcesJobsFind($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesJobsFindFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesJobsFindDocument,
    "\n  subscription ConsoleStreamsJobsWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n": types.ConsoleStreamsJobsWatchDocument,
    "\n  query ConsoleLoggingResourcesPodsFind($kubeContext: String!, $namespace: String!, $labelSelector: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesPodsFindDocument,
    "\n  subscription ConsoleLoggingResourcesPodsWatch($kubeContext: String!, $namespace: String!, $labelSelector: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n": types.ConsoleLoggingResourcesPodsWatchDocument,
    "\n  query ConsoleNodesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NodesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n": types.ConsoleNodesListFetchDocument,
    "\n  subscription ConsoleNodesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NodesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n": types.ConsoleNodesListWatchDocument,
    "\n  query HomeCronJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n": types.HomeCronJobsListFetchDocument,
    "\n  subscription HomeCronJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n": types.HomeCronJobsListWatchDocument,
    "\n  query HomeDaemonSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n": types.HomeDaemonSetsListFetchDocument,
    "\n  subscription HomeDaemonSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n": types.HomeDaemonSetsListWatchDocument,
    "\n  query HomeDeploymentsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n": types.HomeDeploymentsListFetchDocument,
    "\n  subscription HomeDeploymentsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n": types.HomeDeploymentsListWatchDocument,
    "\n  query HomeJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n": types.HomeJobsListFetchDocument,
    "\n  subscription HomeJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n": types.HomeJobsListWatchDocument,
    "\n  query HomeNamespacesListFetch($kubeContext: String, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n": types.HomeNamespacesListFetchDocument,
    "\n  subscription HomeNamespacesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n": types.HomeNamespacesListWatchDocument,
    "\n  query HomePodsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n": types.HomePodsListFetchDocument,
    "\n  subscription HomePodsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n": types.HomePodsListWatchDocument,
    "\n  query HomeReplicaSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n": types.HomeReplicaSetsListFetchDocument,
    "\n  subscription HomeReplicaSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n": types.HomeReplicaSetsListWatchDocument,
    "\n  query HomeStatefulSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": types.HomeStatefulSetsListFetchDocument,
    "\n  subscription HomeStatefulSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": types.HomeStatefulSetsListWatchDocument,
    "\n  subscription ClusterAPIReadyWait($kubeContext: String!, $namespace: String!, $serviceName: String!) {\n    clusterAPIReadyWait(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName)\n  }\n": types.ClusterApiReadyWaitDocument,
    "\n  query ClusterAPIServicesListFetch($kubeContext: String, $continue: String = \"\") {\n    clusterAPIServicesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }\n  }\n": types.ClusterApiServicesListFetchDocument,
    "\n  subscription ClusterAPIServicesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    clusterAPIServicesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }    \n  }\n": types.ClusterApiServicesListWatchDocument,
    "\n  mutation HelmInstallLatest($kubeContext: String) {\n    helmInstallLatest(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n": types.HelmInstallLatestDocument,
    "\n  query HelmListReleases($kubeContext: String) {\n    helmListReleases(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n": types.HelmListReleasesDocument,
    "\n  query KubeConfigGet {\n    kubeConfigGet {\n      ...KubeConfigFragment\n    }\n  }\n": types.KubeConfigGetDocument,
    "\n  subscription KubeConfigWatch {\n    kubeConfigWatch {\n      type\n      object {\n        ...KubeConfigFragment\n      }\n    }\n  }\n": types.KubeConfigWatchDocument,
    "\n  subscription KubernetesAPIReadyWait($kubeContext: String) {\n    kubernetesAPIReadyWait(kubeContext: $kubeContext)\n  }\n": types.KubernetesApiReadyWaitDocument,
    "\n  query LogRecordsFetch($kubeContext: String, $sources: [String!]!, $mode: LogRecordsQueryMode, $since: String, $until: String, $after: String, $before: String, $grep: String, $sourceFilter: LogSourceFilter, $limit: Int) {\n    logRecordsFetch(kubeContext: $kubeContext, sources: $sources, mode: $mode, since: $since, until: $until, after: $after, before: $before, grep: $grep, sourceFilter: $sourceFilter, limit: $limit) {\n      records {\n        ...LogRecordsFragment\n      }\n      nextCursor\n    }\n  }\n": types.LogRecordsFetchDocument,
    "\n  subscription LogRecordsFollow($kubeContext: String, $sources: [String!]!, $since: String, $after: String, $grep: String, $sourceFilter: LogSourceFilter) {\n    logRecordsFollow(kubeContext: $kubeContext, sources: $sources, since: $since, after: $after, grep: $grep, sourceFilter: $sourceFilter) {\n      ...LogRecordsFragment\n    }\n  }\n": types.LogRecordsFollowDocument,
    "\n  subscription LogSourcesWatch($kubeContext: String, $sources: [String!]!) {\n    logSourcesWatch(kubeContext: $kubeContext, sources: $sources) {\n      type\n      object {\n        ...LogSourceFragment\n      }\n    }\n  }\n": types.LogSourcesWatchDocument,
    "\n  query ServerStatusKubernetesAPIHealthzGet($kubeContext: String!) {\n    kubernetesAPIHealthzGet(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": types.ServerStatusKubernetesApiHealthzGetDocument,
    "\n  subscription ServerStatusKubernetesAPIHealthzWatch($kubeContext: String!) {\n    kubernetesAPIHealthzWatch(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": types.ServerStatusKubernetesApiHealthzWatchDocument,
    "\n  query ServerStatusClusterAPIHealthzGet($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzGet(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": types.ServerStatusClusterApiHealthzGetDocument,
    "\n  subscription ServerStatusClusterAPIHealthzWatch($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzWatch(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n": types.ServerStatusClusterApiHealthzWatchDocument,
    "\n  query SourcePickerCronJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerCronJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerCronJobsCountFetchDocument,
    "\n  subscription SourcePickerCronJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerCronJobsCountWatchDocument,
    "\n  query SourcePickerDaemonSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDaemonSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerDaemonSetsCountFetchDocument,
    "\n  subscription SourcePickerDaemonSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerDaemonSetsCountWatchDocument,
    "\n  query SourcePickerDeploymentsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDeploymentsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerDeploymentsCountFetchDocument,
    "\n  subscription SourcePickerDeploymentsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerDeploymentsCountWatchDocument,
    "\n  query SourcePickerJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerJobsCountFetchDocument,
    "\n  subscription SourcePickerJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerJobsCountWatchDocument,
    "\n  query SourcePickerPodsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerPodsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerPodsCountFetchDocument,
    "\n  subscription SourcePickerPodsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerPodsCountWatchDocument,
    "\n  query SourcePickerReplicaSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerReplicaSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerReplicaSetsCountFetchDocument,
    "\n  subscription SourcePickerReplicaSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerReplicaSetsCountWatchDocument,
    "\n  query SourcePickerStatefulSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerStatefulSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerStatefulSetsCountFetchDocument,
    "\n  subscription SourcePickerStatefulSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n": types.SourcePickerStatefulSetsCountWatchDocument,
    "\n  query SourcePickerCronJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerCronJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerCronJobsListFetchDocument,
    "\n  subscription SourcePickerCronJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerCronJobsListWatchDocument,
    "\n  query SourcePickerDaemonSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDaemonSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerDaemonSetsListFetchDocument,
    "\n  subscription SourcePickerDaemonSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerDaemonSetsListWatchDocument,
    "\n  query SourcePickerDeploymentsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDeploymentsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerDeploymentsListFetchDocument,
    "\n  subscription SourcePickerDeploymentsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerDeploymentsListWatchDocument,
    "\n  query SourcePickerJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerJobsListFetchDocument,
    "\n  subscription SourcePickerJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerJobsListWatchDocument,
    "\n  query SourcePickerNamespacesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerNamespacesListFetchDocument,
    "\n  subscription SourcePickerNamespacesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerNamespacesListWatchDocument,
    "\n  query SourcePickerPodsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerPodsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerPodsListFetchDocument,
    "\n  subscription SourcePickerPodsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerPodsListWatchDocument,
    "\n  query SourcePickerReplicaSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerReplicaSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerReplicaSetsListFetchDocument,
    "\n  subscription SourcePickerReplicaSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerReplicaSetsListWatchDocument,
    "\n  query SourcePickerStatefulSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerStatefulSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n": types.SourcePickerStatefulSetsListFetchDocument,
    "\n  subscription SourcePickerStatefulSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n": types.SourcePickerStatefulSetsListWatchDocument,
};

/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 *
 *
 * @example
 * ```ts
 * const query = gql(`query GetUser($id: ID!) { user(id: $id) { name } }`);
 * ```
 *
 * The query argument is unknown!
 * Please regenerate the types.
 */
export function gql(source: string): unknown;

/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesGenericObjectFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesGenericObjectFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesCronJobFragment on BatchV1CronJob {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      jobTemplate {\n        spec {\n          selector {\n            matchLabels\n          }\n        }\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesCronJobFragment on BatchV1CronJob {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      jobTemplate {\n        spec {\n          selector {\n            matchLabels\n          }\n        }\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesDaemonSetFragment on AppsV1DaemonSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesDaemonSetFragment on AppsV1DaemonSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesDeploymentFragment on AppsV1Deployment {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesDeploymentFragment on AppsV1Deployment {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesJobFragment on BatchV1Job {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesJobFragment on BatchV1Job {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesPodFragment on CoreV1Pod {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      containers {\n        name\n      }\n      nodeName\n    }\n    status {\n      containerStatuses {\n        name\n        started\n        state {\n          running {\n            startedAt\n          }\n          terminated {\n            exitCode\n          }\n        }\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesPodFragment on CoreV1Pod {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      containers {\n        name\n      }\n      nodeName\n    }\n    status {\n      containerStatuses {\n        name\n        started\n        state {\n          running {\n            startedAt\n          }\n          terminated {\n            exitCode\n          }\n        }\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesReplicaSetFragment on AppsV1ReplicaSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesReplicaSetFragment on AppsV1ReplicaSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesStatefulSetFragment on AppsV1StatefulSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesStatefulSetFragment on AppsV1StatefulSet {\n    ...ConsoleLoggingResourcesGenericObjectFragment\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleLoggingResourcesJobsFindFragment on BatchV1Job {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleLoggingResourcesJobsFindFragment on BatchV1Job {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n    spec {\n      selector {\n        matchLabels\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ConsoleNodesListItemFragment on CoreV1Node {\n    id\n    metadata {\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      labels\n      annotations\n    }\n  }\n"): (typeof documents)["\n  fragment ConsoleNodesListItemFragment on CoreV1Node {\n    id\n    metadata {\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      labels\n      annotations\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HealthCheckResponseFragment on HealthCheckResponse {\n    status\n    message\n    timestamp\n  }\n"): (typeof documents)["\n  fragment HealthCheckResponseFragment on HealthCheckResponse {\n    status\n    message\n    timestamp\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HelmReleaseFragment on HelmRelease {\n    name\n    version\n    namespace\n    chart {\n      metadata {\n        name\n        version\n        appVersion\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment HelmReleaseFragment on HelmRelease {\n    name\n    version\n    namespace\n    chart {\n      metadata {\n        name\n        version\n        appVersion\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeCronJobsListItemFragment on BatchV1CronJob {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeCronJobsListItemFragment on BatchV1CronJob {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeDaemonSetsListItemFragment on AppsV1DaemonSet {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeDaemonSetsListItemFragment on AppsV1DaemonSet {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeDeploymentsListItemFragment on AppsV1Deployment {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeDeploymentsListItemFragment on AppsV1Deployment {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeJobsListItemFragment on BatchV1Job {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeJobsListItemFragment on BatchV1Job {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n"): (typeof documents)["\n  fragment HomeGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment HomeGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n      ownerReferences {\n        name\n        uid\n        controller\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeNamespacesListItemFragment on CoreV1Namespace {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeNamespacesListItemFragment on CoreV1Namespace {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomePodsListItemFragment on CoreV1Pod {\n    ...HomeGenericListItemFragment\n    status {\n      containerStatuses {\n        containerID\n        started\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment HomePodsListItemFragment on CoreV1Pod {\n    ...HomeGenericListItemFragment\n    status {\n      containerStatuses {\n        containerID\n        started\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeReplicaSetsListItemFragment on AppsV1ReplicaSet {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeReplicaSetsListItemFragment on AppsV1ReplicaSet {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment HomeStatefulSetsListItemFragment on AppsV1StatefulSet {\n    ...HomeGenericListItemFragment\n  }\n"): (typeof documents)["\n  fragment HomeStatefulSetsListItemFragment on AppsV1StatefulSet {\n    ...HomeGenericListItemFragment\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment ClusterAPIServicesListItemFragment on CoreV1Service {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n    spec {\n      ports {\n        name\n        port\n        appProtocol\n      }\n    }\n  }\n"): (typeof documents)["\n  fragment ClusterAPIServicesListItemFragment on CoreV1Service {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n    spec {\n      ports {\n        name\n        port\n        appProtocol\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment KubeConfigFragment on KubeConfig {\n    currentContext\n    contexts {\n      name\n      cluster\n      namespace\n    }\n  }\n"): (typeof documents)["\n  fragment KubeConfigFragment on KubeConfig {\n    currentContext\n    contexts {\n      name\n      cluster\n      namespace\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment LogRecordsFragment on LogRecord {\n    timestamp\n    message\n    source {\n      ...LogSourceFragment\n    }\n  }\n"): (typeof documents)["\n  fragment LogRecordsFragment on LogRecord {\n    timestamp\n    message\n    source {\n      ...LogSourceFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment LogSourceFragment on LogSource {\n    metadata {\n      region\n      zone\n      os\n      arch\n      node\n    }\n    namespace\n    podName\n    containerName\n    containerID\n  }\n"): (typeof documents)["\n  fragment LogSourceFragment on LogSource {\n    metadata {\n      region\n      zone\n      os\n      arch\n      node\n    }\n    namespace\n    podName\n    containerName\n    containerID\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment SourcePickerGenericCounterFragment on List {\n    metadata {\n      remainingItemCount\n      resourceVersion\n    }\n    items {\n      ...SourcePickerGenericCounterItemFragment\n    }\n  }\n"): (typeof documents)["\n  fragment SourcePickerGenericCounterFragment on List {\n    metadata {\n      remainingItemCount\n      resourceVersion\n    }\n    items {\n      ...SourcePickerGenericCounterItemFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment SourcePickerGenericCounterItemFragment on Object {\n    id\n    metadata {\n      resourceVersion\n    }\n  }\n"): (typeof documents)["\n  fragment SourcePickerGenericCounterItemFragment on Object {\n    id\n    metadata {\n      resourceVersion\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment SourcePickerGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n"): (typeof documents)["\n  fragment SourcePickerGenericListFragment on List {\n    metadata {\n      continue\n      resourceVersion\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  fragment SourcePickerGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n  }\n"): (typeof documents)["\n  fragment SourcePickerGenericListItemFragment on Object {\n    id\n    metadata {\n      namespace\n      name\n      uid\n      creationTimestamp\n      deletionTimestamp\n      resourceVersion\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesCronJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1CronJobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesCronJobFragment\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesCronJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1CronJobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesCronJobFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesCronJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesCronJobFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesCronJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesCronJobFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesDaemonSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DaemonSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDaemonSetFragment\n    }    \n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesDaemonSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DaemonSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDaemonSetFragment\n    }    \n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesDaemonSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDaemonSetFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesDaemonSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDaemonSetFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesDeploymentGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DeploymentsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDeploymentFragment\n    }    \n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesDeploymentGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1DeploymentsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesDeploymentFragment\n    }    \n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesDeploymentWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDeploymentFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesDeploymentWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesDeploymentFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1JobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesJobFragment\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesJobGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    batchV1JobsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesJobFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesJobWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesPodGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    coreV1PodsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesPodFragment\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesPodGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    coreV1PodsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesPodFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesPodWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesPodWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsolePodsListFetch($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query ConsolePodsListFetch($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsolePodsListWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsolePodsListWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesReplicaSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1ReplicaSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesReplicaSetFragment\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesReplicaSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1ReplicaSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesReplicaSetFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesReplicaSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesReplicaSetFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesReplicaSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesReplicaSetFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesStatefulSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1StatefulSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesStatefulSetFragment\n    }    \n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesStatefulSetGet($kubeContext: String!, $namespace: String!, $name: String!) {\n    appsV1StatefulSetsGet(kubeContext: $kubeContext, namespace: $namespace, name: $name) {\n      ...ConsoleLoggingResourcesStatefulSetFragment\n    }    \n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesStatefulSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesStatefulSetFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesStatefulSetWatch($kubeContext: String!, $namespace: String!, $fieldSelector: String!) {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { fieldSelector: $fieldSelector }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesStatefulSetFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesJobsFind($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesJobsFindFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesJobsFind($kubeContext: String!, $namespace: String!, $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesJobsFindFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleStreamsJobsWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleStreamsJobsWatch($kubeContext: String!, $namespace: String!, $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesJobFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleLoggingResourcesPodsFind($kubeContext: String!, $namespace: String!, $labelSelector: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query ConsoleLoggingResourcesPodsFind($kubeContext: String!, $namespace: String!, $labelSelector: String!, $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleLoggingResourcesPodsWatch($kubeContext: String!, $namespace: String!, $labelSelector: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleLoggingResourcesPodsWatch($kubeContext: String!, $namespace: String!, $labelSelector: String!, $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { labelSelector: $labelSelector, resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleLoggingResourcesPodFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ConsoleNodesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NodesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query ConsoleNodesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NodesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ConsoleNodesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NodesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription ConsoleNodesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NodesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ConsoleNodesListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeCronJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeCronJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeCronJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeCronJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeCronJobsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeDaemonSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeDaemonSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeDaemonSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeDaemonSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDaemonSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeDeploymentsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeDeploymentsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeDeploymentsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeDeploymentsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeDeploymentsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeJobsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeJobsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeJobsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeNamespacesListFetch($kubeContext: String, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeNamespacesListFetch($kubeContext: String, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeNamespacesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeNamespacesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeNamespacesListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomePodsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomePodsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomePodsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomePodsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomePodsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeReplicaSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeReplicaSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeReplicaSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeReplicaSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeReplicaSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HomeStatefulSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query HomeStatefulSetsListFetch($kubeContext: String, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) {\n      ...HomeGenericListFragment\n      items {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription HomeStatefulSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription HomeStatefulSetsListWatch($kubeContext: String, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ClusterAPIReadyWait($kubeContext: String!, $namespace: String!, $serviceName: String!) {\n    clusterAPIReadyWait(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName)\n  }\n"): (typeof documents)["\n  subscription ClusterAPIReadyWait($kubeContext: String!, $namespace: String!, $serviceName: String!) {\n    clusterAPIReadyWait(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName)\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ClusterAPIServicesListFetch($kubeContext: String, $continue: String = \"\") {\n    clusterAPIServicesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query ClusterAPIServicesListFetch($kubeContext: String, $continue: String = \"\") {\n    clusterAPIServicesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      metadata {\n        continue\n        resourceVersion\n      }\n      items {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ClusterAPIServicesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    clusterAPIServicesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }    \n  }\n"): (typeof documents)["\n  subscription ClusterAPIServicesListWatch($kubeContext: String, $resourceVersion: String = \"\") {\n    clusterAPIServicesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...ClusterAPIServicesListItemFragment\n      }\n    }    \n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  mutation HelmInstallLatest($kubeContext: String) {\n    helmInstallLatest(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n"): (typeof documents)["\n  mutation HelmInstallLatest($kubeContext: String) {\n    helmInstallLatest(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query HelmListReleases($kubeContext: String) {\n    helmListReleases(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n"): (typeof documents)["\n  query HelmListReleases($kubeContext: String) {\n    helmListReleases(kubeContext: $kubeContext) {\n      ...HelmReleaseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query KubeConfigGet {\n    kubeConfigGet {\n      ...KubeConfigFragment\n    }\n  }\n"): (typeof documents)["\n  query KubeConfigGet {\n    kubeConfigGet {\n      ...KubeConfigFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription KubeConfigWatch {\n    kubeConfigWatch {\n      type\n      object {\n        ...KubeConfigFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription KubeConfigWatch {\n    kubeConfigWatch {\n      type\n      object {\n        ...KubeConfigFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription KubernetesAPIReadyWait($kubeContext: String) {\n    kubernetesAPIReadyWait(kubeContext: $kubeContext)\n  }\n"): (typeof documents)["\n  subscription KubernetesAPIReadyWait($kubeContext: String) {\n    kubernetesAPIReadyWait(kubeContext: $kubeContext)\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query LogRecordsFetch($kubeContext: String, $sources: [String!]!, $mode: LogRecordsQueryMode, $since: String, $until: String, $after: String, $before: String, $grep: String, $sourceFilter: LogSourceFilter, $limit: Int) {\n    logRecordsFetch(kubeContext: $kubeContext, sources: $sources, mode: $mode, since: $since, until: $until, after: $after, before: $before, grep: $grep, sourceFilter: $sourceFilter, limit: $limit) {\n      records {\n        ...LogRecordsFragment\n      }\n      nextCursor\n    }\n  }\n"): (typeof documents)["\n  query LogRecordsFetch($kubeContext: String, $sources: [String!]!, $mode: LogRecordsQueryMode, $since: String, $until: String, $after: String, $before: String, $grep: String, $sourceFilter: LogSourceFilter, $limit: Int) {\n    logRecordsFetch(kubeContext: $kubeContext, sources: $sources, mode: $mode, since: $since, until: $until, after: $after, before: $before, grep: $grep, sourceFilter: $sourceFilter, limit: $limit) {\n      records {\n        ...LogRecordsFragment\n      }\n      nextCursor\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription LogRecordsFollow($kubeContext: String, $sources: [String!]!, $since: String, $after: String, $grep: String, $sourceFilter: LogSourceFilter) {\n    logRecordsFollow(kubeContext: $kubeContext, sources: $sources, since: $since, after: $after, grep: $grep, sourceFilter: $sourceFilter) {\n      ...LogRecordsFragment\n    }\n  }\n"): (typeof documents)["\n  subscription LogRecordsFollow($kubeContext: String, $sources: [String!]!, $since: String, $after: String, $grep: String, $sourceFilter: LogSourceFilter) {\n    logRecordsFollow(kubeContext: $kubeContext, sources: $sources, since: $since, after: $after, grep: $grep, sourceFilter: $sourceFilter) {\n      ...LogRecordsFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription LogSourcesWatch($kubeContext: String, $sources: [String!]!) {\n    logSourcesWatch(kubeContext: $kubeContext, sources: $sources) {\n      type\n      object {\n        ...LogSourceFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription LogSourcesWatch($kubeContext: String, $sources: [String!]!) {\n    logSourcesWatch(kubeContext: $kubeContext, sources: $sources) {\n      type\n      object {\n        ...LogSourceFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ServerStatusKubernetesAPIHealthzGet($kubeContext: String!) {\n    kubernetesAPIHealthzGet(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"): (typeof documents)["\n  query ServerStatusKubernetesAPIHealthzGet($kubeContext: String!) {\n    kubernetesAPIHealthzGet(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ServerStatusKubernetesAPIHealthzWatch($kubeContext: String!) {\n    kubernetesAPIHealthzWatch(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"): (typeof documents)["\n  subscription ServerStatusKubernetesAPIHealthzWatch($kubeContext: String!) {\n    kubernetesAPIHealthzWatch(kubeContext: $kubeContext) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query ServerStatusClusterAPIHealthzGet($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzGet(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"): (typeof documents)["\n  query ServerStatusClusterAPIHealthzGet($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzGet(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription ServerStatusClusterAPIHealthzWatch($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzWatch(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"): (typeof documents)["\n  subscription ServerStatusClusterAPIHealthzWatch($kubeContext: String!, $namespace: String, $serviceName: String) {\n    clusterAPIHealthzWatch(kubeContext: $kubeContext, namespace: $namespace, serviceName: $serviceName) {\n      ...HealthCheckResponseFragment\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerCronJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerCronJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerCronJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerCronJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerCronJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerCronJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerDaemonSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDaemonSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerDaemonSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDaemonSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerDaemonSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerDaemonSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerDeploymentsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDeploymentsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerDeploymentsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerDeploymentsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerDeploymentsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerDeploymentsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerJobsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerJobsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerJobsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerPodsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerPodsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerPodsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerPodsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerPodsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerPodsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerReplicaSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerReplicaSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerReplicaSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerReplicaSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerReplicaSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerReplicaSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerStatefulSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerStatefulSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerStatefulSetsCountFetch($kubeContext: String!, $namespace: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"1\" }) @connection(key: \"SourcePickerStatefulSetsCountFetch\") {\n      ...SourcePickerGenericCounterFragment\n      items {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerStatefulSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerStatefulSetsCountWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericCounterItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerCronJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerCronJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerCronJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1CronJobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerCronJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerCronJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerCronJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1CronJobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerDaemonSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDaemonSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerDaemonSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DaemonSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDaemonSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerDaemonSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerDaemonSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DaemonSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerDeploymentsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDeploymentsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerDeploymentsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1DeploymentsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerDeploymentsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerDeploymentsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerDeploymentsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1DeploymentsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerJobsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    batchV1JobsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerJobsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerJobsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    batchV1JobsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerNamespacesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerNamespacesListFetch($kubeContext: String!, $continue: String = \"\") {\n    coreV1NamespacesList(kubeContext: $kubeContext, options: { limit: \"50\", continue: $continue }) {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerNamespacesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerNamespacesListWatch($kubeContext: String!, $resourceVersion: String = \"\") {\n    coreV1NamespacesWatch(kubeContext: $kubeContext, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerPodsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerPodsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerPodsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    coreV1PodsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerPodsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerPodsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerPodsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    coreV1PodsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerReplicaSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerReplicaSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerReplicaSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1ReplicaSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerReplicaSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerReplicaSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerReplicaSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1ReplicaSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  query SourcePickerStatefulSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerStatefulSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  query SourcePickerStatefulSetsListFetch($kubeContext: String!, $namespace: String = \"\", $continue: String = \"\") {\n    appsV1StatefulSetsList(kubeContext: $kubeContext, namespace: $namespace, options: { limit: \"50\", continue: $continue }) @connection(key: \"SourcePickerStatefulSetsListFetch\") {\n      ...SourcePickerGenericListFragment\n      items {\n        ...SourcePickerGenericListItemFragment\n      }\n    }\n  }\n"];
/**
 * The gql function is used to parse GraphQL queries into a document that can be used by GraphQL clients.
 */
export function gql(source: "\n  subscription SourcePickerStatefulSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"): (typeof documents)["\n  subscription SourcePickerStatefulSetsListWatch($kubeContext: String!, $namespace: String = \"\", $resourceVersion: String = \"\") {\n    appsV1StatefulSetsWatch(kubeContext: $kubeContext, namespace: $namespace, options: { resourceVersion: $resourceVersion }) {\n      type\n      object {\n        ...HomeStatefulSetsListItemFragment\n      }\n    }\n  }\n"];

export function gql(source: string) {
  return (documents as any)[source] ?? {};
}

export type DocumentType<TDocumentNode extends DocumentNode<any, any>> = TDocumentNode extends DocumentNode<  infer TType,  any>  ? TType  : never;