/* eslint-disable */
import { TypedDocumentNode as DocumentNode } from '@graphql-typed-document-node/core';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> = T | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: { input: string; output: string; }
  String: { input: string; output: string; }
  Boolean: { input: boolean; output: boolean; }
  Int: { input: number; output: number; }
  Float: { input: number; output: number; }
  AppsV1DaemonSetConditionType: { input: any; output: any; }
  /** A 64-bit integer. */
  Int64: { input: any; output: any; }
  KubeConfigExtensions: { input: any; output: any; }
  /** An ISO-8601 encoded UTC date string. */
  MetaV1Time: { input: any; output: any; }
  /** An arbitrary dictionary with string values */
  StringMap: { input: any; output: any; }
  /** An ISO-8601 encoded UTC date string. */
  Time: { input: any; output: any; }
};

export type AppsV1DaemonSet = Object & {
  __typename?: 'AppsV1DaemonSet';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: AppsV1DaemonSetSpec;
  status: AppsV1DaemonSetStatus;
};

export type AppsV1DaemonSetCondition = {
  __typename?: 'AppsV1DaemonSetCondition';
  lastTransitionTime: Scalars['MetaV1Time']['output'];
  message: Scalars['String']['output'];
  reason: Scalars['String']['output'];
  status: CoreV1ConditionStatus;
  type: Scalars['AppsV1DaemonSetConditionType']['output'];
};

export type AppsV1DaemonSetList = List & {
  __typename?: 'AppsV1DaemonSetList';
  apiVersion: Scalars['String']['output'];
  items: Array<AppsV1DaemonSet>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type AppsV1DaemonSetSpec = {
  __typename?: 'AppsV1DaemonSetSpec';
  selector?: Maybe<MetaV1LabelSelector>;
};

export type AppsV1DaemonSetStatus = {
  __typename?: 'AppsV1DaemonSetStatus';
  conditions: Array<AppsV1DaemonSetCondition>;
  currentNumberScheduled: Scalars['Int']['output'];
  desiredNumberScheduled: Scalars['Int']['output'];
  numberAvailable: Scalars['Int']['output'];
  numberMisscheduled: Scalars['Int']['output'];
  numberReady: Scalars['Int']['output'];
  numberUnavailable: Scalars['Int']['output'];
  observedGeneration: Scalars['Int64']['output'];
  updatedNumberScheduled: Scalars['Int']['output'];
};

export type AppsV1DaemonSetsWatchEvent = {
  __typename?: 'AppsV1DaemonSetsWatchEvent';
  object?: Maybe<AppsV1DaemonSet>;
  type: WatchEventType;
};

export type AppsV1Deployment = Object & {
  __typename?: 'AppsV1Deployment';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: AppsV1DeploymentSpec;
  status: AppsV1DeploymentStatus;
};

export type AppsV1DeploymentList = List & {
  __typename?: 'AppsV1DeploymentList';
  apiVersion: Scalars['String']['output'];
  items: Array<AppsV1Deployment>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type AppsV1DeploymentSpec = {
  __typename?: 'AppsV1DeploymentSpec';
  paused: Scalars['Boolean']['output'];
  replicas?: Maybe<Scalars['Int']['output']>;
  selector?: Maybe<MetaV1LabelSelector>;
};

export type AppsV1DeploymentStatus = {
  __typename?: 'AppsV1DeploymentStatus';
  replicas: Scalars['Int']['output'];
};

export type AppsV1DeploymentsWatchEvent = {
  __typename?: 'AppsV1DeploymentsWatchEvent';
  object?: Maybe<AppsV1Deployment>;
  type: WatchEventType;
};

export type AppsV1ReplicaSet = Object & {
  __typename?: 'AppsV1ReplicaSet';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: AppsV1ReplicaSetSpec;
  status: AppsV1ReplicaSetStatus;
};

export type AppsV1ReplicaSetList = List & {
  __typename?: 'AppsV1ReplicaSetList';
  apiVersion: Scalars['String']['output'];
  items: Array<AppsV1ReplicaSet>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type AppsV1ReplicaSetSpec = {
  __typename?: 'AppsV1ReplicaSetSpec';
  replicas?: Maybe<Scalars['Int']['output']>;
  selector?: Maybe<MetaV1LabelSelector>;
};

export type AppsV1ReplicaSetStatus = {
  __typename?: 'AppsV1ReplicaSetStatus';
  replicas: Scalars['Int']['output'];
};

export type AppsV1ReplicaSetsWatchEvent = {
  __typename?: 'AppsV1ReplicaSetsWatchEvent';
  object?: Maybe<AppsV1ReplicaSet>;
  type: WatchEventType;
};

export type AppsV1StatefulSet = Object & {
  __typename?: 'AppsV1StatefulSet';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: AppsV1StatefulSetSpec;
};

export type AppsV1StatefulSetList = List & {
  __typename?: 'AppsV1StatefulSetList';
  apiVersion: Scalars['String']['output'];
  items: Array<AppsV1StatefulSet>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type AppsV1StatefulSetSpec = {
  __typename?: 'AppsV1StatefulSetSpec';
  replicas?: Maybe<Scalars['Int']['output']>;
  selector?: Maybe<MetaV1LabelSelector>;
};

export type AppsV1StatefulSetsWatchEvent = {
  __typename?: 'AppsV1StatefulSetsWatchEvent';
  object?: Maybe<AppsV1StatefulSet>;
  type: WatchEventType;
};

export type BatchV1CronJob = Object & {
  __typename?: 'BatchV1CronJob';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: BatchV1CronJobSpec;
  status: BatchV1CronJobStatus;
};

export type BatchV1CronJobList = List & {
  __typename?: 'BatchV1CronJobList';
  apiVersion: Scalars['String']['output'];
  items: Array<BatchV1CronJob>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type BatchV1CronJobSpec = {
  __typename?: 'BatchV1CronJobSpec';
  failedJobsHistoryLimit?: Maybe<Scalars['Int']['output']>;
  jobTemplate: BatchV1JobTemplateSpec;
  schedule: Scalars['String']['output'];
  successfulJobsHistoryLimit?: Maybe<Scalars['Int']['output']>;
  suspend?: Maybe<Scalars['Boolean']['output']>;
  timeZone?: Maybe<Scalars['String']['output']>;
};

export type BatchV1CronJobStatus = {
  __typename?: 'BatchV1CronJobStatus';
  active: Array<CoreV1ObjectReference>;
  lastScheduleTime?: Maybe<Scalars['MetaV1Time']['output']>;
  lastSuccessfulTime?: Maybe<Scalars['MetaV1Time']['output']>;
};

export type BatchV1CronJobsWatchEvent = {
  __typename?: 'BatchV1CronJobsWatchEvent';
  object?: Maybe<BatchV1CronJob>;
  type: WatchEventType;
};

export type BatchV1Job = Object & {
  __typename?: 'BatchV1Job';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: BatchV1JobSpec;
  status: BatchV1JobStatus;
};

export type BatchV1JobCondition = {
  __typename?: 'BatchV1JobCondition';
  lastProbeTime: Scalars['MetaV1Time']['output'];
  lastTransitionTime: Scalars['MetaV1Time']['output'];
  message: Scalars['String']['output'];
  reason: Scalars['String']['output'];
  status: CoreV1ConditionStatus;
  type: BatchV1JobConditionType;
};

export enum BatchV1JobConditionType {
  Complete = 'Complete',
  Failed = 'Failed',
  FailureTarget = 'FailureTarget',
  Suspended = 'Suspended'
}

export type BatchV1JobList = List & {
  __typename?: 'BatchV1JobList';
  apiVersion: Scalars['String']['output'];
  items: Array<BatchV1Job>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type BatchV1JobSpec = {
  __typename?: 'BatchV1JobSpec';
  backoffLimit?: Maybe<Scalars['Int']['output']>;
  completions?: Maybe<Scalars['Int']['output']>;
  manualSelector?: Maybe<Scalars['Boolean']['output']>;
  parallelism?: Maybe<Scalars['Int']['output']>;
  selector?: Maybe<MetaV1LabelSelector>;
  suspend?: Maybe<Scalars['Boolean']['output']>;
  ttlSecondsAfterFinished?: Maybe<Scalars['Int']['output']>;
};

export type BatchV1JobStatus = {
  __typename?: 'BatchV1JobStatus';
  active: Scalars['Int']['output'];
  completedIndexes: Scalars['String']['output'];
  completionTime?: Maybe<Scalars['MetaV1Time']['output']>;
  conditions: Array<BatchV1JobCondition>;
  failed: Scalars['Int']['output'];
  ready?: Maybe<Scalars['Int']['output']>;
  startTime?: Maybe<Scalars['MetaV1Time']['output']>;
  succeeded: Scalars['Int']['output'];
};

export type BatchV1JobTemplateSpec = {
  __typename?: 'BatchV1JobTemplateSpec';
  metadata: MetaV1ObjectMeta;
  spec: BatchV1JobSpec;
};

export type BatchV1JobsWatchEvent = {
  __typename?: 'BatchV1JobsWatchEvent';
  object?: Maybe<BatchV1Job>;
  type: WatchEventType;
};

export enum CoreV1ConditionStatus {
  False = 'False',
  True = 'True',
  Unknown = 'Unknown'
}

export type CoreV1Container = {
  __typename?: 'CoreV1Container';
  image: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type CoreV1ContainerState = {
  __typename?: 'CoreV1ContainerState';
  running?: Maybe<CoreV1ContainerStateRunning>;
  terminated?: Maybe<CoreV1ContainerStateTerminated>;
  waiting?: Maybe<CoreV1ContainerStateWaiting>;
};

export type CoreV1ContainerStateRunning = {
  __typename?: 'CoreV1ContainerStateRunning';
  startedAt: Scalars['MetaV1Time']['output'];
};

export type CoreV1ContainerStateTerminated = {
  __typename?: 'CoreV1ContainerStateTerminated';
  containerID: Scalars['String']['output'];
  exitCode: Scalars['Int']['output'];
  message: Scalars['String']['output'];
  reason: Scalars['String']['output'];
  signal: Scalars['Int']['output'];
};

export type CoreV1ContainerStateWaiting = {
  __typename?: 'CoreV1ContainerStateWaiting';
  message: Scalars['String']['output'];
  reason: Scalars['String']['output'];
};

export type CoreV1ContainerStatus = {
  __typename?: 'CoreV1ContainerStatus';
  containerID: Scalars['String']['output'];
  image: Scalars['String']['output'];
  imageID: Scalars['String']['output'];
  lastTerminationState: CoreV1ContainerState;
  name: Scalars['String']['output'];
  ready: Scalars['Boolean']['output'];
  restartCount: Scalars['Int']['output'];
  started?: Maybe<Scalars['Boolean']['output']>;
  state: CoreV1ContainerState;
};

export type CoreV1Namespace = Object & {
  __typename?: 'CoreV1Namespace';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
};

export type CoreV1NamespaceList = List & {
  __typename?: 'CoreV1NamespaceList';
  apiVersion: Scalars['String']['output'];
  items: Array<CoreV1Namespace>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type CoreV1NamespacesWatchEvent = {
  __typename?: 'CoreV1NamespacesWatchEvent';
  object?: Maybe<CoreV1Namespace>;
  type: WatchEventType;
};

export type CoreV1Node = Object & {
  __typename?: 'CoreV1Node';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
};

export type CoreV1NodeList = List & {
  __typename?: 'CoreV1NodeList';
  apiVersion: Scalars['String']['output'];
  items: Array<CoreV1Node>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type CoreV1NodesWatchEvent = {
  __typename?: 'CoreV1NodesWatchEvent';
  object?: Maybe<CoreV1Node>;
  type: WatchEventType;
};

export type CoreV1ObjectReference = {
  __typename?: 'CoreV1ObjectReference';
  apiVersion: Scalars['String']['output'];
  fieldPath: Scalars['String']['output'];
  kind: Scalars['String']['output'];
  name: Scalars['String']['output'];
  namespace: Scalars['String']['output'];
  resourceVersion: Scalars['String']['output'];
  uid: Scalars['ID']['output'];
};

export type CoreV1Pod = Object & {
  __typename?: 'CoreV1Pod';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: CoreV1PodSpec;
  status: CoreV1PodStatus;
};

export type CoreV1PodList = List & {
  __typename?: 'CoreV1PodList';
  apiVersion: Scalars['String']['output'];
  items: Array<CoreV1Pod>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export enum CoreV1PodPhase {
  Failed = 'Failed',
  Pending = 'Pending',
  Running = 'Running',
  Succeeded = 'Succeeded',
  Unknown = 'Unknown'
}

export type CoreV1PodSpec = {
  __typename?: 'CoreV1PodSpec';
  containers: Array<CoreV1Container>;
  hostname: Scalars['String']['output'];
  nodeName: Scalars['String']['output'];
  priorityClassName: Scalars['String']['output'];
};

export type CoreV1PodStatus = {
  __typename?: 'CoreV1PodStatus';
  containerStatuses: Array<CoreV1ContainerStatus>;
  message: Scalars['String']['output'];
  phase: CoreV1PodPhase;
  reason: Scalars['String']['output'];
};

export type CoreV1PodsWatchEvent = {
  __typename?: 'CoreV1PodsWatchEvent';
  object?: Maybe<CoreV1Pod>;
  type: WatchEventType;
};

export type CoreV1Service = Object & {
  __typename?: 'CoreV1Service';
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
  spec: CoreV1ServiceSpec;
};

export type CoreV1ServiceList = List & {
  __typename?: 'CoreV1ServiceList';
  apiVersion: Scalars['String']['output'];
  items: Array<CoreV1Service>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type CoreV1ServicePort = {
  __typename?: 'CoreV1ServicePort';
  appProtocol?: Maybe<Scalars['String']['output']>;
  name: Scalars['String']['output'];
  port: Scalars['Int']['output'];
};

export type CoreV1ServiceSpec = {
  __typename?: 'CoreV1ServiceSpec';
  clusterIP?: Maybe<Scalars['String']['output']>;
  clusterIPs?: Maybe<Array<Scalars['String']['output']>>;
  externalName?: Maybe<Scalars['String']['output']>;
  ports: Array<CoreV1ServicePort>;
  selector?: Maybe<Scalars['StringMap']['output']>;
};

export type CoreV1ServicesWatchEvent = {
  __typename?: 'CoreV1ServicesWatchEvent';
  object?: Maybe<CoreV1Service>;
  type: WatchEventType;
};

export type HealthCheckResponse = {
  __typename?: 'HealthCheckResponse';
  message?: Maybe<Scalars['String']['output']>;
  status: HealthCheckStatus;
  timestamp: Scalars['Time']['output'];
};

export enum HealthCheckStatus {
  Failure = 'FAILURE',
  Notfound = 'NOTFOUND',
  Pending = 'PENDING',
  Success = 'SUCCESS',
  Unknown = 'UNKNOWN'
}

export type HelmChart = {
  __typename?: 'HelmChart';
  metadata?: Maybe<HelmChartMetadata>;
};

export type HelmChartMetadata = {
  __typename?: 'HelmChartMetadata';
  appVersion: Scalars['String']['output'];
  condition: Scalars['String']['output'];
  name: Scalars['String']['output'];
  version: Scalars['String']['output'];
};

export type HelmRelease = {
  __typename?: 'HelmRelease';
  chart?: Maybe<HelmChart>;
  name: Scalars['String']['output'];
  namespace: Scalars['String']['output'];
  version: Scalars['Int']['output'];
};

export type KubeConfig = {
  __typename?: 'KubeConfig';
  authInfos: Array<KubeConfigAuthInfo>;
  clusters: Array<KubeConfigCluster>;
  contexts: Array<KubeConfigContext>;
  currentContext: Scalars['String']['output'];
  extensions?: Maybe<Scalars['KubeConfigExtensions']['output']>;
};

export type KubeConfigAuthInfo = {
  __typename?: 'KubeConfigAuthInfo';
  extensions?: Maybe<Scalars['KubeConfigExtensions']['output']>;
  locationOfOrigin: Scalars['String']['output'];
  name: Scalars['String']['output'];
};

export type KubeConfigCluster = {
  __typename?: 'KubeConfigCluster';
  extensions?: Maybe<Scalars['KubeConfigExtensions']['output']>;
  locationOfOrigin: Scalars['String']['output'];
  name: Scalars['String']['output'];
  server: Scalars['String']['output'];
};

export type KubeConfigContext = {
  __typename?: 'KubeConfigContext';
  authInfo: Scalars['String']['output'];
  cluster: Scalars['String']['output'];
  extensions?: Maybe<Scalars['KubeConfigExtensions']['output']>;
  locationOfOrigin: Scalars['String']['output'];
  name: Scalars['String']['output'];
  namespace: Scalars['String']['output'];
};

export type KubeConfigWatchEvent = {
  __typename?: 'KubeConfigWatchEvent';
  object?: Maybe<KubeConfig>;
  type: WatchEventType;
};

export type List = {
  apiVersion: Scalars['String']['output'];
  items: Array<Object>;
  kind: Scalars['String']['output'];
  metadata: MetaV1ListMeta;
};

export type LogRecord = {
  __typename?: 'LogRecord';
  message: Scalars['String']['output'];
  source: LogSource;
  timestamp: Scalars['Time']['output'];
};

export enum LogRecordsQueryMode {
  Head = 'HEAD',
  Tail = 'TAIL'
}

export type LogRecordsQueryResponse = {
  __typename?: 'LogRecordsQueryResponse';
  nextCursor?: Maybe<Scalars['ID']['output']>;
  records: Array<LogRecord>;
};

export type LogSource = {
  __typename?: 'LogSource';
  containerID: Scalars['String']['output'];
  containerName: Scalars['String']['output'];
  metadata: LogSourceMetadata;
  namespace: Scalars['String']['output'];
  podName: Scalars['String']['output'];
};

export type LogSourceFilter = {
  arch?: InputMaybe<Array<Scalars['String']['input']>>;
  container?: InputMaybe<Array<Scalars['String']['input']>>;
  node?: InputMaybe<Array<Scalars['String']['input']>>;
  os?: InputMaybe<Array<Scalars['String']['input']>>;
  region?: InputMaybe<Array<Scalars['String']['input']>>;
  zone?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type LogSourceMetadata = {
  __typename?: 'LogSourceMetadata';
  arch: Scalars['String']['output'];
  node: Scalars['String']['output'];
  os: Scalars['String']['output'];
  region: Scalars['String']['output'];
  zone: Scalars['String']['output'];
};

export type LogSourceWatchEvent = {
  __typename?: 'LogSourceWatchEvent';
  object?: Maybe<LogSource>;
  type: WatchEventType;
};

export type MetaV1GetOptions = {
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
};

export type MetaV1LabelSelector = {
  __typename?: 'MetaV1LabelSelector';
  matchExpressions: Array<MetaV1LabelSelectorRequirement>;
  matchLabels?: Maybe<Scalars['StringMap']['output']>;
};

export enum MetaV1LabelSelectorOperator {
  DoesNotExist = 'DoesNotExist',
  Exists = 'Exists',
  In = 'In',
  NotIn = 'NotIn'
}

export type MetaV1LabelSelectorRequirement = {
  __typename?: 'MetaV1LabelSelectorRequirement';
  key: Scalars['String']['output'];
  operator: MetaV1LabelSelectorOperator;
  values: Array<Scalars['String']['output']>;
};

export type MetaV1ListMeta = {
  __typename?: 'MetaV1ListMeta';
  continue: Scalars['String']['output'];
  remainingItemCount?: Maybe<Scalars['Int64']['output']>;
  resourceVersion: Scalars['String']['output'];
};

export type MetaV1ListOptions = {
  allowWatchBookmarks?: InputMaybe<Scalars['Boolean']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
  fieldSelector?: InputMaybe<Scalars['String']['input']>;
  labelSelector?: InputMaybe<Scalars['String']['input']>;
  limit?: InputMaybe<Scalars['Int64']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
  resourceVersionMatch?: InputMaybe<MetaV1ResourceVersionMatch>;
  sendInitialEvents?: InputMaybe<Scalars['Boolean']['input']>;
};

export type MetaV1ObjectMeta = {
  __typename?: 'MetaV1ObjectMeta';
  annotations?: Maybe<Scalars['StringMap']['output']>;
  creationTimestamp: Scalars['MetaV1Time']['output'];
  deletionTimestamp?: Maybe<Scalars['MetaV1Time']['output']>;
  labels?: Maybe<Scalars['StringMap']['output']>;
  name: Scalars['String']['output'];
  namespace: Scalars['String']['output'];
  ownerReferences: Array<MetaV1OwnerReference>;
  resourceVersion: Scalars['String']['output'];
  uid: Scalars['ID']['output'];
};

export type MetaV1OwnerReference = {
  __typename?: 'MetaV1OwnerReference';
  apiVersion: Scalars['String']['output'];
  controller?: Maybe<Scalars['Boolean']['output']>;
  kind: Scalars['String']['output'];
  name: Scalars['String']['output'];
  uid: Scalars['ID']['output'];
};

export enum MetaV1ResourceVersionMatch {
  Exact = 'Exact',
  NotOlderThan = 'NotOlderThan'
}

export type Mutation = {
  __typename?: 'Mutation';
  /** Helm mutations */
  helmInstallLatest?: Maybe<HelmRelease>;
};


export type MutationHelmInstallLatestArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};

export type Object = {
  apiVersion: Scalars['String']['output'];
  id: Scalars['ID']['output'];
  kind: Scalars['String']['output'];
  metadata: MetaV1ObjectMeta;
};

export type PageInfo = {
  __typename?: 'PageInfo';
  /** When paginating forwards, the cursor to continue. */
  endCursor?: Maybe<Scalars['ID']['output']>;
  /** When paginating forwards, are there more items? */
  hasNextPage: Scalars['Boolean']['output'];
  /** When paginating backwards, are there more items? */
  hasPreviousPage: Scalars['Boolean']['output'];
  /** When paginating backwards, the cursor to continue. */
  startCursor?: Maybe<Scalars['ID']['output']>;
};

export type Query = {
  __typename?: 'Query';
  /** AppsV1 queries */
  appsV1DaemonSetsGet?: Maybe<AppsV1DaemonSet>;
  appsV1DaemonSetsList?: Maybe<AppsV1DaemonSetList>;
  appsV1DeploymentsGet?: Maybe<AppsV1Deployment>;
  appsV1DeploymentsList?: Maybe<AppsV1DeploymentList>;
  appsV1ReplicaSetsGet?: Maybe<AppsV1ReplicaSet>;
  appsV1ReplicaSetsList?: Maybe<AppsV1ReplicaSetList>;
  appsV1StatefulSetsGet?: Maybe<AppsV1StatefulSet>;
  appsV1StatefulSetsList?: Maybe<AppsV1StatefulSetList>;
  /** BatchV1 queries */
  batchV1CronJobsGet?: Maybe<BatchV1CronJob>;
  batchV1CronJobsList?: Maybe<BatchV1CronJobList>;
  batchV1JobsGet?: Maybe<BatchV1Job>;
  batchV1JobsList?: Maybe<BatchV1JobList>;
  clusterAPIHealthzGet: HealthCheckResponse;
  /** Cluster API */
  clusterAPIReadyWait: Scalars['Boolean']['output'];
  clusterAPIServicesList?: Maybe<CoreV1ServiceList>;
  /** CoreV1 queries */
  coreV1NamespacesList?: Maybe<CoreV1NamespaceList>;
  coreV1NodesList?: Maybe<CoreV1NodeList>;
  coreV1PodsGet?: Maybe<CoreV1Pod>;
  coreV1PodsList?: Maybe<CoreV1PodList>;
  coreV1ServicesGet?: Maybe<CoreV1Service>;
  coreV1ServicesList?: Maybe<CoreV1ServiceList>;
  /** Helm */
  helmListReleases: Array<HelmRelease>;
  /** KubeConfig queries */
  kubeConfigGet?: Maybe<KubeConfig>;
  kubernetesAPIHealthzGet: HealthCheckResponse;
  /** Kubernetes API */
  kubernetesAPIReadyWait: Scalars['Boolean']['output'];
  /** Log records API */
  logRecordsFetch?: Maybe<LogRecordsQueryResponse>;
};


export type QueryAppsV1DaemonSetsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryAppsV1DaemonSetsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryAppsV1DeploymentsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryAppsV1DeploymentsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryAppsV1ReplicaSetsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryAppsV1ReplicaSetsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryAppsV1StatefulSetsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryAppsV1StatefulSetsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryBatchV1CronJobsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryBatchV1CronJobsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryBatchV1JobsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryBatchV1JobsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryClusterApiHealthzGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryClusterApiReadyWaitArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
};


export type QueryClusterApiServicesListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryCoreV1NamespacesListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryCoreV1NodesListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryCoreV1PodsGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryCoreV1PodsListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryCoreV1ServicesGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  name: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1GetOptions>;
};


export type QueryCoreV1ServicesListArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type QueryHelmListReleasesArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};


export type QueryKubernetesApiHealthzGetArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};


export type QueryKubernetesApiReadyWaitArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};


export type QueryLogRecordsFetchArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  grep?: InputMaybe<Scalars['String']['input']>;
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  limit?: InputMaybe<Scalars['Int']['input']>;
  mode?: InputMaybe<LogRecordsQueryMode>;
  since?: InputMaybe<Scalars['String']['input']>;
  sourceFilter?: InputMaybe<LogSourceFilter>;
  sources: Array<Scalars['String']['input']>;
  until?: InputMaybe<Scalars['String']['input']>;
};

export type Subscription = {
  __typename?: 'Subscription';
  /** AppsV1 watchers */
  appsV1DaemonSetsWatch?: Maybe<AppsV1DaemonSetsWatchEvent>;
  appsV1DeploymentsWatch?: Maybe<AppsV1DeploymentsWatchEvent>;
  appsV1ReplicaSetsWatch?: Maybe<AppsV1ReplicaSetsWatchEvent>;
  appsV1StatefulSetsWatch?: Maybe<AppsV1StatefulSetsWatchEvent>;
  /** BatchV1 watchers */
  batchV1CronJobsWatch?: Maybe<BatchV1CronJobsWatchEvent>;
  batchV1JobsWatch?: Maybe<BatchV1JobsWatchEvent>;
  clusterAPIHealthzWatch: HealthCheckResponse;
  /** Cluster API */
  clusterAPIReadyWait: Scalars['Boolean']['output'];
  clusterAPIServicesWatch?: Maybe<CoreV1ServicesWatchEvent>;
  /** CoreV1 watchers */
  coreV1NamespacesWatch?: Maybe<CoreV1NamespacesWatchEvent>;
  coreV1NodesWatch?: Maybe<CoreV1NodesWatchEvent>;
  coreV1PodsWatch?: Maybe<CoreV1PodsWatchEvent>;
  coreV1ServicesWatch?: Maybe<CoreV1ServicesWatchEvent>;
  /** KubeConfig watchers */
  kubeConfigWatch?: Maybe<KubeConfigWatchEvent>;
  kubernetesAPIHealthzWatch: HealthCheckResponse;
  /** Kubernetes API */
  kubernetesAPIReadyWait: Scalars['Boolean']['output'];
  /** LogRecords API */
  logRecordsFollow?: Maybe<LogRecord>;
  /** LogSources API */
  logSourcesWatch?: Maybe<LogSourceWatchEvent>;
};


export type SubscriptionAppsV1DaemonSetsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionAppsV1DeploymentsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionAppsV1ReplicaSetsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionAppsV1StatefulSetsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionBatchV1CronJobsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionBatchV1JobsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionClusterApiHealthzWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
};


export type SubscriptionClusterApiReadyWaitArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
};


export type SubscriptionClusterApiServicesWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionCoreV1NamespacesWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionCoreV1NodesWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionCoreV1PodsWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionCoreV1ServicesWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  options?: InputMaybe<MetaV1ListOptions>;
};


export type SubscriptionKubernetesApiHealthzWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};


export type SubscriptionKubernetesApiReadyWaitArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
};


export type SubscriptionLogRecordsFollowArgs = {
  after?: InputMaybe<Scalars['String']['input']>;
  grep?: InputMaybe<Scalars['String']['input']>;
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  since?: InputMaybe<Scalars['String']['input']>;
  sourceFilter?: InputMaybe<LogSourceFilter>;
  sources: Array<Scalars['String']['input']>;
};


export type SubscriptionLogSourcesWatchArgs = {
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  sources: Array<Scalars['String']['input']>;
};

export enum WatchEventType {
  Added = 'ADDED',
  Bookmark = 'BOOKMARK',
  Deleted = 'DELETED',
  Error = 'ERROR',
  Modified = 'MODIFIED'
}

type ConsoleLoggingResourcesGenericObjectFragment_AppsV1DaemonSet_Fragment = { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_AppsV1Deployment_Fragment = { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_AppsV1ReplicaSet_Fragment = { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_AppsV1StatefulSet_Fragment = { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_BatchV1CronJob_Fragment = { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_BatchV1Job_Fragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_CoreV1Namespace_Fragment = { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_CoreV1Node_Fragment = { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_CoreV1Pod_Fragment = { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type ConsoleLoggingResourcesGenericObjectFragment_CoreV1Service_Fragment = { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesGenericObjectFragmentFragment = ConsoleLoggingResourcesGenericObjectFragment_AppsV1DaemonSet_Fragment | ConsoleLoggingResourcesGenericObjectFragment_AppsV1Deployment_Fragment | ConsoleLoggingResourcesGenericObjectFragment_AppsV1ReplicaSet_Fragment | ConsoleLoggingResourcesGenericObjectFragment_AppsV1StatefulSet_Fragment | ConsoleLoggingResourcesGenericObjectFragment_BatchV1CronJob_Fragment | ConsoleLoggingResourcesGenericObjectFragment_BatchV1Job_Fragment | ConsoleLoggingResourcesGenericObjectFragment_CoreV1Namespace_Fragment | ConsoleLoggingResourcesGenericObjectFragment_CoreV1Node_Fragment | ConsoleLoggingResourcesGenericObjectFragment_CoreV1Pod_Fragment | ConsoleLoggingResourcesGenericObjectFragment_CoreV1Service_Fragment;

export type ConsoleLoggingResourcesCronJobFragmentFragment = { __typename?: 'BatchV1CronJob', id: string, spec: { __typename?: 'BatchV1CronJobSpec', jobTemplate: { __typename?: 'BatchV1JobTemplateSpec', spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null } } }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesDaemonSetFragmentFragment = { __typename?: 'AppsV1DaemonSet', id: string, spec: { __typename?: 'AppsV1DaemonSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesDeploymentFragmentFragment = { __typename?: 'AppsV1Deployment', id: string, spec: { __typename?: 'AppsV1DeploymentSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesJobFragmentFragment = { __typename?: 'BatchV1Job', id: string, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesPodFragmentFragment = { __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesReplicaSetFragmentFragment = { __typename?: 'AppsV1ReplicaSet', id: string, spec: { __typename?: 'AppsV1ReplicaSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesStatefulSetFragmentFragment = { __typename?: 'AppsV1StatefulSet', id: string, spec: { __typename?: 'AppsV1StatefulSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ConsoleLoggingResourcesJobsFindFragmentFragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> }, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null } };

export type ConsoleNodesListItemFragmentFragment = { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, labels?: any | null, annotations?: any | null } };

export type HealthCheckResponseFragmentFragment = { __typename?: 'HealthCheckResponse', status: HealthCheckStatus, message?: string | null, timestamp: any };

export type HelmReleaseFragmentFragment = { __typename?: 'HelmRelease', name: string, version: number, namespace: string, chart?: { __typename?: 'HelmChart', metadata?: { __typename?: 'HelmChartMetadata', name: string, version: string, appVersion: string } | null } | null };

export type HomeCronJobsListItemFragmentFragment = { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeDaemonSetsListItemFragmentFragment = { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeDeploymentsListItemFragmentFragment = { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeJobsListItemFragmentFragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListFragment_AppsV1DaemonSetList_Fragment = { __typename?: 'AppsV1DaemonSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_AppsV1DeploymentList_Fragment = { __typename?: 'AppsV1DeploymentList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_AppsV1ReplicaSetList_Fragment = { __typename?: 'AppsV1ReplicaSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_AppsV1StatefulSetList_Fragment = { __typename?: 'AppsV1StatefulSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_BatchV1CronJobList_Fragment = { __typename?: 'BatchV1CronJobList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_BatchV1JobList_Fragment = { __typename?: 'BatchV1JobList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_CoreV1NamespaceList_Fragment = { __typename?: 'CoreV1NamespaceList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_CoreV1NodeList_Fragment = { __typename?: 'CoreV1NodeList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_CoreV1PodList_Fragment = { __typename?: 'CoreV1PodList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type HomeGenericListFragment_CoreV1ServiceList_Fragment = { __typename?: 'CoreV1ServiceList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

export type HomeGenericListFragmentFragment = HomeGenericListFragment_AppsV1DaemonSetList_Fragment | HomeGenericListFragment_AppsV1DeploymentList_Fragment | HomeGenericListFragment_AppsV1ReplicaSetList_Fragment | HomeGenericListFragment_AppsV1StatefulSetList_Fragment | HomeGenericListFragment_BatchV1CronJobList_Fragment | HomeGenericListFragment_BatchV1JobList_Fragment | HomeGenericListFragment_CoreV1NamespaceList_Fragment | HomeGenericListFragment_CoreV1NodeList_Fragment | HomeGenericListFragment_CoreV1PodList_Fragment | HomeGenericListFragment_CoreV1ServiceList_Fragment;

type HomeGenericListItemFragment_AppsV1DaemonSet_Fragment = { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_AppsV1Deployment_Fragment = { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_AppsV1ReplicaSet_Fragment = { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_AppsV1StatefulSet_Fragment = { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_BatchV1CronJob_Fragment = { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_BatchV1Job_Fragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_CoreV1Namespace_Fragment = { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_CoreV1Node_Fragment = { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_CoreV1Pod_Fragment = { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

type HomeGenericListItemFragment_CoreV1Service_Fragment = { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeGenericListItemFragmentFragment = HomeGenericListItemFragment_AppsV1DaemonSet_Fragment | HomeGenericListItemFragment_AppsV1Deployment_Fragment | HomeGenericListItemFragment_AppsV1ReplicaSet_Fragment | HomeGenericListItemFragment_AppsV1StatefulSet_Fragment | HomeGenericListItemFragment_BatchV1CronJob_Fragment | HomeGenericListItemFragment_BatchV1Job_Fragment | HomeGenericListItemFragment_CoreV1Namespace_Fragment | HomeGenericListItemFragment_CoreV1Node_Fragment | HomeGenericListItemFragment_CoreV1Pod_Fragment | HomeGenericListItemFragment_CoreV1Service_Fragment;

export type HomeNamespacesListItemFragmentFragment = { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomePodsListItemFragmentFragment = { __typename?: 'CoreV1Pod', id: string, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', containerID: string, started?: boolean | null }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeReplicaSetsListItemFragmentFragment = { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type HomeStatefulSetsListItemFragmentFragment = { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } };

export type ClusterApiServicesListItemFragmentFragment = { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string }, spec: { __typename?: 'CoreV1ServiceSpec', ports: Array<{ __typename?: 'CoreV1ServicePort', name: string, port: number, appProtocol?: string | null }> } };

export type KubeConfigFragmentFragment = { __typename?: 'KubeConfig', currentContext: string, contexts: Array<{ __typename?: 'KubeConfigContext', name: string, cluster: string, namespace: string }> };

export type LogRecordsFragmentFragment = { __typename?: 'LogRecord', timestamp: any, message: string, source: { __typename?: 'LogSource', namespace: string, podName: string, containerName: string, containerID: string, metadata: { __typename?: 'LogSourceMetadata', region: string, zone: string, os: string, arch: string, node: string } } };

export type LogSourceFragmentFragment = { __typename?: 'LogSource', namespace: string, podName: string, containerName: string, containerID: string, metadata: { __typename?: 'LogSourceMetadata', region: string, zone: string, os: string, arch: string, node: string } };

type SourcePickerGenericCounterFragment_AppsV1DaemonSetList_Fragment = { __typename?: 'AppsV1DaemonSetList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_AppsV1DeploymentList_Fragment = { __typename?: 'AppsV1DeploymentList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_AppsV1ReplicaSetList_Fragment = { __typename?: 'AppsV1ReplicaSetList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_AppsV1StatefulSetList_Fragment = { __typename?: 'AppsV1StatefulSetList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_BatchV1CronJobList_Fragment = { __typename?: 'BatchV1CronJobList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_BatchV1JobList_Fragment = { __typename?: 'BatchV1JobList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_CoreV1NamespaceList_Fragment = { __typename?: 'CoreV1NamespaceList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_CoreV1NodeList_Fragment = { __typename?: 'CoreV1NodeList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_CoreV1PodList_Fragment = { __typename?: 'CoreV1PodList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

type SourcePickerGenericCounterFragment_CoreV1ServiceList_Fragment = { __typename?: 'CoreV1ServiceList', metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }> };

export type SourcePickerGenericCounterFragmentFragment = SourcePickerGenericCounterFragment_AppsV1DaemonSetList_Fragment | SourcePickerGenericCounterFragment_AppsV1DeploymentList_Fragment | SourcePickerGenericCounterFragment_AppsV1ReplicaSetList_Fragment | SourcePickerGenericCounterFragment_AppsV1StatefulSetList_Fragment | SourcePickerGenericCounterFragment_BatchV1CronJobList_Fragment | SourcePickerGenericCounterFragment_BatchV1JobList_Fragment | SourcePickerGenericCounterFragment_CoreV1NamespaceList_Fragment | SourcePickerGenericCounterFragment_CoreV1NodeList_Fragment | SourcePickerGenericCounterFragment_CoreV1PodList_Fragment | SourcePickerGenericCounterFragment_CoreV1ServiceList_Fragment;

type SourcePickerGenericCounterItemFragment_AppsV1DaemonSet_Fragment = { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_AppsV1Deployment_Fragment = { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_AppsV1ReplicaSet_Fragment = { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_AppsV1StatefulSet_Fragment = { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_BatchV1CronJob_Fragment = { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_BatchV1Job_Fragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_CoreV1Namespace_Fragment = { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_CoreV1Node_Fragment = { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_CoreV1Pod_Fragment = { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

type SourcePickerGenericCounterItemFragment_CoreV1Service_Fragment = { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } };

export type SourcePickerGenericCounterItemFragmentFragment = SourcePickerGenericCounterItemFragment_AppsV1DaemonSet_Fragment | SourcePickerGenericCounterItemFragment_AppsV1Deployment_Fragment | SourcePickerGenericCounterItemFragment_AppsV1ReplicaSet_Fragment | SourcePickerGenericCounterItemFragment_AppsV1StatefulSet_Fragment | SourcePickerGenericCounterItemFragment_BatchV1CronJob_Fragment | SourcePickerGenericCounterItemFragment_BatchV1Job_Fragment | SourcePickerGenericCounterItemFragment_CoreV1Namespace_Fragment | SourcePickerGenericCounterItemFragment_CoreV1Node_Fragment | SourcePickerGenericCounterItemFragment_CoreV1Pod_Fragment | SourcePickerGenericCounterItemFragment_CoreV1Service_Fragment;

type SourcePickerGenericListFragment_AppsV1DaemonSetList_Fragment = { __typename?: 'AppsV1DaemonSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_AppsV1DeploymentList_Fragment = { __typename?: 'AppsV1DeploymentList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_AppsV1ReplicaSetList_Fragment = { __typename?: 'AppsV1ReplicaSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_AppsV1StatefulSetList_Fragment = { __typename?: 'AppsV1StatefulSetList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_BatchV1CronJobList_Fragment = { __typename?: 'BatchV1CronJobList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_BatchV1JobList_Fragment = { __typename?: 'BatchV1JobList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_CoreV1NamespaceList_Fragment = { __typename?: 'CoreV1NamespaceList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_CoreV1NodeList_Fragment = { __typename?: 'CoreV1NodeList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_CoreV1PodList_Fragment = { __typename?: 'CoreV1PodList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

type SourcePickerGenericListFragment_CoreV1ServiceList_Fragment = { __typename?: 'CoreV1ServiceList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } };

export type SourcePickerGenericListFragmentFragment = SourcePickerGenericListFragment_AppsV1DaemonSetList_Fragment | SourcePickerGenericListFragment_AppsV1DeploymentList_Fragment | SourcePickerGenericListFragment_AppsV1ReplicaSetList_Fragment | SourcePickerGenericListFragment_AppsV1StatefulSetList_Fragment | SourcePickerGenericListFragment_BatchV1CronJobList_Fragment | SourcePickerGenericListFragment_BatchV1JobList_Fragment | SourcePickerGenericListFragment_CoreV1NamespaceList_Fragment | SourcePickerGenericListFragment_CoreV1NodeList_Fragment | SourcePickerGenericListFragment_CoreV1PodList_Fragment | SourcePickerGenericListFragment_CoreV1ServiceList_Fragment;

type SourcePickerGenericListItemFragment_AppsV1DaemonSet_Fragment = { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_AppsV1Deployment_Fragment = { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_AppsV1ReplicaSet_Fragment = { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_AppsV1StatefulSet_Fragment = { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_BatchV1CronJob_Fragment = { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_BatchV1Job_Fragment = { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_CoreV1Namespace_Fragment = { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_CoreV1Node_Fragment = { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_CoreV1Pod_Fragment = { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

type SourcePickerGenericListItemFragment_CoreV1Service_Fragment = { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } };

export type SourcePickerGenericListItemFragmentFragment = SourcePickerGenericListItemFragment_AppsV1DaemonSet_Fragment | SourcePickerGenericListItemFragment_AppsV1Deployment_Fragment | SourcePickerGenericListItemFragment_AppsV1ReplicaSet_Fragment | SourcePickerGenericListItemFragment_AppsV1StatefulSet_Fragment | SourcePickerGenericListItemFragment_BatchV1CronJob_Fragment | SourcePickerGenericListItemFragment_BatchV1Job_Fragment | SourcePickerGenericListItemFragment_CoreV1Namespace_Fragment | SourcePickerGenericListItemFragment_CoreV1Node_Fragment | SourcePickerGenericListItemFragment_CoreV1Pod_Fragment | SourcePickerGenericListItemFragment_CoreV1Service_Fragment;

export type ConsoleLoggingResourcesCronJobGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesCronJobGetQuery = { __typename?: 'Query', batchV1CronJobsGet?: { __typename?: 'BatchV1CronJob', id: string, spec: { __typename?: 'BatchV1CronJobSpec', jobTemplate: { __typename?: 'BatchV1JobTemplateSpec', spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null } } }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesCronJobWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesCronJobWatchSubscription = { __typename?: 'Subscription', batchV1CronJobsWatch?: { __typename?: 'BatchV1CronJobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1CronJob', id: string, spec: { __typename?: 'BatchV1CronJobSpec', jobTemplate: { __typename?: 'BatchV1JobTemplateSpec', spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null } } }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesDaemonSetGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesDaemonSetGetQuery = { __typename?: 'Query', appsV1DaemonSetsGet?: { __typename?: 'AppsV1DaemonSet', id: string, spec: { __typename?: 'AppsV1DaemonSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesDaemonSetWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesDaemonSetWatchSubscription = { __typename?: 'Subscription', appsV1DaemonSetsWatch?: { __typename?: 'AppsV1DaemonSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1DaemonSet', id: string, spec: { __typename?: 'AppsV1DaemonSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesDeploymentGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesDeploymentGetQuery = { __typename?: 'Query', appsV1DeploymentsGet?: { __typename?: 'AppsV1Deployment', id: string, spec: { __typename?: 'AppsV1DeploymentSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesDeploymentWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesDeploymentWatchSubscription = { __typename?: 'Subscription', appsV1DeploymentsWatch?: { __typename?: 'AppsV1DeploymentsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1Deployment', id: string, spec: { __typename?: 'AppsV1DeploymentSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesJobGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesJobGetQuery = { __typename?: 'Query', batchV1JobsGet?: { __typename?: 'BatchV1Job', id: string, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesJobWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesJobWatchSubscription = { __typename?: 'Subscription', batchV1JobsWatch?: { __typename?: 'BatchV1JobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1Job', id: string, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesPodGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesPodGetQuery = { __typename?: 'Query', coreV1PodsGet?: { __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesPodWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesPodWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsolePodsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsolePodsListFetchQuery = { __typename?: 'Query', coreV1PodsList?: { __typename?: 'CoreV1PodList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }> } | null };

export type ConsolePodsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsolePodsListWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesReplicaSetGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesReplicaSetGetQuery = { __typename?: 'Query', appsV1ReplicaSetsGet?: { __typename?: 'AppsV1ReplicaSet', id: string, spec: { __typename?: 'AppsV1ReplicaSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesReplicaSetWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesReplicaSetWatchSubscription = { __typename?: 'Subscription', appsV1ReplicaSetsWatch?: { __typename?: 'AppsV1ReplicaSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1ReplicaSet', id: string, spec: { __typename?: 'AppsV1ReplicaSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesStatefulSetGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  name: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesStatefulSetGetQuery = { __typename?: 'Query', appsV1StatefulSetsGet?: { __typename?: 'AppsV1StatefulSet', id: string, spec: { __typename?: 'AppsV1StatefulSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null };

export type ConsoleLoggingResourcesStatefulSetWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  fieldSelector: Scalars['String']['input'];
}>;


export type ConsoleLoggingResourcesStatefulSetWatchSubscription = { __typename?: 'Subscription', appsV1StatefulSetsWatch?: { __typename?: 'AppsV1StatefulSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1StatefulSet', id: string, spec: { __typename?: 'AppsV1StatefulSetSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesJobsFindQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleLoggingResourcesJobsFindQuery = { __typename?: 'Query', batchV1JobsList?: { __typename?: 'BatchV1JobList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string }, items: Array<{ __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> }, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null } }> } | null };

export type ConsoleStreamsJobsWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleStreamsJobsWatchSubscription = { __typename?: 'Subscription', batchV1JobsWatch?: { __typename?: 'BatchV1JobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1Job', id: string, spec: { __typename?: 'BatchV1JobSpec', selector?: { __typename?: 'MetaV1LabelSelector', matchLabels?: any | null } | null }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleLoggingResourcesPodsFindQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  labelSelector: Scalars['String']['input'];
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleLoggingResourcesPodsFindQuery = { __typename?: 'Query', coreV1PodsList?: { __typename?: 'CoreV1PodList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }> } | null };

export type ConsoleLoggingResourcesPodsWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  labelSelector: Scalars['String']['input'];
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleLoggingResourcesPodsWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, spec: { __typename?: 'CoreV1PodSpec', nodeName: string, containers: Array<{ __typename?: 'CoreV1Container', name: string }> }, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', name: string, started?: boolean | null, state: { __typename?: 'CoreV1ContainerState', running?: { __typename?: 'CoreV1ContainerStateRunning', startedAt: any } | null, terminated?: { __typename?: 'CoreV1ContainerStateTerminated', exitCode: number } | null } }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ConsoleNodesListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleNodesListFetchQuery = { __typename?: 'Query', coreV1NodesList?: { __typename?: 'CoreV1NodeList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, labels?: any | null, annotations?: any | null } }> } | null };

export type ConsoleNodesListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type ConsoleNodesListWatchSubscription = { __typename?: 'Subscription', coreV1NodesWatch?: { __typename?: 'CoreV1NodesWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Node', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, labels?: any | null, annotations?: any | null } } | null } | null };

export type HomeCronJobsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeCronJobsListFetchQuery = { __typename?: 'Query', batchV1CronJobsList?: { __typename?: 'BatchV1CronJobList', items: Array<{ __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeCronJobsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeCronJobsListWatchSubscription = { __typename?: 'Subscription', batchV1CronJobsWatch?: { __typename?: 'BatchV1CronJobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeDaemonSetsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeDaemonSetsListFetchQuery = { __typename?: 'Query', appsV1DaemonSetsList?: { __typename?: 'AppsV1DaemonSetList', items: Array<{ __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeDaemonSetsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeDaemonSetsListWatchSubscription = { __typename?: 'Subscription', appsV1DaemonSetsWatch?: { __typename?: 'AppsV1DaemonSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeDeploymentsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeDeploymentsListFetchQuery = { __typename?: 'Query', appsV1DeploymentsList?: { __typename?: 'AppsV1DeploymentList', items: Array<{ __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeDeploymentsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeDeploymentsListWatchSubscription = { __typename?: 'Subscription', appsV1DeploymentsWatch?: { __typename?: 'AppsV1DeploymentsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeJobsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeJobsListFetchQuery = { __typename?: 'Query', batchV1JobsList?: { __typename?: 'BatchV1JobList', items: Array<{ __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeJobsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeJobsListWatchSubscription = { __typename?: 'Subscription', batchV1JobsWatch?: { __typename?: 'BatchV1JobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeNamespacesListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeNamespacesListFetchQuery = { __typename?: 'Query', coreV1NamespacesList?: { __typename?: 'CoreV1NamespaceList', items: Array<{ __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeNamespacesListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeNamespacesListWatchSubscription = { __typename?: 'Subscription', coreV1NamespacesWatch?: { __typename?: 'CoreV1NamespacesWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomePodsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomePodsListFetchQuery = { __typename?: 'Query', coreV1PodsList?: { __typename?: 'CoreV1PodList', items: Array<{ __typename?: 'CoreV1Pod', id: string, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', containerID: string, started?: boolean | null }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomePodsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomePodsListWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, status: { __typename?: 'CoreV1PodStatus', containerStatuses: Array<{ __typename?: 'CoreV1ContainerStatus', containerID: string, started?: boolean | null }> }, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeReplicaSetsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeReplicaSetsListFetchQuery = { __typename?: 'Query', appsV1ReplicaSetsList?: { __typename?: 'AppsV1ReplicaSetList', items: Array<{ __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeReplicaSetsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeReplicaSetsListWatchSubscription = { __typename?: 'Subscription', appsV1ReplicaSetsWatch?: { __typename?: 'AppsV1ReplicaSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type HomeStatefulSetsListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeStatefulSetsListFetchQuery = { __typename?: 'Query', appsV1StatefulSetsList?: { __typename?: 'AppsV1StatefulSetList', items: Array<{ __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type HomeStatefulSetsListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type HomeStatefulSetsListWatchSubscription = { __typename?: 'Subscription', appsV1StatefulSetsWatch?: { __typename?: 'AppsV1StatefulSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export type ClusterApiReadyWaitSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace: Scalars['String']['input'];
  serviceName: Scalars['String']['input'];
}>;


export type ClusterApiReadyWaitSubscription = { __typename?: 'Subscription', clusterAPIReadyWait: boolean };

export type ClusterApiServicesListFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type ClusterApiServicesListFetchQuery = { __typename?: 'Query', clusterAPIServicesList?: { __typename?: 'CoreV1ServiceList', metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string }, items: Array<{ __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string }, spec: { __typename?: 'CoreV1ServiceSpec', ports: Array<{ __typename?: 'CoreV1ServicePort', name: string, port: number, appProtocol?: string | null }> } }> } | null };

export type ClusterApiServicesListWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type ClusterApiServicesListWatchSubscription = { __typename?: 'Subscription', clusterAPIServicesWatch?: { __typename?: 'CoreV1ServicesWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Service', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string }, spec: { __typename?: 'CoreV1ServiceSpec', ports: Array<{ __typename?: 'CoreV1ServicePort', name: string, port: number, appProtocol?: string | null }> } } | null } | null };

export type HelmInstallLatestMutationVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
}>;


export type HelmInstallLatestMutation = { __typename?: 'Mutation', helmInstallLatest?: { __typename?: 'HelmRelease', name: string, version: number, namespace: string, chart?: { __typename?: 'HelmChart', metadata?: { __typename?: 'HelmChartMetadata', name: string, version: string, appVersion: string } | null } | null } | null };

export type HelmListReleasesQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
}>;


export type HelmListReleasesQuery = { __typename?: 'Query', helmListReleases: Array<{ __typename?: 'HelmRelease', name: string, version: number, namespace: string, chart?: { __typename?: 'HelmChart', metadata?: { __typename?: 'HelmChartMetadata', name: string, version: string, appVersion: string } | null } | null }> };

export type KubeConfigGetQueryVariables = Exact<{ [key: string]: never; }>;


export type KubeConfigGetQuery = { __typename?: 'Query', kubeConfigGet?: { __typename?: 'KubeConfig', currentContext: string, contexts: Array<{ __typename?: 'KubeConfigContext', name: string, cluster: string, namespace: string }> } | null };

export type KubeConfigWatchSubscriptionVariables = Exact<{ [key: string]: never; }>;


export type KubeConfigWatchSubscription = { __typename?: 'Subscription', kubeConfigWatch?: { __typename?: 'KubeConfigWatchEvent', type: WatchEventType, object?: { __typename?: 'KubeConfig', currentContext: string, contexts: Array<{ __typename?: 'KubeConfigContext', name: string, cluster: string, namespace: string }> } | null } | null };

export type KubernetesApiReadyWaitSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
}>;


export type KubernetesApiReadyWaitSubscription = { __typename?: 'Subscription', kubernetesAPIReadyWait: boolean };

export type LogRecordsFetchQueryVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  sources: Array<Scalars['String']['input']> | Scalars['String']['input'];
  mode?: InputMaybe<LogRecordsQueryMode>;
  since?: InputMaybe<Scalars['String']['input']>;
  until?: InputMaybe<Scalars['String']['input']>;
  after?: InputMaybe<Scalars['String']['input']>;
  before?: InputMaybe<Scalars['String']['input']>;
  grep?: InputMaybe<Scalars['String']['input']>;
  sourceFilter?: InputMaybe<LogSourceFilter>;
  limit?: InputMaybe<Scalars['Int']['input']>;
}>;


export type LogRecordsFetchQuery = { __typename?: 'Query', logRecordsFetch?: { __typename?: 'LogRecordsQueryResponse', nextCursor?: string | null, records: Array<{ __typename?: 'LogRecord', timestamp: any, message: string, source: { __typename?: 'LogSource', namespace: string, podName: string, containerName: string, containerID: string, metadata: { __typename?: 'LogSourceMetadata', region: string, zone: string, os: string, arch: string, node: string } } }> } | null };

export type LogRecordsFollowSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  sources: Array<Scalars['String']['input']> | Scalars['String']['input'];
  since?: InputMaybe<Scalars['String']['input']>;
  after?: InputMaybe<Scalars['String']['input']>;
  grep?: InputMaybe<Scalars['String']['input']>;
  sourceFilter?: InputMaybe<LogSourceFilter>;
}>;


export type LogRecordsFollowSubscription = { __typename?: 'Subscription', logRecordsFollow?: { __typename?: 'LogRecord', timestamp: any, message: string, source: { __typename?: 'LogSource', namespace: string, podName: string, containerName: string, containerID: string, metadata: { __typename?: 'LogSourceMetadata', region: string, zone: string, os: string, arch: string, node: string } } } | null };

export type LogSourcesWatchSubscriptionVariables = Exact<{
  kubeContext?: InputMaybe<Scalars['String']['input']>;
  sources: Array<Scalars['String']['input']> | Scalars['String']['input'];
}>;


export type LogSourcesWatchSubscription = { __typename?: 'Subscription', logSourcesWatch?: { __typename?: 'LogSourceWatchEvent', type: WatchEventType, object?: { __typename?: 'LogSource', namespace: string, podName: string, containerName: string, containerID: string, metadata: { __typename?: 'LogSourceMetadata', region: string, zone: string, os: string, arch: string, node: string } } | null } | null };

export type ServerStatusKubernetesApiHealthzGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
}>;


export type ServerStatusKubernetesApiHealthzGetQuery = { __typename?: 'Query', kubernetesAPIHealthzGet: { __typename?: 'HealthCheckResponse', status: HealthCheckStatus, message?: string | null, timestamp: any } };

export type ServerStatusKubernetesApiHealthzWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
}>;


export type ServerStatusKubernetesApiHealthzWatchSubscription = { __typename?: 'Subscription', kubernetesAPIHealthzWatch: { __typename?: 'HealthCheckResponse', status: HealthCheckStatus, message?: string | null, timestamp: any } };

export type ServerStatusClusterApiHealthzGetQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
}>;


export type ServerStatusClusterApiHealthzGetQuery = { __typename?: 'Query', clusterAPIHealthzGet: { __typename?: 'HealthCheckResponse', status: HealthCheckStatus, message?: string | null, timestamp: any } };

export type ServerStatusClusterApiHealthzWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  serviceName?: InputMaybe<Scalars['String']['input']>;
}>;


export type ServerStatusClusterApiHealthzWatchSubscription = { __typename?: 'Subscription', clusterAPIHealthzWatch: { __typename?: 'HealthCheckResponse', status: HealthCheckStatus, message?: string | null, timestamp: any } };

export type SourcePickerCronJobsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerCronJobsCountFetchQuery = { __typename?: 'Query', batchV1CronJobsList?: { __typename?: 'BatchV1CronJobList', items: Array<{ __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerCronJobsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerCronJobsCountWatchSubscription = { __typename?: 'Subscription', batchV1CronJobsWatch?: { __typename?: 'BatchV1CronJobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerDaemonSetsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDaemonSetsCountFetchQuery = { __typename?: 'Query', appsV1DaemonSetsList?: { __typename?: 'AppsV1DaemonSetList', items: Array<{ __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerDaemonSetsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDaemonSetsCountWatchSubscription = { __typename?: 'Subscription', appsV1DaemonSetsWatch?: { __typename?: 'AppsV1DaemonSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerDeploymentsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDeploymentsCountFetchQuery = { __typename?: 'Query', appsV1DeploymentsList?: { __typename?: 'AppsV1DeploymentList', items: Array<{ __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerDeploymentsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDeploymentsCountWatchSubscription = { __typename?: 'Subscription', appsV1DeploymentsWatch?: { __typename?: 'AppsV1DeploymentsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerJobsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerJobsCountFetchQuery = { __typename?: 'Query', batchV1JobsList?: { __typename?: 'BatchV1JobList', items: Array<{ __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerJobsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerJobsCountWatchSubscription = { __typename?: 'Subscription', batchV1JobsWatch?: { __typename?: 'BatchV1JobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerPodsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerPodsCountFetchQuery = { __typename?: 'Query', coreV1PodsList?: { __typename?: 'CoreV1PodList', items: Array<{ __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerPodsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerPodsCountWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerReplicaSetsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerReplicaSetsCountFetchQuery = { __typename?: 'Query', appsV1ReplicaSetsList?: { __typename?: 'AppsV1ReplicaSetList', items: Array<{ __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerReplicaSetsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerReplicaSetsCountWatchSubscription = { __typename?: 'Subscription', appsV1ReplicaSetsWatch?: { __typename?: 'AppsV1ReplicaSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerStatefulSetsCountFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerStatefulSetsCountFetchQuery = { __typename?: 'Query', appsV1StatefulSetsList?: { __typename?: 'AppsV1StatefulSetList', items: Array<{ __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', remainingItemCount?: any | null, resourceVersion: string } } | null };

export type SourcePickerStatefulSetsCountWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerStatefulSetsCountWatchSubscription = { __typename?: 'Subscription', appsV1StatefulSetsWatch?: { __typename?: 'AppsV1StatefulSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', resourceVersion: string } } | null } | null };

export type SourcePickerCronJobsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerCronJobsListFetchQuery = { __typename?: 'Query', batchV1CronJobsList?: { __typename?: 'BatchV1CronJobList', items: Array<{ __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerCronJobsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerCronJobsListWatchSubscription = { __typename?: 'Subscription', batchV1CronJobsWatch?: { __typename?: 'BatchV1CronJobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1CronJob', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerDaemonSetsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDaemonSetsListFetchQuery = { __typename?: 'Query', appsV1DaemonSetsList?: { __typename?: 'AppsV1DaemonSetList', items: Array<{ __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerDaemonSetsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDaemonSetsListWatchSubscription = { __typename?: 'Subscription', appsV1DaemonSetsWatch?: { __typename?: 'AppsV1DaemonSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1DaemonSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerDeploymentsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDeploymentsListFetchQuery = { __typename?: 'Query', appsV1DeploymentsList?: { __typename?: 'AppsV1DeploymentList', items: Array<{ __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerDeploymentsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerDeploymentsListWatchSubscription = { __typename?: 'Subscription', appsV1DeploymentsWatch?: { __typename?: 'AppsV1DeploymentsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1Deployment', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerJobsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerJobsListFetchQuery = { __typename?: 'Query', batchV1JobsList?: { __typename?: 'BatchV1JobList', items: Array<{ __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerJobsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerJobsListWatchSubscription = { __typename?: 'Subscription', batchV1JobsWatch?: { __typename?: 'BatchV1JobsWatchEvent', type: WatchEventType, object?: { __typename?: 'BatchV1Job', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerNamespacesListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerNamespacesListFetchQuery = { __typename?: 'Query', coreV1NamespacesList?: { __typename?: 'CoreV1NamespaceList', items: Array<{ __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerNamespacesListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerNamespacesListWatchSubscription = { __typename?: 'Subscription', coreV1NamespacesWatch?: { __typename?: 'CoreV1NamespacesWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Namespace', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerPodsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerPodsListFetchQuery = { __typename?: 'Query', coreV1PodsList?: { __typename?: 'CoreV1PodList', items: Array<{ __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerPodsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerPodsListWatchSubscription = { __typename?: 'Subscription', coreV1PodsWatch?: { __typename?: 'CoreV1PodsWatchEvent', type: WatchEventType, object?: { __typename?: 'CoreV1Pod', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerReplicaSetsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerReplicaSetsListFetchQuery = { __typename?: 'Query', appsV1ReplicaSetsList?: { __typename?: 'AppsV1ReplicaSetList', items: Array<{ __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerReplicaSetsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerReplicaSetsListWatchSubscription = { __typename?: 'Subscription', appsV1ReplicaSetsWatch?: { __typename?: 'AppsV1ReplicaSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1ReplicaSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } } | null } | null };

export type SourcePickerStatefulSetsListFetchQueryVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  continue?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerStatefulSetsListFetchQuery = { __typename?: 'Query', appsV1StatefulSetsList?: { __typename?: 'AppsV1StatefulSetList', items: Array<{ __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string } }>, metadata: { __typename?: 'MetaV1ListMeta', continue: string, resourceVersion: string } } | null };

export type SourcePickerStatefulSetsListWatchSubscriptionVariables = Exact<{
  kubeContext: Scalars['String']['input'];
  namespace?: InputMaybe<Scalars['String']['input']>;
  resourceVersion?: InputMaybe<Scalars['String']['input']>;
}>;


export type SourcePickerStatefulSetsListWatchSubscription = { __typename?: 'Subscription', appsV1StatefulSetsWatch?: { __typename?: 'AppsV1StatefulSetsWatchEvent', type: WatchEventType, object?: { __typename?: 'AppsV1StatefulSet', id: string, metadata: { __typename?: 'MetaV1ObjectMeta', namespace: string, name: string, uid: string, creationTimestamp: any, deletionTimestamp?: any | null, resourceVersion: string, ownerReferences: Array<{ __typename?: 'MetaV1OwnerReference', name: string, uid: string, controller?: boolean | null }> } } | null } | null };

export const ConsoleLoggingResourcesGenericObjectFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesGenericObjectFragmentFragment, unknown>;
export const ConsoleLoggingResourcesCronJobFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"jobTemplate"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesCronJobFragmentFragment, unknown>;
export const ConsoleLoggingResourcesDaemonSetFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDaemonSetFragmentFragment, unknown>;
export const ConsoleLoggingResourcesDeploymentFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDeploymentFragmentFragment, unknown>;
export const ConsoleLoggingResourcesJobFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesJobFragmentFragment, unknown>;
export const ConsoleLoggingResourcesPodFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesPodFragmentFragment, unknown>;
export const ConsoleLoggingResourcesReplicaSetFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesReplicaSetFragmentFragment, unknown>;
export const ConsoleLoggingResourcesStatefulSetFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesStatefulSetFragmentFragment, unknown>;
export const ConsoleLoggingResourcesJobsFindFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobsFindFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesJobsFindFragmentFragment, unknown>;
export const ConsoleNodesListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleNodesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Node"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"labels"}},{"kind":"Field","name":{"kind":"Name","value":"annotations"}}]}}]}}]} as unknown as DocumentNode<ConsoleNodesListItemFragmentFragment, unknown>;
export const HealthCheckResponseFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HealthCheckResponseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HealthCheckResponse"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"status"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}}]}}]} as unknown as DocumentNode<HealthCheckResponseFragmentFragment, unknown>;
export const HelmReleaseFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HelmReleaseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HelmRelease"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"chart"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"appVersion"}}]}}]}}]}}]} as unknown as DocumentNode<HelmReleaseFragmentFragment, unknown>;
export const HomeGenericListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeGenericListItemFragmentFragment, unknown>;
export const HomeCronJobsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeCronJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeCronJobsListItemFragmentFragment, unknown>;
export const HomeDaemonSetsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDaemonSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeDaemonSetsListItemFragmentFragment, unknown>;
export const HomeDeploymentsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDeploymentsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeDeploymentsListItemFragmentFragment, unknown>;
export const HomeJobsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeJobsListItemFragmentFragment, unknown>;
export const HomeGenericListFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<HomeGenericListFragmentFragment, unknown>;
export const HomeNamespacesListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeNamespacesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Namespace"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeNamespacesListItemFragmentFragment, unknown>;
export const HomePodsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomePodsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerID"}},{"kind":"Field","name":{"kind":"Name","value":"started"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomePodsListItemFragmentFragment, unknown>;
export const HomeReplicaSetsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeReplicaSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeReplicaSetsListItemFragmentFragment, unknown>;
export const HomeStatefulSetsListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}}]} as unknown as DocumentNode<HomeStatefulSetsListItemFragmentFragment, unknown>;
export const ClusterApiServicesListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ClusterAPIServicesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Service"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"ports"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"port"}},{"kind":"Field","name":{"kind":"Name","value":"appProtocol"}}]}}]}}]}}]} as unknown as DocumentNode<ClusterApiServicesListItemFragmentFragment, unknown>;
export const KubeConfigFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"KubeConfigFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"KubeConfig"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"currentContext"}},{"kind":"Field","name":{"kind":"Name","value":"contexts"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"cluster"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}}]}}]}}]} as unknown as DocumentNode<KubeConfigFragmentFragment, unknown>;
export const LogSourceFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogSourceFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogSource"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"region"}},{"kind":"Field","name":{"kind":"Name","value":"zone"}},{"kind":"Field","name":{"kind":"Name","value":"os"}},{"kind":"Field","name":{"kind":"Name","value":"arch"}},{"kind":"Field","name":{"kind":"Name","value":"node"}}]}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"podName"}},{"kind":"Field","name":{"kind":"Name","value":"containerName"}},{"kind":"Field","name":{"kind":"Name","value":"containerID"}}]}}]} as unknown as DocumentNode<LogSourceFragmentFragment, unknown>;
export const LogRecordsFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogRecordsFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogRecord"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"timestamp"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"source"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogSourceFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogSourceFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogSource"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"region"}},{"kind":"Field","name":{"kind":"Name","value":"zone"}},{"kind":"Field","name":{"kind":"Name","value":"os"}},{"kind":"Field","name":{"kind":"Name","value":"arch"}},{"kind":"Field","name":{"kind":"Name","value":"node"}}]}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"podName"}},{"kind":"Field","name":{"kind":"Name","value":"containerName"}},{"kind":"Field","name":{"kind":"Name","value":"containerID"}}]}}]} as unknown as DocumentNode<LogRecordsFragmentFragment, unknown>;
export const SourcePickerGenericCounterItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerGenericCounterItemFragmentFragment, unknown>;
export const SourcePickerGenericCounterFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerGenericCounterFragmentFragment, unknown>;
export const SourcePickerGenericListFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerGenericListFragmentFragment, unknown>;
export const SourcePickerGenericListItemFragmentFragmentDoc = {"kind":"Document","definitions":[{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerGenericListItemFragmentFragment, unknown>;
export const ConsoleLoggingResourcesCronJobGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"jobTemplate"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesCronJobGetQuery, ConsoleLoggingResourcesCronJobGetQueryVariables>;
export const ConsoleLoggingResourcesCronJobWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesCronJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"jobTemplate"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesCronJobWatchSubscription, ConsoleLoggingResourcesCronJobWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesDaemonSetGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDaemonSetGetQuery, ConsoleLoggingResourcesDaemonSetGetQueryVariables>;
export const ConsoleLoggingResourcesDaemonSetWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDaemonSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDaemonSetWatchSubscription, ConsoleLoggingResourcesDaemonSetWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesDeploymentGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDeploymentGetQuery, ConsoleLoggingResourcesDeploymentGetQueryVariables>;
export const ConsoleLoggingResourcesDeploymentWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesDeploymentFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesDeploymentWatchSubscription, ConsoleLoggingResourcesDeploymentWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesJobGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesJobGetQuery, ConsoleLoggingResourcesJobGetQueryVariables>;
export const ConsoleLoggingResourcesJobWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesJobWatchSubscription, ConsoleLoggingResourcesJobWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesPodGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesPodGetQuery, ConsoleLoggingResourcesPodGetQueryVariables>;
export const ConsoleLoggingResourcesPodWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesPodWatchSubscription, ConsoleLoggingResourcesPodWatchSubscriptionVariables>;
export const ConsolePodsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsolePodsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsolePodsListFetchQuery, ConsolePodsListFetchQueryVariables>;
export const ConsolePodsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsolePodsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsolePodsListWatchSubscription, ConsolePodsListWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesReplicaSetGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesReplicaSetGetQuery, ConsoleLoggingResourcesReplicaSetGetQueryVariables>;
export const ConsoleLoggingResourcesReplicaSetWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesReplicaSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesReplicaSetWatchSubscription, ConsoleLoggingResourcesReplicaSetWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesStatefulSetGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"name"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"name"},"value":{"kind":"Variable","name":{"kind":"Name","value":"name"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesStatefulSetGetQuery, ConsoleLoggingResourcesStatefulSetGetQueryVariables>;
export const ConsoleLoggingResourcesStatefulSetWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"fieldSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"fieldSelector"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesStatefulSetFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesStatefulSetWatchSubscription, ConsoleLoggingResourcesStatefulSetWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesJobsFindDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobsFind"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobsFindFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobsFindFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesJobsFindQuery, ConsoleLoggingResourcesJobsFindQueryVariables>;
export const ConsoleStreamsJobsWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleStreamsJobsWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesJobFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"selector"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"matchLabels"}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleStreamsJobsWatchSubscription, ConsoleStreamsJobsWatchSubscriptionVariables>;
export const ConsoleLoggingResourcesPodsFindDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodsFind"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"labelSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"labelSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"labelSelector"}}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesPodsFindQuery, ConsoleLoggingResourcesPodsFindQueryVariables>;
export const ConsoleLoggingResourcesPodsWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodsWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"labelSelector"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"labelSelector"},"value":{"kind":"Variable","name":{"kind":"Name","value":"labelSelector"}}},{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleLoggingResourcesPodFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleLoggingResourcesGenericObjectFragment"}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containers"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nodeName"}}]}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"started"}},{"kind":"Field","name":{"kind":"Name","value":"state"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"running"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"startedAt"}}]}},{"kind":"Field","name":{"kind":"Name","value":"terminated"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"exitCode"}}]}}]}}]}}]}}]}}]} as unknown as DocumentNode<ConsoleLoggingResourcesPodsWatchSubscription, ConsoleLoggingResourcesPodsWatchSubscriptionVariables>;
export const ConsoleNodesListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ConsoleNodesListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NodesList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleNodesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleNodesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Node"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"labels"}},{"kind":"Field","name":{"kind":"Name","value":"annotations"}}]}}]}}]} as unknown as DocumentNode<ConsoleNodesListFetchQuery, ConsoleNodesListFetchQueryVariables>;
export const ConsoleNodesListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ConsoleNodesListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NodesWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ConsoleNodesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ConsoleNodesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Node"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"labels"}},{"kind":"Field","name":{"kind":"Name","value":"annotations"}}]}}]}}]} as unknown as DocumentNode<ConsoleNodesListWatchSubscription, ConsoleNodesListWatchSubscriptionVariables>;
export const HomeCronJobsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeCronJobsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeCronJobsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeCronJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeCronJobsListFetchQuery, HomeCronJobsListFetchQueryVariables>;
export const HomeCronJobsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeCronJobsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeCronJobsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeCronJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1CronJob"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeCronJobsListWatchSubscription, HomeCronJobsListWatchSubscriptionVariables>;
export const HomeDaemonSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeDaemonSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeDaemonSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDaemonSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeDaemonSetsListFetchQuery, HomeDaemonSetsListFetchQueryVariables>;
export const HomeDaemonSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeDaemonSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeDaemonSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDaemonSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1DaemonSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeDaemonSetsListWatchSubscription, HomeDaemonSetsListWatchSubscriptionVariables>;
export const HomeDeploymentsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeDeploymentsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeDeploymentsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDeploymentsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeDeploymentsListFetchQuery, HomeDeploymentsListFetchQueryVariables>;
export const HomeDeploymentsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeDeploymentsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeDeploymentsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeDeploymentsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1Deployment"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeDeploymentsListWatchSubscription, HomeDeploymentsListWatchSubscriptionVariables>;
export const HomeJobsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeJobsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeJobsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeJobsListFetchQuery, HomeJobsListFetchQueryVariables>;
export const HomeJobsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeJobsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeJobsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeJobsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"BatchV1Job"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeJobsListWatchSubscription, HomeJobsListWatchSubscriptionVariables>;
export const HomeNamespacesListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeNamespacesListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NamespacesList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeNamespacesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeNamespacesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Namespace"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeNamespacesListFetchQuery, HomeNamespacesListFetchQueryVariables>;
export const HomeNamespacesListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeNamespacesListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NamespacesWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeNamespacesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeNamespacesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Namespace"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeNamespacesListWatchSubscription, HomeNamespacesListWatchSubscriptionVariables>;
export const HomePodsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomePodsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomePodsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomePodsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerID"}},{"kind":"Field","name":{"kind":"Name","value":"started"}}]}}]}}]}}]} as unknown as DocumentNode<HomePodsListFetchQuery, HomePodsListFetchQueryVariables>;
export const HomePodsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomePodsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomePodsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomePodsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Pod"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}},{"kind":"Field","name":{"kind":"Name","value":"status"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerStatuses"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"containerID"}},{"kind":"Field","name":{"kind":"Name","value":"started"}}]}}]}}]}}]} as unknown as DocumentNode<HomePodsListWatchSubscription, HomePodsListWatchSubscriptionVariables>;
export const HomeReplicaSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeReplicaSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeReplicaSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeReplicaSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeReplicaSetsListFetchQuery, HomeReplicaSetsListFetchQueryVariables>;
export const HomeReplicaSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeReplicaSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeReplicaSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeReplicaSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1ReplicaSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeReplicaSetsListWatchSubscription, HomeReplicaSetsListWatchSubscriptionVariables>;
export const HomeStatefulSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HomeStatefulSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeStatefulSetsListFetchQuery, HomeStatefulSetsListFetchQueryVariables>;
export const HomeStatefulSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"HomeStatefulSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<HomeStatefulSetsListWatchSubscription, HomeStatefulSetsListWatchSubscriptionVariables>;
export const ClusterApiReadyWaitDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ClusterAPIReadyWait"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"clusterAPIReadyWait"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"serviceName"},"value":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}}}]}]}}]} as unknown as DocumentNode<ClusterApiReadyWaitSubscription, ClusterApiReadyWaitSubscriptionVariables>;
export const ClusterApiServicesListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ClusterAPIServicesListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"clusterAPIServicesList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ClusterAPIServicesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ClusterAPIServicesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Service"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"ports"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"port"}},{"kind":"Field","name":{"kind":"Name","value":"appProtocol"}}]}}]}}]}}]} as unknown as DocumentNode<ClusterApiServicesListFetchQuery, ClusterApiServicesListFetchQueryVariables>;
export const ClusterApiServicesListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ClusterAPIServicesListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"clusterAPIServicesWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"ClusterAPIServicesListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"ClusterAPIServicesListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"CoreV1Service"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"spec"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"ports"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"port"}},{"kind":"Field","name":{"kind":"Name","value":"appProtocol"}}]}}]}}]}}]} as unknown as DocumentNode<ClusterApiServicesListWatchSubscription, ClusterApiServicesListWatchSubscriptionVariables>;
export const HelmInstallLatestDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"mutation","name":{"kind":"Name","value":"HelmInstallLatest"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"helmInstallLatest"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HelmReleaseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HelmReleaseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HelmRelease"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"chart"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"appVersion"}}]}}]}}]}}]} as unknown as DocumentNode<HelmInstallLatestMutation, HelmInstallLatestMutationVariables>;
export const HelmListReleasesDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"HelmListReleases"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"helmListReleases"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HelmReleaseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HelmReleaseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HelmRelease"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"chart"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"version"}},{"kind":"Field","name":{"kind":"Name","value":"appVersion"}}]}}]}}]}}]} as unknown as DocumentNode<HelmListReleasesQuery, HelmListReleasesQueryVariables>;
export const KubeConfigGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"KubeConfigGet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"kubeConfigGet"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"KubeConfigFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"KubeConfigFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"KubeConfig"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"currentContext"}},{"kind":"Field","name":{"kind":"Name","value":"contexts"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"cluster"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}}]}}]}}]} as unknown as DocumentNode<KubeConfigGetQuery, KubeConfigGetQueryVariables>;
export const KubeConfigWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"KubeConfigWatch"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"kubeConfigWatch"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"KubeConfigFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"KubeConfigFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"KubeConfig"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"currentContext"}},{"kind":"Field","name":{"kind":"Name","value":"contexts"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"cluster"}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}}]}}]}}]} as unknown as DocumentNode<KubeConfigWatchSubscription, KubeConfigWatchSubscriptionVariables>;
export const KubernetesApiReadyWaitDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"KubernetesAPIReadyWait"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"kubernetesAPIReadyWait"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}}]}]}}]} as unknown as DocumentNode<KubernetesApiReadyWaitSubscription, KubernetesApiReadyWaitSubscriptionVariables>;
export const LogRecordsFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"LogRecordsFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"sources"}},"type":{"kind":"NonNullType","type":{"kind":"ListType","type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"mode"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"LogRecordsQueryMode"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"since"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"until"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"after"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"before"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"grep"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"sourceFilter"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"LogSourceFilter"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"limit"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"Int"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"logRecordsFetch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"sources"},"value":{"kind":"Variable","name":{"kind":"Name","value":"sources"}}},{"kind":"Argument","name":{"kind":"Name","value":"mode"},"value":{"kind":"Variable","name":{"kind":"Name","value":"mode"}}},{"kind":"Argument","name":{"kind":"Name","value":"since"},"value":{"kind":"Variable","name":{"kind":"Name","value":"since"}}},{"kind":"Argument","name":{"kind":"Name","value":"until"},"value":{"kind":"Variable","name":{"kind":"Name","value":"until"}}},{"kind":"Argument","name":{"kind":"Name","value":"after"},"value":{"kind":"Variable","name":{"kind":"Name","value":"after"}}},{"kind":"Argument","name":{"kind":"Name","value":"before"},"value":{"kind":"Variable","name":{"kind":"Name","value":"before"}}},{"kind":"Argument","name":{"kind":"Name","value":"grep"},"value":{"kind":"Variable","name":{"kind":"Name","value":"grep"}}},{"kind":"Argument","name":{"kind":"Name","value":"sourceFilter"},"value":{"kind":"Variable","name":{"kind":"Name","value":"sourceFilter"}}},{"kind":"Argument","name":{"kind":"Name","value":"limit"},"value":{"kind":"Variable","name":{"kind":"Name","value":"limit"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"records"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogRecordsFragment"}}]}},{"kind":"Field","name":{"kind":"Name","value":"nextCursor"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogSourceFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogSource"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"region"}},{"kind":"Field","name":{"kind":"Name","value":"zone"}},{"kind":"Field","name":{"kind":"Name","value":"os"}},{"kind":"Field","name":{"kind":"Name","value":"arch"}},{"kind":"Field","name":{"kind":"Name","value":"node"}}]}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"podName"}},{"kind":"Field","name":{"kind":"Name","value":"containerName"}},{"kind":"Field","name":{"kind":"Name","value":"containerID"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogRecordsFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogRecord"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"timestamp"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"source"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogSourceFragment"}}]}}]}}]} as unknown as DocumentNode<LogRecordsFetchQuery, LogRecordsFetchQueryVariables>;
export const LogRecordsFollowDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"LogRecordsFollow"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"sources"}},"type":{"kind":"NonNullType","type":{"kind":"ListType","type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"since"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"after"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"grep"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"sourceFilter"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"LogSourceFilter"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"logRecordsFollow"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"sources"},"value":{"kind":"Variable","name":{"kind":"Name","value":"sources"}}},{"kind":"Argument","name":{"kind":"Name","value":"since"},"value":{"kind":"Variable","name":{"kind":"Name","value":"since"}}},{"kind":"Argument","name":{"kind":"Name","value":"after"},"value":{"kind":"Variable","name":{"kind":"Name","value":"after"}}},{"kind":"Argument","name":{"kind":"Name","value":"grep"},"value":{"kind":"Variable","name":{"kind":"Name","value":"grep"}}},{"kind":"Argument","name":{"kind":"Name","value":"sourceFilter"},"value":{"kind":"Variable","name":{"kind":"Name","value":"sourceFilter"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogRecordsFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogSourceFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogSource"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"region"}},{"kind":"Field","name":{"kind":"Name","value":"zone"}},{"kind":"Field","name":{"kind":"Name","value":"os"}},{"kind":"Field","name":{"kind":"Name","value":"arch"}},{"kind":"Field","name":{"kind":"Name","value":"node"}}]}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"podName"}},{"kind":"Field","name":{"kind":"Name","value":"containerName"}},{"kind":"Field","name":{"kind":"Name","value":"containerID"}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogRecordsFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogRecord"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"timestamp"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"source"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogSourceFragment"}}]}}]}}]} as unknown as DocumentNode<LogRecordsFollowSubscription, LogRecordsFollowSubscriptionVariables>;
export const LogSourcesWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"LogSourcesWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"sources"}},"type":{"kind":"NonNullType","type":{"kind":"ListType","type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"logSourcesWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"sources"},"value":{"kind":"Variable","name":{"kind":"Name","value":"sources"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"LogSourceFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"LogSourceFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"LogSource"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"region"}},{"kind":"Field","name":{"kind":"Name","value":"zone"}},{"kind":"Field","name":{"kind":"Name","value":"os"}},{"kind":"Field","name":{"kind":"Name","value":"arch"}},{"kind":"Field","name":{"kind":"Name","value":"node"}}]}},{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"podName"}},{"kind":"Field","name":{"kind":"Name","value":"containerName"}},{"kind":"Field","name":{"kind":"Name","value":"containerID"}}]}}]} as unknown as DocumentNode<LogSourcesWatchSubscription, LogSourcesWatchSubscriptionVariables>;
export const ServerStatusKubernetesApiHealthzGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ServerStatusKubernetesAPIHealthzGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"kubernetesAPIHealthzGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HealthCheckResponseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HealthCheckResponseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HealthCheckResponse"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"status"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}}]}}]} as unknown as DocumentNode<ServerStatusKubernetesApiHealthzGetQuery, ServerStatusKubernetesApiHealthzGetQueryVariables>;
export const ServerStatusKubernetesApiHealthzWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ServerStatusKubernetesAPIHealthzWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"kubernetesAPIHealthzWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HealthCheckResponseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HealthCheckResponseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HealthCheckResponse"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"status"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}}]}}]} as unknown as DocumentNode<ServerStatusKubernetesApiHealthzWatchSubscription, ServerStatusKubernetesApiHealthzWatchSubscriptionVariables>;
export const ServerStatusClusterApiHealthzGetDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"ServerStatusClusterAPIHealthzGet"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"clusterAPIHealthzGet"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"serviceName"},"value":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HealthCheckResponseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HealthCheckResponseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HealthCheckResponse"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"status"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}}]}}]} as unknown as DocumentNode<ServerStatusClusterApiHealthzGetQuery, ServerStatusClusterApiHealthzGetQueryVariables>;
export const ServerStatusClusterApiHealthzWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"ServerStatusClusterAPIHealthzWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"clusterAPIHealthzWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"serviceName"},"value":{"kind":"Variable","name":{"kind":"Name","value":"serviceName"}}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HealthCheckResponseFragment"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HealthCheckResponseFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"HealthCheckResponse"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"status"}},{"kind":"Field","name":{"kind":"Name","value":"message"}},{"kind":"Field","name":{"kind":"Name","value":"timestamp"}}]}}]} as unknown as DocumentNode<ServerStatusClusterApiHealthzWatchSubscription, ServerStatusClusterApiHealthzWatchSubscriptionVariables>;
export const SourcePickerCronJobsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerCronJobsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerCronJobsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerCronJobsCountFetchQuery, SourcePickerCronJobsCountFetchQueryVariables>;
export const SourcePickerCronJobsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerCronJobsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerCronJobsCountWatchSubscription, SourcePickerCronJobsCountWatchSubscriptionVariables>;
export const SourcePickerDaemonSetsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerDaemonSetsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerDaemonSetsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDaemonSetsCountFetchQuery, SourcePickerDaemonSetsCountFetchQueryVariables>;
export const SourcePickerDaemonSetsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerDaemonSetsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDaemonSetsCountWatchSubscription, SourcePickerDaemonSetsCountWatchSubscriptionVariables>;
export const SourcePickerDeploymentsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerDeploymentsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerDeploymentsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDeploymentsCountFetchQuery, SourcePickerDeploymentsCountFetchQueryVariables>;
export const SourcePickerDeploymentsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerDeploymentsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDeploymentsCountWatchSubscription, SourcePickerDeploymentsCountWatchSubscriptionVariables>;
export const SourcePickerJobsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerJobsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerJobsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerJobsCountFetchQuery, SourcePickerJobsCountFetchQueryVariables>;
export const SourcePickerJobsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerJobsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerJobsCountWatchSubscription, SourcePickerJobsCountWatchSubscriptionVariables>;
export const SourcePickerPodsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerPodsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerPodsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerPodsCountFetchQuery, SourcePickerPodsCountFetchQueryVariables>;
export const SourcePickerPodsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerPodsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerPodsCountWatchSubscription, SourcePickerPodsCountWatchSubscriptionVariables>;
export const SourcePickerReplicaSetsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerReplicaSetsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerReplicaSetsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerReplicaSetsCountFetchQuery, SourcePickerReplicaSetsCountFetchQueryVariables>;
export const SourcePickerReplicaSetsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerReplicaSetsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerReplicaSetsCountWatchSubscription, SourcePickerReplicaSetsCountWatchSubscriptionVariables>;
export const SourcePickerStatefulSetsCountFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerStatefulSetsCountFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"1","block":false}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerStatefulSetsCountFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"remainingItemCount"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]} as unknown as DocumentNode<SourcePickerStatefulSetsCountFetchQuery, SourcePickerStatefulSetsCountFetchQueryVariables>;
export const SourcePickerStatefulSetsCountWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerStatefulSetsCountWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericCounterItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerStatefulSetsCountWatchSubscription, SourcePickerStatefulSetsCountWatchSubscriptionVariables>;
export const SourcePickerCronJobsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerCronJobsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerCronJobsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerCronJobsListFetchQuery, SourcePickerCronJobsListFetchQueryVariables>;
export const SourcePickerCronJobsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerCronJobsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1CronJobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerCronJobsListWatchSubscription, SourcePickerCronJobsListWatchSubscriptionVariables>;
export const SourcePickerDaemonSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerDaemonSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerDaemonSetsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDaemonSetsListFetchQuery, SourcePickerDaemonSetsListFetchQueryVariables>;
export const SourcePickerDaemonSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerDaemonSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DaemonSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDaemonSetsListWatchSubscription, SourcePickerDaemonSetsListWatchSubscriptionVariables>;
export const SourcePickerDeploymentsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerDeploymentsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerDeploymentsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDeploymentsListFetchQuery, SourcePickerDeploymentsListFetchQueryVariables>;
export const SourcePickerDeploymentsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerDeploymentsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1DeploymentsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerDeploymentsListWatchSubscription, SourcePickerDeploymentsListWatchSubscriptionVariables>;
export const SourcePickerJobsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerJobsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerJobsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerJobsListFetchQuery, SourcePickerJobsListFetchQueryVariables>;
export const SourcePickerJobsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerJobsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"batchV1JobsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerJobsListWatchSubscription, SourcePickerJobsListWatchSubscriptionVariables>;
export const SourcePickerNamespacesListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerNamespacesListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NamespacesList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerNamespacesListFetchQuery, SourcePickerNamespacesListFetchQueryVariables>;
export const SourcePickerNamespacesListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerNamespacesListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1NamespacesWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerNamespacesListWatchSubscription, SourcePickerNamespacesListWatchSubscriptionVariables>;
export const SourcePickerPodsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerPodsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerPodsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerPodsListFetchQuery, SourcePickerPodsListFetchQueryVariables>;
export const SourcePickerPodsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerPodsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"coreV1PodsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerPodsListWatchSubscription, SourcePickerPodsListWatchSubscriptionVariables>;
export const SourcePickerReplicaSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerReplicaSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerReplicaSetsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerReplicaSetsListFetchQuery, SourcePickerReplicaSetsListFetchQueryVariables>;
export const SourcePickerReplicaSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerReplicaSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1ReplicaSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerReplicaSetsListWatchSubscription, SourcePickerReplicaSetsListWatchSubscriptionVariables>;
export const SourcePickerStatefulSetsListFetchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"query","name":{"kind":"Name","value":"SourcePickerStatefulSetsListFetch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"continue"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsList"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"limit"},"value":{"kind":"StringValue","value":"50","block":false}},{"kind":"ObjectField","name":{"kind":"Name","value":"continue"},"value":{"kind":"Variable","name":{"kind":"Name","value":"continue"}}}]}}],"directives":[{"kind":"Directive","name":{"kind":"Name","value":"connection"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"key"},"value":{"kind":"StringValue","value":"SourcePickerStatefulSetsListFetch","block":false}}]}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListFragment"}},{"kind":"Field","name":{"kind":"Name","value":"items"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"List"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"continue"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"SourcePickerGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}}]}}]}}]} as unknown as DocumentNode<SourcePickerStatefulSetsListFetchQuery, SourcePickerStatefulSetsListFetchQueryVariables>;
export const SourcePickerStatefulSetsListWatchDocument = {"kind":"Document","definitions":[{"kind":"OperationDefinition","operation":"subscription","name":{"kind":"Name","value":"SourcePickerStatefulSetsListWatch"},"variableDefinitions":[{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}},"type":{"kind":"NonNullType","type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}}}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}},{"kind":"VariableDefinition","variable":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}},"type":{"kind":"NamedType","name":{"kind":"Name","value":"String"}},"defaultValue":{"kind":"StringValue","value":"","block":false}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"appsV1StatefulSetsWatch"},"arguments":[{"kind":"Argument","name":{"kind":"Name","value":"kubeContext"},"value":{"kind":"Variable","name":{"kind":"Name","value":"kubeContext"}}},{"kind":"Argument","name":{"kind":"Name","value":"namespace"},"value":{"kind":"Variable","name":{"kind":"Name","value":"namespace"}}},{"kind":"Argument","name":{"kind":"Name","value":"options"},"value":{"kind":"ObjectValue","fields":[{"kind":"ObjectField","name":{"kind":"Name","value":"resourceVersion"},"value":{"kind":"Variable","name":{"kind":"Name","value":"resourceVersion"}}}]}}],"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"type"}},{"kind":"Field","name":{"kind":"Name","value":"object"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeGenericListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"Object"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"id"}},{"kind":"Field","name":{"kind":"Name","value":"metadata"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"namespace"}},{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"creationTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"deletionTimestamp"}},{"kind":"Field","name":{"kind":"Name","value":"resourceVersion"}},{"kind":"Field","name":{"kind":"Name","value":"ownerReferences"},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"Field","name":{"kind":"Name","value":"name"}},{"kind":"Field","name":{"kind":"Name","value":"uid"}},{"kind":"Field","name":{"kind":"Name","value":"controller"}}]}}]}}]}},{"kind":"FragmentDefinition","name":{"kind":"Name","value":"HomeStatefulSetsListItemFragment"},"typeCondition":{"kind":"NamedType","name":{"kind":"Name","value":"AppsV1StatefulSet"}},"selectionSet":{"kind":"SelectionSet","selections":[{"kind":"FragmentSpread","name":{"kind":"Name","value":"HomeGenericListItemFragment"}}]}}]} as unknown as DocumentNode<SourcePickerStatefulSetsListWatchSubscription, SourcePickerStatefulSetsListWatchSubscriptionVariables>;