# _murex_ Shell Docs

## User Guide

This section contains miscellaneous documents on using and configuring the
shell and _murex_'s numerous features.

## Other Reference Material

There are other sections for which are dedicated to _murex_'s parser, builtin
commands and such like:

### Language Guides

1. [GUIDE.builtin-functions](./GUIDE.builtin-functions.md), for docs
on the core builtins.

2. [GUIDE.parser](./GUIDE.parser.md), which details a lot of the logic.

## Pages

* [ANSI Constants](user-guide/ansi.md):
  Infixed constants that return ANSI escape sequences
* [Bang Prefix](user-guide/bang-prefix.md):
  Bang prefixing to reverse default actions
* [Code Block Parsing](user-guide/code-block.md):
  Overview of how code blocks are parsed
* [FileRef](user-guide/fileref.md):
  How to track what code was loaded and from where
* [Modules and Packages](user-guide/modules.md):
  An introduction to _murex_ modules and packages
* [Pipeline](user-guide/pipeline.md):
  Overview of what a "pipeline" is
* [Reserved Variables](user-guide/reserved-vars.md):
  Special variables reserved by _murex_
* [Schedulers](user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in _murex_
* [Spellcheck](user-guide/spellcheck.md):
  How to enable inline spellchecking
* [Variable and Config Scoping](user-guide/scoping.md):
  How scoping works within _murex_
* [_murex_ Profile Files](user-guide/profile.md):
  A breakdown of the different files loaded on start up
* [_murex_'s Interactive Shell](user-guide/interactive-shell.md):
  What's different about _murex_'s interactive shell?