# _murex_ Change Log

## What's new in murex v2.9

Breaking Changes:

* None

Features:

* `>>` redirect (append to file) operator added. This is just syntactic sugar for `-> >>`. To redirect and overwrite/truncate a file use `|>` rather than `>`

* Support for automatic globbing in the commandline. This has to be enabled via `config: set shell auto-glob true` and you will get prompted for each glob. Any globs inside blocks will be ignored and this only works on the interactive prompt (ie not in scripts or background processes) -- these limitations are not a bug but by design

* Dynamic autocomplete suggestions are now cached for 5 seconds by default. This cache can be changed via the **CacheTTL** directive in `autocomplete`

* Additional scoping for `try` and `trypipe`. You can define the scope as being an entire function or a module. If set for an entire module then any functions, autocompletions, etc inside that module will inherit that `try` or `trypipe` mode automatically. These are set via the new builtin `runmode`

* New reserved variable `$PWD` (this was just a global variable previously)

* Additional flags added to range, `@[`

* New builtin, `man-get-flags`. This exposes _murex_'s internal man page parser to the command line scripts

* Binaries now produced for ARM64 Windows

Minor Changes:

* The order in which namespaces are looked up has been altered since `private`s should be resolved before `function`s

* Updated autocomplete for homebrew, `brew`

* New autocomplete for AWS CLI, `aws`

* New autocomplete for yarn, `yarn`

* _murex_ unit tests should report progressively rather than everything upon completion

* Minimum recommended version of Go has been raised to 1.15. This is due to some bugs in dependencies when running tests against v1.13 and v1.14. _murex_ will technically compile and work on them but it not worth my time debugging why the CircleCI tests fail for those versions given their age

* Vendor directory removed. This isn't really needed now support is focused on newer versions of Go

* Website: New 404 error

* Website: search bar added

* The start of a massive push towards upping the test coverage

* Lots of improvements to the docs

Bug Fixes:

* FileRef module string for functions forked from the REPL changed to `murex/shell` to bring it inline with the naming convention of other modules

<hr>

Published: 15.07.2022 at 20:35

## See Also

* [parser/Append Pipe (`>>`) Token](../parser/pipe-append.md):
  Redirects STDOUT to a file and append its contents
* [user-guide/Reserved Variables](../user-guide/reserved-vars.md):
  Special variables reserved by _murex_
* [user-guide/Schedulers](../user-guide/schedulers.md):
  Overview of the different schedulers (or 'run modes') in _murex_
* [commands/`>>` (append file)](../commands/greater-than-greater-than.md):
  Writes STDIN to disk - appending contents if file already exists
* [commands/`>` (truncate file)](../commands/greater-than.md):
  Writes STDIN to disk - overwriting contents if file already exists
* [commands/`@[` (range) ](../commands/range.md):
  Outputs a ranged subset of data from STDIN
* [commands/`autocomplete`](../commands/autocomplete.md):
  Set definitions for tab-completion in the command line
* [commands/`config`](../commands/config.md):
  Query or define _murex_ runtime settings
* [commands/`function`](../commands/function.md):
  Define a function block
* [commands/`murex-docs`](../commands/murex-docs.md):
  Displays the man pages for _murex_ builtins
* [commands/`private`](../commands/private.md):
  Define a private function block
* [commands/`runmode`](../commands/runmode.md):
  Alter the scheduler's behaviour at higher scoping level
* [commands/`try`](../commands/try.md):
  Handles errors inside a block of code
* [commands/`trypipe`](../commands/trypipe.md):
  Checks state of each function in a pipeline and exits block on error