## Deprecation Warnings

Please read out [compatibility commitment](https://murex.rocks/compatibility.html) to understand how features are deprecated.

* the `?` pipe will be deprecated to make way for a the ternary operator. You can achieve the same result with `<err> <!out>`, eg `command <err> <!out> parameters... | next-command ...`
  
* the `=` and `let` builtins are now officially deprecated. They've been marked as deprecated in the documentation for a couple of years but you'll now receive a deprecation warning when using them. This warning will not impact any functions that call them (they bypass the stdout and stderr pipes and write directly to your TTY) but it is still recommended that you update any existing code not to use it. The change is very simple, Murex supported expressions as first class primitives, so you can simply drop the `=` and `let` command names from your expressions

* `tread` has been deprecated for a while due to `read` supporting all `tread`'s use cases. `tread` will officially be removed in the next release

* `@[]` syntax for ranging has been deprecated for a while. It will be officially removed in the next release in favour of `[]`

* backtick strings (````) has been an undocumented hack for several years. This release officially sees that hack as deprecated and will be removed in the next release

* `die` has been deprecated because it just adds a feature for no purpose. It was original borrowed from Perl but realistically you can do the same with `exit 1` so this removal is to bring the language complexity down.

## Breaking Changes

* `for` syntax change, switching from parenthesis to curly braces ([discussion](https://github.com/lmorg/murex/discussions/855), {{link "documentation" "for"}}) 

* tilde `~` sigil for home directories will now fail if username is not found ([issue #840](https://github.com/lmorg/murex/issues/840))

* support removed for string concatenation via `+=`. This isn't really needed in a shell with infixing support. Removing this feature allows for more common code with other operators and thus fewer bugs

## Features

* variables: tilde `~` sigil for home directories will now fail if username is not found ([issue #840](https://github.com/lmorg/murex/issues/840))

* new builtin + operator: `~>` to perform immutable merges ({{link "read more" "alter"}})

* `count`: added support for `--bytes` and `--runes` ({{link "read more" "count"}})

* variables: Lots of new variables added for POSIX compatibility ([issue #873](https://github.com/lmorg/murex/issues/873))

* expressions: added support for sub-expressions inside object and array builders ([issue #834](https://github.com/lmorg/murex/issues/834))

* core: added support for pseudo-variable pointers via parenthesis ([issue #830](https://github.com/lmorg/murex/issues/830))

* expressions: added support for `++` and `--`

* new builtin: `mjoin` created to join arrays into a string ({{link "read more" "mjoin"}})

* new builtin: `list.case` created to alter the text capitalizations on arrays and strings ({{link "read more" "list.case"}})

* `regexp`: new flag, `M`, returns matches including first row. This is useful if first row is a headings ({{link "read more" "regexp"}})

* `murex`: new flag: `setsid` provides better POSIX support with SID / GPID management. This breaks some of Murex's features so this flag is provided for edge cases where commands capture job control signals

* integrations: added wrapper for Helix editor to support job control
  
* `version`: now includes git's branch name, build date and license. ({{link "read more" "version"}})

* core: `go generate` now builds and executes doc gen. As well as updates Murex's version number and build date

* docgen: added support for sub-categories and Vue menu generation

* `murex`: new environmental variable, `MUREX_DEBUG`, enables `--debug` flag without having to specify a parameter (eg when using Murex as a shell)

* integrations: new integration: orbstack.

* `regexp`: separator can now support separators which are characters larger than 1 byte, ie unicode characters ({{link "read more" "regexp"}})

* `murex`: new flag `--execute` -- this behaves like `-c` except that it takes `@ARGV` parameters instead of a pipeline as a single string

* cicd: added support for Go v1.23

* website: significant updates across all documents

* readline: if terminal is small, the max completion rows is automatically reduced

## Bug Fixes

* core: better conversion of numbers from strings ([issue #874](https://github.com/lmorg/murex/issues/874))

* `config`: errors generated via dynamic config are now better surfaced

* `alter`: fixed nil pointer error in `--merge` ([issue #850](https://github.com/lmorg/murex/issues/850))

* autocomplete: fixed unit file completions for `systemctl`

* core: terminal no longer hangs if stdin is a term and `<!out>` defined in command

* autocomplete: removed deprecated `?` operator from `git`

* expressions: sub-shell scalars inside object builders now return objects instead of strings ([issue #853](https://github.com/lmorg/murex/issues/853))

* core: improved expression validator

* core: statements are no longer forced to be parsed as expressions when the first parameter is `=` ([issue #854](https://github.com/lmorg/murex/issues/854))

* readline: ignore panics in VIM keys. In the edge cases where panics are raised, we'd want to exit that function regardless. So handling panics as exceptions is the cleanest way to handle errors ([issue #866](https://github.com/lmorg/murex/issues/866))

* integrations: removed deprecated builtin, `=`, from Linux profile

* core: missing `Release()` after `os.FindProcess()`

* readline: preview displays error if terminal too small ([issue #868](https://github.com/lmorg/murex/issues/868))

## Special Thanks

Thank yous for this release goes to [tiymat](https://github.com/tiymat), [atagen](https://github.com/atagen) and [orefalo](https://github.com/orefalo) for your testing and feedback. Also thank you to everyone in the [discussions group](https://github.com/lmorg/murex/discussions) and all who raise bug reports.

You rock!
