# Usage

<!-- This is generated by scripts/generate-usage.sh. Don't edit this file directly. -->

```console
$ pinact --help
NAME:
   pinact - Pin GitHub Actions versions. https://github.com/suzuki-shunsuke/pinact

USAGE:
   pinact [global options] [command [command options]]

VERSION:
   3.4.2

COMMANDS:
   init        Create .pinact.yaml if it doesn't exist
   run         Pin GitHub Actions versions
   migrate     Migrate .pinact.yaml
   token       Manage GitHub Access token
   version     Show version
   help, h     Shows a list of commands or help for one command
   completion  Output shell completion script for bash, zsh, fish, or Powershell

GLOBAL OPTIONS:
   --log-level string          log level [$PINACT_LOG_LEVEL]
   --config string, -c string  configuration file path [$PINACT_CONFIG]
   --help, -h                  show help
   --version, -v               print the version
```

## pinact init

```console
$ pinact init --help
NAME:
   pinact init - Create .pinact.yaml if it doesn't exist

USAGE:
   pinact init

DESCRIPTION:
   Create .pinact.yaml if it doesn't exist

   $ pinact init

   You can also pass configuration file path.

   e.g.

   $ pinact init .github/pinact.yaml


OPTIONS:
   --help, -h  show help
```

## pinact run

```console
$ pinact run --help
NAME:
   pinact run - Pin GitHub Actions versions

USAGE:
   pinact run

DESCRIPTION:
   If no argument is passed, pinact searches GitHub Actions workflow files from .github/workflows.

   $ pinact run

   You can also pass workflow file paths as arguments.

   e.g.

   $ pinact run .github/actions/foo/action.yaml .github/actions/bar/action.yaml


OPTIONS:
   --verify, -v                                                 Verify if pairs of commit SHA and version are correct (default: false)
   --check                                                      Exit with a non-zero status code if actions are not pinned. If this is true, files aren't updated (default: false)
   --update, -u                                                 Update actions to latest versions (default: false)
   --review                                                     Create reviews (default: false)
   --fix                                                        Fix code. By default, this is true. If -check or -diff is true, this is false by default (default: false)
   --diff                                                       Output diff. By default, this is false (default: false)
   --repo-owner string                                          GitHub repository owner [$GITHUB_REPOSITORY_OWNER]
   --repo-name string                                           GitHub repository name
   --sha string                                                 Commit SHA to be reviewed
   --pr int                                                     GitHub pull request number (default: 0)
   --include string, -i string [ --include string, -i string ]  A regular expression to fix actions
   --exclude string, -e string [ --exclude string, -e string ]  A regular expression to exclude actions
   --help, -h                                                   show help
```

## pinact migrate

```console
$ pinact migrate --help
NAME:
   pinact migrate - Migrate .pinact.yaml

USAGE:
   pinact migrate

DESCRIPTION:
   Migrate the version of .pinact.yaml

   $ pinact migrate


OPTIONS:
   --help, -h  show help
```

## pinact token

```console
$ pinact token --help
NAME:
   pinact token - Manage GitHub Access token

USAGE:
   pinact token [command [command options]]

DESCRIPTION:
   Manage GitHub Access token by keyring.

COMMANDS:
   set         Set GitHub Access token
   remove, rm  Remove GitHub Access token

OPTIONS:
   --help, -h  show help
```

### token set

```console
$ token set --help
NAME:
   pinact token set - Set GitHub Access token

USAGE:
   pinact token set

DESCRIPTION:
   Set GitHub Access token to keyring.

OPTIONS:
   --stdin     Read GitHub Access token from stdin (default: false)
   --help, -h  show help
```

### token remove

```console
$ token remove --help
NAME:
   pinact token remove - Remove GitHub Access token

USAGE:
   pinact token remove

DESCRIPTION:
   Remove GitHub Access token from keyring.

OPTIONS:
   --help, -h  show help
```

## pinact version

```console
$ pinact version --help
NAME:
   pinact version - Show version

USAGE:
   pinact version

OPTIONS:
   --json, -j  Output version in JSON format (default: false)
   --help, -h  show help
```

## pinact completion

```console
$ pinact completion --help
NAME:
   pinact completion - Output shell completion script for bash, zsh, fish, or Powershell

USAGE:
   pinact completion

DESCRIPTION:
   Output shell completion script for bash, zsh, fish, or Powershell.
   Source the output to enable completion.

   # .bashrc
   source <(pinact completion bash)

   # .zshrc
   source <(pinact completion zsh)

   # fish
   pinact completion fish > ~/.config/fish/completions/pinact.fish

   # Powershell
   Output the script to path/to/autocomplete/pinact.ps1 an run it.


OPTIONS:
   --help, -h  show help
```
