<!-- DO NOT EDIT: this file is automatically generated using scw-doc-gen -->
# Documentation for `scw account`
This API allows you to manage your Scaleway Projects.
  
- [Project management commands](#project-management-commands)
  - [Create a new Project for an Organization](#create-a-new-project-for-an-organization)
  - [Delete an existing Project](#delete-an-existing-project)
  - [Get an existing Project](#get-an-existing-project)
  - [List all Projects of an Organization](#list-all-projects-of-an-organization)
  - [Update Project](#update-project)

  
## Project management commands

Project management commands.


### Create a new Project for an Organization

Generate a new Project for an Organization, specifying its configuration including name and description.

**Usage:**

```
scw account project create [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name | Default: `<generated>` | Name of the Project |
| description |  | Description of the Project |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



### Delete an existing Project

Delete an existing Project, specified by its Project ID. The Project needs to be empty (meaning there are no resources left in it) to be deleted effectively. Note that deleting a Project is permanent, and cannot be undone.

**Usage:**

```
scw account project delete [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### Get an existing Project

Retrieve information about an existing Project, specified by its Project ID. Its full details, including ID, name and description, are returned in the response object.

**Usage:**

```
scw account project get [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |



### List all Projects of an Organization

List all Projects of an Organization. The response will include the total number of Projects as well as their associated Organizations, names, and IDs. Other information includes the creation and update date of the Project.

**Usage:**

```
scw account project list [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| name |  | Name of the Project |
| order-by | One of: `created_at_asc`, `created_at_desc`, `name_asc`, `name_desc` | Sort order of the returned Projects |
| project-ids.{index} |  | Project IDs to filter for. The results will be limited to any Projects with an ID in this array |
| organization-id |  | Organization ID to use. If none is passed the default organization ID will be used |



### Update Project

Update the parameters of an existing Project, specified by its Project ID. These parameters include the name and description.

**Usage:**

```
scw account project update [arg=value ...]
```


**Args:**

| Name |   | Description |
|------|---|-------------|
| project-id |  | Project ID to use. If none is passed the default project ID will be used |
| name |  | Name of the Project |
| description |  | Description of the Project |



