// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0
// source: batch.go

package querytest

import (
	"context"
	"errors"

	"github.com/jackc/pgx/v5"
	"github.com/jackc/pgx/v5/pgtype"
)

var (
	ErrBatchAlreadyClosed = errors.New("batch already closed")
)

const createAuthors = `-- name: CreateAuthors :batchexec
INSERT INTO authors (
  name, bio
) VALUES (
  $1, $2
)
`

type CreateAuthorsBatchResults struct {
	br     pgx.BatchResults
	tot    int
	closed bool
}

type CreateAuthorsParams struct {
	Name string
	Bio  pgtype.Text
}

func (q *Queries) CreateAuthors(ctx context.Context, arg []CreateAuthorsParams) *CreateAuthorsBatchResults {
	batch := &pgx.Batch{}
	for _, a := range arg {
		vals := []interface{}{
			a.Name,
			a.Bio,
		}
		batch.Queue(createAuthors, vals...)
	}
	br := q.db.SendBatch(ctx, batch)
	return &CreateAuthorsBatchResults{br, len(arg), false}
}

func (b *CreateAuthorsBatchResults) Exec(f func(int, error)) {
	defer b.br.Close()
	for t := 0; t < b.tot; t++ {
		if b.closed {
			if f != nil {
				f(t, ErrBatchAlreadyClosed)
			}
			continue
		}
		_, err := b.br.Exec()
		if f != nil {
			f(t, err)
		}
	}
}

func (b *CreateAuthorsBatchResults) Close() error {
	b.closed = true
	return b.br.Close()
}
