// Copyright (c) 2021 Tailscale Inc & AUTHORS All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated by "stringer -type=pcpResultCode -trimprefix=pcpCode"; DO NOT EDIT.

package portmapper

import "strconv"

func _() {
	// An "invalid array index" compiler error signifies that the constant values have changed.
	// Re-run the stringer command to generate them again.
	var x [1]struct{}
	_ = x[pcpCodeOK-0]
	_ = x[pcpCodeNotAuthorized-2]
	_ = x[pcpCodeAddressMismatch-12]
}

const (
	_pcpResultCode_name_0 = "OK"
	_pcpResultCode_name_1 = "NotAuthorized"
	_pcpResultCode_name_2 = "AddressMismatch"
)

func (i pcpResultCode) String() string {
	switch {
	case i == 0:
		return _pcpResultCode_name_0
	case i == 2:
		return _pcpResultCode_name_1
	case i == 12:
		return _pcpResultCode_name_2
	default:
		return "pcpResultCode(" + strconv.FormatInt(int64(i), 10) + ")"
	}
}
