package ebs

// ATTENTION!
// This rule was autogenerated!
// Before making changes, consider updating the generator.

// generator-locked
import (
	"github.com/aquasecurity/tfsec/internal/app/tfsec/block"
	"github.com/aquasecurity/tfsec/internal/app/tfsec/scanner"
	"github.com/aquasecurity/tfsec/pkg/provider"
	"github.com/aquasecurity/tfsec/pkg/result"
	"github.com/aquasecurity/tfsec/pkg/rule"
	"github.com/aquasecurity/tfsec/pkg/severity"
)

func init() {
	scanner.RegisterCheckRule(rule.Rule{
		Provider:  provider.AWSProvider,
		Service:   "ebs",
		ShortCode: "enable-volume-encryption",
		Documentation: rule.RuleDocumentation{
			Summary:     "EBS volumes must be encrypted",
			Explanation: `By enabling encryption on EBS volumes you protect the volume, the disk I/O and any derived snapshots from compromise if intercepted.`,
			Impact:      "Unencrypted sensitive data is vulnerable to compromise.",
			Resolution:  "Enable encryption of EBS volumes",
			BadExample: []string{`
resource "aws_ebs_volume" "bad_example" {
  availability_zone = "us-west-2a"
  size              = 40

  tags = {
    Name = "HelloWorld"
  }
  encrypted = false
}
`},
			GoodExample: []string{`
resource "aws_ebs_volume" "good_example" {
  availability_zone = "us-west-2a"
  size              = 40

  tags = {
    Name = "HelloWorld"
  }
  encrypted = true
}
`},
			Links: []string{
				"https://registry.terraform.io/providers/hashicorp/aws/latest/docs/resources/ebs_volume#encrypted",
			},
		},
		RequiredTypes: []string{
			"resource",
		},
		RequiredLabels: []string{
			"aws_ebs_volume",
		},
		DefaultSeverity: severity.High,
		CheckFunc: func(set result.Set, resourceBlock block.Block, _ block.Module) {
			if encryptedAttr := resourceBlock.GetAttribute("encrypted"); encryptedAttr.IsNil() { // alert on use of default value
				set.AddResult().
					WithDescription("Resource '%s' uses default value for encrypted", resourceBlock.FullName())
			} else if encryptedAttr.IsFalse() {
				set.AddResult().
					WithDescription("Resource '%s' does not have encrypted set to true", resourceBlock.FullName()).
					WithAttribute(encryptedAttr)
			}
		},
	})
}
