---
title: vulnerability-alerts
---

### Explanation

You can do this by setting the <code>vulnerability_alerts</code> attribute to 'true'.

### Possible Impact
Insecure vulnerabilities might be used in the codebase.

### Suggested Resolution
Enable vulnerability alerts for all repositories.


### Insecure Example

The following example will fail the github-repositories-vulnerability-alerts check.

```terraform

resource "github_repository" "bad_example" {
  name        		   = "example"
  description 		   = "My awesome codebase"
  vulnerability_alerts = false
}

```



### Secure Example

The following example will pass the github-repositories-vulnerability-alerts check.

```terraform

resource "github_repository" "good_example" {
  name        		   = "example"
  description 		   = "My awesome codebase"
  vulnerability_alerts = true
}

```




### Related Links


- [https://registry.terraform.io/providers/hashicorp/github/latest/docs/resources/repository#vulnerability_alerts](https://registry.terraform.io/providers/hashicorp/github/latest/docs/resources/repository#vulnerability_alerts){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies](https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies){:target="_blank" rel="nofollow noreferrer noopener"}


