---
title: GitHub repository has vulnerability alerts disabled.
---

# GitHub repository has vulnerability alerts disabled.

### Default Severity: <span class="severity high">high</span>

### Explanation

GitHub repository should be set to use vulnerability alerts.

You can do this by setting the <code>vulnerability_alerts</code> attribute to 'true'.

### Possible Impact
Known vulnerabilities may not be discovered

### Suggested Resolution
Enable vulnerability alerts


### Insecure Example

The following example will fail the github-repositories-enable_vulnerability_alerts check.
```terraform

 resource "github_repository" "bad_example" {
   name        = "example"
   description = "My awesome codebase"

   vulnerability_alerts = false

   template {
     owner = "github"
     repository = "terraform-module-template"
   }
 }
 
```



### Secure Example

The following example will pass the github-repositories-enable_vulnerability_alerts check.
```terraform

 resource "github_repository" "good_example" {
   name        = "example"
   description = "My awesome codebase"

   vulnerability_alerts = true

   template {
     owner = "github"
     repository = "terraform-module-template"
   }
 }
 
```



### Links


- [https://registry.terraform.io/providers/integrations/github/latest/docs/resources/repository](https://registry.terraform.io/providers/integrations/github/latest/docs/resources/repository){:target="_blank" rel="nofollow noreferrer noopener"}

- [https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies](https://docs.github.com/en/code-security/supply-chain-security/managing-vulnerabilities-in-your-projects-dependencies/about-alerts-for-vulnerable-dependencies){:target="_blank" rel="nofollow noreferrer noopener"}



