// Code generated by go generate; DO NOT EDIT.
package figma

import "errors"

type Permission int

const (
    Invalid Permission = iota
    FilesRead Permission = iota
    FileVariablesRead Permission = iota
    FileVariablesWrite Permission = iota
    FileCommentsWrite Permission = iota
    FileDevResourcesRead Permission = iota
    FileDevResourcesWrite Permission = iota
    LibraryAnalyticsRead Permission = iota
    WebhooksWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        FilesRead: "files:read",
        FileVariablesRead: "file_variables:read",
        FileVariablesWrite: "file_variables:write",
        FileCommentsWrite: "file_comments:write",
        FileDevResourcesRead: "file_dev_resources:read",
        FileDevResourcesWrite: "file_dev_resources:write",
        LibraryAnalyticsRead: "library_analytics:read",
        WebhooksWrite: "webhooks:write",
    }

    StringToPermission = map[string]Permission{
        "files:read": FilesRead,
        "file_variables:read": FileVariablesRead,
        "file_variables:write": FileVariablesWrite,
        "file_comments:write": FileCommentsWrite,
        "file_dev_resources:read": FileDevResourcesRead,
        "file_dev_resources:write": FileDevResourcesWrite,
        "library_analytics:read": LibraryAnalyticsRead,
        "webhooks:write": WebhooksWrite,
    }

    PermissionIDs = map[Permission]int{
        FilesRead: 1,
        FileVariablesRead: 2,
        FileVariablesWrite: 3,
        FileCommentsWrite: 4,
        FileDevResourcesRead: 5,
        FileDevResourcesWrite: 6,
        LibraryAnalyticsRead: 7,
        WebhooksWrite: 8,
    }

    IdToPermission = map[int]Permission{
        1: FilesRead,
        2: FileVariablesRead,
        3: FileVariablesWrite,
        4: FileCommentsWrite,
        5: FileDevResourcesRead,
        6: FileDevResourcesWrite,
        7: LibraryAnalyticsRead,
        8: WebhooksWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
