// Code generated by go generate; DO NOT EDIT.
package posthog

import "errors"

type Permission int

const (
    Invalid Permission = iota
    ActionRead Permission = iota
    ActionWrite Permission = iota
    ActivityLogRead Permission = iota
    ActivityLogWrite Permission = iota
    AnnotationRead Permission = iota
    AnnotationWrite Permission = iota
    BatchExportRead Permission = iota
    BatchExportWrite Permission = iota
    CohortRead Permission = iota
    CohortWrite Permission = iota
    DashboardRead Permission = iota
    DashboardWrite Permission = iota
    DashboardTemplateRead Permission = iota
    DashboardTemplateWrite Permission = iota
    EarlyAccessFeatureRead Permission = iota
    EarlyAccessFeatureWrite Permission = iota
    EventDefinitionRead Permission = iota
    EventDefinitionWrite Permission = iota
    ErrorTrackingRead Permission = iota
    ErrorTrackingWrite Permission = iota
    ExperimentRead Permission = iota
    ExperimentWrite Permission = iota
    ExportRead Permission = iota
    ExportWrite Permission = iota
    FeatureFlagRead Permission = iota
    FeatureFlagWrite Permission = iota
    GroupRead Permission = iota
    GroupWrite Permission = iota
    HogFunctionRead Permission = iota
    HogFunctionWrite Permission = iota
    InsightRead Permission = iota
    InsightWrite Permission = iota
    NotebookRead Permission = iota
    NotebookWrite Permission = iota
    OrganizationRead Permission = iota
    OrganizationWrite Permission = iota
    OrganizationMemberRead Permission = iota
    OrganizationMemberWrite Permission = iota
    PersonRead Permission = iota
    PersonWrite Permission = iota
    PluginRead Permission = iota
    PluginWrite Permission = iota
    ProjectRead Permission = iota
    ProjectWrite Permission = iota
    PropertyDefinitionRead Permission = iota
    PropertyDefinitionWrite Permission = iota
    QueryRead Permission = iota
    SessionRecordingRead Permission = iota
    SessionRecordingWrite Permission = iota
    SessionRecordingPlaylistRead Permission = iota
    SessionRecordingPlaylistWrite Permission = iota
    SharingConfigurationRead Permission = iota
    SharingConfigurationWrite Permission = iota
    SubscriptionRead Permission = iota
    SubscriptionWrite Permission = iota
    SurveyRead Permission = iota
    SurveyWrite Permission = iota
    UserRead Permission = iota
    WebhookRead Permission = iota
    WebhookWrite Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        ActionRead: "action:read",
        ActionWrite: "action:write",
        ActivityLogRead: "activity_log:read",
        ActivityLogWrite: "activity_log:write",
        AnnotationRead: "annotation:read",
        AnnotationWrite: "annotation:write",
        BatchExportRead: "batch_export:read",
        BatchExportWrite: "batch_export:write",
        CohortRead: "cohort:read",
        CohortWrite: "cohort:write",
        DashboardRead: "dashboard:read",
        DashboardWrite: "dashboard:write",
        DashboardTemplateRead: "dashboard_template:read",
        DashboardTemplateWrite: "dashboard_template:write",
        EarlyAccessFeatureRead: "early_access_feature:read",
        EarlyAccessFeatureWrite: "early_access_feature:write",
        EventDefinitionRead: "event_definition:read",
        EventDefinitionWrite: "event_definition:write",
        ErrorTrackingRead: "error_tracking:read",
        ErrorTrackingWrite: "error_tracking:write",
        ExperimentRead: "experiment:read",
        ExperimentWrite: "experiment:write",
        ExportRead: "export:read",
        ExportWrite: "export:write",
        FeatureFlagRead: "feature_flag:read",
        FeatureFlagWrite: "feature_flag:write",
        GroupRead: "group:read",
        GroupWrite: "group:write",
        HogFunctionRead: "hog_function:read",
        HogFunctionWrite: "hog_function:write",
        InsightRead: "insight:read",
        InsightWrite: "insight:write",
        NotebookRead: "notebook:read",
        NotebookWrite: "notebook:write",
        OrganizationRead: "organization:read",
        OrganizationWrite: "organization:write",
        OrganizationMemberRead: "organization_member:read",
        OrganizationMemberWrite: "organization_member:write",
        PersonRead: "person:read",
        PersonWrite: "person:write",
        PluginRead: "plugin:read",
        PluginWrite: "plugin:write",
        ProjectRead: "project:read",
        ProjectWrite: "project:write",
        PropertyDefinitionRead: "property_definition:read",
        PropertyDefinitionWrite: "property_definition:write",
        QueryRead: "query:read",
        SessionRecordingRead: "session_recording:read",
        SessionRecordingWrite: "session_recording:write",
        SessionRecordingPlaylistRead: "session_recording_playlist:read",
        SessionRecordingPlaylistWrite: "session_recording_playlist:write",
        SharingConfigurationRead: "sharing_configuration:read",
        SharingConfigurationWrite: "sharing_configuration:write",
        SubscriptionRead: "subscription:read",
        SubscriptionWrite: "subscription:write",
        SurveyRead: "survey:read",
        SurveyWrite: "survey:write",
        UserRead: "user:read",
        WebhookRead: "webhook:read",
        WebhookWrite: "webhook:write",
    }

    StringToPermission = map[string]Permission{
        "action:read": ActionRead,
        "action:write": ActionWrite,
        "activity_log:read": ActivityLogRead,
        "activity_log:write": ActivityLogWrite,
        "annotation:read": AnnotationRead,
        "annotation:write": AnnotationWrite,
        "batch_export:read": BatchExportRead,
        "batch_export:write": BatchExportWrite,
        "cohort:read": CohortRead,
        "cohort:write": CohortWrite,
        "dashboard:read": DashboardRead,
        "dashboard:write": DashboardWrite,
        "dashboard_template:read": DashboardTemplateRead,
        "dashboard_template:write": DashboardTemplateWrite,
        "early_access_feature:read": EarlyAccessFeatureRead,
        "early_access_feature:write": EarlyAccessFeatureWrite,
        "event_definition:read": EventDefinitionRead,
        "event_definition:write": EventDefinitionWrite,
        "error_tracking:read": ErrorTrackingRead,
        "error_tracking:write": ErrorTrackingWrite,
        "experiment:read": ExperimentRead,
        "experiment:write": ExperimentWrite,
        "export:read": ExportRead,
        "export:write": ExportWrite,
        "feature_flag:read": FeatureFlagRead,
        "feature_flag:write": FeatureFlagWrite,
        "group:read": GroupRead,
        "group:write": GroupWrite,
        "hog_function:read": HogFunctionRead,
        "hog_function:write": HogFunctionWrite,
        "insight:read": InsightRead,
        "insight:write": InsightWrite,
        "notebook:read": NotebookRead,
        "notebook:write": NotebookWrite,
        "organization:read": OrganizationRead,
        "organization:write": OrganizationWrite,
        "organization_member:read": OrganizationMemberRead,
        "organization_member:write": OrganizationMemberWrite,
        "person:read": PersonRead,
        "person:write": PersonWrite,
        "plugin:read": PluginRead,
        "plugin:write": PluginWrite,
        "project:read": ProjectRead,
        "project:write": ProjectWrite,
        "property_definition:read": PropertyDefinitionRead,
        "property_definition:write": PropertyDefinitionWrite,
        "query:read": QueryRead,
        "session_recording:read": SessionRecordingRead,
        "session_recording:write": SessionRecordingWrite,
        "session_recording_playlist:read": SessionRecordingPlaylistRead,
        "session_recording_playlist:write": SessionRecordingPlaylistWrite,
        "sharing_configuration:read": SharingConfigurationRead,
        "sharing_configuration:write": SharingConfigurationWrite,
        "subscription:read": SubscriptionRead,
        "subscription:write": SubscriptionWrite,
        "survey:read": SurveyRead,
        "survey:write": SurveyWrite,
        "user:read": UserRead,
        "webhook:read": WebhookRead,
        "webhook:write": WebhookWrite,
    }

    PermissionIDs = map[Permission]int{
        ActionRead: 1,
        ActionWrite: 2,
        ActivityLogRead: 3,
        ActivityLogWrite: 4,
        AnnotationRead: 5,
        AnnotationWrite: 6,
        BatchExportRead: 7,
        BatchExportWrite: 8,
        CohortRead: 9,
        CohortWrite: 10,
        DashboardRead: 11,
        DashboardWrite: 12,
        DashboardTemplateRead: 13,
        DashboardTemplateWrite: 14,
        EarlyAccessFeatureRead: 15,
        EarlyAccessFeatureWrite: 16,
        EventDefinitionRead: 17,
        EventDefinitionWrite: 18,
        ErrorTrackingRead: 19,
        ErrorTrackingWrite: 20,
        ExperimentRead: 21,
        ExperimentWrite: 22,
        ExportRead: 23,
        ExportWrite: 24,
        FeatureFlagRead: 25,
        FeatureFlagWrite: 26,
        GroupRead: 27,
        GroupWrite: 28,
        HogFunctionRead: 29,
        HogFunctionWrite: 30,
        InsightRead: 31,
        InsightWrite: 32,
        NotebookRead: 33,
        NotebookWrite: 34,
        OrganizationRead: 35,
        OrganizationWrite: 36,
        OrganizationMemberRead: 37,
        OrganizationMemberWrite: 38,
        PersonRead: 39,
        PersonWrite: 40,
        PluginRead: 41,
        PluginWrite: 42,
        ProjectRead: 43,
        ProjectWrite: 44,
        PropertyDefinitionRead: 45,
        PropertyDefinitionWrite: 46,
        QueryRead: 47,
        SessionRecordingRead: 48,
        SessionRecordingWrite: 49,
        SessionRecordingPlaylistRead: 50,
        SessionRecordingPlaylistWrite: 51,
        SharingConfigurationRead: 52,
        SharingConfigurationWrite: 53,
        SubscriptionRead: 54,
        SubscriptionWrite: 55,
        SurveyRead: 56,
        SurveyWrite: 57,
        UserRead: 58,
        WebhookRead: 59,
        WebhookWrite: 60,
    }

    IdToPermission = map[int]Permission{
        1: ActionRead,
        2: ActionWrite,
        3: ActivityLogRead,
        4: ActivityLogWrite,
        5: AnnotationRead,
        6: AnnotationWrite,
        7: BatchExportRead,
        8: BatchExportWrite,
        9: CohortRead,
        10: CohortWrite,
        11: DashboardRead,
        12: DashboardWrite,
        13: DashboardTemplateRead,
        14: DashboardTemplateWrite,
        15: EarlyAccessFeatureRead,
        16: EarlyAccessFeatureWrite,
        17: EventDefinitionRead,
        18: EventDefinitionWrite,
        19: ErrorTrackingRead,
        20: ErrorTrackingWrite,
        21: ExperimentRead,
        22: ExperimentWrite,
        23: ExportRead,
        24: ExportWrite,
        25: FeatureFlagRead,
        26: FeatureFlagWrite,
        27: GroupRead,
        28: GroupWrite,
        29: HogFunctionRead,
        30: HogFunctionWrite,
        31: InsightRead,
        32: InsightWrite,
        33: NotebookRead,
        34: NotebookWrite,
        35: OrganizationRead,
        36: OrganizationWrite,
        37: OrganizationMemberRead,
        38: OrganizationMemberWrite,
        39: PersonRead,
        40: PersonWrite,
        41: PluginRead,
        42: PluginWrite,
        43: ProjectRead,
        44: ProjectWrite,
        45: PropertyDefinitionRead,
        46: PropertyDefinitionWrite,
        47: QueryRead,
        48: SessionRecordingRead,
        49: SessionRecordingWrite,
        50: SessionRecordingPlaylistRead,
        51: SessionRecordingPlaylistWrite,
        52: SharingConfigurationRead,
        53: SharingConfigurationWrite,
        54: SubscriptionRead,
        55: SubscriptionWrite,
        56: SurveyRead,
        57: SurveyWrite,
        58: UserRead,
        59: WebhookRead,
        60: WebhookWrite,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
