// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointCancelTask2Params creates a new WaypointCancelTask2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointCancelTask2Params() *WaypointCancelTask2Params {
	return &WaypointCancelTask2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointCancelTask2ParamsWithTimeout creates a new WaypointCancelTask2Params object
// with the ability to set a timeout on a request.
func NewWaypointCancelTask2ParamsWithTimeout(timeout time.Duration) *WaypointCancelTask2Params {
	return &WaypointCancelTask2Params{
		timeout: timeout,
	}
}

// NewWaypointCancelTask2ParamsWithContext creates a new WaypointCancelTask2Params object
// with the ability to set a context for a request.
func NewWaypointCancelTask2ParamsWithContext(ctx context.Context) *WaypointCancelTask2Params {
	return &WaypointCancelTask2Params{
		Context: ctx,
	}
}

// NewWaypointCancelTask2ParamsWithHTTPClient creates a new WaypointCancelTask2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointCancelTask2ParamsWithHTTPClient(client *http.Client) *WaypointCancelTask2Params {
	return &WaypointCancelTask2Params{
		HTTPClient: client,
	}
}

/*
WaypointCancelTask2Params contains all the parameters to send to the API endpoint

	for the waypoint cancel task2 operation.

	Typically these are written to a http.Request.
*/
type WaypointCancelTask2Params struct {

	// Body.
	Body *models.HashicorpWaypointCancelTaskRequest

	/* RefJobID.

	   The main "run" job ID that the task initiated
	*/
	RefJobID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint cancel task2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelTask2Params) WithDefaults() *WaypointCancelTask2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint cancel task2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCancelTask2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) WithTimeout(timeout time.Duration) *WaypointCancelTask2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) WithContext(ctx context.Context) *WaypointCancelTask2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) WithHTTPClient(client *http.Client) *WaypointCancelTask2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) WithBody(body *models.HashicorpWaypointCancelTaskRequest) *WaypointCancelTask2Params {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) SetBody(body *models.HashicorpWaypointCancelTaskRequest) {
	o.Body = body
}

// WithRefJobID adds the refJobID to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) WithRefJobID(refJobID string) *WaypointCancelTask2Params {
	o.SetRefJobID(refJobID)
	return o
}

// SetRefJobID adds the refJobId to the waypoint cancel task2 params
func (o *WaypointCancelTask2Params) SetRefJobID(refJobID string) {
	o.RefJobID = refJobID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointCancelTask2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param ref.job_id
	if err := r.SetPathParam("ref.job_id", o.RefJobID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
