// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointCreateHostnameParams creates a new WaypointCreateHostnameParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointCreateHostnameParams() *WaypointCreateHostnameParams {
	return &WaypointCreateHostnameParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointCreateHostnameParamsWithTimeout creates a new WaypointCreateHostnameParams object
// with the ability to set a timeout on a request.
func NewWaypointCreateHostnameParamsWithTimeout(timeout time.Duration) *WaypointCreateHostnameParams {
	return &WaypointCreateHostnameParams{
		timeout: timeout,
	}
}

// NewWaypointCreateHostnameParamsWithContext creates a new WaypointCreateHostnameParams object
// with the ability to set a context for a request.
func NewWaypointCreateHostnameParamsWithContext(ctx context.Context) *WaypointCreateHostnameParams {
	return &WaypointCreateHostnameParams{
		Context: ctx,
	}
}

// NewWaypointCreateHostnameParamsWithHTTPClient creates a new WaypointCreateHostnameParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointCreateHostnameParamsWithHTTPClient(client *http.Client) *WaypointCreateHostnameParams {
	return &WaypointCreateHostnameParams{
		HTTPClient: client,
	}
}

/*
WaypointCreateHostnameParams contains all the parameters to send to the API endpoint

	for the waypoint create hostname operation.

	Typically these are written to a http.Request.
*/
type WaypointCreateHostnameParams struct {

	// Body.
	Body *models.HashicorpWaypointCreateHostnameRequest

	// TargetApplicationApplicationApplication.
	TargetApplicationApplicationApplication string

	// TargetApplicationApplicationProject.
	TargetApplicationApplicationProject string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint create hostname params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCreateHostnameParams) WithDefaults() *WaypointCreateHostnameParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint create hostname params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointCreateHostnameParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithTimeout(timeout time.Duration) *WaypointCreateHostnameParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithContext(ctx context.Context) *WaypointCreateHostnameParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithHTTPClient(client *http.Client) *WaypointCreateHostnameParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithBody(body *models.HashicorpWaypointCreateHostnameRequest) *WaypointCreateHostnameParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetBody(body *models.HashicorpWaypointCreateHostnameRequest) {
	o.Body = body
}

// WithTargetApplicationApplicationApplication adds the targetApplicationApplicationApplication to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithTargetApplicationApplicationApplication(targetApplicationApplicationApplication string) *WaypointCreateHostnameParams {
	o.SetTargetApplicationApplicationApplication(targetApplicationApplicationApplication)
	return o
}

// SetTargetApplicationApplicationApplication adds the targetApplicationApplicationApplication to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetTargetApplicationApplicationApplication(targetApplicationApplicationApplication string) {
	o.TargetApplicationApplicationApplication = targetApplicationApplicationApplication
}

// WithTargetApplicationApplicationProject adds the targetApplicationApplicationProject to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) WithTargetApplicationApplicationProject(targetApplicationApplicationProject string) *WaypointCreateHostnameParams {
	o.SetTargetApplicationApplicationProject(targetApplicationApplicationProject)
	return o
}

// SetTargetApplicationApplicationProject adds the targetApplicationApplicationProject to the waypoint create hostname params
func (o *WaypointCreateHostnameParams) SetTargetApplicationApplicationProject(targetApplicationApplicationProject string) {
	o.TargetApplicationApplicationProject = targetApplicationApplicationProject
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointCreateHostnameParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param target.application.application.application
	if err := r.SetPathParam("target.application.application.application", o.TargetApplicationApplicationApplication); err != nil {
		return err
	}

	// path param target.application.application.project
	if err := r.SetPathParam("target.application.application.project", o.TargetApplicationApplicationProject); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
