// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointDestroyProjectReader is a Reader for the WaypointDestroyProject structure.
type WaypointDestroyProjectReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointDestroyProjectReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointDestroyProjectOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointDestroyProjectDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointDestroyProjectOK creates a WaypointDestroyProjectOK with default headers values
func NewWaypointDestroyProjectOK() *WaypointDestroyProjectOK {
	return &WaypointDestroyProjectOK{}
}

/*
WaypointDestroyProjectOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointDestroyProjectOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint destroy project o k response has a 2xx status code
func (o *WaypointDestroyProjectOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint destroy project o k response has a 3xx status code
func (o *WaypointDestroyProjectOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint destroy project o k response has a 4xx status code
func (o *WaypointDestroyProjectOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint destroy project o k response has a 5xx status code
func (o *WaypointDestroyProjectOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint destroy project o k response a status code equal to that given
func (o *WaypointDestroyProjectOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointDestroyProjectOK) Error() string {
	return fmt.Sprintf("[DELETE /project/{project.project}][%d] waypointDestroyProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointDestroyProjectOK) String() string {
	return fmt.Sprintf("[DELETE /project/{project.project}][%d] waypointDestroyProjectOK  %+v", 200, o.Payload)
}

func (o *WaypointDestroyProjectOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointDestroyProjectOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointDestroyProjectDefault creates a WaypointDestroyProjectDefault with default headers values
func NewWaypointDestroyProjectDefault(code int) *WaypointDestroyProjectDefault {
	return &WaypointDestroyProjectDefault{
		_statusCode: code,
	}
}

/*
WaypointDestroyProjectDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointDestroyProjectDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint destroy project default response
func (o *WaypointDestroyProjectDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint destroy project default response has a 2xx status code
func (o *WaypointDestroyProjectDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint destroy project default response has a 3xx status code
func (o *WaypointDestroyProjectDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint destroy project default response has a 4xx status code
func (o *WaypointDestroyProjectDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint destroy project default response has a 5xx status code
func (o *WaypointDestroyProjectDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint destroy project default response a status code equal to that given
func (o *WaypointDestroyProjectDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointDestroyProjectDefault) Error() string {
	return fmt.Sprintf("[DELETE /project/{project.project}][%d] Waypoint_DestroyProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDestroyProjectDefault) String() string {
	return fmt.Sprintf("[DELETE /project/{project.project}][%d] Waypoint_DestroyProject default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointDestroyProjectDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointDestroyProjectDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
