// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetApplicationParams creates a new WaypointGetApplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetApplicationParams() *WaypointGetApplicationParams {
	return &WaypointGetApplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetApplicationParamsWithTimeout creates a new WaypointGetApplicationParams object
// with the ability to set a timeout on a request.
func NewWaypointGetApplicationParamsWithTimeout(timeout time.Duration) *WaypointGetApplicationParams {
	return &WaypointGetApplicationParams{
		timeout: timeout,
	}
}

// NewWaypointGetApplicationParamsWithContext creates a new WaypointGetApplicationParams object
// with the ability to set a context for a request.
func NewWaypointGetApplicationParamsWithContext(ctx context.Context) *WaypointGetApplicationParams {
	return &WaypointGetApplicationParams{
		Context: ctx,
	}
}

// NewWaypointGetApplicationParamsWithHTTPClient creates a new WaypointGetApplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetApplicationParamsWithHTTPClient(client *http.Client) *WaypointGetApplicationParams {
	return &WaypointGetApplicationParams{
		HTTPClient: client,
	}
}

/*
WaypointGetApplicationParams contains all the parameters to send to the API endpoint

	for the waypoint get application operation.

	Typically these are written to a http.Request.
*/
type WaypointGetApplicationParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetApplicationParams) WithDefaults() *WaypointGetApplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetApplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get application params
func (o *WaypointGetApplicationParams) WithTimeout(timeout time.Duration) *WaypointGetApplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get application params
func (o *WaypointGetApplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get application params
func (o *WaypointGetApplicationParams) WithContext(ctx context.Context) *WaypointGetApplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get application params
func (o *WaypointGetApplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get application params
func (o *WaypointGetApplicationParams) WithHTTPClient(client *http.Client) *WaypointGetApplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get application params
func (o *WaypointGetApplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint get application params
func (o *WaypointGetApplicationParams) WithApplicationApplication(applicationApplication string) *WaypointGetApplicationParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint get application params
func (o *WaypointGetApplicationParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint get application params
func (o *WaypointGetApplicationParams) WithApplicationProject(applicationProject string) *WaypointGetApplicationParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint get application params
func (o *WaypointGetApplicationParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetApplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
