// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetConfigReader is a Reader for the WaypointGetConfig structure.
type WaypointGetConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetConfigOK creates a WaypointGetConfigOK with default headers values
func NewWaypointGetConfigOK() *WaypointGetConfigOK {
	return &WaypointGetConfigOK{}
}

/*
WaypointGetConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetConfigOK struct {
	Payload *models.HashicorpWaypointConfigGetResponse
}

// IsSuccess returns true when this waypoint get config o k response has a 2xx status code
func (o *WaypointGetConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get config o k response has a 3xx status code
func (o *WaypointGetConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get config o k response has a 4xx status code
func (o *WaypointGetConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get config o k response has a 5xx status code
func (o *WaypointGetConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get config o k response a status code equal to that given
func (o *WaypointGetConfigOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetConfigOK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/config][%d] waypointGetConfigOK  %+v", 200, o.Payload)
}

func (o *WaypointGetConfigOK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/config][%d] waypointGetConfigOK  %+v", 200, o.Payload)
}

func (o *WaypointGetConfigOK) GetPayload() *models.HashicorpWaypointConfigGetResponse {
	return o.Payload
}

func (o *WaypointGetConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointConfigGetResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetConfigDefault creates a WaypointGetConfigDefault with default headers values
func NewWaypointGetConfigDefault(code int) *WaypointGetConfigDefault {
	return &WaypointGetConfigDefault{
		_statusCode: code,
	}
}

/*
WaypointGetConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetConfigDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get config default response
func (o *WaypointGetConfigDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get config default response has a 2xx status code
func (o *WaypointGetConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get config default response has a 3xx status code
func (o *WaypointGetConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get config default response has a 4xx status code
func (o *WaypointGetConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get config default response has a 5xx status code
func (o *WaypointGetConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get config default response a status code equal to that given
func (o *WaypointGetConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetConfigDefault) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/config][%d] Waypoint_GetConfig default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetConfigDefault) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/config][%d] Waypoint_GetConfig default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetConfigDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
