// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetLatestBuildReader is a Reader for the WaypointGetLatestBuild structure.
type WaypointGetLatestBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetLatestBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetLatestBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetLatestBuildDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetLatestBuildOK creates a WaypointGetLatestBuildOK with default headers values
func NewWaypointGetLatestBuildOK() *WaypointGetLatestBuildOK {
	return &WaypointGetLatestBuildOK{}
}

/*
WaypointGetLatestBuildOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetLatestBuildOK struct {
	Payload *models.HashicorpWaypointBuild
}

// IsSuccess returns true when this waypoint get latest build o k response has a 2xx status code
func (o *WaypointGetLatestBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get latest build o k response has a 3xx status code
func (o *WaypointGetLatestBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get latest build o k response has a 4xx status code
func (o *WaypointGetLatestBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get latest build o k response has a 5xx status code
func (o *WaypointGetLatestBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get latest build o k response a status code equal to that given
func (o *WaypointGetLatestBuildOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetLatestBuildOK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/build/latest][%d] waypointGetLatestBuildOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestBuildOK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/build/latest][%d] waypointGetLatestBuildOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestBuildOK) GetPayload() *models.HashicorpWaypointBuild {
	return o.Payload
}

func (o *WaypointGetLatestBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointBuild)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetLatestBuildDefault creates a WaypointGetLatestBuildDefault with default headers values
func NewWaypointGetLatestBuildDefault(code int) *WaypointGetLatestBuildDefault {
	return &WaypointGetLatestBuildDefault{
		_statusCode: code,
	}
}

/*
WaypointGetLatestBuildDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetLatestBuildDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get latest build default response
func (o *WaypointGetLatestBuildDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get latest build default response has a 2xx status code
func (o *WaypointGetLatestBuildDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get latest build default response has a 3xx status code
func (o *WaypointGetLatestBuildDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get latest build default response has a 4xx status code
func (o *WaypointGetLatestBuildDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get latest build default response has a 5xx status code
func (o *WaypointGetLatestBuildDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get latest build default response a status code equal to that given
func (o *WaypointGetLatestBuildDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetLatestBuildDefault) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/build/latest][%d] Waypoint_GetLatestBuild default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestBuildDefault) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/build/latest][%d] Waypoint_GetLatestBuild default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestBuildDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetLatestBuildDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
