// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetLatestReleaseParams creates a new WaypointGetLatestReleaseParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetLatestReleaseParams() *WaypointGetLatestReleaseParams {
	return &WaypointGetLatestReleaseParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetLatestReleaseParamsWithTimeout creates a new WaypointGetLatestReleaseParams object
// with the ability to set a timeout on a request.
func NewWaypointGetLatestReleaseParamsWithTimeout(timeout time.Duration) *WaypointGetLatestReleaseParams {
	return &WaypointGetLatestReleaseParams{
		timeout: timeout,
	}
}

// NewWaypointGetLatestReleaseParamsWithContext creates a new WaypointGetLatestReleaseParams object
// with the ability to set a context for a request.
func NewWaypointGetLatestReleaseParamsWithContext(ctx context.Context) *WaypointGetLatestReleaseParams {
	return &WaypointGetLatestReleaseParams{
		Context: ctx,
	}
}

// NewWaypointGetLatestReleaseParamsWithHTTPClient creates a new WaypointGetLatestReleaseParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetLatestReleaseParamsWithHTTPClient(client *http.Client) *WaypointGetLatestReleaseParams {
	return &WaypointGetLatestReleaseParams{
		HTTPClient: client,
	}
}

/*
WaypointGetLatestReleaseParams contains all the parameters to send to the API endpoint

	for the waypoint get latest release operation.

	Typically these are written to a http.Request.
*/
type WaypointGetLatestReleaseParams struct {

	// ApplicationApplication.
	ApplicationApplication string

	// ApplicationProject.
	ApplicationProject string

	/* LoadDetails.

	     Load additional details about the release. These will become available
	in the Preload section.

	     Default: "NONE"
	*/
	LoadDetails *string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get latest release params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLatestReleaseParams) WithDefaults() *WaypointGetLatestReleaseParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get latest release params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLatestReleaseParams) SetDefaults() {
	var (
		loadDetailsDefault = string("NONE")
	)

	val := WaypointGetLatestReleaseParams{
		LoadDetails: &loadDetailsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithTimeout(timeout time.Duration) *WaypointGetLatestReleaseParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithContext(ctx context.Context) *WaypointGetLatestReleaseParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithHTTPClient(client *http.Client) *WaypointGetLatestReleaseParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithApplicationApplication(applicationApplication string) *WaypointGetLatestReleaseParams {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetApplicationApplication(applicationApplication string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithApplicationProject(applicationProject string) *WaypointGetLatestReleaseParams {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetApplicationProject(applicationProject string) {
	o.ApplicationProject = applicationProject
}

// WithLoadDetails adds the loadDetails to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithLoadDetails(loadDetails *string) *WaypointGetLatestReleaseParams {
	o.SetLoadDetails(loadDetails)
	return o
}

// SetLoadDetails adds the loadDetails to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetLoadDetails(loadDetails *string) {
	o.LoadDetails = loadDetails
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointGetLatestReleaseParams {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint get latest release params
func (o *WaypointGetLatestReleaseParams) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetLatestReleaseParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.application
	if err := r.SetPathParam("application.application", o.ApplicationApplication); err != nil {
		return err
	}

	// path param application.project
	if err := r.SetPathParam("application.project", o.ApplicationProject); err != nil {
		return err
	}

	if o.LoadDetails != nil {

		// query param load_details
		var qrLoadDetails string

		if o.LoadDetails != nil {
			qrLoadDetails = *o.LoadDetails
		}
		qLoadDetails := qrLoadDetails
		if qLoadDetails != "" {

			if err := r.SetQueryParam("load_details", qLoadDetails); err != nil {
				return err
			}
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
