// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetLatestStatusReportReader is a Reader for the WaypointGetLatestStatusReport structure.
type WaypointGetLatestStatusReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetLatestStatusReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetLatestStatusReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetLatestStatusReportDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetLatestStatusReportOK creates a WaypointGetLatestStatusReportOK with default headers values
func NewWaypointGetLatestStatusReportOK() *WaypointGetLatestStatusReportOK {
	return &WaypointGetLatestStatusReportOK{}
}

/*
WaypointGetLatestStatusReportOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetLatestStatusReportOK struct {
	Payload *models.HashicorpWaypointStatusReport
}

// IsSuccess returns true when this waypoint get latest status report o k response has a 2xx status code
func (o *WaypointGetLatestStatusReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get latest status report o k response has a 3xx status code
func (o *WaypointGetLatestStatusReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get latest status report o k response has a 4xx status code
func (o *WaypointGetLatestStatusReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get latest status report o k response has a 5xx status code
func (o *WaypointGetLatestStatusReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get latest status report o k response a status code equal to that given
func (o *WaypointGetLatestStatusReportOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetLatestStatusReportOK) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/status-report/latest][%d] waypointGetLatestStatusReportOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestStatusReportOK) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/status-report/latest][%d] waypointGetLatestStatusReportOK  %+v", 200, o.Payload)
}

func (o *WaypointGetLatestStatusReportOK) GetPayload() *models.HashicorpWaypointStatusReport {
	return o.Payload
}

func (o *WaypointGetLatestStatusReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointStatusReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetLatestStatusReportDefault creates a WaypointGetLatestStatusReportDefault with default headers values
func NewWaypointGetLatestStatusReportDefault(code int) *WaypointGetLatestStatusReportDefault {
	return &WaypointGetLatestStatusReportDefault{
		_statusCode: code,
	}
}

/*
WaypointGetLatestStatusReportDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetLatestStatusReportDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get latest status report default response
func (o *WaypointGetLatestStatusReportDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get latest status report default response has a 2xx status code
func (o *WaypointGetLatestStatusReportDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get latest status report default response has a 3xx status code
func (o *WaypointGetLatestStatusReportDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get latest status report default response has a 4xx status code
func (o *WaypointGetLatestStatusReportDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get latest status report default response has a 5xx status code
func (o *WaypointGetLatestStatusReportDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get latest status report default response a status code equal to that given
func (o *WaypointGetLatestStatusReportDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetLatestStatusReportDefault) Error() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/status-report/latest][%d] Waypoint_GetLatestStatusReport default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestStatusReportDefault) String() string {
	return fmt.Sprintf("[GET /project/{application.project}/application/{application.application}/status-report/latest][%d] Waypoint_GetLatestStatusReport default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetLatestStatusReportDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetLatestStatusReportDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
