// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// NewWaypointGetLogStreamParams creates a new WaypointGetLogStreamParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetLogStreamParams() *WaypointGetLogStreamParams {
	return &WaypointGetLogStreamParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetLogStreamParamsWithTimeout creates a new WaypointGetLogStreamParams object
// with the ability to set a timeout on a request.
func NewWaypointGetLogStreamParamsWithTimeout(timeout time.Duration) *WaypointGetLogStreamParams {
	return &WaypointGetLogStreamParams{
		timeout: timeout,
	}
}

// NewWaypointGetLogStreamParamsWithContext creates a new WaypointGetLogStreamParams object
// with the ability to set a context for a request.
func NewWaypointGetLogStreamParamsWithContext(ctx context.Context) *WaypointGetLogStreamParams {
	return &WaypointGetLogStreamParams{
		Context: ctx,
	}
}

// NewWaypointGetLogStreamParamsWithHTTPClient creates a new WaypointGetLogStreamParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetLogStreamParamsWithHTTPClient(client *http.Client) *WaypointGetLogStreamParams {
	return &WaypointGetLogStreamParams{
		HTTPClient: client,
	}
}

/*
WaypointGetLogStreamParams contains all the parameters to send to the API endpoint

	for the waypoint get log stream operation.

	Typically these are written to a http.Request.
*/
type WaypointGetLogStreamParams struct {

	// Body.
	Body *models.HashicorpWaypointGetLogStreamRequest

	/* DeploymentID.

	   Deployment to request logs for.
	*/
	DeploymentID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get log stream params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLogStreamParams) WithDefaults() *WaypointGetLogStreamParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get log stream params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetLogStreamParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) WithTimeout(timeout time.Duration) *WaypointGetLogStreamParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) WithContext(ctx context.Context) *WaypointGetLogStreamParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) WithHTTPClient(client *http.Client) *WaypointGetLogStreamParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) WithBody(body *models.HashicorpWaypointGetLogStreamRequest) *WaypointGetLogStreamParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) SetBody(body *models.HashicorpWaypointGetLogStreamRequest) {
	o.Body = body
}

// WithDeploymentID adds the deploymentID to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) WithDeploymentID(deploymentID string) *WaypointGetLogStreamParams {
	o.SetDeploymentID(deploymentID)
	return o
}

// SetDeploymentID adds the deploymentId to the waypoint get log stream params
func (o *WaypointGetLogStreamParams) SetDeploymentID(deploymentID string) {
	o.DeploymentID = deploymentID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetLogStreamParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param deployment_id
	if err := r.SetPathParam("deployment_id", o.DeploymentID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
