// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetPipelineReader is a Reader for the WaypointGetPipeline structure.
type WaypointGetPipelineReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetPipelineReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetPipelineOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetPipelineDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetPipelineOK creates a WaypointGetPipelineOK with default headers values
func NewWaypointGetPipelineOK() *WaypointGetPipelineOK {
	return &WaypointGetPipelineOK{}
}

/*
WaypointGetPipelineOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetPipelineOK struct {
	Payload *models.HashicorpWaypointGetPipelineResponse
}

// IsSuccess returns true when this waypoint get pipeline o k response has a 2xx status code
func (o *WaypointGetPipelineOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get pipeline o k response has a 3xx status code
func (o *WaypointGetPipelineOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get pipeline o k response has a 4xx status code
func (o *WaypointGetPipelineOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get pipeline o k response has a 5xx status code
func (o *WaypointGetPipelineOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get pipeline o k response a status code equal to that given
func (o *WaypointGetPipelineOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetPipelineOK) Error() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}][%d] waypointGetPipelineOK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipelineOK) String() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}][%d] waypointGetPipelineOK  %+v", 200, o.Payload)
}

func (o *WaypointGetPipelineOK) GetPayload() *models.HashicorpWaypointGetPipelineResponse {
	return o.Payload
}

func (o *WaypointGetPipelineOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetPipelineResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetPipelineDefault creates a WaypointGetPipelineDefault with default headers values
func NewWaypointGetPipelineDefault(code int) *WaypointGetPipelineDefault {
	return &WaypointGetPipelineDefault{
		_statusCode: code,
	}
}

/*
WaypointGetPipelineDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetPipelineDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get pipeline default response
func (o *WaypointGetPipelineDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get pipeline default response has a 2xx status code
func (o *WaypointGetPipelineDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get pipeline default response has a 3xx status code
func (o *WaypointGetPipelineDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get pipeline default response has a 4xx status code
func (o *WaypointGetPipelineDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get pipeline default response has a 5xx status code
func (o *WaypointGetPipelineDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get pipeline default response a status code equal to that given
func (o *WaypointGetPipelineDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetPipelineDefault) Error() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}][%d] Waypoint_GetPipeline default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipelineDefault) String() string {
	return fmt.Sprintf("[GET /project/{pipeline.owner.project.project}/pipeline/{pipeline.owner.pipeline_name}][%d] Waypoint_GetPipeline default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetPipelineDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetPipelineDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
