// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointGetRelease2Params creates a new WaypointGetRelease2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointGetRelease2Params() *WaypointGetRelease2Params {
	return &WaypointGetRelease2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointGetRelease2ParamsWithTimeout creates a new WaypointGetRelease2Params object
// with the ability to set a timeout on a request.
func NewWaypointGetRelease2ParamsWithTimeout(timeout time.Duration) *WaypointGetRelease2Params {
	return &WaypointGetRelease2Params{
		timeout: timeout,
	}
}

// NewWaypointGetRelease2ParamsWithContext creates a new WaypointGetRelease2Params object
// with the ability to set a context for a request.
func NewWaypointGetRelease2ParamsWithContext(ctx context.Context) *WaypointGetRelease2Params {
	return &WaypointGetRelease2Params{
		Context: ctx,
	}
}

// NewWaypointGetRelease2ParamsWithHTTPClient creates a new WaypointGetRelease2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointGetRelease2ParamsWithHTTPClient(client *http.Client) *WaypointGetRelease2Params {
	return &WaypointGetRelease2Params{
		HTTPClient: client,
	}
}

/*
WaypointGetRelease2Params contains all the parameters to send to the API endpoint

	for the waypoint get release2 operation.

	Typically these are written to a http.Request.
*/
type WaypointGetRelease2Params struct {

	/* LoadDetails.

	     Load additional details about the release. These will become available
	in the Preload section.

	     Default: "NONE"
	*/
	LoadDetails *string

	// RefID.
	RefID *string

	// RefSequenceApplicationApplication.
	RefSequenceApplicationApplication string

	// RefSequenceApplicationProject.
	RefSequenceApplicationProject string

	// RefSequenceNumber.
	//
	// Format: uint64
	RefSequenceNumber string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint get release2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetRelease2Params) WithDefaults() *WaypointGetRelease2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint get release2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointGetRelease2Params) SetDefaults() {
	var (
		loadDetailsDefault = string("NONE")
	)

	val := WaypointGetRelease2Params{
		LoadDetails: &loadDetailsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithTimeout(timeout time.Duration) *WaypointGetRelease2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithContext(ctx context.Context) *WaypointGetRelease2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithHTTPClient(client *http.Client) *WaypointGetRelease2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLoadDetails adds the loadDetails to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithLoadDetails(loadDetails *string) *WaypointGetRelease2Params {
	o.SetLoadDetails(loadDetails)
	return o
}

// SetLoadDetails adds the loadDetails to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetLoadDetails(loadDetails *string) {
	o.LoadDetails = loadDetails
}

// WithRefID adds the refID to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithRefID(refID *string) *WaypointGetRelease2Params {
	o.SetRefID(refID)
	return o
}

// SetRefID adds the refId to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetRefID(refID *string) {
	o.RefID = refID
}

// WithRefSequenceApplicationApplication adds the refSequenceApplicationApplication to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithRefSequenceApplicationApplication(refSequenceApplicationApplication string) *WaypointGetRelease2Params {
	o.SetRefSequenceApplicationApplication(refSequenceApplicationApplication)
	return o
}

// SetRefSequenceApplicationApplication adds the refSequenceApplicationApplication to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetRefSequenceApplicationApplication(refSequenceApplicationApplication string) {
	o.RefSequenceApplicationApplication = refSequenceApplicationApplication
}

// WithRefSequenceApplicationProject adds the refSequenceApplicationProject to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithRefSequenceApplicationProject(refSequenceApplicationProject string) *WaypointGetRelease2Params {
	o.SetRefSequenceApplicationProject(refSequenceApplicationProject)
	return o
}

// SetRefSequenceApplicationProject adds the refSequenceApplicationProject to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetRefSequenceApplicationProject(refSequenceApplicationProject string) {
	o.RefSequenceApplicationProject = refSequenceApplicationProject
}

// WithRefSequenceNumber adds the refSequenceNumber to the waypoint get release2 params
func (o *WaypointGetRelease2Params) WithRefSequenceNumber(refSequenceNumber string) *WaypointGetRelease2Params {
	o.SetRefSequenceNumber(refSequenceNumber)
	return o
}

// SetRefSequenceNumber adds the refSequenceNumber to the waypoint get release2 params
func (o *WaypointGetRelease2Params) SetRefSequenceNumber(refSequenceNumber string) {
	o.RefSequenceNumber = refSequenceNumber
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointGetRelease2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.LoadDetails != nil {

		// query param load_details
		var qrLoadDetails string

		if o.LoadDetails != nil {
			qrLoadDetails = *o.LoadDetails
		}
		qLoadDetails := qrLoadDetails
		if qLoadDetails != "" {

			if err := r.SetQueryParam("load_details", qLoadDetails); err != nil {
				return err
			}
		}
	}

	if o.RefID != nil {

		// query param ref.id
		var qrRefID string

		if o.RefID != nil {
			qrRefID = *o.RefID
		}
		qRefID := qrRefID
		if qRefID != "" {

			if err := r.SetQueryParam("ref.id", qRefID); err != nil {
				return err
			}
		}
	}

	// path param ref.sequence.application.application
	if err := r.SetPathParam("ref.sequence.application.application", o.RefSequenceApplicationApplication); err != nil {
		return err
	}

	// path param ref.sequence.application.project
	if err := r.SetPathParam("ref.sequence.application.project", o.RefSequenceApplicationProject); err != nil {
		return err
	}

	// path param ref.sequence.number
	if err := r.SetPathParam("ref.sequence.number", o.RefSequenceNumber); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
