// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetTask2Reader is a Reader for the WaypointGetTask2 structure.
type WaypointGetTask2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetTask2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetTask2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetTask2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetTask2OK creates a WaypointGetTask2OK with default headers values
func NewWaypointGetTask2OK() *WaypointGetTask2OK {
	return &WaypointGetTask2OK{}
}

/*
WaypointGetTask2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetTask2OK struct {
	Payload *models.HashicorpWaypointGetTaskResponse
}

// IsSuccess returns true when this waypoint get task2 o k response has a 2xx status code
func (o *WaypointGetTask2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get task2 o k response has a 3xx status code
func (o *WaypointGetTask2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get task2 o k response has a 4xx status code
func (o *WaypointGetTask2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get task2 o k response has a 5xx status code
func (o *WaypointGetTask2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get task2 o k response a status code equal to that given
func (o *WaypointGetTask2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetTask2OK) Error() string {
	return fmt.Sprintf("[GET /task/by-job/{ref.job_id}][%d] waypointGetTask2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetTask2OK) String() string {
	return fmt.Sprintf("[GET /task/by-job/{ref.job_id}][%d] waypointGetTask2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetTask2OK) GetPayload() *models.HashicorpWaypointGetTaskResponse {
	return o.Payload
}

func (o *WaypointGetTask2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetTaskResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetTask2Default creates a WaypointGetTask2Default with default headers values
func NewWaypointGetTask2Default(code int) *WaypointGetTask2Default {
	return &WaypointGetTask2Default{
		_statusCode: code,
	}
}

/*
WaypointGetTask2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetTask2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get task2 default response
func (o *WaypointGetTask2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get task2 default response has a 2xx status code
func (o *WaypointGetTask2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get task2 default response has a 3xx status code
func (o *WaypointGetTask2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get task2 default response has a 4xx status code
func (o *WaypointGetTask2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get task2 default response has a 5xx status code
func (o *WaypointGetTask2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get task2 default response a status code equal to that given
func (o *WaypointGetTask2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetTask2Default) Error() string {
	return fmt.Sprintf("[GET /task/by-job/{ref.job_id}][%d] Waypoint_GetTask2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetTask2Default) String() string {
	return fmt.Sprintf("[GET /task/by-job/{ref.job_id}][%d] Waypoint_GetTask2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetTask2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetTask2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
