// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetUser2Reader is a Reader for the WaypointGetUser2 structure.
type WaypointGetUser2Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetUser2Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetUser2OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetUser2Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetUser2OK creates a WaypointGetUser2OK with default headers values
func NewWaypointGetUser2OK() *WaypointGetUser2OK {
	return &WaypointGetUser2OK{}
}

/*
WaypointGetUser2OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetUser2OK struct {
	Payload *models.HashicorpWaypointGetUserResponse
}

// IsSuccess returns true when this waypoint get user2 o k response has a 2xx status code
func (o *WaypointGetUser2OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get user2 o k response has a 3xx status code
func (o *WaypointGetUser2OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get user2 o k response has a 4xx status code
func (o *WaypointGetUser2OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get user2 o k response has a 5xx status code
func (o *WaypointGetUser2OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get user2 o k response a status code equal to that given
func (o *WaypointGetUser2OK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetUser2OK) Error() string {
	return fmt.Sprintf("[GET /user/by-username/{user.username.username}][%d] waypointGetUser2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetUser2OK) String() string {
	return fmt.Sprintf("[GET /user/by-username/{user.username.username}][%d] waypointGetUser2OK  %+v", 200, o.Payload)
}

func (o *WaypointGetUser2OK) GetPayload() *models.HashicorpWaypointGetUserResponse {
	return o.Payload
}

func (o *WaypointGetUser2OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetUserResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetUser2Default creates a WaypointGetUser2Default with default headers values
func NewWaypointGetUser2Default(code int) *WaypointGetUser2Default {
	return &WaypointGetUser2Default{
		_statusCode: code,
	}
}

/*
WaypointGetUser2Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetUser2Default struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get user2 default response
func (o *WaypointGetUser2Default) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get user2 default response has a 2xx status code
func (o *WaypointGetUser2Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get user2 default response has a 3xx status code
func (o *WaypointGetUser2Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get user2 default response has a 4xx status code
func (o *WaypointGetUser2Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get user2 default response has a 5xx status code
func (o *WaypointGetUser2Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get user2 default response a status code equal to that given
func (o *WaypointGetUser2Default) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetUser2Default) Error() string {
	return fmt.Sprintf("[GET /user/by-username/{user.username.username}][%d] Waypoint_GetUser2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetUser2Default) String() string {
	return fmt.Sprintf("[GET /user/by-username/{user.username.username}][%d] Waypoint_GetUser2 default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetUser2Default) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetUser2Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
