// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointGetVersionInfoReader is a Reader for the WaypointGetVersionInfo structure.
type WaypointGetVersionInfoReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointGetVersionInfoReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointGetVersionInfoOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointGetVersionInfoDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointGetVersionInfoOK creates a WaypointGetVersionInfoOK with default headers values
func NewWaypointGetVersionInfoOK() *WaypointGetVersionInfoOK {
	return &WaypointGetVersionInfoOK{}
}

/*
WaypointGetVersionInfoOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointGetVersionInfoOK struct {
	Payload *models.HashicorpWaypointGetVersionInfoResponse
}

// IsSuccess returns true when this waypoint get version info o k response has a 2xx status code
func (o *WaypointGetVersionInfoOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint get version info o k response has a 3xx status code
func (o *WaypointGetVersionInfoOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint get version info o k response has a 4xx status code
func (o *WaypointGetVersionInfoOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint get version info o k response has a 5xx status code
func (o *WaypointGetVersionInfoOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint get version info o k response a status code equal to that given
func (o *WaypointGetVersionInfoOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointGetVersionInfoOK) Error() string {
	return fmt.Sprintf("[GET /version][%d] waypointGetVersionInfoOK  %+v", 200, o.Payload)
}

func (o *WaypointGetVersionInfoOK) String() string {
	return fmt.Sprintf("[GET /version][%d] waypointGetVersionInfoOK  %+v", 200, o.Payload)
}

func (o *WaypointGetVersionInfoOK) GetPayload() *models.HashicorpWaypointGetVersionInfoResponse {
	return o.Payload
}

func (o *WaypointGetVersionInfoOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointGetVersionInfoResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointGetVersionInfoDefault creates a WaypointGetVersionInfoDefault with default headers values
func NewWaypointGetVersionInfoDefault(code int) *WaypointGetVersionInfoDefault {
	return &WaypointGetVersionInfoDefault{
		_statusCode: code,
	}
}

/*
WaypointGetVersionInfoDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointGetVersionInfoDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint get version info default response
func (o *WaypointGetVersionInfoDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint get version info default response has a 2xx status code
func (o *WaypointGetVersionInfoDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint get version info default response has a 3xx status code
func (o *WaypointGetVersionInfoDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint get version info default response has a 4xx status code
func (o *WaypointGetVersionInfoDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint get version info default response has a 5xx status code
func (o *WaypointGetVersionInfoDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint get version info default response a status code equal to that given
func (o *WaypointGetVersionInfoDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointGetVersionInfoDefault) Error() string {
	return fmt.Sprintf("[GET /version][%d] Waypoint_GetVersionInfo default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetVersionInfoDefault) String() string {
	return fmt.Sprintf("[GET /version][%d] Waypoint_GetVersionInfo default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointGetVersionInfoDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointGetVersionInfoDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
