// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointListInstancesParams creates a new WaypointListInstancesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListInstancesParams() *WaypointListInstancesParams {
	return &WaypointListInstancesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListInstancesParamsWithTimeout creates a new WaypointListInstancesParams object
// with the ability to set a timeout on a request.
func NewWaypointListInstancesParamsWithTimeout(timeout time.Duration) *WaypointListInstancesParams {
	return &WaypointListInstancesParams{
		timeout: timeout,
	}
}

// NewWaypointListInstancesParamsWithContext creates a new WaypointListInstancesParams object
// with the ability to set a context for a request.
func NewWaypointListInstancesParamsWithContext(ctx context.Context) *WaypointListInstancesParams {
	return &WaypointListInstancesParams{
		Context: ctx,
	}
}

// NewWaypointListInstancesParamsWithHTTPClient creates a new WaypointListInstancesParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListInstancesParamsWithHTTPClient(client *http.Client) *WaypointListInstancesParams {
	return &WaypointListInstancesParams{
		HTTPClient: client,
	}
}

/*
WaypointListInstancesParams contains all the parameters to send to the API endpoint

	for the waypoint list instances operation.

	Typically these are written to a http.Request.
*/
type WaypointListInstancesParams struct {

	// ApplicationApplicationApplication.
	ApplicationApplicationApplication *string

	// ApplicationApplicationProject.
	ApplicationApplicationProject *string

	// ApplicationWorkspaceWorkspace.
	ApplicationWorkspaceWorkspace *string

	/* DeploymentID.

	   List instances for a specific deployment.
	*/
	DeploymentID string

	/* WaitTimeout.

	   Time to wait before retrying a request to connect to requested instance.
	*/
	WaitTimeout *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list instances params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListInstancesParams) WithDefaults() *WaypointListInstancesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list instances params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListInstancesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint list instances params
func (o *WaypointListInstancesParams) WithTimeout(timeout time.Duration) *WaypointListInstancesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list instances params
func (o *WaypointListInstancesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list instances params
func (o *WaypointListInstancesParams) WithContext(ctx context.Context) *WaypointListInstancesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list instances params
func (o *WaypointListInstancesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list instances params
func (o *WaypointListInstancesParams) WithHTTPClient(client *http.Client) *WaypointListInstancesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list instances params
func (o *WaypointListInstancesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplicationApplication adds the applicationApplicationApplication to the waypoint list instances params
func (o *WaypointListInstancesParams) WithApplicationApplicationApplication(applicationApplicationApplication *string) *WaypointListInstancesParams {
	o.SetApplicationApplicationApplication(applicationApplicationApplication)
	return o
}

// SetApplicationApplicationApplication adds the applicationApplicationApplication to the waypoint list instances params
func (o *WaypointListInstancesParams) SetApplicationApplicationApplication(applicationApplicationApplication *string) {
	o.ApplicationApplicationApplication = applicationApplicationApplication
}

// WithApplicationApplicationProject adds the applicationApplicationProject to the waypoint list instances params
func (o *WaypointListInstancesParams) WithApplicationApplicationProject(applicationApplicationProject *string) *WaypointListInstancesParams {
	o.SetApplicationApplicationProject(applicationApplicationProject)
	return o
}

// SetApplicationApplicationProject adds the applicationApplicationProject to the waypoint list instances params
func (o *WaypointListInstancesParams) SetApplicationApplicationProject(applicationApplicationProject *string) {
	o.ApplicationApplicationProject = applicationApplicationProject
}

// WithApplicationWorkspaceWorkspace adds the applicationWorkspaceWorkspace to the waypoint list instances params
func (o *WaypointListInstancesParams) WithApplicationWorkspaceWorkspace(applicationWorkspaceWorkspace *string) *WaypointListInstancesParams {
	o.SetApplicationWorkspaceWorkspace(applicationWorkspaceWorkspace)
	return o
}

// SetApplicationWorkspaceWorkspace adds the applicationWorkspaceWorkspace to the waypoint list instances params
func (o *WaypointListInstancesParams) SetApplicationWorkspaceWorkspace(applicationWorkspaceWorkspace *string) {
	o.ApplicationWorkspaceWorkspace = applicationWorkspaceWorkspace
}

// WithDeploymentID adds the deploymentID to the waypoint list instances params
func (o *WaypointListInstancesParams) WithDeploymentID(deploymentID string) *WaypointListInstancesParams {
	o.SetDeploymentID(deploymentID)
	return o
}

// SetDeploymentID adds the deploymentId to the waypoint list instances params
func (o *WaypointListInstancesParams) SetDeploymentID(deploymentID string) {
	o.DeploymentID = deploymentID
}

// WithWaitTimeout adds the waitTimeout to the waypoint list instances params
func (o *WaypointListInstancesParams) WithWaitTimeout(waitTimeout *string) *WaypointListInstancesParams {
	o.SetWaitTimeout(waitTimeout)
	return o
}

// SetWaitTimeout adds the waitTimeout to the waypoint list instances params
func (o *WaypointListInstancesParams) SetWaitTimeout(waitTimeout *string) {
	o.WaitTimeout = waitTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListInstancesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationApplicationApplication != nil {

		// query param application.application.application
		var qrApplicationApplicationApplication string

		if o.ApplicationApplicationApplication != nil {
			qrApplicationApplicationApplication = *o.ApplicationApplicationApplication
		}
		qApplicationApplicationApplication := qrApplicationApplicationApplication
		if qApplicationApplicationApplication != "" {

			if err := r.SetQueryParam("application.application.application", qApplicationApplicationApplication); err != nil {
				return err
			}
		}
	}

	if o.ApplicationApplicationProject != nil {

		// query param application.application.project
		var qrApplicationApplicationProject string

		if o.ApplicationApplicationProject != nil {
			qrApplicationApplicationProject = *o.ApplicationApplicationProject
		}
		qApplicationApplicationProject := qrApplicationApplicationProject
		if qApplicationApplicationProject != "" {

			if err := r.SetQueryParam("application.application.project", qApplicationApplicationProject); err != nil {
				return err
			}
		}
	}

	if o.ApplicationWorkspaceWorkspace != nil {

		// query param application.workspace.workspace
		var qrApplicationWorkspaceWorkspace string

		if o.ApplicationWorkspaceWorkspace != nil {
			qrApplicationWorkspaceWorkspace = *o.ApplicationWorkspaceWorkspace
		}
		qApplicationWorkspaceWorkspace := qrApplicationWorkspaceWorkspace
		if qApplicationWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("application.workspace.workspace", qApplicationWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	// path param deployment_id
	if err := r.SetPathParam("deployment_id", o.DeploymentID); err != nil {
		return err
	}

	if o.WaitTimeout != nil {

		// query param wait_timeout
		var qrWaitTimeout string

		if o.WaitTimeout != nil {
			qrWaitTimeout = *o.WaitTimeout
		}
		qWaitTimeout := qrWaitTimeout
		if qWaitTimeout != "" {

			if err := r.SetQueryParam("wait_timeout", qWaitTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
