// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListPipelinesReader is a Reader for the WaypointListPipelines structure.
type WaypointListPipelinesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListPipelinesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListPipelinesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListPipelinesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListPipelinesOK creates a WaypointListPipelinesOK with default headers values
func NewWaypointListPipelinesOK() *WaypointListPipelinesOK {
	return &WaypointListPipelinesOK{}
}

/*
WaypointListPipelinesOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListPipelinesOK struct {
	Payload *models.HashicorpWaypointListPipelinesResponse
}

// IsSuccess returns true when this waypoint list pipelines o k response has a 2xx status code
func (o *WaypointListPipelinesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list pipelines o k response has a 3xx status code
func (o *WaypointListPipelinesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list pipelines o k response has a 4xx status code
func (o *WaypointListPipelinesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list pipelines o k response has a 5xx status code
func (o *WaypointListPipelinesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list pipelines o k response a status code equal to that given
func (o *WaypointListPipelinesOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListPipelinesOK) Error() string {
	return fmt.Sprintf("[GET /project/{project.project}/pipelines][%d] waypointListPipelinesOK  %+v", 200, o.Payload)
}

func (o *WaypointListPipelinesOK) String() string {
	return fmt.Sprintf("[GET /project/{project.project}/pipelines][%d] waypointListPipelinesOK  %+v", 200, o.Payload)
}

func (o *WaypointListPipelinesOK) GetPayload() *models.HashicorpWaypointListPipelinesResponse {
	return o.Payload
}

func (o *WaypointListPipelinesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListPipelinesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListPipelinesDefault creates a WaypointListPipelinesDefault with default headers values
func NewWaypointListPipelinesDefault(code int) *WaypointListPipelinesDefault {
	return &WaypointListPipelinesDefault{
		_statusCode: code,
	}
}

/*
WaypointListPipelinesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListPipelinesDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list pipelines default response
func (o *WaypointListPipelinesDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list pipelines default response has a 2xx status code
func (o *WaypointListPipelinesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list pipelines default response has a 3xx status code
func (o *WaypointListPipelinesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list pipelines default response has a 4xx status code
func (o *WaypointListPipelinesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list pipelines default response has a 5xx status code
func (o *WaypointListPipelinesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list pipelines default response a status code equal to that given
func (o *WaypointListPipelinesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListPipelinesDefault) Error() string {
	return fmt.Sprintf("[GET /project/{project.project}/pipelines][%d] Waypoint_ListPipelines default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListPipelinesDefault) String() string {
	return fmt.Sprintf("[GET /project/{project.project}/pipelines][%d] Waypoint_ListPipelines default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListPipelinesDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListPipelinesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
