// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointListTriggers2Params creates a new WaypointListTriggers2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointListTriggers2Params() *WaypointListTriggers2Params {
	return &WaypointListTriggers2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointListTriggers2ParamsWithTimeout creates a new WaypointListTriggers2Params object
// with the ability to set a timeout on a request.
func NewWaypointListTriggers2ParamsWithTimeout(timeout time.Duration) *WaypointListTriggers2Params {
	return &WaypointListTriggers2Params{
		timeout: timeout,
	}
}

// NewWaypointListTriggers2ParamsWithContext creates a new WaypointListTriggers2Params object
// with the ability to set a context for a request.
func NewWaypointListTriggers2ParamsWithContext(ctx context.Context) *WaypointListTriggers2Params {
	return &WaypointListTriggers2Params{
		Context: ctx,
	}
}

// NewWaypointListTriggers2ParamsWithHTTPClient creates a new WaypointListTriggers2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointListTriggers2ParamsWithHTTPClient(client *http.Client) *WaypointListTriggers2Params {
	return &WaypointListTriggers2Params{
		HTTPClient: client,
	}
}

/*
WaypointListTriggers2Params contains all the parameters to send to the API endpoint

	for the waypoint list triggers2 operation.

	Typically these are written to a http.Request.
*/
type WaypointListTriggers2Params struct {

	// ApplicationApplication.
	ApplicationApplication *string

	// ApplicationProject.
	ApplicationProject *string

	// ProjectProject.
	ProjectProject string

	/* Tags.

	   Will filter triggers by the requested labels if set.
	*/
	Tags []string

	// WorkspaceWorkspace.
	WorkspaceWorkspace *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint list triggers2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListTriggers2Params) WithDefaults() *WaypointListTriggers2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint list triggers2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointListTriggers2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithTimeout(timeout time.Duration) *WaypointListTriggers2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithContext(ctx context.Context) *WaypointListTriggers2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithHTTPClient(client *http.Client) *WaypointListTriggers2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationApplication adds the applicationApplication to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithApplicationApplication(applicationApplication *string) *WaypointListTriggers2Params {
	o.SetApplicationApplication(applicationApplication)
	return o
}

// SetApplicationApplication adds the applicationApplication to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetApplicationApplication(applicationApplication *string) {
	o.ApplicationApplication = applicationApplication
}

// WithApplicationProject adds the applicationProject to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithApplicationProject(applicationProject *string) *WaypointListTriggers2Params {
	o.SetApplicationProject(applicationProject)
	return o
}

// SetApplicationProject adds the applicationProject to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetApplicationProject(applicationProject *string) {
	o.ApplicationProject = applicationProject
}

// WithProjectProject adds the projectProject to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithProjectProject(projectProject string) *WaypointListTriggers2Params {
	o.SetProjectProject(projectProject)
	return o
}

// SetProjectProject adds the projectProject to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetProjectProject(projectProject string) {
	o.ProjectProject = projectProject
}

// WithTags adds the tags to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithTags(tags []string) *WaypointListTriggers2Params {
	o.SetTags(tags)
	return o
}

// SetTags adds the tags to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetTags(tags []string) {
	o.Tags = tags
}

// WithWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) WithWorkspaceWorkspace(workspaceWorkspace *string) *WaypointListTriggers2Params {
	o.SetWorkspaceWorkspace(workspaceWorkspace)
	return o
}

// SetWorkspaceWorkspace adds the workspaceWorkspace to the waypoint list triggers2 params
func (o *WaypointListTriggers2Params) SetWorkspaceWorkspace(workspaceWorkspace *string) {
	o.WorkspaceWorkspace = workspaceWorkspace
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointListTriggers2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationApplication != nil {

		// query param application.application
		var qrApplicationApplication string

		if o.ApplicationApplication != nil {
			qrApplicationApplication = *o.ApplicationApplication
		}
		qApplicationApplication := qrApplicationApplication
		if qApplicationApplication != "" {

			if err := r.SetQueryParam("application.application", qApplicationApplication); err != nil {
				return err
			}
		}
	}

	if o.ApplicationProject != nil {

		// query param application.project
		var qrApplicationProject string

		if o.ApplicationProject != nil {
			qrApplicationProject = *o.ApplicationProject
		}
		qApplicationProject := qrApplicationProject
		if qApplicationProject != "" {

			if err := r.SetQueryParam("application.project", qApplicationProject); err != nil {
				return err
			}
		}
	}

	// path param project.project
	if err := r.SetPathParam("project.project", o.ProjectProject); err != nil {
		return err
	}

	if o.Tags != nil {

		// binding items for tags
		joinedTags := o.bindParamTags(reg)

		// query array param tags
		if err := r.SetQueryParam("tags", joinedTags...); err != nil {
			return err
		}
	}

	if o.WorkspaceWorkspace != nil {

		// query param workspace.workspace
		var qrWorkspaceWorkspace string

		if o.WorkspaceWorkspace != nil {
			qrWorkspaceWorkspace = *o.WorkspaceWorkspace
		}
		qWorkspaceWorkspace := qrWorkspaceWorkspace
		if qWorkspaceWorkspace != "" {

			if err := r.SetQueryParam("workspace.workspace", qWorkspaceWorkspace); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamWaypointListTriggers2 binds the parameter tags
func (o *WaypointListTriggers2Params) bindParamTags(formats strfmt.Registry) []string {
	tagsIR := o.Tags

	var tagsIC []string
	for _, tagsIIR := range tagsIR { // explode []string

		tagsIIV := tagsIIR // string as string
		tagsIC = append(tagsIC, tagsIIV)
	}

	// items.CollectionFormat: "multi"
	tagsIS := swag.JoinByFormat(tagsIC, "multi")

	return tagsIS
}
