// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListTriggersReader is a Reader for the WaypointListTriggers structure.
type WaypointListTriggersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListTriggersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListTriggersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListTriggersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListTriggersOK creates a WaypointListTriggersOK with default headers values
func NewWaypointListTriggersOK() *WaypointListTriggersOK {
	return &WaypointListTriggersOK{}
}

/*
WaypointListTriggersOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListTriggersOK struct {
	Payload *models.HashicorpWaypointListTriggerResponse
}

// IsSuccess returns true when this waypoint list triggers o k response has a 2xx status code
func (o *WaypointListTriggersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list triggers o k response has a 3xx status code
func (o *WaypointListTriggersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list triggers o k response has a 4xx status code
func (o *WaypointListTriggersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list triggers o k response has a 5xx status code
func (o *WaypointListTriggersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list triggers o k response a status code equal to that given
func (o *WaypointListTriggersOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListTriggersOK) Error() string {
	return fmt.Sprintf("[GET /triggers][%d] waypointListTriggersOK  %+v", 200, o.Payload)
}

func (o *WaypointListTriggersOK) String() string {
	return fmt.Sprintf("[GET /triggers][%d] waypointListTriggersOK  %+v", 200, o.Payload)
}

func (o *WaypointListTriggersOK) GetPayload() *models.HashicorpWaypointListTriggerResponse {
	return o.Payload
}

func (o *WaypointListTriggersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListTriggerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListTriggersDefault creates a WaypointListTriggersDefault with default headers values
func NewWaypointListTriggersDefault(code int) *WaypointListTriggersDefault {
	return &WaypointListTriggersDefault{
		_statusCode: code,
	}
}

/*
WaypointListTriggersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListTriggersDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list triggers default response
func (o *WaypointListTriggersDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list triggers default response has a 2xx status code
func (o *WaypointListTriggersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list triggers default response has a 3xx status code
func (o *WaypointListTriggersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list triggers default response has a 4xx status code
func (o *WaypointListTriggersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list triggers default response has a 5xx status code
func (o *WaypointListTriggersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list triggers default response a status code equal to that given
func (o *WaypointListTriggersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListTriggersDefault) Error() string {
	return fmt.Sprintf("[GET /triggers][%d] Waypoint_ListTriggers default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTriggersDefault) String() string {
	return fmt.Sprintf("[GET /triggers][%d] Waypoint_ListTriggers default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListTriggersDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListTriggersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
