// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointListUsersReader is a Reader for the WaypointListUsers structure.
type WaypointListUsersReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointListUsersReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointListUsersOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointListUsersDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointListUsersOK creates a WaypointListUsersOK with default headers values
func NewWaypointListUsersOK() *WaypointListUsersOK {
	return &WaypointListUsersOK{}
}

/*
WaypointListUsersOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointListUsersOK struct {
	Payload *models.HashicorpWaypointListUsersResponse
}

// IsSuccess returns true when this waypoint list users o k response has a 2xx status code
func (o *WaypointListUsersOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint list users o k response has a 3xx status code
func (o *WaypointListUsersOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint list users o k response has a 4xx status code
func (o *WaypointListUsersOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint list users o k response has a 5xx status code
func (o *WaypointListUsersOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint list users o k response a status code equal to that given
func (o *WaypointListUsersOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointListUsersOK) Error() string {
	return fmt.Sprintf("[GET /users][%d] waypointListUsersOK  %+v", 200, o.Payload)
}

func (o *WaypointListUsersOK) String() string {
	return fmt.Sprintf("[GET /users][%d] waypointListUsersOK  %+v", 200, o.Payload)
}

func (o *WaypointListUsersOK) GetPayload() *models.HashicorpWaypointListUsersResponse {
	return o.Payload
}

func (o *WaypointListUsersOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointListUsersResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointListUsersDefault creates a WaypointListUsersDefault with default headers values
func NewWaypointListUsersDefault(code int) *WaypointListUsersDefault {
	return &WaypointListUsersDefault{
		_statusCode: code,
	}
}

/*
WaypointListUsersDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointListUsersDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint list users default response
func (o *WaypointListUsersDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint list users default response has a 2xx status code
func (o *WaypointListUsersDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint list users default response has a 3xx status code
func (o *WaypointListUsersDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint list users default response has a 4xx status code
func (o *WaypointListUsersDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint list users default response has a 5xx status code
func (o *WaypointListUsersDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint list users default response a status code equal to that given
func (o *WaypointListUsersDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointListUsersDefault) Error() string {
	return fmt.Sprintf("[GET /users][%d] Waypoint_ListUsers default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListUsersDefault) String() string {
	return fmt.Sprintf("[GET /users][%d] Waypoint_ListUsers default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointListUsersDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointListUsersDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
