// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointNoAuthRunTriggerReader is a Reader for the WaypointNoAuthRunTrigger structure.
type WaypointNoAuthRunTriggerReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointNoAuthRunTriggerReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointNoAuthRunTriggerOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointNoAuthRunTriggerDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointNoAuthRunTriggerOK creates a WaypointNoAuthRunTriggerOK with default headers values
func NewWaypointNoAuthRunTriggerOK() *WaypointNoAuthRunTriggerOK {
	return &WaypointNoAuthRunTriggerOK{}
}

/*
WaypointNoAuthRunTriggerOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointNoAuthRunTriggerOK struct {
	Payload *models.HashicorpWaypointRunTriggerResponse
}

// IsSuccess returns true when this waypoint no auth run trigger o k response has a 2xx status code
func (o *WaypointNoAuthRunTriggerOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint no auth run trigger o k response has a 3xx status code
func (o *WaypointNoAuthRunTriggerOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint no auth run trigger o k response has a 4xx status code
func (o *WaypointNoAuthRunTriggerOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint no auth run trigger o k response has a 5xx status code
func (o *WaypointNoAuthRunTriggerOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint no auth run trigger o k response a status code equal to that given
func (o *WaypointNoAuthRunTriggerOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointNoAuthRunTriggerOK) Error() string {
	return fmt.Sprintf("[POST /triggers/no-auth/{ref.id}/run][%d] waypointNoAuthRunTriggerOK  %+v", 200, o.Payload)
}

func (o *WaypointNoAuthRunTriggerOK) String() string {
	return fmt.Sprintf("[POST /triggers/no-auth/{ref.id}/run][%d] waypointNoAuthRunTriggerOK  %+v", 200, o.Payload)
}

func (o *WaypointNoAuthRunTriggerOK) GetPayload() *models.HashicorpWaypointRunTriggerResponse {
	return o.Payload
}

func (o *WaypointNoAuthRunTriggerOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointRunTriggerResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointNoAuthRunTriggerDefault creates a WaypointNoAuthRunTriggerDefault with default headers values
func NewWaypointNoAuthRunTriggerDefault(code int) *WaypointNoAuthRunTriggerDefault {
	return &WaypointNoAuthRunTriggerDefault{
		_statusCode: code,
	}
}

/*
WaypointNoAuthRunTriggerDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointNoAuthRunTriggerDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint no auth run trigger default response
func (o *WaypointNoAuthRunTriggerDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint no auth run trigger default response has a 2xx status code
func (o *WaypointNoAuthRunTriggerDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint no auth run trigger default response has a 3xx status code
func (o *WaypointNoAuthRunTriggerDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint no auth run trigger default response has a 4xx status code
func (o *WaypointNoAuthRunTriggerDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint no auth run trigger default response has a 5xx status code
func (o *WaypointNoAuthRunTriggerDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint no auth run trigger default response a status code equal to that given
func (o *WaypointNoAuthRunTriggerDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointNoAuthRunTriggerDefault) Error() string {
	return fmt.Sprintf("[POST /triggers/no-auth/{ref.id}/run][%d] Waypoint_NoAuthRunTrigger default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointNoAuthRunTriggerDefault) String() string {
	return fmt.Sprintf("[POST /triggers/no-auth/{ref.id}/run][%d] Waypoint_NoAuthRunTrigger default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointNoAuthRunTriggerDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointNoAuthRunTriggerDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
