// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointSetConfigReader is a Reader for the WaypointSetConfig structure.
type WaypointSetConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointSetConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointSetConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointSetConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointSetConfigOK creates a WaypointSetConfigOK with default headers values
func NewWaypointSetConfigOK() *WaypointSetConfigOK {
	return &WaypointSetConfigOK{}
}

/*
WaypointSetConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointSetConfigOK struct {
	Payload models.HashicorpWaypointConfigSetResponse
}

// IsSuccess returns true when this waypoint set config o k response has a 2xx status code
func (o *WaypointSetConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint set config o k response has a 3xx status code
func (o *WaypointSetConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint set config o k response has a 4xx status code
func (o *WaypointSetConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint set config o k response has a 5xx status code
func (o *WaypointSetConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint set config o k response a status code equal to that given
func (o *WaypointSetConfigOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointSetConfigOK) Error() string {
	return fmt.Sprintf("[PUT /project/config][%d] waypointSetConfigOK  %+v", 200, o.Payload)
}

func (o *WaypointSetConfigOK) String() string {
	return fmt.Sprintf("[PUT /project/config][%d] waypointSetConfigOK  %+v", 200, o.Payload)
}

func (o *WaypointSetConfigOK) GetPayload() models.HashicorpWaypointConfigSetResponse {
	return o.Payload
}

func (o *WaypointSetConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointSetConfigDefault creates a WaypointSetConfigDefault with default headers values
func NewWaypointSetConfigDefault(code int) *WaypointSetConfigDefault {
	return &WaypointSetConfigDefault{
		_statusCode: code,
	}
}

/*
WaypointSetConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointSetConfigDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint set config default response
func (o *WaypointSetConfigDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint set config default response has a 2xx status code
func (o *WaypointSetConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint set config default response has a 3xx status code
func (o *WaypointSetConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint set config default response has a 4xx status code
func (o *WaypointSetConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint set config default response has a 5xx status code
func (o *WaypointSetConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint set config default response a status code equal to that given
func (o *WaypointSetConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointSetConfigDefault) Error() string {
	return fmt.Sprintf("[PUT /project/config][%d] Waypoint_SetConfig default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointSetConfigDefault) String() string {
	return fmt.Sprintf("[PUT /project/config][%d] Waypoint_SetConfig default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointSetConfigDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointSetConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
