// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointSetConfigSourceReader is a Reader for the WaypointSetConfigSource structure.
type WaypointSetConfigSourceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointSetConfigSourceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointSetConfigSourceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointSetConfigSourceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointSetConfigSourceOK creates a WaypointSetConfigSourceOK with default headers values
func NewWaypointSetConfigSourceOK() *WaypointSetConfigSourceOK {
	return &WaypointSetConfigSourceOK{}
}

/*
WaypointSetConfigSourceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointSetConfigSourceOK struct {
	Payload interface{}
}

// IsSuccess returns true when this waypoint set config source o k response has a 2xx status code
func (o *WaypointSetConfigSourceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint set config source o k response has a 3xx status code
func (o *WaypointSetConfigSourceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint set config source o k response has a 4xx status code
func (o *WaypointSetConfigSourceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint set config source o k response has a 5xx status code
func (o *WaypointSetConfigSourceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint set config source o k response a status code equal to that given
func (o *WaypointSetConfigSourceOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointSetConfigSourceOK) Error() string {
	return fmt.Sprintf("[PUT /config-source][%d] waypointSetConfigSourceOK  %+v", 200, o.Payload)
}

func (o *WaypointSetConfigSourceOK) String() string {
	return fmt.Sprintf("[PUT /config-source][%d] waypointSetConfigSourceOK  %+v", 200, o.Payload)
}

func (o *WaypointSetConfigSourceOK) GetPayload() interface{} {
	return o.Payload
}

func (o *WaypointSetConfigSourceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointSetConfigSourceDefault creates a WaypointSetConfigSourceDefault with default headers values
func NewWaypointSetConfigSourceDefault(code int) *WaypointSetConfigSourceDefault {
	return &WaypointSetConfigSourceDefault{
		_statusCode: code,
	}
}

/*
WaypointSetConfigSourceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointSetConfigSourceDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint set config source default response
func (o *WaypointSetConfigSourceDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint set config source default response has a 2xx status code
func (o *WaypointSetConfigSourceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint set config source default response has a 3xx status code
func (o *WaypointSetConfigSourceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint set config source default response has a 4xx status code
func (o *WaypointSetConfigSourceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint set config source default response has a 5xx status code
func (o *WaypointSetConfigSourceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint set config source default response a status code equal to that given
func (o *WaypointSetConfigSourceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointSetConfigSourceDefault) Error() string {
	return fmt.Sprintf("[PUT /config-source][%d] Waypoint_SetConfigSource default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointSetConfigSourceDefault) String() string {
	return fmt.Sprintf("[PUT /config-source][%d] Waypoint_SetConfigSource default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointSetConfigSourceDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointSetConfigSourceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
