// Code generated by go-swagger; DO NOT EDIT.

package waypoint

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/waypoint/pkg/client/gen/models"
)

// WaypointUIListDeploymentsReader is a Reader for the WaypointUIListDeployments structure.
type WaypointUIListDeploymentsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointUIListDeploymentsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointUIListDeploymentsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointUIListDeploymentsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointUIListDeploymentsOK creates a WaypointUIListDeploymentsOK with default headers values
func NewWaypointUIListDeploymentsOK() *WaypointUIListDeploymentsOK {
	return &WaypointUIListDeploymentsOK{}
}

/*
WaypointUIListDeploymentsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointUIListDeploymentsOK struct {
	Payload *models.HashicorpWaypointUIListDeploymentsResponse
}

// IsSuccess returns true when this waypoint Ui list deployments o k response has a 2xx status code
func (o *WaypointUIListDeploymentsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint Ui list deployments o k response has a 3xx status code
func (o *WaypointUIListDeploymentsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint Ui list deployments o k response has a 4xx status code
func (o *WaypointUIListDeploymentsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint Ui list deployments o k response has a 5xx status code
func (o *WaypointUIListDeploymentsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint Ui list deployments o k response a status code equal to that given
func (o *WaypointUIListDeploymentsOK) IsCode(code int) bool {
	return code == 200
}

func (o *WaypointUIListDeploymentsOK) Error() string {
	return fmt.Sprintf("[GET /ui/deployments/workspace/{workspace.workspace}][%d] waypointUiListDeploymentsOK  %+v", 200, o.Payload)
}

func (o *WaypointUIListDeploymentsOK) String() string {
	return fmt.Sprintf("[GET /ui/deployments/workspace/{workspace.workspace}][%d] waypointUiListDeploymentsOK  %+v", 200, o.Payload)
}

func (o *WaypointUIListDeploymentsOK) GetPayload() *models.HashicorpWaypointUIListDeploymentsResponse {
	return o.Payload
}

func (o *WaypointUIListDeploymentsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpWaypointUIListDeploymentsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointUIListDeploymentsDefault creates a WaypointUIListDeploymentsDefault with default headers values
func NewWaypointUIListDeploymentsDefault(code int) *WaypointUIListDeploymentsDefault {
	return &WaypointUIListDeploymentsDefault{
		_statusCode: code,
	}
}

/*
WaypointUIListDeploymentsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointUIListDeploymentsDefault struct {
	_statusCode int

	Payload *models.GrpcGatewayRuntimeError
}

// Code gets the status code for the waypoint UI list deployments default response
func (o *WaypointUIListDeploymentsDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this waypoint UI list deployments default response has a 2xx status code
func (o *WaypointUIListDeploymentsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint UI list deployments default response has a 3xx status code
func (o *WaypointUIListDeploymentsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint UI list deployments default response has a 4xx status code
func (o *WaypointUIListDeploymentsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint UI list deployments default response has a 5xx status code
func (o *WaypointUIListDeploymentsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint UI list deployments default response a status code equal to that given
func (o *WaypointUIListDeploymentsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *WaypointUIListDeploymentsDefault) Error() string {
	return fmt.Sprintf("[GET /ui/deployments/workspace/{workspace.workspace}][%d] Waypoint_UI_ListDeployments default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIListDeploymentsDefault) String() string {
	return fmt.Sprintf("[GET /ui/deployments/workspace/{workspace.workspace}][%d] Waypoint_UI_ListDeployments default  %+v", o._statusCode, o.Payload)
}

func (o *WaypointUIListDeploymentsDefault) GetPayload() *models.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *WaypointUIListDeploymentsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
