// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointConfigVarTarget Target sets the target where this configuration variable will be set.
//
// This has multiple dimensions that filtering can be based on (app scope,
// runner, workspace, label selectors, etc.). Each of these is optional. If
// you specify any, they must ALL match.
//
// The simplest type of targeting is just for a project. For example, setting
// an environment variable that is present for all apps in a project, regardless
// of what workspace it may be in. For this, you'd just set `app_scope` to
// `project` and leave everything else empty.
//
// swagger:model hashicorp.waypoint.ConfigVar.Target
type HashicorpWaypointConfigVarTarget struct {

	// application
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// global
	Global HashicorpWaypointRefGlobal `json:"global,omitempty"`

	// Label selector specifies an additional filtering mechanism. If this is
	// set, then the labels of the current environment must match for this
	// config variable to be set. Labels are determined by the operation: the
	// labels of the deploy, for example.
	LabelSelector string `json:"label_selector,omitempty"`

	// project
	Project *HashicorpWaypointRefProject `json:"project,omitempty"`

	// If this is set, then this configuration value will be set on runners
	// instead of deployed applications. This determines the runners that
	// will get this config var. If this config var is for an application,
	// leave this unset (null).
	Runner *HashicorpWaypointRefRunner `json:"runner,omitempty"`

	// workspace, if set, will limit this config variable to a specific
	// workspace. This is in addition to the app scoping above. For example,
	// if you specify project scoping above, and set this too, then only
	// matching projects in the matching workspace will have this config var
	// set.
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// Validate validates this hashicorp waypoint config var target
func (m *HashicorpWaypointConfigVarTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRunner(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigVarTarget) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) validateProject(formats strfmt.Registry) error {
	if swag.IsZero(m.Project) { // not required
		return nil
	}

	if m.Project != nil {
		if err := m.Project.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) validateRunner(formats strfmt.Registry) error {
	if swag.IsZero(m.Runner) { // not required
		return nil
	}

	if m.Runner != nil {
		if err := m.Runner.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint config var target based on the context it is used
func (m *HashicorpWaypointConfigVarTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRunner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointConfigVarTarget) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) contextValidateProject(ctx context.Context, formats strfmt.Registry) error {

	if m.Project != nil {
		if err := m.Project.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) contextValidateRunner(ctx context.Context, formats strfmt.Registry) error {

	if m.Runner != nil {
		if err := m.Runner.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("runner")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("runner")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointConfigVarTarget) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointConfigVarTarget) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointConfigVarTarget) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointConfigVarTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
