// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointDeclaredResource A platform resource that an operation (release/deployment) has created, depends on, or manages.
//
// swagger:model hashicorp.waypoint.DeclaredResource
type HashicorpWaypointDeclaredResource struct {

	// high level type of the resource, used for display purposes.
	CategoryDisplayHint *HashicorpWaypointResourceCategoryDisplayHint `json:"category_display_hint,omitempty"`

	// platform-specific name of the resource type. i.e. instance, pod, auto-scaling group, etc
	Name string `json:"name,omitempty"`

	// The platform on which the resource should exist, i.e. docker, gcp, k8s, etc.
	Platform string `json:"platform,omitempty"`

	// Internal ResourceManager representation of the resource.
	State *OpaqueanyAny `json:"state,omitempty"`

	// Any additional information a plugin wants to expose on this resource.
	// EX: Availability zones on a load balancer, concurrency limit on a lambda function, etc.
	StateJSON string `json:"state_json,omitempty"`

	// platform-specific type of the resource type. i.e. instance, pod, auto-scaling group, etc
	Type string `json:"type,omitempty"`
}

// Validate validates this hashicorp waypoint declared resource
func (m *HashicorpWaypointDeclaredResource) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCategoryDisplayHint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointDeclaredResource) validateCategoryDisplayHint(formats strfmt.Registry) error {
	if swag.IsZero(m.CategoryDisplayHint) { // not required
		return nil
	}

	if m.CategoryDisplayHint != nil {
		if err := m.CategoryDisplayHint.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("category_display_hint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("category_display_hint")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeclaredResource) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint declared resource based on the context it is used
func (m *HashicorpWaypointDeclaredResource) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCategoryDisplayHint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointDeclaredResource) contextValidateCategoryDisplayHint(ctx context.Context, formats strfmt.Registry) error {

	if m.CategoryDisplayHint != nil {
		if err := m.CategoryDisplayHint.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("category_display_hint")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("category_display_hint")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointDeclaredResource) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointDeclaredResource) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointDeclaredResource) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointDeclaredResource
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
