// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointJobPipelineConfigSyncResult hashicorp waypoint job pipeline config sync result
//
// swagger:model hashicorp.waypoint.Job.PipelineConfigSyncResult
type HashicorpWaypointJobPipelineConfigSyncResult struct {

	// synced_pipelines is a map of Pipeline Name Keys to Pipeline ID Refs for
	// each pipeline that was synced in the config sync request.
	SyncedPipelines map[string]HashicorpWaypointRefPipeline `json:"synced_pipelines,omitempty"`
}

// Validate validates this hashicorp waypoint job pipeline config sync result
func (m *HashicorpWaypointJobPipelineConfigSyncResult) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSyncedPipelines(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobPipelineConfigSyncResult) validateSyncedPipelines(formats strfmt.Registry) error {
	if swag.IsZero(m.SyncedPipelines) { // not required
		return nil
	}

	for k := range m.SyncedPipelines {

		if err := validate.Required("synced_pipelines"+"."+k, "body", m.SyncedPipelines[k]); err != nil {
			return err
		}
		if val, ok := m.SyncedPipelines[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("synced_pipelines" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("synced_pipelines" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp waypoint job pipeline config sync result based on the context it is used
func (m *HashicorpWaypointJobPipelineConfigSyncResult) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSyncedPipelines(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobPipelineConfigSyncResult) contextValidateSyncedPipelines(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.SyncedPipelines {

		if val, ok := m.SyncedPipelines[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJobPipelineConfigSyncResult) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJobPipelineConfigSyncResult) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJobPipelineConfigSyncResult
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
