// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointJobReleaseOp hashicorp waypoint job release op
//
// swagger:model hashicorp.waypoint.Job.ReleaseOp
type HashicorpWaypointJobReleaseOp struct {

	// deployment
	Deployment *HashicorpWaypointDeployment `json:"deployment,omitempty"`

	// Prune settings. This will prune the deployments that aren't released.
	Prune bool `json:"prune,omitempty"`

	// This sets the number of unreleased deployments to retain when pruning.
	// This only has an effect if "prune_retain_override" is true. If that
	// is false, then pruning uses the default behavior (retain 2).
	PruneRetain int32 `json:"prune_retain,omitempty"`

	// prune retain override
	PruneRetainOverride bool `json:"prune_retain_override,omitempty"`
}

// Validate validates this hashicorp waypoint job release op
func (m *HashicorpWaypointJobReleaseOp) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDeployment(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobReleaseOp) validateDeployment(formats strfmt.Registry) error {
	if swag.IsZero(m.Deployment) { // not required
		return nil
	}

	if m.Deployment != nil {
		if err := m.Deployment.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deployment")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deployment")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint job release op based on the context it is used
func (m *HashicorpWaypointJobReleaseOp) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDeployment(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointJobReleaseOp) contextValidateDeployment(ctx context.Context, formats strfmt.Registry) error {

	if m.Deployment != nil {
		if err := m.Deployment.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deployment")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deployment")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointJobReleaseOp) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointJobReleaseOp) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointJobReleaseOp
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
