// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointOIDCAuthMethod This is used by ListOIDCAuthMethods to return the minimal information
// for an OIDC auth method in an unauthenticated setting.
//
// swagger:model hashicorp.waypoint.OIDCAuthMethod
type HashicorpWaypointOIDCAuthMethod struct {

	// human friendly name
	DisplayName string `json:"display_name,omitempty"`

	// kind is a well known kind of OIDC provider. This is sniffed by
	// the server heuristically and is only here to assist in the UI.
	Kind *HashicorpWaypointOIDCAuthMethodKind `json:"kind,omitempty"`

	// unique identifier used for this auth method. This may or may
	// not be human friendly; use display_name for human display.
	Name string `json:"name,omitempty"`
}

// Validate validates this hashicorp waypoint o ID c auth method
func (m *HashicorpWaypointOIDCAuthMethod) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKind(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointOIDCAuthMethod) validateKind(formats strfmt.Registry) error {
	if swag.IsZero(m.Kind) { // not required
		return nil
	}

	if m.Kind != nil {
		if err := m.Kind.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kind")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kind")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint o ID c auth method based on the context it is used
func (m *HashicorpWaypointOIDCAuthMethod) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateKind(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointOIDCAuthMethod) contextValidateKind(ctx context.Context, formats strfmt.Registry) error {

	if m.Kind != nil {
		if err := m.Kind.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("kind")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("kind")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointOIDCAuthMethod) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointOIDCAuthMethod) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointOIDCAuthMethod
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
