// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointStatusReport StatusReport is the report genrated when querying the overall health of
// a deployed or released application. This report is generated after
// an Up Operation, DeployOp or ReleaseOp. In the future Waypoint will be able
// to generate these reports on demand in the UI.
//
// NOTE: This is not related to Status or StatusFilter messages but a message
// used to run the StatusReport job operation for Waypoint Server. The raw SDK
// StatusReport message is stored as an option on this message
//
// swagger:model hashicorp.waypoint.StatusReport
type HashicorpWaypointStatusReport struct {

	// The application that this build is part of.
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// the deployment id that this status report was generated on
	DeploymentID string `json:"deployment_id,omitempty"`

	// Deprecated in favor of resources
	// A health report of all of the resources that make up the report.
	// Copied from the plugin generated raw SDK status report for convenient API access.
	DeprecatedResourcesHealth []*HashicorpWaypointStatusReportHealth `json:"deprecated_resources_health"`

	// where the health check was performed. External means not executed by Waypoint,
	// but by the platform deployed to.
	External bool `json:"external,omitempty"`

	// the time when this report was generated
	// Copied from the plugin generated raw SDK status report for convenient API access.
	// Format: date-time
	GeneratedTime strfmt.DateTime `json:"generated_time,omitempty"`

	// The overall health of the deployment or release as reported by the plugin.
	// Copied from the plugin generated raw SDK status report for convenient API access.
	Health *HashicorpWaypointStatusReportHealth `json:"health,omitempty"`

	// id is the unique ID for this status report.
	ID string `json:"id,omitempty"`

	// count of active instance connections from waypoint-entrypoint (ceb). This
	// is currently only applicable to deployment type status reports
	InstancesCount int64 `json:"instances_count,omitempty"`

	// the release id that this status report was generated on
	ReleaseID string `json:"release_id,omitempty"`

	// a collection of resources, e.x. platform resources generated and monitored by a deployment.
	Resources []*HashicorpWaypointStatusReportResource `json:"resources"`

	// Status of the StatusReport operation executed by the server.
	// Note that this status is not related to the status report, but the current
	// state of the StatusReport operation
	Status *HashicorpWaypointStatus `json:"status,omitempty"`

	// StatusReport is the raw SDK report object encoded directly from the plugin.
	// This message is a StatusReport proto that exists inside the SDK
	StatusReport *OpaqueanyAny `json:"status_report,omitempty"`

	// status report json
	StatusReportJSON string `json:"status_report_json,omitempty"`

	// The workspace that this exists in
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// Validate validates this hashicorp waypoint status report
func (m *HashicorpWaypointStatusReport) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeprecatedResourcesHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateGeneratedTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealth(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResources(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusReport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointStatusReport) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateDeprecatedResourcesHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.DeprecatedResourcesHealth) { // not required
		return nil
	}

	for i := 0; i < len(m.DeprecatedResourcesHealth); i++ {
		if swag.IsZero(m.DeprecatedResourcesHealth[i]) { // not required
			continue
		}

		if m.DeprecatedResourcesHealth[i] != nil {
			if err := m.DeprecatedResourcesHealth[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("deprecated_resources_health" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("deprecated_resources_health" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateGeneratedTime(formats strfmt.Registry) error {
	if swag.IsZero(m.GeneratedTime) { // not required
		return nil
	}

	if err := validate.FormatOf("generated_time", "body", "date-time", m.GeneratedTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateHealth(formats strfmt.Registry) error {
	if swag.IsZero(m.Health) { // not required
		return nil
	}

	if m.Health != nil {
		if err := m.Health.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("health")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateResources(formats strfmt.Registry) error {
	if swag.IsZero(m.Resources) { // not required
		return nil
	}

	for i := 0; i < len(m.Resources); i++ {
		if swag.IsZero(m.Resources[i]) { // not required
			continue
		}

		if m.Resources[i] != nil {
			if err := m.Resources[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateStatusReport(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusReport) { // not required
		return nil
	}

	if m.StatusReport != nil {
		if err := m.StatusReport.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint status report based on the context it is used
func (m *HashicorpWaypointStatusReport) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeprecatedResourcesHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealth(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResources(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateDeprecatedResourcesHealth(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DeprecatedResourcesHealth); i++ {

		if m.DeprecatedResourcesHealth[i] != nil {
			if err := m.DeprecatedResourcesHealth[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("deprecated_resources_health" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("deprecated_resources_health" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateHealth(ctx context.Context, formats strfmt.Registry) error {

	if m.Health != nil {
		if err := m.Health.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("health")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("health")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateResources(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Resources); i++ {

		if m.Resources[i] != nil {
			if err := m.Resources[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("resources" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("resources" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {
		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateStatusReport(ctx context.Context, formats strfmt.Registry) error {

	if m.StatusReport != nil {
		if err := m.StatusReport.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointStatusReport) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointStatusReport) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointStatusReport) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointStatusReport
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
