// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpWaypointTask Task tracks the life of an on-demand runner task that spawns Start
// and Stop tasks for any kind of job/operation in Waypoint. Automatic jobs
// such as project polling or status report generation spawn on-demand
// runner tasks, and this message can be used to track the life of those
// automated jobs. Note that every on-demand runner task is wrapped with a
// Start and Stop task, which we track here as well.
//
// swagger:model hashicorp.waypoint.Task
type HashicorpWaypointTask struct {

	// The ID of this message. If on first upsert, the id does not need to be
	// specified and the state pkg will autogenerate an id. Specifying an id
	// assumes the Task message already exists in the database.
	ID string `json:"id,omitempty"`

	// The overall state of the Task triple. See the enum def for details for
	// each possible Task state. This will be computed for each GetTaskResponse
	// based on the Task job ids received from the database.
	JobState *HashicorpWaypointTaskState `json:"job_state,omitempty"`

	// The resource that gets created to run the task job for this Task
	// TODO(briancain): This field has not been implemented yet. See
	// "internal/runner/operation_task.go" for more info.
	ResourceName string `json:"resource_name,omitempty"`

	// Both start_job and stop_job relate to task_job.These jobs were
	// responsible for starting and stopping the runner which executed the task
	// job.
	StartJob *HashicorpWaypointRefJob `json:"start_job,omitempty"`

	// This task info message represented as an Any format. This is the full
	// task encoded directly by the server that has access to the proto to decode it.
	State *OpaqueanyAny `json:"state,omitempty"`

	// This task info message represented as JSON-encoded protobuf structure of
	// the Any field below. It does not modify any of the structure.
	StateJSON string `json:"state_json,omitempty"`

	// stop job
	StopJob *HashicorpWaypointRefJob `json:"stop_job,omitempty"`

	// task_job represents the "run" job the runner will execute, i.e. the operation
	// that was requested to run on the runner.
	// The referred job stores data like ODR config, the target runner used,
	// timestamp for when job started or completed, operation state for task, etc.
	// Currently the only required field when Upserting a Task.
	TaskJob *HashicorpWaypointRefJob `json:"task_job,omitempty"`

	// watch_job will spawn a job to stream logs from the `task_job`.
	WatchJob *HashicorpWaypointRefJob `json:"watch_job,omitempty"`
}

// Validate validates this hashicorp waypoint task
func (m *HashicorpWaypointTask) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateJobState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStartJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStopJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTaskJob(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWatchJob(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTask) validateJobState(formats strfmt.Registry) error {
	if swag.IsZero(m.JobState) { // not required
		return nil
	}

	if m.JobState != nil {
		if err := m.JobState.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) validateStartJob(formats strfmt.Registry) error {
	if swag.IsZero(m.StartJob) { // not required
		return nil
	}

	if m.StartJob != nil {
		if err := m.StartJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("start_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("start_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) validateState(formats strfmt.Registry) error {
	if swag.IsZero(m.State) { // not required
		return nil
	}

	if m.State != nil {
		if err := m.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) validateStopJob(formats strfmt.Registry) error {
	if swag.IsZero(m.StopJob) { // not required
		return nil
	}

	if m.StopJob != nil {
		if err := m.StopJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stop_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stop_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) validateTaskJob(formats strfmt.Registry) error {
	if swag.IsZero(m.TaskJob) { // not required
		return nil
	}

	if m.TaskJob != nil {
		if err := m.TaskJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("task_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("task_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) validateWatchJob(formats strfmt.Registry) error {
	if swag.IsZero(m.WatchJob) { // not required
		return nil
	}

	if m.WatchJob != nil {
		if err := m.WatchJob.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("watch_job")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint task based on the context it is used
func (m *HashicorpWaypointTask) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateJobState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStartJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStopJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTaskJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWatchJob(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTask) contextValidateJobState(ctx context.Context, formats strfmt.Registry) error {

	if m.JobState != nil {
		if err := m.JobState.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("job_state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("job_state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) contextValidateStartJob(ctx context.Context, formats strfmt.Registry) error {

	if m.StartJob != nil {
		if err := m.StartJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("start_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("start_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if m.State != nil {
		if err := m.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("state")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("state")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) contextValidateStopJob(ctx context.Context, formats strfmt.Registry) error {

	if m.StopJob != nil {
		if err := m.StopJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("stop_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("stop_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) contextValidateTaskJob(ctx context.Context, formats strfmt.Registry) error {

	if m.TaskJob != nil {
		if err := m.TaskJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("task_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("task_job")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTask) contextValidateWatchJob(ctx context.Context, formats strfmt.Registry) error {

	if m.WatchJob != nil {
		if err := m.WatchJob.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("watch_job")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("watch_job")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointTask) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointTask) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointTask
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
