// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpWaypointTrigger The Trigger message is a representation of a URL that can be requested
// for invoking specific lifecycle operations on a projects applications. These
// trigger URLs are intended to be used in a CI system for easy configuration.
// The user is expected to configure and generate the URL ahead of time, and
// Waypoint will generate a trigger based on the configuration here and return
// a URL to make requests with.
//
// swagger:model hashicorp.waypoint.Trigger
type HashicorpWaypointTrigger struct {

	// time of last execution.
	// Format: date-time
	ActiveTime strfmt.DateTime `json:"active_time,omitempty"`

	// The application to use. Can be empty, this trigger will run on every app
	// if not set.
	Application *HashicorpWaypointRefApplication `json:"application,omitempty"`

	// whether or not this is authenticated. defaults to true.
	Authenticated bool `json:"authenticated,omitempty"`

	// build
	Build *HashicorpWaypointJobBuildOp `json:"build,omitempty"`

	// deploy
	Deploy *HashicorpWaypointJobDeployOp `json:"deploy,omitempty"`

	// description is user defined, describes the purpose
	// of the trigger.
	Description string `json:"description,omitempty"`

	// destroy
	Destroy *HashicorpWaypointJobDestroyOp `json:"destroy,omitempty"`

	// uuid generated by Waypoint on creation. Used as the identifier in the URL.
	ID string `json:"id,omitempty"`

	// init
	Init HashicorpWaypointJobInitOp `json:"init,omitempty"`

	// name can be user defined, or auto generated.
	Name string `json:"name,omitempty"`

	// Required. Project ref must be set to be valid trigger URL.
	Project *HashicorpWaypointRefProject `json:"project,omitempty"`

	// push
	Push *HashicorpWaypointJobPushOp `json:"push,omitempty"`

	// release
	Release *HashicorpWaypointJobReleaseOp `json:"release,omitempty"`

	// status report
	StatusReport *HashicorpWaypointJobStatusReportOp `json:"status_report,omitempty"`

	// tags that allow users to group triggers together that are
	// related. There are no default tags.
	Tags []string `json:"tags"`

	// up
	Up *HashicorpWaypointJobUpOp `json:"up,omitempty"`

	// Defaults to the default workspace if unset.
	Workspace *HashicorpWaypointRefWorkspace `json:"workspace,omitempty"`
}

// Validate validates this hashicorp waypoint trigger
func (m *HashicorpWaypointTrigger) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveTime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateApplication(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateBuild(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDeploy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDestroy(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateProject(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePush(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRelease(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatusReport(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUp(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateWorkspace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTrigger) validateActiveTime(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveTime) { // not required
		return nil
	}

	if err := validate.FormatOf("active_time", "body", "date-time", m.ActiveTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateApplication(formats strfmt.Registry) error {
	if swag.IsZero(m.Application) { // not required
		return nil
	}

	if m.Application != nil {
		if err := m.Application.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateBuild(formats strfmt.Registry) error {
	if swag.IsZero(m.Build) { // not required
		return nil
	}

	if m.Build != nil {
		if err := m.Build.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateDeploy(formats strfmt.Registry) error {
	if swag.IsZero(m.Deploy) { // not required
		return nil
	}

	if m.Deploy != nil {
		if err := m.Deploy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateDestroy(formats strfmt.Registry) error {
	if swag.IsZero(m.Destroy) { // not required
		return nil
	}

	if m.Destroy != nil {
		if err := m.Destroy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateProject(formats strfmt.Registry) error {
	if swag.IsZero(m.Project) { // not required
		return nil
	}

	if m.Project != nil {
		if err := m.Project.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validatePush(formats strfmt.Registry) error {
	if swag.IsZero(m.Push) { // not required
		return nil
	}

	if m.Push != nil {
		if err := m.Push.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("push")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("push")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateRelease(formats strfmt.Registry) error {
	if swag.IsZero(m.Release) { // not required
		return nil
	}

	if m.Release != nil {
		if err := m.Release.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateStatusReport(formats strfmt.Registry) error {
	if swag.IsZero(m.StatusReport) { // not required
		return nil
	}

	if m.StatusReport != nil {
		if err := m.StatusReport.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateUp(formats strfmt.Registry) error {
	if swag.IsZero(m.Up) { // not required
		return nil
	}

	if m.Up != nil {
		if err := m.Up.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) validateWorkspace(formats strfmt.Registry) error {
	if swag.IsZero(m.Workspace) { // not required
		return nil
	}

	if m.Workspace != nil {
		if err := m.Workspace.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp waypoint trigger based on the context it is used
func (m *HashicorpWaypointTrigger) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateApplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBuild(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDeploy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDestroy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateProject(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePush(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRelease(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatusReport(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateWorkspace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateApplication(ctx context.Context, formats strfmt.Registry) error {

	if m.Application != nil {
		if err := m.Application.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("application")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("application")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateBuild(ctx context.Context, formats strfmt.Registry) error {

	if m.Build != nil {
		if err := m.Build.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("build")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("build")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateDeploy(ctx context.Context, formats strfmt.Registry) error {

	if m.Deploy != nil {
		if err := m.Deploy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("deploy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("deploy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateDestroy(ctx context.Context, formats strfmt.Registry) error {

	if m.Destroy != nil {
		if err := m.Destroy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("destroy")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("destroy")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateProject(ctx context.Context, formats strfmt.Registry) error {

	if m.Project != nil {
		if err := m.Project.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("project")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("project")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidatePush(ctx context.Context, formats strfmt.Registry) error {

	if m.Push != nil {
		if err := m.Push.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("push")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("push")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateRelease(ctx context.Context, formats strfmt.Registry) error {

	if m.Release != nil {
		if err := m.Release.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("release")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("release")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateStatusReport(ctx context.Context, formats strfmt.Registry) error {

	if m.StatusReport != nil {
		if err := m.StatusReport.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status_report")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status_report")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateUp(ctx context.Context, formats strfmt.Registry) error {

	if m.Up != nil {
		if err := m.Up.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("up")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("up")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpWaypointTrigger) contextValidateWorkspace(ctx context.Context, formats strfmt.Registry) error {

	if m.Workspace != nil {
		if err := m.Workspace.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("workspace")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("workspace")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpWaypointTrigger) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpWaypointTrigger) UnmarshalBinary(b []byte) error {
	var res HashicorpWaypointTrigger
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
