package funcs

func Docs() map[string]string {
	return map[string]string{
		"abs":             "return the absolute value of the given number",
		"abspath":         "convert the path into an absolute path",
		"base64decode":    "decode the given string in base64 encoding back to binary",
		"base64encode":    "encode the given string to base64 encoding",
		"base64gzip":      "gzip the given string and encode the compressed body as base64",
		"basename":        "return the last component of the string interpreted as a filesystem path",
		"ceil":            "round the given number to the next integer",
		"chomp":           "remove white space from the start and end of the given string",
		"chunklist":       "a single list into fixed-size chunks, returning a list of lists",
		"coalescelist":    "take any number of list arguments and returns the first one that isn't empty",
		"compact":         "remove empty strings from a list",
		"concat":          "combine 2 or more lists into a single list",
		"contains":        "determines whether a given list or set contains a given single value as one of its elements",
		"csvdecode":       "decodes a string containing CSV-formatted data and produces a list of maps representing that data",
		"dirname":         "return all except the last component of the string interpreted as a filesystem path",
		"distinct":        "removes any duplicate elements from a list",
		"element":         "return the value at given numeric index in the list",
		"file":            "return the data in the file located at the given path. This can be paired with the `${path.app}` variable to get a path relative to your app folder, i.e. `filebase64(\"${path.app}/file.txt\")`",
		"filebase64":      "return the data in the file located at the given path after base64 decoding it. This can be paired with the `${path.app}` variable to get a path relative to your app folder, i.e. `filebase64(\"${path.app}/file.txt\")`",
		"fileexists":      "indicate if a file exists at the given path. This can be paired with the `${path.app}` variable to get a path relative to your app folder, i.e. `filebase64(\"${path.app}/file.txt\")`",
		"fileset":         "gather a list of paths that match the given pattern under the given directory",
		"flatten":         "remove any embedded lists by moving the contents to the outer list",
		"floor":           "round the given number to the lowest next integer",
		"format":          "format a string according to the given parameters",
		"formatdate":      "format the current date as a string according to the given parameters",
		"formatlist":      "apply the format() function across all values in the given lists",
		"gitrefhash":      "return the full git hash for the HEAD ref",
		"gitrefpretty":    "return a humanized version of the git hash, taking into account tags and changes",
		"gitreftag":       "return the tag name that points to the HEAD ref",
		"gitremoteurl":    "return the remote url of the git repo",
		"indent":          "indent each line of the given string",
		"join":            "create a string by joining each list element with the given separator",
		"jsondecode":      "decode the given string as json into HCL values",
		"jsonencode":      "encode the given HCL value as json",
		"jsonnetfile":     "convert a Jsonnet file into JSON, returning a file path",
		"jsonnetdir":      "convert a directory of Jsonnet files into JSON, returning a path",
		"keys":            "return a list of the keys present in the given map",
		"log":             "returns the logarithm of a given number in a given base",
		"lower":           "convert the given string to lower case according the unicode rules",
		"max":             "return the largest number present in the list",
		"merge":           "combine a set of map or objects together as one map",
		"min":             "return the smallest number present in the list",
		"parseint":        "parse the string as a number of the given base and return an HCL number value",
		"pathexpand":      "expand any tildes in the given path",
		"pow":             "raise the given number to the given power",
		"range":           "generate a list of numbers",
		"regex":           "match the given string against the given regular expression pattern, returning captures if defined",
		"regexall":        "same as regex but look for all matches of the given pattern rather than just the first",
		"replace":         "searches a given string for another given substring, and replaces each occurrence with a given replacement string.",
		"reverse":         "reverse the order of the elements in the list",
		"selectormatch":   "applies a selector to a map and returns true if the selector matches",
		"selectorlookup":  "applies a map of selectors to a map of labels. The value for the first matching selector is returned. If none match, the default is returned.",
		"setintersection": "takes multiple sets and produces a single set containing only the elements that all of the given sets have in common. In other words, it computes the intersection of the sets",
		"setproduct":      "finds all of the possible combinations of elements from all of the given sets by computing the Cartesian product",
		"setsubtract":     "returns a new set containing the elements from the first set that are not present in the second set. In other words, it computes the relative complement of the first set in the second set",
		"setunion":        "takes multiple sets and produces a single set containing the elements from all of the given sets. In other words, it computes the union of the sets",
		"signum":          "indicates the sign of the given number by -1, 0, or 1",
		"slice":           "return a subset of the given list",
		"sort":            "reorder the given elements according to their sorting order",
		"split":           "break the given string up into substrings",
		"strrev":          "reverse the characters in the given string",
		"substr":          "return a subset of the given string",
		"templatefile":    "expand the template defined at the given file path and return the result",
		"timeadd":         "add a quantum of time to the given timestamp to calculate a new timestamp",
		"title":           "upper case each character on each word in the given string",
		"trim":            "remove characters present in the cutset from the given string from the head and tail of the string",
		"trimprefix":      "remove the given prefix from the string",
		"trimspace":       "remove space charaters from the head and tail of the string",
		"trimsuffix":      "remove the given suffix from the string",
		"upper":           "convert each character to upper case according to the unicode rules",
		"urlencode":       "encode the given string according to the url encoding rules",
		"values":          "return the list of values in the given map or object",
		"yamldecode":      "decode the string as YAML and return the equiv HCL values",
		"yamlencode":      "convert the given HCL values to YAML",
		"zipmap":          "construct a map from a list of keys and a corresponding list of values",
	}
}
