/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Extension
implements Serializable,
InputLocationTracker {
    final String groupId;
    final String artifactId;
    final String version;
    final XmlNode configuration;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Extension(Builder builder) {
        String string = builder.groupId != null ? builder.groupId : (this.groupId = builder.base != null ? builder.base.groupId : null);
        String string2 = builder.artifactId != null ? builder.artifactId : (this.artifactId = builder.base != null ? builder.base.artifactId : null);
        String string3 = builder.version != null ? builder.version : (this.version = builder.base != null ? builder.base.version : null);
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Extension.newBuilder(this);
    }

    @Nonnull
    public Extension withGroupId(String groupId) {
        return Extension.newBuilder(this, true).groupId(groupId).build();
    }

    @Nonnull
    public Extension withArtifactId(String artifactId) {
        return Extension.newBuilder(this, true).artifactId(artifactId).build();
    }

    @Nonnull
    public Extension withVersion(String version) {
        return Extension.newBuilder(this, true).version(version).build();
    }

    @Nonnull
    public Extension withConfiguration(XmlNode configuration) {
        return Extension.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static Extension newInstance() {
        return Extension.newInstance(true);
    }

    @Nonnull
    public static Extension newInstance(boolean withDefaults) {
        return Extension.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Extension.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Extension from) {
        return Extension.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Extension from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Extension) {
            Extension e = (Extension)o;
            return Objects.equals(e.getArtifactId(), this.getArtifactId()) && Objects.equals(e.getGroupId(), this.getGroupId()) && Objects.equals(e.getVersion(), this.getVersion());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getArtifactId(), this.getGroupId(), this.getVersion());
    }

    @NotThreadSafe
    public static class Builder {
        Extension base;
        String groupId;
        String artifactId;
        String version;
        XmlNode configuration;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Extension base, boolean forceCopy) {
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.configuration = base.configuration;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Extension build() {
            if (!(this.base == null || this.groupId != null && this.groupId != this.base.groupId || this.artifactId != null && this.artifactId != this.base.artifactId || this.version != null && this.version != this.base.version || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new Extension(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

